/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery;

import com.dre.brewery.BCauldron;
import com.dre.brewery.BIngredients;
import com.dre.brewery.BPlayer;
import com.dre.brewery.BRecipe;
import com.dre.brewery.Barrel;
import com.dre.brewery.Brew;
import com.dre.brewery.LegacyUtil;
import com.dre.brewery.Wakeup;
import com.dre.brewery.Words;
import com.dre.brewery.filedata.ConfigUpdater;
import com.dre.brewery.filedata.DataSave;
import com.dre.brewery.filedata.DataUpdater;
import com.dre.brewery.filedata.LanguageReader;
import com.dre.brewery.filedata.UpdateChecker;
import com.dre.brewery.integration.LogBlockBarrel;
import com.dre.brewery.integration.Metrics;
import com.dre.brewery.integration.WGBarrel;
import com.dre.brewery.integration.WGBarrel7;
import com.dre.brewery.integration.WGBarrelNew;
import com.dre.brewery.integration.WGBarrelOld;
import com.dre.brewery.listeners.BlockListener;
import com.dre.brewery.listeners.CauldronListener;
import com.dre.brewery.listeners.CommandListener;
import com.dre.brewery.listeners.EntityListener;
import com.dre.brewery.listeners.InventoryListener;
import com.dre.brewery.listeners.PlayerListener;
import com.dre.brewery.listeners.TabListener;
import com.dre.brewery.listeners.WorldListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.UUID;
import net.milkbowl.vault.item.ItemInfo;
import net.milkbowl.vault.item.Items;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class P
extends JavaPlugin {
    public static P p;
    public static final String configVersion = "1.7";
    public static boolean debug;
    public static boolean useUUID;
    public static boolean use1_9;
    public static boolean use1_11;
    public static boolean use1_13;
    public static boolean use1_14;
    public static boolean updateCheck;
    public boolean useWG;
    public WGBarrel wg;
    public boolean useLWC;
    public boolean useLB;
    public boolean useGP;
    public boolean hasVault;
    public boolean useCitadel;
    public BlockListener blockListener;
    public PlayerListener playerListener;
    public EntityListener entityListener;
    public InventoryListener inventoryListener;
    public WorldListener worldListener;
    public String language;
    public LanguageReader languageReader;
    private CommandSender reloader;

    public void onEnable() {
        p = this;
        String v = Bukkit.getBukkitVersion();
        useUUID = !v.matches("(^|.*[^.\\d])1\\.[0-6]([^\\d].*|$)") && !v.matches("(^|.*[^.\\d])1\\.7\\.[0-5]([^\\d].*|$)");
        use1_9 = !v.matches("(^|.*[^.\\d])1\\.[0-8]([^\\d].*|$)");
        use1_11 = !v.matches("(^|.*[^.\\d])1\\.10([^\\d].*|$)") && !v.matches("(^|.*[^.\\d])1\\.[0-9]([^\\d].*|$)");
        use1_13 = !v.matches("(^|.*[^.\\d])1\\.1[0-2]([^\\d].*|$)") && !v.matches("(^|.*[^.\\d])1\\.[0-9]([^\\d].*|$)");
        use1_14 = !v.matches("(^|.*[^.\\d])1\\.1[0-3]([^\\d].*|$)") && !v.matches("(^|.*[^.\\d])1\\.[0-9]([^\\d].*|$)");
        try {
            if (!this.readConfig()) {
                p = null;
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            p = null;
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.readData();
        try {
            Metrics metrics = new Metrics(this);
            metrics.addCustomChart(new Metrics.SingleLineChart("drunk_players", BPlayer::numDrunkPlayers));
            metrics.addCustomChart(new Metrics.SingleLineChart("brews_in_existence", () -> Brew.potions.size()));
            metrics.addCustomChart(new Metrics.SingleLineChart("barrels_built", () -> Barrel.barrels.size()));
            metrics.addCustomChart(new Metrics.SingleLineChart("cauldrons_boiling", () -> BCauldron.bcauldrons.size()));
            metrics.addCustomChart(new Metrics.AdvancedPie("brew_quality", () -> {
                HashMap<String, Integer> map = new HashMap<String, Integer>(5);
                int exc = 0;
                int good = 0;
                int norm = 0;
                int bad = 0;
                int terr = 0;
                for (Brew brew : Brew.potions.values()) {
                    if (brew.getQuality() >= 9) {
                        ++exc;
                        continue;
                    }
                    if (brew.getQuality() >= 7) {
                        ++good;
                        continue;
                    }
                    if (brew.getQuality() >= 5) {
                        ++norm;
                        continue;
                    }
                    if (brew.getQuality() >= 3) {
                        ++bad;
                        continue;
                    }
                    ++terr;
                }
                map.put("excellent", exc);
                map.put("good", good);
                map.put("normal", norm);
                map.put("bad", bad);
                map.put("terrible", terr);
                return map;
            }));
            metrics.addCustomChart(new Metrics.SimplePie("number_of_recipes", () -> {
                int recipes = BIngredients.recipes.size();
                if (recipes < 7) {
                    return "Less than 7";
                }
                if (recipes < 11) {
                    return "7-10";
                }
                if (recipes == 11) {
                    return "11";
                }
                if (recipes <= 31) {
                    if (recipes % 2 == 0) {
                        return recipes + "-" + (recipes + 1);
                    }
                    return recipes - 1 + "-" + recipes;
                }
                return "More than 31";
            }));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.blockListener = new BlockListener();
        this.playerListener = new PlayerListener();
        this.entityListener = new EntityListener();
        this.inventoryListener = new InventoryListener();
        this.worldListener = new WorldListener();
        this.getCommand("Brewery").setExecutor((CommandExecutor)new CommandListener());
        this.getCommand("Brewery").setTabCompleter((TabCompleter)new TabListener());
        p.getServer().getPluginManager().registerEvents((Listener)this.blockListener, (Plugin)p);
        p.getServer().getPluginManager().registerEvents((Listener)this.playerListener, (Plugin)p);
        p.getServer().getPluginManager().registerEvents((Listener)this.entityListener, (Plugin)p);
        p.getServer().getPluginManager().registerEvents((Listener)this.inventoryListener, (Plugin)p);
        p.getServer().getPluginManager().registerEvents((Listener)this.worldListener, (Plugin)p);
        if (use1_9) {
            p.getServer().getPluginManager().registerEvents((Listener)new CauldronListener(), (Plugin)p);
        }
        p.getServer().getScheduler().runTaskTimer((Plugin)p, (Runnable)new BreweryRunnable(), 650L, 1200L);
        p.getServer().getScheduler().runTaskTimer((Plugin)p, (Runnable)new DrunkRunnable(), 120L, 120L);
        if (updateCheck) {
            try {
                p.getServer().getScheduler().runTaskLaterAsynchronously((Plugin)p, (Runnable)new UpdateChecker(), 135L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.log(this.getDescription().getName() + " enabled!");
    }

    public void onDisable() {
        HandlerList.unregisterAll((Plugin)this);
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        if (p == null) {
            return;
        }
        DataSave.save(true);
        this.languageReader.save();
        Barrel.barrels.clear();
        BCauldron.bcauldrons.clear();
        BIngredients.possibleIngredients.clear();
        BIngredients.recipes.clear();
        BIngredients.cookedNames.clear();
        BPlayer.clear();
        Brew.potions.clear();
        Wakeup.wakeups.clear();
        Words.words.clear();
        Words.ignoreText.clear();
        Words.commands = null;
        this.log(this.getDescription().getName() + " disabled!");
    }

    public void reload(CommandSender sender) {
        if (sender != null && !sender.equals(this.getServer().getConsoleSender())) {
            this.reloader = sender;
        }
        BIngredients.possibleIngredients.clear();
        BIngredients.recipes.clear();
        BIngredients.cookedNames.clear();
        Words.words.clear();
        Words.ignoreText.clear();
        Words.commands = null;
        BPlayer.drainItems.clear();
        if (this.useLB) {
            try {
                LogBlockBarrel.clear();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            if (!this.readConfig()) {
                p = null;
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            p = null;
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.languageReader.save();
        this.languageReader = new LanguageReader(new File(p.getDataFolder(), "languages/" + this.language + ".yml"));
        boolean successful = true;
        for (Brew brew : Brew.potions.values()) {
            if (brew.reloadRecipe()) continue;
            successful = false;
        }
        if (!successful) {
            this.msg(sender, P.p.languageReader.get("Error_Recipeload", new String[0]));
        }
        this.reloader = null;
    }

    public void msg(CommandSender sender, String msg) {
        sender.sendMessage(this.color("&2[Brewery] &f" + msg));
    }

    public void log(String msg) {
        this.msg((CommandSender)Bukkit.getConsoleSender(), msg);
    }

    public void debugLog(String msg) {
        if (debug) {
            this.msg((CommandSender)Bukkit.getConsoleSender(), "&2[Debug] &f" + msg);
        }
    }

    public void errorLog(String msg) {
        Bukkit.getConsoleSender().sendMessage(ChatColor.DARK_GREEN + "[Brewery] " + ChatColor.DARK_RED + "ERROR: " + ChatColor.RED + msg);
        if (this.reloader != null) {
            this.reloader.sendMessage(ChatColor.DARK_GREEN + "[Brewery] " + ChatColor.DARK_RED + "ERROR: " + ChatColor.RED + msg);
        }
    }

    public boolean readConfig() {
        List drainList;
        File file = new File(p.getDataFolder(), "config.yml");
        if (!this.checkConfigs()) {
            return false;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        this.language = config.getString("language", "en");
        this.languageReader = new LanguageReader(new File(p.getDataFolder(), "languages/" + this.language + ".yml"));
        boolean oldMat = config.getBoolean("oldMat", false);
        String version = config.getString("version", null);
        if (version != null && (!version.equals(configVersion) || oldMat && use1_13)) {
            this.copyDefaultConfigs(true);
            new ConfigUpdater(file).update(version, oldMat, this.language);
            p.log("Config Updated to version: 1.7");
            config = YamlConfiguration.loadConfiguration((File)file);
        }
        updateCheck = config.getBoolean("updateCheck", false);
        boolean bl = this.useWG = config.getBoolean("useWorldGuard", true) && this.getServer().getPluginManager().isPluginEnabled("WorldGuard");
        if (this.useWG) {
            Plugin plugin = Bukkit.getPluginManager().getPlugin("WorldEdit");
            if (plugin != null) {
                String wgv = plugin.getDescription().getVersion();
                this.wg = wgv.startsWith("6.") ? new WGBarrelNew() : (wgv.startsWith("5.") ? new WGBarrelOld() : new WGBarrel7());
            }
            if (this.wg == null) {
                p.errorLog("Failed loading WorldGuard Integration! Opening Barrels will NOT work!");
                p.errorLog("Brewery was tested with version 5.8, 6.1 and 7.0 of WorldGuard!");
                p.errorLog("Disable the WorldGuard support in the config and do /brew reload");
            }
        }
        this.useLWC = config.getBoolean("useLWC", true) && this.getServer().getPluginManager().isPluginEnabled("LWC");
        this.useGP = config.getBoolean("useGriefPrevention", true) && this.getServer().getPluginManager().isPluginEnabled("GriefPrevention");
        this.useLB = config.getBoolean("useLogBlock", false) && this.getServer().getPluginManager().isPluginEnabled("LogBlock");
        this.useCitadel = config.getBoolean("useCitadel", false) && this.getServer().getPluginManager().isPluginEnabled("Citadel");
        this.hasVault = this.getServer().getPluginManager().isPluginEnabled("Vault") && Integer.parseInt(this.getServer().getPluginManager().getPlugin("Vault").getDescription().getVersion().split("\\.")[1]) <= 6;
        DataSave.autosave = config.getInt("autosave", 3);
        debug = config.getBoolean("debug", false);
        BPlayer.pukeItem = Material.matchMaterial((String)config.getString("pukeItem", "SOUL_SAND"));
        BPlayer.hangoverTime = config.getInt("hangoverDays", 0) * 24 * 60;
        BPlayer.overdrinkKick = config.getBoolean("enableKickOnOverdrink", false);
        BPlayer.enableHome = config.getBoolean("enableHome", false);
        BPlayer.enableLoginDisallow = config.getBoolean("enableLoginDisallow", false);
        BPlayer.enablePuke = config.getBoolean("enablePuke", false);
        BPlayer.pukeDespawntime = config.getInt("pukeDespawntime", 60) * 20;
        BPlayer.homeType = config.getString("homeType", null);
        Brew.colorInBarrels = config.getBoolean("colorInBarrels", false);
        Brew.colorInBrewer = config.getBoolean("colorInBrewer", false);
        PlayerListener.openEverywhere = config.getBoolean("openLargeBarrelEverywhere", false);
        ConfigurationSection configSection = config.getConfigurationSection("recipes");
        if (configSection != null) {
            for (String recipeId : configSection.getKeys(false)) {
                BRecipe recipe = new BRecipe(configSection, recipeId);
                if (recipe.isValid()) {
                    BIngredients.recipes.add(recipe);
                    continue;
                }
                this.errorLog("Loading the Recipe with id: '" + recipeId + "' failed!");
            }
        }
        if ((configSection = config.getConfigurationSection("cooked")) != null) {
            for (String ingredient : configSection.getKeys(false)) {
                Material mat = Material.matchMaterial((String)ingredient);
                if (mat == null && this.hasVault) {
                    try {
                        ItemInfo vaultItem = Items.itemByString((String)ingredient);
                        if (vaultItem != null) {
                            mat = vaultItem.getType();
                        }
                    }
                    catch (Exception e) {
                        p.errorLog("Could not check vault for Item Name");
                        e.printStackTrace();
                    }
                }
                if (mat != null) {
                    BIngredients.cookedNames.put(mat, configSection.getString(ingredient, null));
                    BIngredients.possibleIngredients.add(mat);
                    continue;
                }
                this.errorLog("Unknown Material: " + ingredient);
            }
        }
        if ((drainList = config.getStringList("drainItems")) != null) {
            for (String drainString : drainList) {
                String[] drainSplit = drainString.split("/");
                if (drainSplit.length <= 1) continue;
                Material mat = Material.matchMaterial((String)drainSplit[0]);
                int strength = p.parseInt(drainSplit[1]);
                if (mat == null && this.hasVault && strength > 0) {
                    try {
                        ItemInfo vaultItem = Items.itemByString((String)drainSplit[0]);
                        if (vaultItem != null) {
                            mat = vaultItem.getType();
                        }
                    }
                    catch (Exception e) {
                        p.errorLog("Could not check vault for Item Name");
                        e.printStackTrace();
                    }
                }
                if (mat == null || strength <= 0) continue;
                BPlayer.drainItems.put(mat, strength);
            }
        }
        if (config.getBoolean("enableChatDistortion", false)) {
            for (Map map : config.getMapList("words")) {
                new Words(map);
            }
            for (String bypass : config.getStringList("distortBypass")) {
                Words.ignoreText.add(bypass.split(","));
            }
            Words.commands = config.getStringList("distortCommands");
        }
        Words.log = config.getBoolean("logRealChat", false);
        Words.doSigns = config.getBoolean("distortSignText", false);
        return true;
    }

    public void readData() {
        File file = new File(p.getDataFolder(), "data.yml");
        if (file.exists()) {
            YamlConfiguration data = YamlConfiguration.loadConfiguration((File)file);
            Brew.installTime = data.getLong("installTime", System.currentTimeMillis());
            String version = data.getString("Version", null);
            if (version != null && !version.equals("1.1")) {
                p.log("Data File is being updated...");
                new DataUpdater((FileConfiguration)data, file).update(version);
                data = YamlConfiguration.loadConfiguration((File)file);
                p.log("Data Updated to version: 1.1");
            }
            HashMap<String, BIngredients> ingMap = new HashMap<String, BIngredients>();
            ConfigurationSection section = data.getConfigurationSection("Ingredients");
            if (section != null) {
                for (String id : section.getKeys(false)) {
                    ConfigurationSection matSection = section.getConfigurationSection(id + ".mats");
                    if (matSection != null) {
                        ArrayList<ItemStack> ingredients = this.deserializeIngredients(matSection);
                        ingMap.put(id, new BIngredients(ingredients, section.getInt(id + ".cookedTime", 0)));
                        continue;
                    }
                    this.errorLog("Ingredient id: '" + id + "' incomplete in data.yml");
                }
            }
            if ((section = data.getConfigurationSection("Brew")) != null) {
                for (String uid : section.getKeys(false)) {
                    BIngredients ingredients = this.getIngredients(ingMap, section.getString(uid + ".ingId"));
                    int quality = section.getInt(uid + ".quality", 0);
                    int distillRuns = section.getInt(uid + ".distillRuns", 0);
                    float ageTime = (float)section.getDouble(uid + ".ageTime", 0.0);
                    float wood = (float)section.getDouble(uid + ".wood", -1.0);
                    String recipe = section.getString(uid + ".recipe", null);
                    boolean unlabeled = section.getBoolean(uid + ".unlabeled", false);
                    boolean persistent = section.getBoolean(uid + ".persist", false);
                    boolean stat = section.getBoolean(uid + ".stat", false);
                    int lastUpdate = section.getInt("lastUpdate", 0);
                    new Brew(this.parseInt(uid), ingredients, quality, distillRuns, ageTime, wood, recipe, unlabeled, persistent, stat, lastUpdate);
                }
            }
            if ((section = data.getConfigurationSection("Player")) != null) {
                for (String name : section.getKeys(false)) {
                    block15: {
                        try {
                            UUID.fromString(name);
                            if (!useUUID) {
                            }
                            break block15;
                        }
                        catch (IllegalArgumentException e) {
                            if (!useUUID) break block15;
                        }
                        continue;
                    }
                    int quality = section.getInt(name + ".quality");
                    int drunk = section.getInt(name + ".drunk");
                    int offDrunk = section.getInt(name + ".offDrunk", 0);
                    new BPlayer(name, quality, drunk, offDrunk);
                }
            }
            for (World world : p.getServer().getWorlds()) {
                if (world.getName().startsWith("DXL_")) {
                    this.loadWorldData(this.getDxlName(world.getName()), world);
                    continue;
                }
                this.loadWorldData(world.getUID().toString(), world);
            }
        } else {
            this.errorLog("No data.yml found, will create new one!");
        }
    }

    public ArrayList<ItemStack> deserializeIngredients(ConfigurationSection matSection) {
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        for (String mat : matSection.getKeys(false)) {
            String[] matSplit = mat.split(",");
            Material m = Material.getMaterial((String)matSplit[0]);
            if (m == null && use1_13) {
                m = matSplit[0].equals("LONG_GRASS") ? Material.GRASS : Material.matchMaterial((String)matSplit[0], (boolean)true);
                this.debugLog("converting Data Material from " + matSplit[0] + " to " + m);
            }
            if (m == null) continue;
            ItemStack item = new ItemStack(m, matSection.getInt(mat));
            if (matSplit.length == 2) {
                item.setDurability((short)p.parseInt(matSplit[1]));
            }
            ingredients.add(item);
        }
        return ingredients;
    }

    public BIngredients getIngredients(Map<String, BIngredients> ingMap, String id) {
        if (!ingMap.isEmpty() && ingMap.containsKey(id)) {
            return ingMap.get(id);
        }
        this.errorLog("Ingredient id: '" + id + "' not found in data.yml");
        return new BIngredients();
    }

    public BIngredients loadIngredients(ConfigurationSection section) {
        if (section != null) {
            return new BIngredients(this.deserializeIngredients(section), 0);
        }
        this.errorLog("Cauldron is missing Ingredient Section");
        return new BIngredients();
    }

    public void loadWorldData(String uuid, World world) {
        File file = new File(p.getDataFolder(), "data.yml");
        if (file.exists()) {
            String[] splitted;
            ConfigurationSection section;
            YamlConfiguration data = YamlConfiguration.loadConfiguration((File)file);
            if (data.contains("BCauldron." + uuid)) {
                section = data.getConfigurationSection("BCauldron." + uuid);
                for (String cauldron : section.getKeys(false)) {
                    String block = section.getString(cauldron + ".block");
                    if (block != null) {
                        splitted = block.split("/");
                        if (splitted.length == 3) {
                            Block worldBlock = world.getBlockAt(this.parseInt(splitted[0]), this.parseInt(splitted[1]), this.parseInt(splitted[2]));
                            BIngredients ingredients = this.loadIngredients(section.getConfigurationSection(cauldron + ".ingredients"));
                            int state = section.getInt(cauldron + ".state", 1);
                            new BCauldron(worldBlock, ingredients, state);
                            continue;
                        }
                        this.errorLog("Incomplete Block-Data in data.yml: " + section.getCurrentPath() + "." + cauldron);
                        continue;
                    }
                    this.errorLog("Missing Block-Data in data.yml: " + section.getCurrentPath() + "." + cauldron);
                }
            }
            if (data.contains("Barrel." + uuid)) {
                section = data.getConfigurationSection("Barrel." + uuid);
                for (String barrel : section.getKeys(false)) {
                    String spigot = section.getString(barrel + ".spigot");
                    if (spigot != null) {
                        splitted = spigot.split("/");
                        if (splitted.length == 3) {
                            ConfigurationSection invSection = section.getConfigurationSection(barrel + ".inv");
                            Block block = world.getBlockAt(this.parseInt(splitted[0]), this.parseInt(splitted[1]), this.parseInt(splitted[2]));
                            float time = (float)section.getDouble(barrel + ".time", 0.0);
                            byte sign = (byte)section.getInt(barrel + ".sign", 0);
                            String[] st = section.getString(barrel + ".st", "").split(",");
                            String[] wo = section.getString(barrel + ".wo", "").split(",");
                            if (invSection != null) {
                                new Barrel(block, sign, st, wo, invSection.getValues(true), time);
                                continue;
                            }
                            new Barrel(block, sign, st, wo, null, time);
                            continue;
                        }
                        this.errorLog("Incomplete Block-Data in data.yml: " + section.getCurrentPath() + "." + barrel);
                        continue;
                    }
                    this.errorLog("Missing Block-Data in data.yml: " + section.getCurrentPath() + "." + barrel);
                }
            }
            if (data.contains("Wakeup." + uuid)) {
                section = data.getConfigurationSection("Wakeup." + uuid);
                for (String wakeup : section.getKeys(false)) {
                    String loc = section.getString(wakeup);
                    if (loc == null) continue;
                    splitted = loc.split("/");
                    if (splitted.length == 5) {
                        double x = NumberUtils.toDouble((String)splitted[0]);
                        double y = NumberUtils.toDouble((String)splitted[1]);
                        double z = NumberUtils.toDouble((String)splitted[2]);
                        float pitch = NumberUtils.toFloat((String)splitted[3]);
                        float yaw = NumberUtils.toFloat((String)splitted[4]);
                        Location location = new Location(world, x, y, z, yaw, pitch);
                        Wakeup.wakeups.add(new Wakeup(location));
                        continue;
                    }
                    this.errorLog("Incomplete Location-Data in data.yml: " + section.getCurrentPath() + "." + wakeup);
                }
            }
        }
    }

    private boolean checkConfigs() {
        File cfg = new File(p.getDataFolder(), "config.yml");
        if (!cfg.exists()) {
            this.errorLog("No config.yml found, creating default file! You may want to choose a config according to your language!");
            this.errorLog("You can find them in plugins/Brewery/configs/");
            InputStream defconf = this.getResource("config/" + (use1_13 ? "v13/" : "v12/") + "en/config.yml");
            if (defconf == null) {
                this.errorLog("default config file not found, your jarfile may be corrupt. Disabling Brewery!");
                return false;
            }
            try {
                P.saveFile(defconf, this.getDataFolder(), "config.yml", false);
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        if (!cfg.exists()) {
            this.errorLog("default config file could not be copied, your jarfile may be corrupt. Disabling Brewery!");
            return false;
        }
        this.copyDefaultConfigs(false);
        return true;
    }

    private void copyDefaultConfigs(boolean overwrite) {
        File configs = new File(this.getDataFolder(), "configs");
        File languages = new File(this.getDataFolder(), "languages");
        for (String l : new String[]{"de", "en", "fr", "it"}) {
            File lfold = new File(configs, l);
            try {
                P.saveFile(this.getResource("config/" + (use1_13 ? "v13/" : "v12/") + l + "/config.yml"), lfold, "config.yml", overwrite);
                P.saveFile(this.getResource("languages/" + l + ".yml"), languages, l + ".yml", false);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public int parseInt(String string) {
        return NumberUtils.toInt((String)string, (int)0);
    }

    public String getDxlName(String worldName) {
        File dungeonFolder = new File(worldName);
        if (dungeonFolder.isDirectory()) {
            for (File file : dungeonFolder.listFiles()) {
                if (file.isDirectory() || !file.getName().startsWith(".id_")) continue;
                return file.getName().substring(1).toLowerCase();
            }
        }
        return worldName;
    }

    public void createWorldSections(ConfigurationSection section) {
        for (World world : p.getServer().getWorlds()) {
            String worldName = world.getName();
            worldName = worldName.startsWith("DXL_") ? this.getDxlName(worldName) : world.getUID().toString();
            section.createSection(worldName);
        }
    }

    public void list(CommandSender sender, ArrayList<String> strings, int page) {
        int pages = (int)Math.ceil((float)strings.size() / 7.0f);
        if (page > pages || page < 1) {
            page = 1;
        }
        sender.sendMessage(this.color("&7-------------- &f" + this.languageReader.get("Etc_Page", new String[0]) + " &6" + page + "&f/&6" + pages + " &7--------------"));
        ListIterator<String> iter = strings.listIterator((page - 1) * 7);
        for (int i = 0; i < 7 && iter.hasNext(); ++i) {
            sender.sendMessage(this.color(iter.next()));
        }
    }

    public boolean blockDestroy(Block block, Player player) {
        Barrel barrel3;
        Material type = block.getType();
        if (type == Material.CAULDRON) {
            BCauldron.remove(block);
            return true;
        }
        if (LegacyUtil.isFence(type)) {
            Barrel barrel = Barrel.getBySpigot(block);
            if (barrel != null) {
                if (barrel.hasPermsDestroy(player)) {
                    barrel.remove(null, player);
                    return true;
                }
                return false;
            }
            return true;
        }
        if (LegacyUtil.isSign(type)) {
            Barrel barrel2 = Barrel.getBySpigot(block);
            if (barrel2 != null) {
                if (!barrel2.isLarge()) {
                    if (barrel2.hasPermsDestroy(player)) {
                        barrel2.remove(null, player);
                        return true;
                    }
                    return false;
                }
                barrel2.destroySign();
            }
            return true;
        }
        if ((LegacyUtil.isWoodPlanks(type) || LegacyUtil.isWoodStairs(type)) && (barrel3 = Barrel.getByWood(block)) != null) {
            if (barrel3.hasPermsDestroy(player)) {
                barrel3.remove(block, player);
            } else {
                return false;
            }
        }
        return true;
    }

    public String color(String msg) {
        if (msg != null) {
            msg = ChatColor.translateAlternateColorCodes((char)'&', (String)msg);
        }
        return msg;
    }

    public static void saveFile(InputStream in, File dest, String name, boolean overwrite) throws IOException {
        int length;
        File result;
        if (in == null) {
            return;
        }
        if (!dest.exists()) {
            dest.mkdirs();
        }
        if ((result = new File(dest, name)).exists()) {
            if (overwrite) {
                result.delete();
            } else {
                return;
            }
        }
        FileOutputStream out = new FileOutputStream(result);
        byte[] buffer = new byte[1024];
        while ((length = in.read(buffer)) > 0) {
            ((OutputStream)out).write(buffer, 0, length);
        }
        in.close();
        ((OutputStream)out).close();
    }

    public static String playerString(Player player) {
        if (useUUID) {
            return player.getUniqueId().toString();
        }
        return player.getName();
    }

    public static Player getPlayerfromString(String name) {
        if (useUUID) {
            try {
                return Bukkit.getPlayer((UUID)UUID.fromString(name));
            }
            catch (Exception e) {
                return Bukkit.getPlayerExact((String)name);
            }
        }
        return Bukkit.getPlayerExact((String)name);
    }

    public class BreweryRunnable
    implements Runnable {
        @Override
        public void run() {
            P.this.reloader = null;
            for (BCauldron cauldron : BCauldron.bcauldrons) {
                cauldron.onUpdate();
            }
            Barrel.onUpdate();
            BPlayer.onUpdate();
            P.this.debugLog("Update");
            DataSave.autoSave();
        }
    }

    public class DrunkRunnable
    implements Runnable {
        @Override
        public void run() {
            if (!BPlayer.isEmpty()) {
                BPlayer.drunkeness();
            }
        }
    }
}

