/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.filedata;

import com.dre.brewery.LegacyUtil;
import com.dre.brewery.P;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.Material;

public class ConfigUpdater {
    private ArrayList<String> config = new ArrayList();
    private File file;

    public ConfigUpdater(File file) {
        this.file = file;
        this.getConfigString();
    }

    public int indexOfStart(String lineStart) {
        for (int i = 0; i < this.config.size(); ++i) {
            if (!this.config.get(i).startsWith(lineStart)) continue;
            return i;
        }
        return -1;
    }

    public void appendLines(String ... lines) {
        this.config.addAll(Arrays.asList(lines));
    }

    public void setLine(int index, String newLine) {
        this.config.set(index, newLine);
    }

    public void addLines(int index, String ... newLines) {
        this.config.addAll(index, Arrays.asList(newLines));
    }

    public void saveConfig() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String line : this.config) {
            stringBuilder.append(line).append("\n");
        }
        String configString = stringBuilder.toString().trim();
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.file));
            writer.write(configString);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void getConfigString() {
        try {
            String currentLine;
            BufferedReader reader = new BufferedReader(new FileReader(this.file));
            while ((currentLine = reader.readLine()) != null) {
                this.config.add(currentLine);
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void update(String fromVersion, boolean oldMat, String lang) {
        if (fromVersion.equals("0.5") && !lang.equals("de")) {
            lang = "de";
        }
        boolean de = lang.equals("de");
        if (fromVersion.equals("0.5") || fromVersion.equals("1.0")) {
            if (de) {
                this.update05de();
            } else {
                this.update10en();
            }
            fromVersion = "1.1";
        }
        if (fromVersion.equals("1.1") || fromVersion.equals("1.1.1")) {
            if (de) {
                this.update11de();
            } else {
                this.update11en();
            }
            fromVersion = "1.2";
        }
        if (fromVersion.equals("1.2")) {
            if (de) {
                this.update12de();
            } else {
                this.update12en();
            }
            fromVersion = "1.3";
        }
        if (fromVersion.equals("1.3")) {
            if (de) {
                this.update13de();
            } else {
                this.update13en();
            }
            fromVersion = "1.3.1";
        }
        if (fromVersion.equals("1.3.1")) {
            if (de) {
                this.update131de();
            } else {
                this.update131en();
            }
            fromVersion = "1.4";
        }
        if (fromVersion.equals("1.4")) {
            if (de) {
                this.update14de();
            } else {
                this.update14en();
            }
            fromVersion = "1.5";
        }
        if (fromVersion.equals("1.5") || fromVersion.equals("1.6")) {
            this.update15(P.use1_13, de);
            fromVersion = "1.7";
            oldMat = false;
        }
        if (P.use1_13 && oldMat) {
            this.updateMaterials(true);
        }
        if (!fromVersion.equals("1.7")) {
            P.p.log(P.p.languageReader.get("Error_ConfigUpdate", fromVersion));
            return;
        }
        this.saveConfig();
    }

    private void updateVersion(String to) {
        int index = this.indexOfStart("version");
        String line = "version: '" + to + "'";
        if (index != -1) {
            this.setLine(index, line);
        } else {
            index = this.indexOfStart("# Config Version");
            if (index == -1) {
                index = this.indexOfStart("autosave");
            }
            if (index == -1) {
                this.appendLines(line);
            } else {
                this.addLines(index, line);
            }
        }
    }

    private void update05de() {
        this.updateVersion("1.1");
        int index = this.indexOfStart("language: en");
        if (index != -1) {
            this.setLine(index, "language: de");
            P.p.language = "de";
        }
        String[] entries = new String[]{"# -- Chat Ver\u00e4nderungs Einstellungen --", "", "# Text nach den angegebenen Kommandos wird bei Trunkenheit ebenfalls Ver\u00e4ndert (Liste) [- /gl]", "distortCommands:", "- /gl", "- /global", "- /fl", "- /s", "- /letter", "", "# Geschriebenen Text auf Schildern bei Trunkenheit ver\u00e4ndern [false]", "distortSignText: false", "", "# Text, der zwischen diesen Buchstaben steht, wird nicht ver\u00e4ndert (\",\" als Trennung verwenden) (Liste) [- '[,]']", "distortBypass:", "- '*,*'", "- '[,]'", ""};
        index = this.indexOfStart("# words");
        if (index == -1) {
            index = this.indexOfStart("# Diese werden von oben");
        }
        if (index == -1) {
            index = this.indexOfStart("# replace");
        }
        if (index == -1) {
            index = this.indexOfStart("words:");
        }
        if (index == -1) {
            this.appendLines(entries);
        } else {
            this.addLines(index, entries);
        }
        String line = "# -- Verschiedene Einstellungen --";
        index = this.indexOfStart("# Verschiedene Einstellungen");
        if (index != -1) {
            this.setLine(index, line);
        }
        line = "# -- Rezepte f\u00fcr Getr\u00e4nke --";
        index = this.indexOfStart("# Rezepte f\u00fcr Getr\u00e4nke");
        if (index != -1) {
            this.setLine(index, line);
        }
    }

    private void update10en() {
        this.updateVersion("1.1");
        String[] entries = new String[]{"# -- Chat Distortion Settings --", "", "# Text after specified commands will be distorted when drunk (list) [- /gl]", "distortCommands:", "- /gl", "- /global", "- /fl", "- /s", "- /letter", "", "# Distort the Text written on a Sign while drunk [false]", "distortSignText: false", "", "# Enclose a text with these Letters to bypass Chat Distortion (Use \",\" as Separator) (list) [- '[,]']", "distortBypass:", "- '*,*'", "- '[,]'", ""};
        int index = this.indexOfStart("# words");
        if (index == -1) {
            index = this.indexOfStart("# Will be processed");
        }
        if (index == -1) {
            index = this.indexOfStart("# replace");
        }
        if (index == -1) {
            index = this.indexOfStart("words:");
        }
        if (index == -1) {
            this.appendLines(entries);
        } else {
            this.addLines(index, entries);
        }
        String line = "# -- Settings --";
        index = this.indexOfStart("# Settings");
        if (index != -1) {
            this.setLine(index, line);
        }
        line = "# -- Recipes for Potions --";
        index = this.indexOfStart("# Recipes for Potions");
        if (index != -1) {
            this.setLine(index, line);
        }
    }

    private void update11de() {
        this.updateVersion("1.2");
        int index = this.indexOfStart("# Das Item kann nicht aufgesammelt werden");
        if (index != -1) {
            this.setLine(index, "# Das Item kann nicht aufgesammelt werden und bleibt bis zum Despawnen liegen. (Achtung: Kann nach Serverrestart aufgesammelt werden!)");
        }
        String[] lines = new String[]{"# Ob gro\u00dfe F\u00e4sser an jedem Block ge\u00f6ffnet werden k\u00f6nnen, nicht nur an Zapfhahn und Schild. Bei kleinen F\u00e4ssern geht dies immer. [true]", "openLargeBarrelEverywhere: true", ""};
        index = this.indexOfStart("colorInBrewer") + 2;
        if (index == 1) {
            index = this.indexOfStart("colorInBarrels") + 2;
        }
        if (index == 1) {
            index = this.indexOfStart("# Autosave");
        }
        if (index == -1) {
            index = this.indexOfStart("language") + 2;
        }
        if (index == 1) {
            this.addLines(3, lines);
        } else {
            this.addLines(index, lines);
        }
        lines = new String[]{"", "# -- Plugin Kompatiblit\u00e4t --", "", "# Andere Plugins (wenn installiert) nach Rechten zum \u00f6ffnen von F\u00e4ssern checken [true]", "useWorldGuard: true", "useLWC: true", "useGriefPrevention: true", "", "# \u00c4nderungen an Fassinventaren mit LogBlock aufzeichen [true]", "useLogBlock: true", "", ""};
        index = this.indexOfStart("# -- Chat Ver\u00e4nderungs Einstellungen");
        if (index == -1) {
            index = this.indexOfStart("# words");
        }
        if (index == -1 && (index = this.indexOfStart("distortCommands")) > 4) {
            index -= 4;
        }
        if (index != -1) {
            this.addLines(index, lines);
        } else {
            this.appendLines(lines);
        }
    }

    private void update11en() {
        this.updateVersion("1.2");
        int index = this.indexOfStart("# The item can not be collected");
        if (index != -1) {
            this.setLine(index, "# The item can not be collected and stays on the ground until it despawns. (Warning: Can be collected after Server restart!)");
        }
        String[] lines = new String[]{"# If a Large Barrel can be opened by clicking on any of its blocks, not just Spigot or Sign. This is always true for Small Barrels. [true]", "openLargeBarrelEverywhere: true", ""};
        index = this.indexOfStart("colorInBrewer") + 2;
        if (index == 1) {
            index = this.indexOfStart("colorInBarrels") + 2;
        }
        if (index == 1) {
            index = this.indexOfStart("# Autosave");
        }
        if (index == -1) {
            index = this.indexOfStart("language") + 2;
        }
        if (index == 1) {
            this.addLines(3, lines);
        } else {
            this.addLines(index, lines);
        }
        lines = new String[]{"", "# -- Plugin Compatibility --", "", "# Enable checking of other Plugins (if installed) for Barrel Permissions [true]", "useWorldGuard: true", "useLWC: true", "useGriefPrevention: true", "", "# Enable the Logging of Barrel Inventories to LogBlock [true]", "useLogBlock: true", "", ""};
        index = this.indexOfStart("# -- Chat Distortion Settings");
        if (index == -1) {
            index = this.indexOfStart("# words");
        }
        if (index == -1 && (index = this.indexOfStart("distortCommands")) > 4) {
            index -= 4;
        }
        if (index != -1) {
            this.addLines(index, lines);
        } else {
            this.appendLines(lines);
        }
    }

    private void update12de() {
        this.updateVersion("1.3");
        int index = this.indexOfStart("# wood:");
        if (index != -1) {
            this.setLine(index, "# wood: Holz des Fasses 0=alle Holzsorten 1=Birke 2=Eiche 3=Jungel 4=Fichte 5=Akazie 6=Schwarzeiche");
        }
        if ((index = this.indexOfStart("# cooked:")) != -1) {
            this.addLines(index + 1, "# [Beispiel] MATERIAL_oder_id: Name nach G\u00e4hren");
        }
        String replacedLine = "# ingredients: Auflistung von 'Material oder ID,Data/Anzahl'";
        String[] lines = new String[]{"#   (Item-ids anstatt Material werden von Bukkit nicht mehr unterst\u00fctzt und funktionieren m\u00f6glicherweise in Zukunft nicht mehr!)", "#   Eine Liste von allen Materialien kann hier gefunden werden: http://jd.bukkit.org/beta/apidocs/org/bukkit/Material.html", "#   Es kann ein Data-Wert angegeben werden, weglassen ignoriert diesen beim hinzuf\u00fcgen einer Zutat"};
        index = this.indexOfStart("# ingredients:");
        if (index != -1) {
            this.setLine(index, replacedLine);
            this.addLines(index + 1, lines);
        } else {
            index = this.indexOfStart("# name:");
            if (index != -1) {
                this.addLines(index + 1, lines);
                this.addLines(index + 1, replacedLine);
            } else {
                index = this.indexOfStart("# -- Rezepte f\u00fcr Getr\u00e4nke --");
                if (index != -1) {
                    this.addLines(index + 2, lines);
                    this.addLines(index + 2, "", replacedLine);
                }
            }
        }
        replacedLine = "# color: Farbe des Getr\u00e4nks nach destillieren/reifen.";
        lines = new String[]{"#   Benutzbare Farben: DARK_RED, RED, BRIGHT_RED, ORANGE, PINK, BLUE, CYAN, WATER, GREEN, BLACK, GREY, BRIGHT_GREY"};
        index = this.indexOfStart("# color:");
        if (index != -1) {
            this.setLine(index, replacedLine);
            this.addLines(index + 1, lines);
        } else {
            index = this.indexOfStart("# age:");
            if (index != -1) {
                this.addLines(index + 1, lines);
                this.addLines(index + 1, replacedLine);
            }
        }
        replacedLine = "# effects: Auflistung Effekt/Level/Dauer  Besonderere Trank-Effekte beim Trinken, Dauer in sek.";
        lines = new String[]{"#   Ein 'X' an den Namen anh\u00e4ngen, um ihn zu verbergen. Bsp: 'POISONX/2/10' (WEAKNESS, INCREASE_DAMAGE, SLOW und SPEED sind immer verborgen.)", "#   M\u00f6gliche Effekte: http://jd.bukkit.org/rb/apidocs/org/bukkit/potion/PotionEffectType.html", "#   Minimale und Maximale Level/Dauer k\u00f6nnen durch \"-\" festgelegt werden, Bsp: 'SPEED/1-2/30-40' = Level 1 und 30 sek minimal, Level 2 und 40 sek maximal", "#   Diese Bereiche funktionieren auch umgekehrt, Bsp: 'POISON/3-1/20-5' f\u00fcr abschw\u00e4chende Effekte bei guter Qualit\u00e4t", "#   L\u00e4ngste m\u00f6gliche Effektdauer: 1638 sek. Es muss keine Dauer f\u00fcr Effekte mit sofortiger Wirkung angegeben werden."};
        index = this.indexOfStart("# effects:");
        if (index != -1) {
            this.setLine(index, replacedLine);
            this.addLines(index + 1, lines);
        } else {
            index = this.indexOfStart("# alcohol:");
            if (index != -1) {
                this.addLines(index + 1, lines);
                this.addLines(index + 1, replacedLine);
            } else {
                index = this.indexOfStart("# -- Rezepte f\u00fcr Getr\u00e4nke --");
                if (index != -1) {
                    this.addLines(index + 2, lines);
                    this.addLines(index + 2, "", replacedLine);
                }
            }
        }
        if (index != -1 && (index = this.indexOfStart("#   (WEAKNESS, INCREASE_DAMAGE, SLOW und SPEED sind immer verborgen.)  M\u00f6gliche Effekte:")) != -1) {
            this.config.remove(index);
        }
        if ((index = this.indexOfStart("#   Bei Effekten mit sofortiger Wirkung ")) != -1) {
            this.config.remove(index);
        }
    }

    private void update12en() {
        this.updateVersion("1.3");
        int index = this.indexOfStart("# wood:");
        if (index != -1) {
            this.setLine(index, "# wood: Wood of the barrel 0=any 1=Birch 2=Oak 3=Jungle 4=Spruce 5=Acacia 6=Dark Oak");
        }
        if ((index = this.indexOfStart("# cooked:")) != -1) {
            this.addLines(index + 1, "# [Example] MATERIAL_or_id: Name after cooking");
        }
        String replacedLine = "# ingredients: List of 'material or id,data/amount'";
        String[] lines = new String[]{"#   (Item-ids instead of material are deprecated by bukkit and may not work in the future!)", "#   A list of materials can be found here: http://jd.bukkit.org/beta/apidocs/org/bukkit/Material.html", "#   You can specify a data value, omitting it will ignore the data value of the added ingredient"};
        index = this.indexOfStart("# ingredients:");
        if (index != -1) {
            this.setLine(index, replacedLine);
            this.addLines(index + 1, lines);
        } else {
            index = this.indexOfStart("# name:");
            if (index != -1) {
                this.addLines(index + 1, lines);
                this.addLines(index + 1, replacedLine);
            } else {
                index = this.indexOfStart("# -- Recipes for Potions --");
                if (index != -1) {
                    this.addLines(index + 2, lines);
                    this.addLines(index + 2, "", replacedLine);
                }
            }
        }
        replacedLine = "# color: Color of the potion after distilling/aging.";
        lines = new String[]{"#   Usable Colors: DARK_RED, RED, BRIGHT_RED, ORANGE, PINK, BLUE, CYAN, WATER, GREEN, BLACK, GREY, BRIGHT_GREY"};
        index = this.indexOfStart("# color:");
        if (index != -1) {
            this.setLine(index, replacedLine);
            this.addLines(index + 1, lines);
        } else {
            index = this.indexOfStart("# age:");
            if (index != -1) {
                this.addLines(index + 1, lines);
                this.addLines(index + 1, replacedLine);
            }
        }
        replacedLine = "# effects: List of effect/level/duration  Special potion-effect when drinking, duration in sek.";
        lines = new String[]{"#   Suffix name with 'X' to hide effect from label. Sample: 'POISONX/2/10' (WEAKNESS, INCREASE_DAMAGE, SLOW and SPEED are always hidden.)", "#   Possible Effects: http://jd.bukkit.org/rb/apidocs/org/bukkit/potion/PotionEffectType.html", "#   Level or Duration ranges may be specified with a \"-\", ex. 'SPEED/1-2/30-40' = lvl 1 and 30 sec at worst and lvl 2 and 40 sec at best", "#   Ranges also work high-low, ex. 'POISON/3-1/20-5' for weaker effects at good quality.", "#   Highest possible Duration: 1638 sec. Instant Effects dont need any duration specified."};
        index = this.indexOfStart("# effects:");
        if (index != -1) {
            this.setLine(index, replacedLine);
            this.addLines(index + 1, lines);
        } else {
            index = this.indexOfStart("# alcohol:");
            if (index != -1) {
                this.addLines(index + 1, lines);
                this.addLines(index + 1, replacedLine);
            } else {
                index = this.indexOfStart("# -- Recipes for Potions --");
                if (index != -1) {
                    this.addLines(index + 2, lines);
                    this.addLines(index + 2, "", replacedLine);
                }
            }
        }
        if (index != -1 && (index = this.indexOfStart("#   (WEAKNESS, INCREASE_DAMAGE, SLOW and SPEED are always hidden.)  Possible Effects:")) != -1) {
            this.config.remove(index);
        }
        if ((index = this.indexOfStart("#   instant effects ")) != -1) {
            this.config.remove(index);
        }
    }

    private void update13de() {
        this.updateVersion("1.3.1");
        int index = this.indexOfStart("# Autosave");
        String[] lines = new String[]{"# Aktiviert das Suchen nach Updates f\u00fcr Brewery mit der curseforge api [true]", "# Wenn ein Update gefunden wurde, wird dies bei Serverstart im log angezeigt, sowie ops benachrichtigt", "updateCheck: true", ""};
        if (index == -1 && (index = this.indexOfStart("autosave:")) == -1 && (index = this.indexOfStart("# Sprachedatei")) == -1) {
            index = this.indexOfStart("language:");
        }
        if (index == -1) {
            this.appendLines(lines);
        } else {
            this.addLines(index, lines);
        }
    }

    private void update13en() {
        this.updateVersion("1.3.1");
        int index = this.indexOfStart("# Autosave");
        String[] lines = new String[]{"# Enable checking for Updates, Checks the curseforge api for updates to Brewery [true]", "# If an Update is found a Message is logged on Server-start and displayed to ops joining the game", "updateCheck: true", ""};
        if (index == -1 && (index = this.indexOfStart("autosave:")) == -1 && (index = this.indexOfStart("# Languagefile")) == -1) {
            index = this.indexOfStart("language:");
        }
        if (index == -1) {
            this.appendLines(lines);
        } else {
            this.addLines(index, lines);
        }
    }

    private void update131de() {
        this.updateVersion("1.4");
        int index = this.indexOfStart("# SamplePlugin = installiertes home plugin. Unterst\u00fctzt: ManagerXL.");
        if (index != -1) {
            this.config.remove(index);
        }
        if ((index = this.indexOfStart("# Ob der Spieler nach etwas k\u00fcrzerem Ausloggen an einem zuf\u00e4lligen Ort \"aufwacht\" (diese m\u00fcssen durch '/br Wakeup add")) != -1) {
            this.setLine(index, "# Ob der Spieler nach etwas k\u00fcrzerem Ausloggen an einem zuf\u00e4lligen Ort \"aufwacht\" (diese m\u00fcssen durch '/brew Wakeup add' von einem Admin festgelegt werden)");
        }
        if ((index = this.indexOfStart("# Ob der Spieler sich bei gro\u00dfer Trunkenheit teilweise nicht einloggen kann und kurz warten muss, da sein Charakter nicht reagiert")) != -1) {
            this.setLine(index, "# Ob der Spieler bei gro\u00dfer Trunkenheit mehrmals probieren muss sich einzuloggen, da sein Charakter kurz nicht reagiert [true]");
        }
        if ((index = this.indexOfStart("# Ob der Spieler sich \u00fcbertrinken kann und dann in Ohnmacht f\u00e4llt (gekickt wird)")) != -1) {
            this.setLine(index, "# Ob der Spieler kurz in Ohnmacht f\u00e4llt (vom Server gekickt wird) wenn er die maximale Trunkenheit erreicht [false]");
        }
        if ((index = this.indexOfStart("# Das Item kann nicht aufgesammelt werden und bleibt bis zum Despawnen liegen. (Achtung:")) != -1) {
            this.setLine(index, "# Das Item kann nicht aufgesammelt werden und bleibt bis zum Despawnen liegen.");
        }
        String[] lines = new String[]{"", "# Zeit in Sekunden bis die pukeitems despawnen, (mc standard w\u00e4re 300 = 5 min) [60]", "# Wurde die item Despawnzeit in der spigot.yml ver\u00e4ndert, ver\u00e4ndert sich auch die pukeDespawnzeit in Abh\u00e4ngigkeit.", "pukeDespawntime: 60"};
        index = this.indexOfStart("pukeItem:");
        if (index == -1 && (index = this.indexOfStart("enablePuke:")) == -1 && (index = this.indexOfStart("# Konsumierbares Item") - 1) == -2 && (index = this.indexOfStart("enableKickOnOverdrink:")) == -1) {
            index = this.indexOfStart("language:");
        }
        if (index == -1) {
            this.appendLines(lines);
        } else {
            this.addLines(index + 1, lines);
        }
        index = this.indexOfStart("# F\u00e4rben der Iteminformationen je nach Qualit\u00e4t w\u00e4hrend sie sich 1. im Fass und/oder 2. im Braustand befinden [true, false]");
        if (index != -1) {
            this.setLine(index, "# F\u00e4rben der Iteminformationen je nach Qualit\u00e4t w\u00e4hrend sie sich 1. im Fass und/oder 2. im Braustand befinden [true, true]");
        }
        if ((index = this.indexOfStart("# Wenn ein Update gefunden wurde, wird dies bei Serverstart im log angezeigt, sowie ops benachrichtigt")) != -1) {
            this.setLine(index, "# Wenn ein Update gefunden wurde, wird dies bei Serverstart im log angezeigt, sowie OPs benachrichtigt");
        }
        if ((index = this.indexOfStart("#   Eine Liste von allen Materialien kann hier gefunden werden: http://jd.bukkit.org")) != -1) {
            this.setLine(index, "#   Eine Liste von allen Materialien kann hier gefunden werden: https://hub.spigotmc.org/javadocs/spigot/org/bukkit/Material.html");
        }
        lines = new String[]{"#   Wenn Vault installiert ist k\u00f6nnen normale englische Item Namen verwendet werden, anstatt Material, ID und Data!", "#   Vault erkennt Namen wie \"Jungle Leaves\" anstatt \"LEAVES,3\". Dies macht es viel einfacher!"};
        index = this.indexOfStart("#   Es kann ein Data-Wert angegeben werden, weglassen");
        if (index != -1) {
            this.setLine(index, "#   Es kann ein Data-Wert (durability) angegeben werden, weglassen ignoriert diesen beim hinzuf\u00fcgen einer Zutat");
            this.addLines(index + 1, lines);
        } else {
            index = this.indexOfStart("#   Eine Liste von allen Materialien kann hier");
            if (index == -1 && (index = this.indexOfStart("# cookingtime: ") - 1) == -2 && (index = this.indexOfStart("# ingredients: Auflistung von")) == -1 && (index = this.indexOfStart("# -- Rezepte f\u00fcr Getr\u00e4nke --") + 1) == 0) {
                index = this.indexOfStart("# -- Verschiedene Einstellungen --");
            }
            if (index == -1) {
                this.appendLines(lines);
            } else {
                this.addLines(index + 1, lines);
            }
        }
        lines = new String[]{"#   Effekte sind ab der 1.9 immer verborgen, wegen \u00c4nderungen an den Tr\u00e4nken."};
        index = this.indexOfStart("#   M\u00f6gliche Effekte: http://jd.bukkit.org");
        if (index != -1) {
            this.setLine(index, "#   M\u00f6gliche Effekte: https://hub.spigotmc.org/javadocs/spigot/org/bukkit/potion/PotionEffectType.html");
            this.addLines(index, lines);
        } else {
            index = this.indexOfStart("#   Ein 'X' an den Namen anh\u00e4ngen, um");
            if (index == -1 && (index = this.indexOfStart("# effects: ")) == -1) {
                index = this.indexOfStart("# -- Rezepte f\u00fcr Getr\u00e4nke --") + 1;
            }
            if (index == 0) {
                this.appendLines(lines);
            } else {
                this.addLines(index + 1, lines);
            }
        }
        index = this.indexOfStart("# Text, der zwischen diesen Buchstaben");
        if (index != -1) {
            this.setLine(index, "# Im Chat geschriebener Text, der zwischen diesen Buchstaben steht, wird nicht ver\u00e4ndert (\",\" als Trennung verwenden) (Liste) [- '[,]']");
        }
    }

    private void update131en() {
        this.updateVersion("1.4");
        int index = this.indexOfStart("# SamplePlugin = installed home plugin. Supports: ManagerXL.");
        if (index != -1) {
            this.config.remove(index);
        }
        if ((index = this.indexOfStart("# If the player \"wakes up\" at a random place when offline for some time while drinking (the places have to be defined with '/br Wakeup add'")) != -1) {
            this.setLine(index, "# If the player \"wakes up\" at a random place when offline for some time while drinking (the places have to be defined with '/brew Wakeup add' through an admin)");
        }
        if ((index = this.indexOfStart("# If the Player may get some logins denied, when his character is drunk")) != -1) {
            this.setLine(index, "# If the Player may have to try multiple times when logging in while extremely drunk [true]");
        }
        if ((index = this.indexOfStart("# If the Player faints (gets kicked) for some minutes if he overdrinks")) != -1) {
            this.setLine(index, "# If the Player faints shortly (gets kicked from the server) if he drinks the max amount of alcohol possible [false]");
        }
        if ((index = this.indexOfStart("# The item can not be collected and stays on the ground until it despawns. (Warning:")) != -1) {
            this.setLine(index, "# The item can not be collected and stays on the ground until it despawns.");
        }
        String[] lines = new String[]{"", "# Time in seconds until the pukeitems despawn, (mc default is 300 = 5 min) [60]", "# If the item despawn time was changed in the spigot.yml, the pukeDespawntime changes as well.", "pukeDespawntime: 60"};
        index = this.indexOfStart("pukeItem:");
        if (index == -1 && (index = this.indexOfStart("enablePuke:")) == -1 && (index = this.indexOfStart("# Consumable Item") - 1) == -2 && (index = this.indexOfStart("enableKickOnOverdrink:")) == -1) {
            index = this.indexOfStart("language:");
        }
        if (index == -1) {
            this.appendLines(lines);
        } else {
            this.addLines(index + 1, lines);
        }
        index = this.indexOfStart("# Color the Item information (lore) depending on quality while it is 1. in a barrel and/or 2. in a brewing stand [true, false]");
        if (index != -1) {
            this.setLine(index, "# Color the Item information (lore) depending on quality while it is 1. in a barrel and/or 2. in a brewing stand [true, true]");
        }
        if ((index = this.indexOfStart("# If an Update is found a Message is logged on Server-start and displayed to ops joining the game")) != -1) {
            this.setLine(index, "# If an Update is found a Message is logged on Server-start and displayed to OPs joining the game");
        }
        if ((index = this.indexOfStart("#   A list of materials can be found here: http://jd.bukkit.org")) != -1) {
            this.setLine(index, "#   A list of materials can be found here: https://hub.spigotmc.org/javadocs/spigot/org/bukkit/Material.html");
        }
        lines = new String[]{"#   If Vault is installed normal names can be used instead of material or id, so using Vault is highly recommended.", "#   Vault will recognize things like \"Jungle Leaves\" instead of \"LEAVES,3\""};
        index = this.indexOfStart("#   You can specify a data value, omitting");
        if (index != -1) {
            this.setLine(index, "#   You can specify a data (durability) value, omitting it will ignore the data value of the added ingredient");
            this.addLines(index + 1, lines);
        } else {
            index = this.indexOfStart("#   A list of materials can be found");
            if (index == -1 && (index = this.indexOfStart("# cookingtime: Time in real minutes") - 1) == -2 && (index = this.indexOfStart("# ingredients: ")) == -1 && (index = this.indexOfStart("# -- Recipes for Potions --") + 1) == 0) {
                index = this.indexOfStart("# -- Settings --");
            }
            if (index == -1) {
                this.appendLines(lines);
            } else {
                this.addLines(index + 1, lines);
            }
        }
        lines = new String[]{"#   Effects are always hidden in 1.9 and newer, because of changes in the potion mechanics."};
        index = this.indexOfStart("#   Possible Effects: http://jd.bukkit.org");
        if (index != -1) {
            this.setLine(index, "#   Possible Effects: https://hub.spigotmc.org/javadocs/spigot/org/bukkit/potion/PotionEffectType.html");
            this.addLines(index, lines);
        } else {
            index = this.indexOfStart("#   Suffix name with");
            if (index == -1 && (index = this.indexOfStart("# effects: ")) == -1) {
                index = this.indexOfStart("# -- Recipes for Potions --") + 1;
            }
            if (index == 0) {
                this.appendLines(lines);
            } else {
                this.addLines(index + 1, lines);
            }
        }
        index = this.indexOfStart("# Enclose a text with these Letters to bypass Chat Distortion");
        if (index != -1) {
            this.setLine(index, "# Enclose a Chat text with these Letters to bypass Chat Distortion (Use \",\" as Separator) (list) [- '[,]']");
        }
    }

    private void update14de() {
        this.updateVersion("1.5");
        String[] lines = new String[]{"", "# Ob geschriebener Chat bei gro\u00dfer Trunkenheit abgef\u00e4lscht werden soll,", "# so dass es etwas betrunken aussieht was geschrieben wird.", "# Wie stark der Chat ver\u00e4ndert wird h\u00e4ngt davon ab wie betrunken der Spieler ist", "# Unten kann noch eingestellt werden wie und was ver\u00e4ndert wird", "enableChatDistortion: true"};
        int index = this.indexOfStart("# -- Chat") + 2;
        if (index == 1 && (index = this.indexOfStart("distortCommands:") - 1) == -2 && (index = this.indexOfStart("distortSignText:") - 1) == -2 && (index = this.indexOfStart("# words:")) == -1) {
            index = this.indexOfStart("words:");
        }
        if (index == -1) {
            this.appendLines(lines);
        } else {
            this.addLines(index - 1, lines);
        }
        lines = new String[]{"# Also zum Beispiel im Chat: Hallo ich bin betrunken *Ich teste Brewery*"};
        index = this.indexOfStart("# Im Chat geschriebener Text, der zwischen");
        if (index != -1) {
            this.addLines(index + 1, lines);
        } else {
            index = this.indexOfStart("distortBypass:");
            if (index != -1) {
                this.addLines(index, lines);
            }
        }
        lines = new String[]{"# distilltime: Wie lange (in sekunden) ein Destillations-Durchlauf braucht (0=Standard Zeit von 40 sek) MC Standard w\u00e4re 20 sek"};
        index = this.indexOfStart("# distillruns:");
        if (index == -1 && (index = this.indexOfStart("# wood:") - 1) == -2 && (index = this.indexOfStart("# -- Rezepte") + 1) == 0) {
            index = -1;
        }
        if (index != -1) {
            this.addLines(index + 1, lines);
        }
        if ((index = this.indexOfStart("      name: Schlechtes Beispiel/Beispiel/Gutes Beispiel")) != -1) {
            this.addLines(index + 1, "      distilltime: 60");
        }
        if ((index = this.indexOfStart("      name: Bitterer Rum/W\u00fcrziger Rum/&6Goldener Rum")) != -1) {
            this.addLines(index + 1, "      distilltime: 30");
        }
        if ((index = this.indexOfStart("      name: minderwertiger Absinth/Absinth/Starker Absinth")) != -1) {
            this.addLines(index + 1, "      distilltime: 80");
        }
    }

    private void update14en() {
        this.updateVersion("1.5");
        String[] lines = new String[]{"", "# If written Chat is distorted when the Player is Drunk,", "# so that it looks like drunk writing", "# How much the chat is distorted depends on how drunk the Player is", "# Below are settings for what and how changes in chat occur", "enableChatDistortion: true"};
        int index = this.indexOfStart("# -- Chat") + 2;
        if (index == 1 && (index = this.indexOfStart("distortCommands:") - 1) == -2 && (index = this.indexOfStart("distortSignText:") - 1) == -2 && (index = this.indexOfStart("# words:")) == -1) {
            index = this.indexOfStart("words:");
        }
        if (index == -1) {
            this.appendLines(lines);
        } else {
            this.addLines(index - 1, lines);
        }
        lines = new String[]{"# Chat Example: Hello i am drunk *I am testing Brewery*"};
        index = this.indexOfStart("# Enclose a Chat text with these Letters");
        if (index != -1) {
            this.addLines(index + 1, lines);
        } else {
            index = this.indexOfStart("distortBypass:");
            if (index != -1) {
                this.addLines(index, lines);
            }
        }
        lines = new String[]{"# distilltime: How long (in seconds) one distill-run takes (0=Default time of 40 sec) MC Default would be 20 sec"};
        index = this.indexOfStart("# distillruns:");
        if (index == -1 && (index = this.indexOfStart("# wood:") - 1) == -2 && (index = this.indexOfStart("# -- Recipes") + 1) == 0) {
            index = -1;
        }
        if (index != -1) {
            this.addLines(index + 1, lines);
        }
        if ((index = this.indexOfStart("      name: Bad Example/Example/Good Example")) != -1) {
            this.addLines(index + 1, "      distilltime: 60");
        }
        if ((index = this.indexOfStart("      name: Bitter Rum/Spicy Rum/&6Golden Rum")) != -1) {
            this.addLines(index + 1, "      distilltime: 30");
        }
        if ((index = this.indexOfStart("      name: Poor Absinthe/Absinthe/Strong Absinthe")) != -1) {
            this.addLines(index + 1, "      distilltime: 80");
        }
    }

    private void update15(boolean mc113, boolean langDE) {
        this.updateVersion("1.7");
        this.updateMaterials(mc113);
        if (langDE) {
            int index = this.indexOfStart("# ingredients: Auflistung von 'Material oder ID");
            if (index != -1) {
                this.setLine(index, "# ingredients: Auflistung von 'Material,Data/Anzahl'");
            }
            if ((index = this.indexOfStart("#   (Item-ids anstatt Material")) != -1) {
                this.setLine(index, "#   (Item-ids anstatt Material k\u00f6nnen in Bukkit nicht mehr benutzt werden)");
            }
            if ((index = this.indexOfStart("# [Beispiel] MATERIAL_oder_id: Name")) != -1) {
                this.setLine(index, "# [Beispiel] MATERIAL: Name nach G\u00e4hren");
            }
        } else {
            int index = this.indexOfStart("# ingredients: List of 'material or id");
            if (index != -1) {
                this.setLine(index, "# ingredients: List of 'material,data/amount'");
            }
            if ((index = this.indexOfStart("#   (Item-ids instead of material are deprecated")) != -1) {
                this.setLine(index, "#   (Item-ids instead of material are not supported by bukkit anymore and will not work)");
            }
            if ((index = this.indexOfStart("# [Example] MATERIAL_or_id: Name")) != -1) {
                this.setLine(index, "# [Example] MATERIAL: Name after cooking");
            }
        }
    }

    private void updateMaterials(boolean toMC113) {
        String line;
        int index;
        if (toMC113) {
            index = this.indexOfStart("oldMat:");
            if (index != -1) {
                this.config.remove(index);
            }
        } else {
            index = this.indexOfStart("version:");
            if (index != -1) {
                this.addLines(index + 1, "oldMat: true");
            }
        }
        if ((index = this.indexOfStart("pukeItem: ")) != -1 && (line = this.config.get(index)).length() > 10) {
            this.setLine(index, this.convertMaterial(line, "pukeItem: ", "", toMC113));
        }
        if ((index = this.indexOfStart("drainItems:")) != -1) {
            ++index;
            while (this.config.get(index).startsWith("-")) {
                this.setLine(index, this.convertMaterial(this.config.get(index), "- ", "(,.*|)/.*", toMC113));
                ++index;
            }
        }
        if ((index = this.indexOfStart("recipes:")) != -1) {
            int endIndex = this.indexOfStart("useWorldGuard:");
            if (endIndex < ++index) {
                endIndex = this.indexOfStart("enableChatDistortion:");
            }
            if (endIndex < index) {
                endIndex = this.indexOfStart("words:");
            }
            if (endIndex < index) {
                endIndex = this.config.size();
            }
            while (index < endIndex) {
                if (this.config.get(index).matches("^\\s+ingredients:.*")) {
                    ++index;
                    while (this.config.get(index).matches("^\\s+- .+")) {
                        line = this.config.get(index);
                        this.setLine(index, this.convertMaterial(line, "^\\s+- ", "(,.*|)/.*", toMC113));
                        ++index;
                    }
                } else if (this.config.get(index).startsWith("cooked:")) {
                    ++index;
                    while (this.config.get(index).matches("^\\s\\s+.+")) {
                        line = this.config.get(index);
                        this.setLine(index, this.convertMaterial(line, "^\\s\\s+", ":.*", toMC113));
                        ++index;
                    }
                }
                ++index;
            }
        }
    }

    private String convertMaterial(String line, String regexPrefix, String regexPostfix, boolean toMC113) {
        if (!toMC113) {
            return this.convertIdtoMaterial(line, regexPrefix, regexPostfix);
        }
        String mat = line.replaceFirst(regexPrefix, "").replaceFirst(regexPostfix, "");
        Material material = mat.equalsIgnoreCase("LONG_GRASS") ? Material.GRASS : Material.matchMaterial((String)mat, (boolean)true);
        if (material == null) {
            return line;
        }
        String matnew = material.name();
        if (!mat.equalsIgnoreCase(matnew)) {
            return line.replaceAll(mat, matnew);
        }
        return line;
    }

    private String convertIdtoMaterial(String line, String regexPrefix, String regexPostfix) {
        String idString = line.replaceFirst(regexPrefix, "").replaceFirst(regexPostfix, "");
        int id = P.p.parseInt(idString);
        if (id > 0) {
            Material material = LegacyUtil.getMaterial(id);
            if (material == null) {
                P.p.errorLog("Could not find Material with id: " + line);
                return line;
            }
            return line.replaceAll(idString, material.name());
        }
        return line;
    }
}

