/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.filedata;

import com.dre.brewery.BCauldron;
import com.dre.brewery.BPlayer;
import com.dre.brewery.Barrel;
import com.dre.brewery.Brew;
import com.dre.brewery.P;
import com.dre.brewery.Wakeup;
import com.dre.brewery.filedata.ReadOldData;
import com.dre.brewery.filedata.WriteData;
import java.io.File;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DataSave
extends BukkitRunnable {
    public static int lastBackup = 0;
    public static int lastSave = 1;
    public static int autosave = 3;
    public static final String dataVersion = "1.1";
    public static DataSave running;
    public ReadOldData read;
    private long time;
    public boolean collected = false;

    public DataSave(ReadOldData read) {
        this.read = read;
        this.time = System.currentTimeMillis();
    }

    public void run() {
        YamlConfiguration oldData;
        if (this.read != null) {
            if (!this.read.done) {
                if (System.currentTimeMillis() - this.time > 30000L) {
                    P.p.errorLog("Old Data took too long to load!");
                    this.cancel();
                    return;
                }
                return;
            }
            oldData = this.read.getData();
        } else {
            oldData = new YamlConfiguration();
        }
        try {
            this.cancel();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        YamlConfiguration configFile = new YamlConfiguration();
        configFile.set("installTime", (Object)Brew.installTime);
        if (!Brew.potions.isEmpty()) {
            Brew.save(configFile.createSection("Brew"));
        }
        if (!BCauldron.bcauldrons.isEmpty() || oldData.contains("BCauldron")) {
            BCauldron.save(configFile.createSection("BCauldron"), oldData.getConfigurationSection("BCauldron"));
        }
        if (!Barrel.barrels.isEmpty() || oldData.contains("Barrel")) {
            Barrel.save(configFile.createSection("Barrel"), oldData.getConfigurationSection("Barrel"));
        }
        if (!BPlayer.isEmpty()) {
            BPlayer.save(configFile.createSection("Player"));
        }
        if (!Wakeup.wakeups.isEmpty() || oldData.contains("Wakeup")) {
            Wakeup.save(configFile.createSection("Wakeup"), oldData.getConfigurationSection("Wakeup"));
        }
        DataSave.saveWorldNames((FileConfiguration)configFile, oldData.getConfigurationSection("Worlds"));
        configFile.set("Version", (Object)dataVersion);
        this.collected = true;
        if (P.p.isEnabled()) {
            P.p.getServer().getScheduler().runTaskAsynchronously((Plugin)P.p, (Runnable)new WriteData((FileConfiguration)configFile));
        } else {
            new WriteData((FileConfiguration)configFile).run();
        }
    }

    public void now() {
        if (!this.read.done) {
            this.read.cancel();
            this.read.run();
        }
        if (!this.collected) {
            this.cancel();
            this.run();
        }
    }

    public static void save(boolean collectInstant) {
        long time = System.nanoTime();
        if (running != null) {
            P.p.log("Another Save was started while a Save was in Progress");
            if (collectInstant) {
                running.now();
            }
            return;
        }
        File datafile = new File(P.p.getDataFolder(), "data.yml");
        if (datafile.exists()) {
            ReadOldData read = new ReadOldData();
            if (collectInstant) {
                read.run();
                running = new DataSave(read);
                running.run();
            } else {
                read.runTaskAsynchronously((Plugin)P.p);
                running = new DataSave(read);
                running.runTaskTimer((Plugin)P.p, 1L, 2L);
            }
        } else {
            running = new DataSave(null);
            running.run();
        }
        P.p.debugLog("saving: " + (double)(System.nanoTime() - time) / 1000000.0 + "ms");
    }

    public static void autoSave() {
        if (lastSave >= autosave) {
            DataSave.save(false);
        } else {
            ++lastSave;
        }
    }

    public static void saveWorldNames(FileConfiguration root, ConfigurationSection old) {
        if (old != null) {
            root.set("Worlds", (Object)old);
        }
        for (World world : P.p.getServer().getWorlds()) {
            String worldName = world.getName();
            if (worldName.startsWith("DXL_")) {
                worldName = P.p.getDxlName(worldName);
                root.set("Worlds." + worldName, (Object)0);
                continue;
            }
            worldName = world.getUID().toString();
            root.set("Worlds." + worldName, (Object)world.getName());
        }
    }
}

