/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.filedata;

import com.dre.brewery.LegacyUtil;
import com.dre.brewery.P;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class DataUpdater {
    private FileConfiguration data;
    private File file;

    public DataUpdater(FileConfiguration data, File file) {
        this.data = data;
        this.file = file;
    }

    public void update(String fromVersion) {
        if (fromVersion.equalsIgnoreCase("1.0")) {
            this.update10();
        }
        try {
            this.data.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void update10() {
        this.data.set("Version", (Object)"1.1");
        ConfigurationSection section = this.data.getConfigurationSection("Ingredients");
        try {
            if (section != null) {
                for (String id : section.getKeys(false)) {
                    ConfigurationSection matSection = section.getConfigurationSection(id + ".mats");
                    if (matSection != null) {
                        HashMap<String, Integer> ingredients = new HashMap<String, Integer>();
                        for (String ingredient : matSection.getKeys(false)) {
                            Material mat = LegacyUtil.getMaterial(P.p.parseInt(ingredient));
                            if (mat == null) continue;
                            ingredients.put(mat.name(), matSection.getInt(ingredient));
                        }
                        section.set(id + ".mats", ingredients);
                        continue;
                    }
                    P.p.errorLog("Ingredient id: '" + id + "' incomplete in data.yml");
                }
            }
        }
        catch (Exception e) {
            P.p.errorLog("Error Converting Ingredient Section of the Data File, newer versions of Bukkit may not support the old Save File anymore:");
            e.printStackTrace();
        }
        section = this.data.getConfigurationSection("BCauldron");
        if (section != null) {
            try {
                for (String uuid : section.getKeys(false)) {
                    ConfigurationSection cauldrons = section.getConfigurationSection(uuid);
                    if (cauldrons == null) continue;
                    for (String id : cauldrons.getKeys(false)) {
                        ConfigurationSection ingredientSection = cauldrons.getConfigurationSection(id + ".ingredients");
                        if (ingredientSection != null) {
                            HashMap<String, Integer> ingredients = new HashMap<String, Integer>();
                            for (String ingredient : ingredientSection.getKeys(false)) {
                                Material mat = LegacyUtil.getMaterial(P.p.parseInt(ingredient));
                                if (mat == null) continue;
                                ingredients.put(mat.name(), ingredientSection.getInt(ingredient));
                            }
                            cauldrons.set(id + ".ingredients", ingredients);
                            continue;
                        }
                        P.p.errorLog("BCauldron " + id + " is missing Ingredient Section");
                    }
                }
            }
            catch (Exception e) {
                P.p.errorLog("Error Converting Ingredient Section of Cauldrons, newer versions of Bukkit may not support the old Save File anymore:");
                e.printStackTrace();
            }
        }
    }
}

