/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.filedata;

import com.dre.brewery.P;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class UpdateChecker
implements Runnable {
    private static final int projectID = 68006;
    private static final String DELIMETER = "^v|[\\s_-]v";
    private static final String API_NAME_VALUE = "name";
    private static final String API_QUERY = "/servermods/files?projectIds=";
    private static final String API_HOST = "https://api.curseforge.com";
    public static String update = null;

    public static void notify(Player player) {
        if (update == null || !player.isOp()) {
            return;
        }
        P.p.msg((CommandSender)player, update);
    }

    @Override
    public void run() {
        this.query();
    }

    public void query() {
        block7: {
            URL url;
            try {
                url = new URL("https://api.curseforge.com/servermods/files?projectIds=68006");
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return;
            }
            try {
                URLConnection conn = url.openConnection();
                conn.addRequestProperty("User-Agent", "Brewery UpdateChecker (by Gravity)");
                BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                JsonParser parser = new JsonParser();
                JsonArray array = parser.parse((Reader)reader).getAsJsonArray();
                if (array.size() > 0) {
                    JsonObject latest = array.get(array.size() - 1).getAsJsonObject();
                    String versionName = latest.get(API_NAME_VALUE).getAsString();
                    String[] split = versionName.split(DELIMETER);
                    if (split.length < 2) {
                        P.p.log("Malformed Remote File Name, could not check for updates");
                        break block7;
                    }
                    String version = split[1];
                    if (P.p.getDescription().getVersion().equals(split[1].split(" ")[0])) break block7;
                    String[] verNew = version.split("\\.");
                    String[] verOld = P.p.getDescription().getVersion().split("\\.");
                    for (int i = 0; i < verNew.length && (i >= verOld.length || P.p.parseInt(verOld[i]) <= P.p.parseInt(verNew[i])); ++i) {
                        if (i < verOld.length && P.p.parseInt(verOld[i]) >= P.p.parseInt(verNew[i])) continue;
                        P.p.log("Update available for Brewery-" + P.p.getDescription().getVersion() + ": " + versionName);
                        update = "Update available: v" + version;
                        break block7;
                    }
                    break block7;
                }
                P.p.log("There are no files for this project");
            }
            catch (IOException e) {
                P.p.errorLog("Could not check for Updates. This error can probably be ignored");
                e.printStackTrace();
            }
        }
    }
}

