/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.integration;

import com.dre.brewery.Barrel;
import com.dre.brewery.P;
import com.griefcraft.listeners.LWCPlayerListener;
import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Flag;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.event.LWCEvent;
import com.griefcraft.scripting.event.LWCProtectionDestroyEvent;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;

public class LWCBarrel {
    public static boolean checkDestroy(Player player, Barrel barrel) {
        Block sign;
        LWC lwc = LWC.getInstance();
        Protection protection = lwc.findProtection(sign = barrel.getSignOfSpigot());
        if (protection != null) {
            boolean canAccess = lwc.canAccessProtection(player, protection);
            boolean canAdmin = lwc.canAdminProtection(player, protection);
            try {
                LWCProtectionDestroyEvent evt = new LWCProtectionDestroyEvent(player, protection, LWCProtectionDestroyEvent.Method.BLOCK_DESTRUCTION, canAccess, canAdmin);
                lwc.getModuleLoader().dispatchEvent((LWCEvent)evt);
                if (evt.isCancelled()) {
                    return false;
                }
            }
            catch (Exception e) {
                lwc.sendLocale((CommandSender)player, "protection.internalerror", new Object[]{"id", "BLOCK_BREAK"});
                P.p.errorLog("Failed to dispatch LWCProtectionDestroyEvent");
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public static boolean checkAccess(Player player, Block sign, PlayerInteractEvent event, Plugin plugin) {
        LWC lwc = LWC.getInstance();
        if (!lwc.hasPermission(player, "lwc.protect") && lwc.hasPermission(player, "lwc.deny") && !lwc.isAdmin(player) && !lwc.isMod(player)) {
            lwc.sendLocale((CommandSender)player, "protection.interact.error.blocked", new Object[0]);
            return false;
        }
        PlayerInteractEvent lwcEvent = new PlayerInteractEvent(player, event.getAction(), event.getItem(), sign, event.getBlockFace());
        for (RegisteredListener listener : HandlerList.getRegisteredListeners((Plugin)plugin)) {
            if (!(listener.getListener() instanceof LWCPlayerListener)) continue;
            try {
                listener.callEvent((Event)lwcEvent);
                if (!lwcEvent.isCancelled()) continue;
                return false;
            }
            catch (EventException e) {
                lwc.sendLocale((CommandSender)player, "protection.internalerror", new Object[]{"id", "PLAYER_INTERACT"});
                P.p.errorLog("Block Interact could not be passed to LWC");
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public static void remove(Barrel barrel) {
        Protection protection = LWC.getInstance().findProtection(barrel.getSignOfSpigot());
        if (protection != null) {
            protection.remove();
        }
    }

    public static boolean blockExplosion(Barrel barrel, Block block) {
        Protection protection = LWC.getInstance().findProtection(barrel.getSignOfSpigot());
        if (protection == null) {
            barrel.remove(block, null);
            return false;
        }
        if (protection.hasFlag(Flag.Type.ALLOWEXPLOSIONS)) {
            protection.remove();
            barrel.remove(block, null);
            return false;
        }
        return true;
    }
}

