/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.integration;

import com.dre.brewery.LegacyUtil;
import com.dre.brewery.P;
import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.Consumer;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.util.BukkitUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class LogBlockBarrel {
    private static final List<LogBlockBarrel> opened = new ArrayList<LogBlockBarrel>();
    public static Consumer consumer = LogBlock.getInstance().getConsumer();
    private static Method rawData;
    private static Method queueChestAccess;
    private HumanEntity player;
    private ItemStack[] items;
    private Location loc;

    public LogBlockBarrel(HumanEntity player, ItemStack[] items, Location spigotLoc) {
        this.player = player;
        this.items = items;
        this.loc = spigotLoc;
        opened.add(this);
    }

    private void compareInv(ItemStack[] after) {
        ItemStack[] diff;
        if (consumer == null) {
            return;
        }
        for (ItemStack item : diff = BukkitUtils.compareInventories((ItemStack[])this.items, (ItemStack[])after)) {
            if (!P.use1_13) {
                try {
                    queueChestAccess.invoke((Object)consumer, this.player.getName(), this.loc, LegacyUtil.getBlockTypeIdAt(this.loc), (short)item.getType().getId(), (short)item.getAmount(), rawData.invoke(null, item));
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    e.printStackTrace();
                }
                continue;
            }
            ItemStack i2 = item;
            if (item.getAmount() < 0) {
                i2 = item.clone();
                i2.setAmount(Math.abs(item.getAmount()));
            }
            consumer.queueChestAccess(Actor.actorFromEntity((Entity)this.player), this.loc, this.loc.getBlock().getBlockData(), i2, item.getAmount() < 0);
        }
    }

    public static LogBlockBarrel get(HumanEntity player) {
        for (LogBlockBarrel open : opened) {
            if (!open.player.equals(player)) continue;
            return open;
        }
        return null;
    }

    public static void openBarrel(HumanEntity player, Inventory inv, Location spigotLoc) {
        if (!Config.isLogging((World)player.getWorld(), (Logging)Logging.CHESTACCESS)) {
            return;
        }
        new LogBlockBarrel(player, BukkitUtils.compressInventory((ItemStack[])inv.getContents()), spigotLoc);
    }

    public static void closeBarrel(HumanEntity player, Inventory inv) {
        if (!Config.isLogging((World)player.getWorld(), (Logging)Logging.CHESTACCESS)) {
            return;
        }
        LogBlockBarrel open = LogBlockBarrel.get(player);
        if (open != null) {
            open.compareInv(BukkitUtils.compressInventory((ItemStack[])inv.getContents()));
            opened.remove(open);
        }
    }

    public static void breakBarrel(Player player, ItemStack[] contents, Location spigotLoc) {
        ItemStack[] items;
        if (consumer == null) {
            return;
        }
        if (!Config.isLogging((World)spigotLoc.getWorld(), (Logging)Logging.CHESTACCESS)) {
            return;
        }
        for (ItemStack item : items = BukkitUtils.compressInventory((ItemStack[])contents)) {
            if (!P.use1_13) {
                try {
                    queueChestAccess.invoke((Object)consumer, player.getName(), spigotLoc, LegacyUtil.getBlockTypeIdAt(spigotLoc), (short)item.getType().getId(), (short)(item.getAmount() * -1), rawData.invoke(null, item));
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    e.printStackTrace();
                }
                continue;
            }
            consumer.queueChestAccess(Actor.actorFromEntity((Entity)player), spigotLoc, spigotLoc.getBlock().getBlockData(), item, false);
        }
    }

    public static void clear() {
        opened.clear();
    }

    static {
        if (!P.use1_13) {
            try {
                rawData = BukkitUtils.class.getDeclaredMethod("rawData", ItemStack.class);
                queueChestAccess = Consumer.class.getDeclaredMethod("queueChestAccess", String.class, Location.class, Integer.TYPE, Short.TYPE, Short.TYPE, Short.TYPE);
            }
            catch (NoSuchMethodException e) {
                P.p.errorLog("Failed to hook into LogBlock to log barrels. Logging barrel contents is not going to work.");
                P.p.errorLog("Brewery was tested with version 1.12 to 1.13.1 of LogBlock.");
                P.p.errorLog("Disable LogBlock support in the configuration file and type /brew reload.");
                e.printStackTrace();
            }
        }
    }
}

