/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.integration;

import com.dre.brewery.P;
import com.dre.brewery.integration.WGBarrel;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.DefaultFlag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class WGBarrelOld
implements WGBarrel {
    private Method allows;
    private Method canBuild;
    private Method getApplicableRegions;

    public WGBarrelOld() {
        try {
            this.allows = ApplicableRegionSet.class.getMethod("allows", StateFlag.class, LocalPlayer.class);
            this.canBuild = ApplicableRegionSet.class.getMethod("canBuild", LocalPlayer.class);
            this.getApplicableRegions = RegionManager.class.getMethod("getApplicableRegions", Location.class);
        }
        catch (NoSuchMethodException e) {
            P.p.errorLog("Failed to Hook WorldGuard for Barrel Open Permissions! Opening Barrels will NOT work!");
            P.p.errorLog("Brewery was tested with version 5.8, 6.1 to 7.0 of WorldGuard!");
            P.p.errorLog("Disable the WorldGuard support in the config and do /brew reload");
            e.printStackTrace();
        }
    }

    @Override
    public boolean checkAccess(Player player, Block spigot, Plugin plugin) {
        WorldGuardPlugin wg = (WorldGuardPlugin)plugin;
        if (!wg.getGlobalRegionManager().hasBypass(player, player.getWorld())) {
            try {
                LocalPlayer localPlayer;
                Object region = this.getApplicableRegions.invoke((Object)wg.getRegionManager(player.getWorld()), spigot.getLocation());
                if (region != null && !((Boolean)this.allows.invoke(region, DefaultFlag.CHEST_ACCESS, localPlayer = wg.wrapPlayer(player))).booleanValue() && !((Boolean)this.canBuild.invoke(region, localPlayer)).booleanValue()) {
                    P.p.msg((CommandSender)player, P.p.languageReader.get("Error_NoBarrelAccess", new String[0]));
                    return false;
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }
}

