/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.listeners;

import com.dre.brewery.BPlayer;
import com.dre.brewery.Barrel;
import com.dre.brewery.P;
import com.dre.brewery.Words;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.SignChangeEvent;

public class BlockListener
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSignChange(SignChangeEvent event) {
        String[] lines = event.getLines();
        if (lines[0].equalsIgnoreCase("Barrel") || lines[0].equalsIgnoreCase(P.p.languageReader.get("Etc_Barrel", new String[0]))) {
            Player player = event.getPlayer();
            if (!player.hasPermission("brewery.createbarrel.small") && !player.hasPermission("brewery.createbarrel.big")) {
                P.p.msg((CommandSender)player, P.p.languageReader.get("Perms_NoBarrelCreate", new String[0]));
                return;
            }
            if (Barrel.create(event.getBlock(), player)) {
                P.p.msg((CommandSender)player, P.p.languageReader.get("Player_BarrelCreated", new String[0]));
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onSignChangeLow(SignChangeEvent event) {
        if (Words.doSigns.booleanValue() && BPlayer.hasPlayer(event.getPlayer())) {
            Words.signWrite(event);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        if (!P.p.blockDestroy(event.getBlock(), event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBurn(BlockBurnEvent event) {
        P.p.blockDestroy(event.getBlock(), null);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPistonRetract(BlockPistonRetractEvent event) {
        Block block;
        if (event.isSticky() && Barrel.get(block = event.getRetractLocation().getBlock()) != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPistonExtend(BlockPistonExtendEvent event) {
        for (Block block : event.getBlocks()) {
            if (Barrel.get(block) == null) continue;
            event.setCancelled(true);
            return;
        }
    }
}

