/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.listeners;

import com.dre.brewery.BIngredients;
import com.dre.brewery.BPlayer;
import com.dre.brewery.BRecipe;
import com.dre.brewery.Brew;
import com.dre.brewery.P;
import com.dre.brewery.Wakeup;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CommandListener
implements CommandExecutor {
    public P p = P.p;

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String cmd = "help";
        if (args.length > 0) {
            cmd = args[0];
        }
        if (cmd.equalsIgnoreCase("help")) {
            this.cmdHelp(sender, args);
        } else if (cmd.equalsIgnoreCase("reload")) {
            if (sender.hasPermission("brewery.cmd.reload")) {
                this.p.reload(sender);
                this.p.msg(sender, this.p.languageReader.get("CMD_Reload", new String[0]));
            } else {
                this.p.msg(sender, this.p.languageReader.get("Error_NoPermissions", new String[0]));
            }
        } else if (cmd.equalsIgnoreCase("wakeup")) {
            if (sender.hasPermission("brewery.cmd.wakeup")) {
                this.cmdWakeup(sender, args);
            } else {
                this.p.msg(sender, this.p.languageReader.get("Error_NoPermissions", new String[0]));
            }
        } else if (cmd.equalsIgnoreCase("create")) {
            if (sender.hasPermission("brewery.cmd.create")) {
                this.cmdCreate(sender, args);
            } else {
                this.p.msg(sender, this.p.languageReader.get("Error_NoPermissions", new String[0]));
            }
        } else if (cmd.equalsIgnoreCase("info")) {
            if (args.length > 1) {
                if (sender.hasPermission("brewery.cmd.infoOther")) {
                    this.cmdInfo(sender, args[1]);
                } else {
                    this.p.msg(sender, this.p.languageReader.get("Error_NoPermissions", new String[0]));
                }
            } else if (sender.hasPermission("brewery.cmd.info")) {
                this.cmdInfo(sender, null);
            } else {
                this.p.msg(sender, this.p.languageReader.get("Error_NoPermissions", new String[0]));
            }
        } else if (cmd.equalsIgnoreCase("copy") || cmd.equalsIgnoreCase("cp")) {
            if (sender.hasPermission("brewery.cmd.copy")) {
                if (args.length > 1) {
                    this.cmdCopy(sender, this.p.parseInt(args[1]));
                } else {
                    this.cmdCopy(sender, 1);
                }
            } else {
                this.p.msg(sender, this.p.languageReader.get("Error_NoPermissions", new String[0]));
            }
        } else if (cmd.equalsIgnoreCase("delete") || cmd.equalsIgnoreCase("rm") || cmd.equalsIgnoreCase("remove")) {
            if (sender.hasPermission("brewery.cmd.delete")) {
                this.cmdDelete(sender);
            } else {
                this.p.msg(sender, this.p.languageReader.get("Error_NoPermissions", new String[0]));
            }
        } else if (cmd.equalsIgnoreCase("persist") || cmd.equalsIgnoreCase("persistent")) {
            if (sender.hasPermission("brewery.cmd.persist")) {
                this.cmdPersist(sender);
            } else {
                this.p.msg(sender, this.p.languageReader.get("Error_NoPermissions", new String[0]));
            }
        } else if (cmd.equalsIgnoreCase("static")) {
            if (sender.hasPermission("brewery.cmd.static")) {
                this.cmdStatic(sender);
            } else {
                this.p.msg(sender, this.p.languageReader.get("Error_NoPermissions", new String[0]));
            }
        } else if (cmd.equalsIgnoreCase("unlabel")) {
            if (sender.hasPermission("brewery.cmd.unlabel")) {
                this.cmdUnlabel(sender);
            } else {
                this.p.msg(sender, this.p.languageReader.get("Error_NoPermissions", new String[0]));
            }
        } else if (this.p.getServer().getPlayerExact(cmd) != null || BPlayer.hasPlayerbyName(cmd)) {
            if (args.length == 1) {
                if (sender.hasPermission("brewery.cmd.infoOther")) {
                    this.cmdInfo(sender, cmd);
                }
            } else if (sender.hasPermission("brewery.cmd.player")) {
                this.cmdPlayer(sender, args);
            } else {
                this.p.msg(sender, this.p.languageReader.get("Error_NoPermissions", new String[0]));
            }
        } else {
            this.p.msg(sender, this.p.languageReader.get("Error_UnknownCommand", new String[0]));
            this.p.msg(sender, this.p.languageReader.get("Error_ShowHelp", new String[0]));
        }
        return true;
    }

    public void cmdHelp(CommandSender sender, String[] args) {
        int page = 1;
        if (args.length > 1) {
            page = this.p.parseInt(args[1]);
        }
        ArrayList<String> commands = this.getCommands(sender);
        if (page == 1) {
            this.p.msg(sender, "&6" + this.p.getDescription().getName() + " v" + this.p.getDescription().getVersion());
        }
        this.p.list(sender, commands, page);
    }

    public ArrayList<String> getCommands(CommandSender sender) {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add(this.p.languageReader.get("Help_Help", new String[0]));
        if (sender.hasPermission("brewery.cmd.player")) {
            cmds.add(this.p.languageReader.get("Help_Player", new String[0]));
        }
        if (sender.hasPermission("brewery.cmd.info")) {
            cmds.add(this.p.languageReader.get("Help_Info", new String[0]));
        }
        if (sender.hasPermission("brewery.cmd.unlabel")) {
            cmds.add(this.p.languageReader.get("Help_UnLabel", new String[0]));
        }
        if (sender.hasPermission("brewery.cmd.copy")) {
            cmds.add(this.p.languageReader.get("Help_Copy", new String[0]));
        }
        if (sender.hasPermission("brewery.cmd.delete")) {
            cmds.add(this.p.languageReader.get("Help_Delete", new String[0]));
        }
        if (sender.hasPermission("brewery.cmd.infoOther")) {
            cmds.add(this.p.languageReader.get("Help_InfoOther", new String[0]));
        }
        if (sender.hasPermission("brewery.cmd.wakeup")) {
            cmds.add(this.p.languageReader.get("Help_Wakeup", new String[0]));
            cmds.add(this.p.languageReader.get("Help_WakeupList", new String[0]));
            cmds.add(this.p.languageReader.get("Help_WakeupCheck", new String[0]));
            cmds.add(this.p.languageReader.get("Help_WakeupCheckSpecific", new String[0]));
            cmds.add(this.p.languageReader.get("Help_WakeupAdd", new String[0]));
            cmds.add(this.p.languageReader.get("Help_WakeupRemove", new String[0]));
        }
        if (sender.hasPermission("brewery.cmd.reload")) {
            cmds.add(this.p.languageReader.get("Help_Reload", new String[0]));
        }
        if (sender.hasPermission("brewery.cmd.persist")) {
            cmds.add(this.p.languageReader.get("Help_Persist", new String[0]));
        }
        if (sender.hasPermission("brewery.cmd.static")) {
            cmds.add(this.p.languageReader.get("Help_Static", new String[0]));
        }
        if (sender.hasPermission("brewery.cmd.create")) {
            cmds.add(this.p.languageReader.get("Help_Create", new String[0]));
        }
        return cmds;
    }

    public void cmdWakeup(CommandSender sender, String[] args) {
        if (args.length == 1) {
            this.cmdHelp(sender, args);
            return;
        }
        if (args[1].equalsIgnoreCase("add")) {
            Wakeup.set(sender);
        } else if (args[1].equalsIgnoreCase("list")) {
            int page = 1;
            String world = null;
            if (args.length > 2) {
                page = this.p.parseInt(args[2]);
            }
            if (args.length > 3) {
                world = args[3];
            }
            Wakeup.list(sender, page, world);
        } else if (args[1].equalsIgnoreCase("remove")) {
            if (args.length > 2) {
                int id = this.p.parseInt(args[2]);
                Wakeup.remove(sender, id);
            } else {
                this.p.msg(sender, this.p.languageReader.get("Etc_Usage", new String[0]));
                this.p.msg(sender, this.p.languageReader.get("Help_WakeupRemove", new String[0]));
            }
        } else if (args[1].equalsIgnoreCase("check")) {
            int id = -1;
            if (args.length > 2 && (id = this.p.parseInt(args[2])) < 0) {
                id = 0;
            }
            Wakeup.check(sender, id, id == -1);
        } else if (args[1].equalsIgnoreCase("cancel")) {
            Wakeup.cancel(sender);
        } else {
            this.p.msg(sender, this.p.languageReader.get("Error_UnknownCommand", new String[0]));
            this.p.msg(sender, this.p.languageReader.get("Error_ShowHelp", new String[0]));
        }
    }

    public void cmdPlayer(CommandSender sender, String[] args) {
        int drunkeness = this.p.parseInt(args[1]);
        if (drunkeness < 0) {
            return;
        }
        int quality = -1;
        if (args.length > 2 && ((quality = this.p.parseInt(args[2])) < 1 || quality > 10)) {
            this.p.msg(sender, this.p.languageReader.get("CMD_Player_Error", new String[0]));
            return;
        }
        String playerName = args[0];
        Player player = P.p.getServer().getPlayerExact(playerName);
        BPlayer bPlayer = player == null ? BPlayer.getByName(playerName) : BPlayer.get(player);
        if (bPlayer == null && player != null) {
            if (drunkeness == 0) {
                return;
            }
            bPlayer = BPlayer.addPlayer(player);
        }
        if (bPlayer == null) {
            return;
        }
        if (drunkeness == 0) {
            bPlayer.remove();
        } else {
            bPlayer.setData(drunkeness, quality);
        }
        if (drunkeness > 100) {
            if (player != null) {
                bPlayer.drinkCap(player);
            } else if (!BPlayer.overdrinkKick) {
                bPlayer.setData(100, 0);
            }
        }
        this.p.msg(sender, this.p.languageReader.get("CMD_Player", playerName, "" + drunkeness, "" + bPlayer.getQuality()));
    }

    public void cmdInfo(CommandSender sender, String playerName) {
        BPlayer bPlayer;
        Player player;
        if (playerName == null) {
            if (sender instanceof Player) {
                player = (Player)sender;
                playerName = player.getName();
            } else {
                this.p.msg(sender, this.p.languageReader.get("Error_PlayerCommand", new String[0]));
                return;
            }
        }
        if ((bPlayer = (player = P.p.getServer().getPlayerExact(playerName)) == null ? BPlayer.getByName(playerName) : BPlayer.get(player)) == null) {
            this.p.msg(sender, this.p.languageReader.get("CMD_Info_NotDrunk", playerName));
        } else {
            this.p.msg(sender, this.p.languageReader.get("CMD_Info_Drunk", playerName, "" + bPlayer.getDrunkeness(), "" + bPlayer.getQuality()));
        }
    }

    public void cmdCopy(CommandSender sender, int count) {
        if (sender instanceof Player) {
            Brew brew;
            if (count < 1 || count > 36) {
                this.p.msg(sender, this.p.languageReader.get("Etc_Usage", new String[0]));
                this.p.msg(sender, this.p.languageReader.get("Help_Copy", new String[0]));
                return;
            }
            Player player = (Player)sender;
            ItemStack hand = player.getItemInHand();
            if (hand != null && (brew = Brew.get(hand)) != null) {
                while (count > 0) {
                    ItemStack item = brew.copy(hand);
                    if (!player.getInventory().addItem(new ItemStack[]{item}).isEmpty()) {
                        this.p.msg(sender, this.p.languageReader.get("CMD_Copy_Error", "" + count));
                        return;
                    }
                    --count;
                }
                if (brew.isPersistent()) {
                    this.p.msg(sender, this.p.languageReader.get("CMD_CopyNotPersistent", new String[0]));
                }
                return;
            }
            this.p.msg(sender, this.p.languageReader.get("Error_ItemNotPotion", new String[0]));
        } else {
            this.p.msg(sender, this.p.languageReader.get("Error_PlayerCommand", new String[0]));
        }
    }

    public void cmdDelete(CommandSender sender) {
        if (sender instanceof Player) {
            Brew brew;
            Player player = (Player)sender;
            ItemStack hand = player.getItemInHand();
            if (hand != null && (brew = Brew.get(hand)) != null) {
                if (brew.isPersistent()) {
                    this.p.msg(sender, this.p.languageReader.get("CMD_PersistRemove", new String[0]));
                } else {
                    brew.remove(hand);
                    player.setItemInHand(new ItemStack(Material.AIR));
                }
                return;
            }
            this.p.msg(sender, this.p.languageReader.get("Error_ItemNotPotion", new String[0]));
        } else {
            this.p.msg(sender, this.p.languageReader.get("Error_PlayerCommand", new String[0]));
        }
    }

    public void cmdPersist(CommandSender sender) {
        if (sender instanceof Player) {
            Brew brew;
            Player player = (Player)sender;
            ItemStack hand = player.getItemInHand();
            if (hand != null && (brew = Brew.get(hand)) != null) {
                if (brew.isPersistent()) {
                    brew.removePersistence();
                    brew.setStatic(false, hand);
                    this.p.msg(sender, this.p.languageReader.get("CMD_UnPersist", new String[0]));
                } else {
                    brew.makePersistent();
                    brew.setStatic(true, hand);
                    this.p.msg(sender, this.p.languageReader.get("CMD_Persistent", new String[0]));
                }
                brew.touch();
                return;
            }
            this.p.msg(sender, this.p.languageReader.get("Error_ItemNotPotion", new String[0]));
        } else {
            this.p.msg(sender, this.p.languageReader.get("Error_PlayerCommand", new String[0]));
        }
    }

    public void cmdStatic(CommandSender sender) {
        if (sender instanceof Player) {
            Brew brew;
            Player player = (Player)sender;
            ItemStack hand = player.getItemInHand();
            if (hand != null && (brew = Brew.get(hand)) != null) {
                if (brew.isStatic()) {
                    if (!brew.isPersistent()) {
                        brew.setStatic(false, hand);
                        this.p.msg(sender, this.p.languageReader.get("CMD_NonStatic", new String[0]));
                    } else {
                        this.p.msg(sender, this.p.languageReader.get("Error_PersistStatic", new String[0]));
                    }
                } else {
                    brew.setStatic(true, hand);
                    this.p.msg(sender, this.p.languageReader.get("CMD_Static", new String[0]));
                }
                brew.touch();
                return;
            }
            this.p.msg(sender, this.p.languageReader.get("Error_ItemNotPotion", new String[0]));
        } else {
            this.p.msg(sender, this.p.languageReader.get("Error_PlayerCommand", new String[0]));
        }
    }

    public void cmdUnlabel(CommandSender sender) {
        if (sender instanceof Player) {
            Brew brew;
            Player player = (Player)sender;
            ItemStack hand = player.getItemInHand();
            if (hand != null && (brew = Brew.get(hand)) != null) {
                brew.unLabel(hand);
                brew.touch();
                this.p.msg(sender, this.p.languageReader.get("CMD_UnLabel", new String[0]));
                return;
            }
            this.p.msg(sender, this.p.languageReader.get("Error_ItemNotPotion", new String[0]));
        } else {
            this.p.msg(sender, this.p.languageReader.get("Error_PlayerCommand", new String[0]));
        }
    }

    public void cmdCreate(CommandSender sender, String[] args) {
        if (args.length < 2) {
            this.p.msg(sender, this.p.languageReader.get("Etc_Usage", new String[0]));
            this.p.msg(sender, this.p.languageReader.get("Help_Create", new String[0]));
            return;
        }
        int quality = 10;
        boolean hasQuality = false;
        String pName = null;
        if (args.length > 2) {
            quality = this.p.parseInt(args[args.length - 1]);
            if (quality <= 0 || quality > 10) {
                pName = args[args.length - 1];
                if (args.length > 3) {
                    quality = this.p.parseInt(args[args.length - 2]);
                }
            }
            if (quality > 0 && quality <= 10) {
                hasQuality = true;
            } else {
                quality = 10;
            }
        }
        Player player = null;
        if (pName != null) {
            player = this.p.getServer().getPlayer(pName);
        }
        if (sender instanceof Player || player != null) {
            String name;
            if (player == null) {
                player = (Player)sender;
            }
            int stringLength = args.length - 1;
            if (pName != null) {
                --stringLength;
            }
            if (hasQuality) {
                --stringLength;
            }
            if (stringLength > 1) {
                StringBuilder builder = new StringBuilder(args[1]);
                for (int i = 2; i < stringLength + 1; ++i) {
                    builder.append(" ").append(args[i]);
                }
                name = builder.toString();
            } else {
                name = args[1];
            }
            if (player.getInventory().firstEmpty() == -1) {
                this.p.msg(sender, this.p.languageReader.get("CMD_Copy_Error", "1"));
                return;
            }
            BRecipe recipe = null;
            for (BRecipe r : BIngredients.recipes) {
                if (!r.hasName(name)) continue;
                recipe = r;
                break;
            }
            if (recipe != null) {
                player.getInventory().addItem(new ItemStack[]{recipe.create(quality)});
            } else {
                this.p.msg(sender, this.p.languageReader.get("Error_NoBrewName", name));
            }
        } else {
            this.p.msg(sender, this.p.languageReader.get("Error_PlayerCommand", new String[0]));
        }
    }
}

