/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.listeners;

import com.dre.brewery.Barrel;
import com.dre.brewery.Brew;
import com.dre.brewery.P;
import com.dre.brewery.integration.LWCBarrel;
import java.util.ListIterator;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.ItemDespawnEvent;
import org.bukkit.inventory.ItemStack;

public class EntityListener
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onItemDespawn(ItemDespawnEvent event) {
        Brew brew;
        ItemStack item = event.getEntity().getItemStack();
        if (item.getType() == Material.POTION && (brew = Brew.get(item)) != null) {
            brew.remove(item);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityCombust(EntityCombustEvent event) {
        Brew brew;
        ItemStack item;
        Entity entity = event.getEntity();
        if (entity.getType() == EntityType.DROPPED_ITEM && entity instanceof Item && (item = ((Item)entity).getItemStack()).getType() == Material.POTION && (brew = Brew.get(item)) != null) {
            brew.remove(item);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onExplode(EntityExplodeEvent event) {
        ListIterator iter = event.blockList().listIterator();
        Barrel barrel = null;
        boolean removedBarrel = false;
        while (iter.hasNext()) {
            Block block = (Block)iter.next();
            if (barrel == null || !barrel.hasBlock(block)) {
                barrel = Barrel.get(block);
                removedBarrel = false;
            }
            if (removedBarrel || barrel == null || !P.p.useLWC) continue;
            try {
                if (LWCBarrel.blockExplosion(barrel, block)) {
                    iter.remove();
                    continue;
                }
                removedBarrel = true;
            }
            catch (Exception e) {
                P.p.errorLog("Failed to Check LWC on Barrel Explosion!");
                e.printStackTrace();
                removedBarrel = true;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockChange(EntityChangeBlockEvent event) {
        if (Barrel.get(event.getBlock()) != null) {
            event.setCancelled(true);
        }
    }
}

