/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.listeners;

import com.dre.brewery.BPlayer;
import com.dre.brewery.BRecipe;
import com.dre.brewery.Barrel;
import com.dre.brewery.Brew;
import com.dre.brewery.P;
import com.dre.brewery.integration.LogBlockBarrel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.BrewingStand;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.BrewEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class InventoryListener
implements Listener {
    private HashSet<UUID> trackedBrewmen = new HashSet();
    private HashMap<Block, Integer> trackedBrewers = new HashMap();
    private static final int DISTILLTIME = 400;

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBrewerOpen(InventoryOpenEvent event) {
        if (!P.use1_9) {
            return;
        }
        HumanEntity player = event.getPlayer();
        Inventory inv = event.getInventory();
        if (player == null || !(inv instanceof BrewerInventory)) {
            return;
        }
        P.p.debugLog("Starting brew inventory tracking");
        this.trackedBrewmen.add(player.getUniqueId());
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBrewerClose(InventoryCloseEvent event) {
        if (!P.use1_9) {
            return;
        }
        HumanEntity player = event.getPlayer();
        Inventory inv = event.getInventory();
        if (player == null || !(inv instanceof BrewerInventory)) {
            return;
        }
        P.p.debugLog("Stopping brew inventory tracking");
        this.trackedBrewmen.remove(player.getUniqueId());
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBrewerDrag(InventoryDragEvent event) {
        if (!P.use1_9) {
            return;
        }
        if (event.getInventory() instanceof BrewerInventory) {
            this.onBrewerClick(new InventoryClickEvent(event.getView(), InventoryType.SlotType.CONTAINER, 0, ClickType.LEFT, InventoryAction.PLACE_ALL));
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBrewerClick(InventoryClickEvent event) {
        if (!P.use1_9) {
            return;
        }
        HumanEntity player = event.getWhoClicked();
        Inventory inv = event.getInventory();
        if (player == null || !(inv instanceof BrewerInventory)) {
            return;
        }
        UUID puid = player.getUniqueId();
        if (!this.trackedBrewmen.contains(puid)) {
            return;
        }
        if (InventoryType.BREWING != inv.getType()) {
            return;
        }
        if (event.getAction() == InventoryAction.NOTHING) {
            return;
        }
        BrewerInventory brewer = (BrewerInventory)inv;
        final Block brewery = brewer.getHolder().getBlock();
        Integer curTask = this.trackedBrewers.get(brewery);
        if (curTask != null) {
            Bukkit.getScheduler().cancelTask(curTask.intValue());
            brewer.getHolder().setBrewingTime(0);
            brewer.getHolder().update();
        }
        final int fuel = brewer.getHolder().getFuelLevel();
        this.trackedBrewers.put(brewery, new BukkitRunnable(){
            private int runTime = -1;
            private int brewTime = -1;

            public void run() {
                BlockState now = brewery.getState();
                if (now instanceof BrewingStand) {
                    BrewingStand stand = (BrewingStand)now;
                    if (this.brewTime == -1) {
                        switch (InventoryListener.this.hasCustom(stand.getInventory())) {
                            case 1: {
                                if (stand.getBrewingTime() > 0) {
                                    if (P.use1_11) {
                                        stand.setBrewingTime(Short.MAX_VALUE);
                                    } else {
                                        stand.setBrewingTime(65534);
                                    }
                                    stand.setFuelLevel(fuel);
                                    stand.update();
                                }
                            }
                            case 0: {
                                this.cancel();
                                InventoryListener.this.trackedBrewers.remove(brewery);
                                P.p.debugLog("nothing to distill");
                                return;
                            }
                        }
                        this.brewTime = this.runTime = InventoryListener.this.getLongestDistillTime(stand.getInventory());
                        P.p.debugLog("using brewtime: " + this.runTime);
                    }
                    --this.brewTime;
                    stand.setBrewingTime((int)((float)this.brewTime / ((float)this.runTime / 400.0f)) + 1);
                    if (this.brewTime <= 1) {
                        stand.setBrewingTime(0);
                        stand.update();
                        BrewerInventory brewer = stand.getInventory();
                        if (!InventoryListener.this.runDistill(brewer)) {
                            this.cancel();
                            InventoryListener.this.trackedBrewers.remove(brewery);
                            P.p.debugLog("All done distilling");
                        } else {
                            this.brewTime = -1;
                            P.p.debugLog("Can distill more! Continuing.");
                        }
                    } else {
                        stand.update();
                    }
                } else {
                    this.cancel();
                    InventoryListener.this.trackedBrewers.remove(brewery);
                    P.p.debugLog("The block was replaced; not a brewing stand.");
                }
            }
        }.runTaskTimer((Plugin)P.p, 2L, 1L).getTaskId());
    }

    private Brew[] getDistillContents(BrewerInventory inv) {
        Brew[] contents = new Brew[3];
        for (int slot = 0; slot < 3; ++slot) {
            ItemStack item = inv.getItem(slot);
            if (item == null) continue;
            contents[slot] = Brew.get(item);
        }
        return contents;
    }

    private byte hasCustom(BrewerInventory brewer) {
        ItemStack item = brewer.getItem(3);
        boolean glowstone = item != null && Material.GLOWSTONE_DUST == item.getType();
        byte customFound = 0;
        for (Brew brew : this.getDistillContents(brewer)) {
            if (brew == null) continue;
            if (!glowstone) {
                return 1;
            }
            if (brew.canDistill()) {
                return 2;
            }
            customFound = 1;
        }
        return customFound;
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBrew(BrewEvent event) {
        if (P.use1_9) {
            if (this.hasCustom(event.getContents()) != 0) {
                event.setCancelled(true);
            }
            return;
        }
        if (this.runDistill(event.getContents())) {
            event.setCancelled(true);
        }
    }

    private boolean runDistill(BrewerInventory inv) {
        boolean custom = false;
        Brew[] contents = this.getDistillContents(inv);
        for (int slot = 0; slot < 3; ++slot) {
            if (contents[slot] == null) continue;
            if (contents[slot].canDistill()) {
                custom = true;
                continue;
            }
            contents[slot] = null;
        }
        if (custom) {
            Brew.distillAll(inv, contents);
            return true;
        }
        return false;
    }

    private int getLongestDistillTime(BrewerInventory inv) {
        int bestTime = 0;
        Brew[] contents = this.getDistillContents(inv);
        for (int slot = 0; slot < 3; ++slot) {
            if (contents[slot] == null) continue;
            int time = contents[slot].getDistillTimeNextRun();
            if (time == 0) {
                time = 800;
            }
            if (time <= bestTime) continue;
            bestTime = time;
        }
        if (bestTime > 0) {
            return bestTime;
        }
        return 800;
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=false)
    public void onInventoryClickLow(InventoryClickEvent event) {
        PotionMeta potion;
        Brew brew;
        ItemStack item;
        if (event.getCurrentItem() != null && event.getCurrentItem().getType().equals((Object)Material.POTION) && (item = event.getCurrentItem()).hasItemMeta() && (brew = Brew.get(potion = (PotionMeta)item.getItemMeta())) != null) {
            BRecipe recipe;
            if (P.use1_9 && !potion.hasItemFlag(ItemFlag.HIDE_POTION_EFFECTS) && (recipe = brew.getCurrentRecipe()) != null) {
                Brew.removeEffects(potion);
                Brew.PotionColor.valueOf(recipe.getColor()).colorBrew(potion, item, brew.canDistill());
                item.setItemMeta((ItemMeta)potion);
            }
            brew.touch();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        PotionMeta meta;
        Brew brew;
        if (event.getInventory().getType() == InventoryType.BREWING ? event.getSlot() > 2 : !(event.getInventory().getHolder() instanceof Barrel)) {
            return;
        }
        ItemStack item = event.getCurrentItem();
        if (item != null && item.getType() == Material.POTION && item.hasItemMeta() && (brew = Brew.get(meta = (PotionMeta)item.getItemMeta())) != null && Brew.hasColorLore(meta).booleanValue()) {
            brew.convertLore(meta, false);
            item.setItemMeta((ItemMeta)meta);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryPickupItem(InventoryPickupItemEvent event) {
        if (event.getItem().getPickupDelay() > 1000 && event.getItem().getItemStack().getType() == BPlayer.pukeItem) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (P.p.useLB && event.getInventory().getHolder() instanceof Barrel) {
            try {
                LogBlockBarrel.closeBarrel(event.getPlayer(), event.getInventory());
            }
            catch (Exception e) {
                P.p.errorLog("Failed to Log Barrel to LogBlock!");
                P.p.errorLog("Brewery was tested with version 1.94 of LogBlock!");
                e.printStackTrace();
            }
        }
    }
}

