/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.listeners;

import com.dre.brewery.BCauldron;
import com.dre.brewery.BIngredients;
import com.dre.brewery.BPlayer;
import com.dre.brewery.Barrel;
import com.dre.brewery.Brew;
import com.dre.brewery.LegacyUtil;
import com.dre.brewery.P;
import com.dre.brewery.Wakeup;
import com.dre.brewery.Words;
import com.dre.brewery.filedata.UpdateChecker;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class PlayerListener
implements Listener {
    public static boolean openEverywhere;
    private static Set<UUID> interacted;

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player;
        Block clickedBlock = event.getClickedBlock();
        if (clickedBlock != null && event.getAction() == Action.RIGHT_CLICK_BLOCK && !(player = event.getPlayer()).isSneaking()) {
            Material type = clickedBlock.getType();
            if (type == Material.CAULDRON) {
                Material materialInHand = event.getMaterial();
                ItemStack item = event.getItem();
                if (materialInHand == null || materialInHand == Material.BUCKET) {
                    return;
                }
                if (materialInHand == LegacyUtil.CLOCK) {
                    BCauldron.printTime(player, clickedBlock);
                    return;
                }
                if (materialInHand == Material.GLASS_BOTTLE) {
                    if (player.getInventory().firstEmpty() != -1 || item.getAmount() == 1) {
                        if (BCauldron.fill(player, clickedBlock)) {
                            event.setCancelled(true);
                            if (player.hasPermission("brewery.cauldron.fill")) {
                                if (item.getAmount() > 1) {
                                    item.setAmount(item.getAmount() - 1);
                                } else {
                                    this.setItemInHand(event, Material.AIR, false);
                                }
                            }
                        }
                    } else {
                        event.setCancelled(true);
                    }
                    return;
                }
                if (materialInHand == Material.WATER_BUCKET) {
                    if (!P.use1_9 && LegacyUtil.getFillLevel(clickedBlock) == 1) {
                        BCauldron.remove(clickedBlock);
                    }
                    return;
                }
                Block down = clickedBlock.getRelative(BlockFace.DOWN);
                if (down.getType() == Material.FIRE || LegacyUtil.isLava(down.getType())) {
                    event.setCancelled(true);
                    boolean handSwap = false;
                    if (P.use1_9) {
                        if (event.getHand() == EquipmentSlot.HAND) {
                            final UUID id = player.getUniqueId();
                            interacted.add(id);
                            P.p.getServer().getScheduler().runTask((Plugin)P.p, new Runnable(){

                                @Override
                                public void run() {
                                    interacted.remove(id);
                                }
                            });
                        } else if (event.getHand() == EquipmentSlot.OFF_HAND && !interacted.remove(player.getUniqueId())) {
                            item = player.getInventory().getItemInMainHand();
                            if (item != null && item.getType() != Material.AIR) {
                                materialInHand = item.getType();
                                handSwap = true;
                            } else {
                                item = event.getItem();
                            }
                        }
                    }
                    if (item == null) {
                        return;
                    }
                    if (BIngredients.possibleIngredients.contains(materialInHand)) {
                        if (player.hasPermission("brewery.cauldron.insert")) {
                            if (BCauldron.ingredientAdd(clickedBlock, item)) {
                                boolean isBucket;
                                boolean bl = isBucket = item.getType().equals((Object)Material.WATER_BUCKET) || item.getType().equals((Object)Material.LAVA_BUCKET) || item.getType().equals((Object)Material.MILK_BUCKET);
                                if (item.getAmount() > 1) {
                                    item.setAmount(item.getAmount() - 1);
                                    if (isBucket) {
                                        BCauldron.giveItem(player, new ItemStack(Material.BUCKET));
                                    }
                                } else if (isBucket) {
                                    this.setItemInHand(event, Material.BUCKET, handSwap);
                                } else {
                                    this.setItemInHand(event, Material.AIR, handSwap);
                                }
                            }
                        } else {
                            P.p.msg((CommandSender)player, P.p.languageReader.get("Perms_NoCauldronInsert", new String[0]));
                        }
                    }
                }
                return;
            }
            if (P.use1_9 && event.getHand() != EquipmentSlot.HAND) {
                return;
            }
            Barrel barrel = null;
            if (LegacyUtil.isWoodPlanks(type)) {
                if (openEverywhere) {
                    barrel = Barrel.get(clickedBlock);
                }
            } else if (LegacyUtil.isWoodStairs(type)) {
                for (Barrel barrel2 : Barrel.barrels) {
                    if (!barrel2.hasStairsBlock(clickedBlock)) continue;
                    if (openEverywhere || !barrel2.isLarge()) {
                        barrel = barrel2;
                    }
                    break;
                }
            } else if (LegacyUtil.isFence(type) || LegacyUtil.isSign(type)) {
                barrel = Barrel.getBySpigot(clickedBlock);
            }
            if (barrel != null) {
                event.setCancelled(true);
                if (!barrel.hasPermsOpen(player, event)) {
                    return;
                }
                barrel.open(player);
            }
        }
    }

    public void setItemInHand(PlayerInteractEvent event, Material mat, boolean swapped) {
        if (P.use1_9) {
            if (event.getHand() == EquipmentSlot.OFF_HAND != swapped) {
                event.getPlayer().getInventory().setItemInOffHand(new ItemStack(mat));
            } else {
                event.getPlayer().getInventory().setItemInMainHand(new ItemStack(mat));
            }
        } else {
            event.getPlayer().setItemInHand(new ItemStack(mat));
        }
    }

    @EventHandler
    public void onClickAir(PlayerInteractEvent event) {
        if (Wakeup.checkPlayer == null) {
            return;
        }
        if (event.getAction() == Action.LEFT_CLICK_AIR && !event.hasItem() && event.getPlayer() == Wakeup.checkPlayer) {
            Wakeup.tpNext();
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerItemConsume(PlayerItemConsumeEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item != null) {
            BPlayer bplayer;
            if (item.getType() == Material.POTION) {
                Brew brew = Brew.get(item);
                if (brew != null) {
                    BPlayer.drink(brew, player);
                    if (player.getGameMode() != GameMode.CREATIVE) {
                        brew.remove(item);
                    }
                    if (P.use1_9) {
                        if (player.getGameMode() != GameMode.CREATIVE) {
                            event.setItem(new ItemStack(Material.POTION));
                        } else {
                            event.setCancelled(true);
                        }
                    }
                }
            } else if (BPlayer.drainItems.containsKey(item.getType()) && (bplayer = BPlayer.get(player)) != null) {
                bplayer.drainByItem(player, item.getType());
            }
        }
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        BPlayer bPlayer = BPlayer.get(event.getPlayer());
        if (bPlayer != null) {
            if (bPlayer.getDrunkeness() > 20) {
                bPlayer.setData(bPlayer.getDrunkeness() - 20, 0);
            } else {
                BPlayer.remove(event.getPlayer());
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (BPlayer.hasPlayer(event.getPlayer())) {
            BPlayer.playerMove(event);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Words.playerChat(event);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onCommandPreProcess(PlayerCommandPreprocessEvent event) {
        Words.playerCommand(event);
    }

    @EventHandler
    public void onPlayerLogin(PlayerLoginEvent event) {
        Player player;
        BPlayer bplayer;
        if (event.getResult() == PlayerLoginEvent.Result.ALLOWED && (bplayer = BPlayer.get(player = event.getPlayer())) != null) {
            if (player.hasPermission("brewery.bypass.logindeny")) {
                if (bplayer.getDrunkeness() > 100) {
                    bplayer.setData(100, 0);
                }
                bplayer.join(player);
                return;
            }
            switch (bplayer.canJoin()) {
                case 0: {
                    bplayer.join(player);
                    return;
                }
                case 2: {
                    event.disallow(PlayerLoginEvent.Result.KICK_OTHER, P.p.languageReader.get("Player_LoginDeny", new String[0]));
                    return;
                }
                case 3: {
                    event.disallow(PlayerLoginEvent.Result.KICK_OTHER, P.p.languageReader.get("Player_LoginDenyLong", new String[0]));
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent event) {
        UpdateChecker.notify(event.getPlayer());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        BPlayer bplayer = BPlayer.get(event.getPlayer());
        if (bplayer != null) {
            bplayer.disconnecting();
        }
    }

    @EventHandler
    public void onPlayerKick(PlayerKickEvent event) {
        BPlayer bplayer = BPlayer.get(event.getPlayer());
        if (bplayer != null) {
            bplayer.disconnecting();
        }
    }

    static {
        interacted = new HashSet<UUID>();
    }
}

