/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.configuration;

import com.fastasyncworldedit.core.configuration.MemorySection;
import com.fastasyncworldedit.core.configuration.file.YamlConfiguration;
import com.fastasyncworldedit.core.util.StringMan;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.Logger;

public class Config {
    private static final Logger LOGGER = LogManagerCompat.getLogger();

    public Config() {
        this.save(new PrintWriter(new ByteArrayOutputStream(0)), this.getClass(), this, 0);
    }

    private <T> T get(String key, Class<?> root) {
        Field field;
        String[] split = key.split("\\.");
        Object instance = this.getInstance(split, root);
        if (instance != null && (field = this.getField(split, instance)) != null) {
            try {
                return (T)field.get(instance);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        LOGGER.error("Failed to get config option: {}", (Object)key);
        return null;
    }

    private void set(String key, Object value, Class<?> root) {
        Field field;
        String[] split = key.split("\\.");
        Object instance = this.getInstance(split, root);
        if (instance != null && (field = this.getField(split, instance)) != null) {
            try {
                if (field.getAnnotation(Final.class) != null) {
                    return;
                }
                if (field.getType() == String.class && !(value instanceof String)) {
                    value = "" + value;
                }
                field.set(instance, value);
                return;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        LOGGER.error("Failed to set config option: {}: {} | {} | {}.yml", (Object)key, value, instance, (Object)root.getSimpleName());
    }

    public boolean load(File file) {
        if (!file.exists()) {
            return false;
        }
        YamlConfiguration yml = YamlConfiguration.loadConfiguration(file);
        for (String key : yml.getKeys(true)) {
            Object value = yml.get(key);
            if (value instanceof MemorySection) continue;
            this.set(key, value, this.getClass());
        }
        return true;
    }

    public void save(File file) {
        try {
            if (!file.exists()) {
                File parent = file.getParentFile();
                if (parent != null) {
                    file.getParentFile().mkdirs();
                }
                file.createNewFile();
            }
            PrintWriter writer = new PrintWriter(file);
            Config instance = this;
            this.save(writer, this.getClass(), instance, 0);
            writer.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private String toYamlString(Object value, String spacing) {
        if (value instanceof List) {
            Collection listValue = (Collection)value;
            if (listValue.isEmpty()) {
                return "[]";
            }
            StringBuilder m = new StringBuilder();
            for (Object obj : listValue) {
                m.append(System.lineSeparator()).append(spacing).append("- ").append(this.toYamlString(obj, spacing));
            }
            return m.toString();
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            if (stringValue.isEmpty()) {
                return "''";
            }
            return "\"" + stringValue + "\"";
        }
        return value != null ? value.toString() : "null";
    }

    private void save(PrintWriter writer, Class<?> clazz, Object instance, int indent) {
        try {
            String CTRF = System.lineSeparator();
            String spacing = StringMan.repeat(" ", indent);
            HashMap<Class, Object> instances = new HashMap<Class, Object>();
            for (Field field : clazz.getFields()) {
                int n;
                if (field.getAnnotation(Ignore.class) != null) continue;
                Class current = field.getType();
                if (field.getAnnotation(Ignore.class) != null) continue;
                Comment comment = field.getAnnotation(Comment.class);
                if (comment != null) {
                    for (String commentLine : comment.value()) {
                        writer.write(spacing + "# " + commentLine + CTRF);
                    }
                }
                if (current == ConfigBlock.class) {
                    BlockName blockNames;
                    current = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                    comment = current.getAnnotation(Comment.class);
                    if (comment != null) {
                        for (String commentLine : comment.value()) {
                            writer.write(spacing + "# " + commentLine + CTRF);
                        }
                    }
                    if ((blockNames = current.getAnnotation(BlockName.class)) == null) continue;
                    writer.write(spacing + this.toNodeName(current.getSimpleName()) + ":" + CTRF);
                    ConfigBlock configBlock = (ConfigBlock)field.get(instance);
                    if (configBlock == null || configBlock.getInstances().isEmpty()) {
                        configBlock = new ConfigBlock();
                        field.set(instance, configBlock);
                        String[] stringArray = blockNames.value();
                        int commentLine = stringArray.length;
                        for (n = 0; n < commentLine; ++n) {
                            String blockName = stringArray[n];
                            configBlock.put(blockName, current.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                        }
                    }
                    for (Map.Entry entry : configBlock.getRaw().entrySet()) {
                        String key = entry.getKey();
                        writer.write(spacing + "  " + this.toNodeName(key) + ":" + CTRF);
                        this.save(writer, current, entry.getValue(), indent + 4);
                    }
                    continue;
                }
                Create create = field.getAnnotation(Create.class);
                if (create != null) {
                    Object value = field.get(instance);
                    this.setAccessible(field);
                    if (indent == 0) {
                        writer.write(CTRF);
                    }
                    if ((comment = current.getAnnotation(Comment.class)) != null) {
                        String[] stringArray = comment.value();
                        int n2 = stringArray.length;
                        for (n = 0; n < n2; ++n) {
                            String commentLine = stringArray[n];
                            writer.write(spacing + "# " + commentLine + CTRF);
                        }
                    }
                    writer.write(spacing + this.toNodeName(current.getSimpleName()) + ":" + CTRF);
                    if (value == null) {
                        value = current.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        field.set(instance, value);
                        instances.put(current, value);
                    }
                    this.save(writer, current, value, indent + 2);
                    continue;
                }
                writer.write(spacing + this.toNodeName(field.getName() + ": ") + this.toYamlString(field.get(instance), spacing) + CTRF);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private Field getField(String[] split, Object instance) {
        try {
            Field field = instance.getClass().getField(this.toFieldName(split[split.length - 1]));
            this.setAccessible(field);
            return field;
        }
        catch (Throwable ignored) {
            LOGGER.warn("Invalid config field: {} for {}", (Object)StringMan.join(split, "."), (Object)this.toNodeName(instance.getClass().getSimpleName()));
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object getInstance(String[] split, Class<?> root) {
        try {
            Class<?> clazz = root == null ? MethodHandles.lookup().lookupClass() : root;
            Object instance = this;
            while (split.length > 0) {
                Class<?>[] classes;
                if (split.length == 1) {
                    return instance;
                }
                Class<?> found = null;
                for (Class<?> current : classes = clazz.getDeclaredClasses()) {
                    if (!StringMan.isEqual(current.getSimpleName(), this.toFieldName(split[0]))) continue;
                    found = current;
                    break;
                }
                try {
                    Field instanceField = clazz.getDeclaredField(this.toFieldName(split[0]));
                    this.setAccessible(instanceField);
                    if (instanceField.getType() != ConfigBlock.class) {
                        Object value = instanceField.get(instance);
                        if (value == null) {
                            value = found.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            instanceField.set(instance, value);
                        }
                        clazz = found;
                        instance = value;
                        split = Arrays.copyOfRange(split, 1, split.length);
                        continue;
                    }
                    ConfigBlock<Object> value = (ConfigBlock<Object>)instanceField.get(instance);
                    if (value == null) {
                        value = new ConfigBlock<Object>();
                        instanceField.set(instance, value);
                    }
                    if ((instance = value.get(split[1])) == null) {
                        instance = found.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        value.put(split[1], instance);
                    }
                    clazz = found;
                    split = Arrays.copyOfRange(split, 2, split.length);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    if (found == null) return null;
                    split = Arrays.copyOfRange(split, 1, split.length);
                    clazz = found;
                    instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    continue;
                    return null;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    private String toFieldName(String node) {
        return node.toUpperCase(Locale.ROOT).replaceAll("-", "_");
    }

    private String toNodeName(String field) {
        return field.toLowerCase(Locale.ROOT).replace("_", "-");
    }

    private void setAccessible(Field field) throws NoSuchFieldException, IllegalAccessException {
        field.setAccessible(true);
        if (Modifier.isFinal(field.getModifiers())) {
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Final {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.TYPE})
    public static @interface Ignore {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.TYPE})
    public static @interface Comment {
        public String[] value();
    }

    @Ignore
    public static class ConfigBlock<T> {
        private final HashMap<String, T> INSTANCES = new HashMap();

        public T remove(String key) {
            return this.INSTANCES.remove(key);
        }

        public T get(String key) {
            return this.INSTANCES.get(key);
        }

        public void put(String key, T value) {
            this.INSTANCES.put(key, value);
        }

        public Collection<T> getInstances() {
            return this.INSTANCES.values();
        }

        public Collection<String> getSections() {
            return this.INSTANCES.keySet();
        }

        private Map<String, T> getRaw() {
            return this.INSTANCES;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.TYPE})
    public static @interface BlockName {
        public String[] value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Create {
    }
}

