/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.extension.factory;

import com.fastasyncworldedit.core.configuration.Caption;
import com.fastasyncworldedit.core.extension.factory.parser.transform.Linear3DTransformParser;
import com.fastasyncworldedit.core.extension.factory.parser.transform.LinearTransformParser;
import com.fastasyncworldedit.core.extension.factory.parser.transform.OffsetTransformParser;
import com.fastasyncworldedit.core.extension.factory.parser.transform.PatternTransformParser;
import com.fastasyncworldedit.core.extension.factory.parser.transform.RandomTransformParser;
import com.fastasyncworldedit.core.extension.factory.parser.transform.RichTransformParser;
import com.fastasyncworldedit.core.extension.factory.parser.transform.RotateTransformParser;
import com.fastasyncworldedit.core.extension.factory.parser.transform.ScaleTransformParser;
import com.fastasyncworldedit.core.extension.factory.parser.transform.SpreadTransformParser;
import com.fastasyncworldedit.core.extent.ResettableExtent;
import com.fastasyncworldedit.core.extent.transform.RandomTransform;
import com.fastasyncworldedit.core.math.random.TrueRandom;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.NoMatchException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.internal.registry.AbstractFactory;
import com.sk89q.worldedit.internal.registry.InputParser;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TransformFactory
extends AbstractFactory<ResettableExtent> {
    private final RichTransformParser richTransformParser;

    public TransformFactory(WorldEdit worldEdit) {
        super(worldEdit, new NullTransformParser(worldEdit));
        this.richTransformParser = new RichTransformParser(worldEdit);
        this.register(new RandomTransformParser(worldEdit));
        this.register(new OffsetTransformParser(worldEdit));
        this.register(new ScaleTransformParser(worldEdit));
        this.register(new RotateTransformParser(worldEdit));
        this.register(new SpreadTransformParser(worldEdit));
        this.register(new PatternTransformParser(worldEdit));
        this.register(new LinearTransformParser(worldEdit));
        this.register(new Linear3DTransformParser(worldEdit));
    }

    @Override
    public ResettableExtent parseFromInput(String input, ParserContext context) throws InputParseException {
        ArrayList<ResettableExtent> transforms = new ArrayList<ResettableExtent>();
        for (String component : input.split(" ")) {
            if (component.isEmpty()) continue;
            ResettableExtent match = this.richTransformParser.parseFromInput(component, context);
            if (match != null) {
                transforms.add(match);
                continue;
            }
            this.parseFromParsers(context, transforms, component);
        }
        return this.getResettableExtent(input, transforms);
    }

    private void parseFromParsers(ParserContext context, List<ResettableExtent> transforms, String component) {
        InputParser parser;
        ResettableExtent match = null;
        Iterator iterator = this.getParsers().iterator();
        while (iterator.hasNext() && (match = (ResettableExtent)(parser = iterator.next()).parseFromInput(component, context)) == null) {
        }
        if (match == null) {
            throw new NoMatchException((Component)Caption.of("worldedit.error.no-match", TextComponent.of((String)component)));
        }
        transforms.add(match);
    }

    public ResettableExtent parseWithoutRich(String input, ParserContext context) throws InputParseException {
        ArrayList<ResettableExtent> transforms = new ArrayList<ResettableExtent>();
        for (String component : input.split(" ")) {
            if (component.isEmpty()) continue;
            this.parseFromParsers(context, transforms, component);
        }
        return this.getResettableExtent(input, transforms);
    }

    private ResettableExtent getResettableExtent(String input, List<ResettableExtent> transforms) {
        switch (transforms.size()) {
            case 0: {
                throw new NoMatchException((Component)Caption.of("worldedit.error.no-match", TextComponent.of((String)input)));
            }
            case 1: {
                return transforms.get(0);
            }
        }
        RandomTransform randomTransform = new RandomTransform(new TrueRandom());
        for (ResettableExtent transform : transforms) {
            randomTransform.add(transform, 1.0);
        }
        return randomTransform;
    }

    private static final class NullTransformParser
    extends InputParser<ResettableExtent> {
        private NullTransformParser(WorldEdit worldEdit) {
            super(worldEdit);
        }

        @Override
        public ResettableExtent parseFromInput(String input, ParserContext context) throws InputParseException {
            return null;
        }
    }
}

