/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.extension.factory.parser.pattern;

import com.fastasyncworldedit.core.command.SuggestInputParseException;
import com.fastasyncworldedit.core.configuration.Caption;
import com.fastasyncworldedit.core.extension.factory.parser.FaweParser;
import com.fastasyncworldedit.core.math.random.TrueRandom;
import com.fastasyncworldedit.core.util.StringMan;
import com.sk89q.minecraft.util.commands.CommandLocals;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.NoMatchException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.function.pattern.RandomPattern;
import com.sk89q.worldedit.internal.command.CommandArgParser;
import com.sk89q.worldedit.internal.expression.Expression;
import com.sk89q.worldedit.internal.util.Substring;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.event.ClickEvent;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.enginehub.piston.inject.InjectedValueAccess;
import org.enginehub.piston.inject.MemoizingValueAccess;
import org.enginehub.piston.suggestion.Suggestion;

public class RichPatternParser
extends FaweParser<com.sk89q.worldedit.function.pattern.Pattern> {
    private static final Pattern percentPatternRegex = Pattern.compile("[0-9]+(\\.[0-9]*)?%.*");

    public RichPatternParser(WorldEdit worldEdit) {
        super(worldEdit);
    }

    @Override
    public com.sk89q.worldedit.function.pattern.Pattern parseFromInput(String input, ParserContext context) throws InputParseException {
        Actor actor;
        if (input.isEmpty()) {
            throw new SuggestInputParseException((Component)Caption.of("fawe.error.no-input-provided", new Object[0]), () -> Stream.concat(Stream.of("#", ",", "&"), BlockTypes.getNameSpaces().stream().map(n -> n + ":")).collect(Collectors.toList()));
        }
        ArrayList<Double> chances = new ArrayList<Double>();
        ArrayList<com.sk89q.worldedit.function.pattern.Pattern> patterns = new ArrayList<com.sk89q.worldedit.function.pattern.Pattern>();
        CommandLocals locals = new CommandLocals();
        Actor actor2 = actor = context != null ? context.getActor() : null;
        if (actor != null) {
            locals.put(Actor.class, actor);
        }
        try {
            for (Map.Entry<FaweParser.ParseEntry, List<String>> entry : RichPatternParser.parse(input)) {
                FaweParser.ParseEntry pe = entry.getKey();
                String command = pe.getInput();
                String full = pe.getFull();
                com.sk89q.worldedit.function.pattern.Pattern pattern = null;
                double chance = 1.0;
                if (command.isEmpty()) {
                    pattern = this.parseFromInput(StringMan.join((Collection)entry.getValue(), ','), context);
                } else if (!this.worldEdit.getPatternFactory().containsAlias(command)) {
                    boolean charPattern;
                    char char0 = command.charAt(0);
                    boolean bl = charPattern = input.length() > 1 && input.charAt(1) != '[';
                    if (charPattern && input.charAt(0) == '=') {
                        pattern = this.parseFromInput(char0 + "[" + input.substring(1) + "]", context);
                    }
                    if (char0 == '#' && command.length() > 1 && command.charAt(1) != '#') {
                        throw new SuggestInputParseException(new NoMatchException((Component)Caption.of("fawe.error.parse.unknown-pattern", full, TextComponent.of((String)"https://intellectualsites.github.io/fastasyncworldedit-documentation/patterns/patterns").clickEvent(ClickEvent.openUrl((String)"https://intellectualsites.github.io/fastasyncworldedit-documentation/patterns/patterns")))), () -> {
                            if (full.length() == 1) {
                                return new ArrayList<String>(this.worldEdit.getPatternFactory().getSuggestions(""));
                            }
                            return new ArrayList<String>(this.worldEdit.getPatternFactory().getSuggestions(command.toLowerCase(Locale.ROOT)));
                        });
                    }
                    if (charPattern && (char0 == '$' || char0 == '^' || char0 == '*' || char0 == '#' && input.charAt(1) == '#')) {
                        pattern = this.worldEdit.getPatternFactory().parseWithoutRich(full, context);
                    }
                    if (pattern == null) {
                        if (command.startsWith("[")) {
                            int end = command.lastIndexOf(93);
                            pattern = this.parseFromInput(command.substring(1, end == -1 ? command.length() : end), context);
                        } else {
                            int percentIndex = command.indexOf(37);
                            if (percentIndex != -1 && percentPatternRegex.matcher(command).matches()) {
                                chance = Expression.compile(command.substring(0, percentIndex), new String[0]).evaluate(new double[0]);
                                Object value = command.substring(percentIndex + 1);
                                if (!entry.getValue().isEmpty()) {
                                    boolean addBrackets;
                                    boolean bl2 = addBrackets = !((String)value).isEmpty();
                                    if (addBrackets) {
                                        value = (String)value + "[";
                                    }
                                    value = (String)value + StringMan.join((Collection)entry.getValue(), "][");
                                    if (addBrackets) {
                                        value = (String)value + "]";
                                    }
                                }
                                pattern = this.parseFromInput((String)value, context);
                            } else {
                                try {
                                    pattern = (com.sk89q.worldedit.function.pattern.Pattern)this.worldEdit.getBlockFactory().parseFromInput(pe.getFull(), context);
                                }
                                catch (NoMatchException e) {
                                    throw new NoMatchException((Component)Caption.of("fawe.error.parse.unknown-pattern", full, TextComponent.of((String)"https://intellectualsites.github.io/fastasyncworldedit-documentation/patterns/patterns").clickEvent(ClickEvent.openUrl((String)"https://intellectualsites.github.io/fastasyncworldedit-documentation/patterns/patterns"))));
                                }
                            }
                        }
                    }
                } else {
                    List<String> args = entry.getValue();
                    try {
                        pattern = this.worldEdit.getPatternFactory().parseWithoutRich(full, context);
                    }
                    catch (InputParseException rethrow) {
                        throw rethrow;
                    }
                    catch (Throwable e) {
                        throw SuggestInputParseException.of(e, full, () -> {
                            try {
                                String cmdArgs = args.isEmpty() ? "" : " " + StringMan.join(args, " ");
                                List<Substring> split = CommandArgParser.forArgString(cmdArgs).parseArgs().toList();
                                List argStrings = split.stream().map(Substring::getSubstring).collect(Collectors.toList());
                                MemoizingValueAccess access = this.getPlatform().initializeInjectedValues(() -> cmdArgs, actor, null, true);
                                List suggestions = this.getPlatform().getCommandManager().getSuggestions((InjectedValueAccess)access, argStrings).stream().map(Suggestion::getSuggestion).collect(Collectors.toUnmodifiableList());
                                ArrayList<Object> result = new ArrayList<Object>();
                                if (suggestions.size() <= 2) {
                                    for (int i = 0; i < suggestions.size(); ++i) {
                                        Object suggestion = (String)suggestions.get(i);
                                        if (((String)suggestion).indexOf(32) == 0) continue;
                                        Object[] splitSuggestion = ((String)suggestion).split(" ");
                                        suggestion = "[" + StringMan.join(splitSuggestion, "][") + "]";
                                        result.set(i, suggestion);
                                    }
                                }
                                return result;
                            }
                            catch (Throwable e2) {
                                e2.printStackTrace();
                                throw new InputParseException((Component)TextComponent.of((String)e2.getMessage()));
                            }
                        });
                    }
                }
                if (pattern == null) continue;
                patterns.add(pattern);
                chances.add(chance);
            }
        }
        catch (InputParseException rethrow) {
            throw rethrow;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new InputParseException((Component)TextComponent.of((String)e.getMessage()), e);
        }
        if (patterns.isEmpty()) {
            return null;
        }
        if (patterns.size() == 1) {
            return (com.sk89q.worldedit.function.pattern.Pattern)patterns.get(0);
        }
        RandomPattern random = new RandomPattern(new TrueRandom());
        for (int i = 0; i < patterns.size(); ++i) {
            random.add((com.sk89q.worldedit.function.pattern.Pattern)patterns.get(i), (Double)chances.get(i));
        }
        return random;
    }

    @Override
    public List<String> getMatchedAliases() {
        return Collections.emptyList();
    }
}

