/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.extent.clipboard.io.schematic;

import com.fastasyncworldedit.core.FaweCache;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.NBTInputStream;
import com.sk89q.jnbt.NBTOutputStream;
import com.sk89q.jnbt.NamedTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardWriter;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.registry.state.AbstractProperty;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.entity.EntityTypes;
import com.sk89q.worldedit.world.storage.NBTConversions;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.Logger;

public class MinecraftStructure
implements ClipboardReader,
ClipboardWriter {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    private static final int WARN_SIZE = 32;
    private NBTInputStream inputStream;
    private NBTOutputStream out;

    public MinecraftStructure(@Nonnull NBTInputStream inputStream) {
        this.inputStream = inputStream;
    }

    public MinecraftStructure(NBTOutputStream out) {
        this.out = out;
    }

    @Override
    public Clipboard read() throws IOException {
        return this.read(UUID.randomUUID());
    }

    @Override
    public Clipboard read(UUID clipboardId) throws IOException {
        ListTag entities;
        NamedTag rootTag = this.inputStream.readNamedTag();
        if (!rootTag.getName().isEmpty()) {
            throw new IOException("Root tag has name - are you sure this is a structure?");
        }
        Object tags = ((CompoundTag)rootTag.getTag()).getValue();
        ListTag size = (ListTag)tags.get("size");
        int width = size.getInt(0);
        int height = size.getInt(1);
        int length = size.getInt(2);
        BlockVector3 origin = BlockVector3.at(0, 0, 0);
        CuboidRegion region = new CuboidRegion(origin, origin.add(width, height, length).subtract(BlockVector3.ONE));
        BlockArrayClipboard clipboard = new BlockArrayClipboard((Region)region, clipboardId);
        ListTag blocks = (ListTag)tags.get("blocks");
        if (blocks != null) {
            List palette = (List)((Tag)tags.get("palette")).getValue();
            BlockState[] combinedArray = new BlockState[palette.size()];
            for (int i = 0; i < palette.size(); ++i) {
                CompoundTag compound = (CompoundTag)palette.get(i);
                Object map = compound.getValue();
                String name = ((StringTag)map.get("Name")).getValue();
                BlockType type = BlockTypes.get(name);
                BlockStateHolder<BlockState> state = type.getDefaultState();
                CompoundTag properties = (CompoundTag)map.get("Properties");
                if (properties != null) {
                    for (Map.Entry entry : properties.getValue().entrySet()) {
                        String key = (String)entry.getKey();
                        String value = ((StringTag)entry.getValue()).getValue();
                        Property property = type.getProperty(key);
                        state = state.with(property, property.getValueFor(value));
                    }
                }
                combinedArray[i] = state;
            }
            List blocksList = (List)((Tag)tags.get("blocks")).getValue();
            try {
                for (CompoundTag compound : blocksList) {
                    CompoundTag nbt;
                    Object blockMap = compound.getValue();
                    IntTag stateTag = (IntTag)blockMap.get("state");
                    ListTag posTag = (ListTag)blockMap.get("pos");
                    BlockState state = combinedArray[stateTag.getValue()];
                    int x = posTag.getInt(0);
                    int y = posTag.getInt(1);
                    int z = posTag.getInt(2);
                    if (state.getBlockType().getMaterial().hasContainer() && (nbt = (CompoundTag)blockMap.get("nbt")) != null) {
                        BaseBlock block = state.toBaseBlock(nbt);
                        clipboard.setBlock(x, y, z, block);
                        continue;
                    }
                    clipboard.setBlock(x, y, z, state);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((entities = (ListTag)tags.get("entities")) != null) {
            Object entityList = entities.getValue();
            Iterator iterator = entityList.iterator();
            while (iterator.hasNext()) {
                CompoundTag entityEntry = (CompoundTag)iterator.next();
                Object entityEntryMap = entityEntry.getValue();
                ListTag posTag = (ListTag)entityEntryMap.get("pos");
                CompoundTag nbtTag = (CompoundTag)entityEntryMap.get("nbt");
                String id = nbtTag.getString("Id");
                Location location = NBTConversions.toLocation(clipboard, posTag, nbtTag.getListTag("Rotation"));
                if (id.isEmpty()) continue;
                BaseEntity state = new BaseEntity(EntityTypes.get(id), nbtTag);
                clipboard.createEntity(location, state);
            }
        }
        return clipboard;
    }

    @Override
    public void write(Clipboard clipboard) throws IOException {
        clipboard.flush();
        this.write(clipboard, "FAWE");
    }

    public void write(Clipboard clipboard, String owner) throws IOException {
        Region region = clipboard.getRegion();
        int width = region.getWidth();
        int height = region.getHeight();
        int length = region.getLength();
        if (width > 32 || height > 32 || length > 32) {
            LOGGER.info("A structure longer than 32 is unsupported by minecraft (but probably still works)");
        }
        Map<String, Object> structure = FaweCache.INSTANCE.asMap("version", 1, "author", owner);
        Int2ObjectArrayMap indexes = new Int2ObjectArrayMap();
        structure.put("size", Arrays.asList(width, height, length));
        ArrayList palette = new ArrayList();
        for (BlockVector3 point : region) {
            BlockState block = clipboard.getBlock(point);
            int combined = block.getInternalId();
            BlockType blockType = block.getBlockType();
            if (blockType == BlockTypes.STRUCTURE_VOID || indexes.containsKey(combined)) continue;
            indexes.put(combined, (Object)palette.size());
            HashMap<String, Object> paletteEntry = new HashMap<String, Object>();
            paletteEntry.put("Name", blockType.getId());
            if (block.getInternalId() != blockType.getInternalId()) {
                HashMap<String, String> properties = null;
                for (AbstractProperty abstractProperty : blockType.getProperties()) {
                    int propIndex = abstractProperty.getIndex(block.getInternalId());
                    if (propIndex == 0) continue;
                    if (properties == null) {
                        properties = new HashMap<String, String>();
                    }
                    Object value = abstractProperty.getValues().get(propIndex);
                    properties.put(abstractProperty.getName(), value.toString());
                }
                if (properties != null) {
                    paletteEntry.put("Properties", properties);
                }
            }
            palette.add(paletteEntry);
        }
        if (!palette.isEmpty()) {
            structure.put("palette", palette);
        }
        ArrayList<Map<String, Object>> blocks = new ArrayList<Map<String, Object>>();
        BlockVector3 min = region.getMinimumPoint();
        for (BlockVector3 point : region) {
            BaseBlock baseBlock = clipboard.getFullBlock(point);
            if (baseBlock.getBlockType() == BlockTypes.STRUCTURE_VOID) continue;
            int combined = baseBlock.getInternalId();
            int index = (Integer)indexes.get(combined);
            List<Integer> pos = Arrays.asList(point.getX() - min.getX(), point.getY() - min.getY(), point.getZ() - min.getZ());
            if (!baseBlock.hasNbtData()) {
                blocks.add(FaweCache.INSTANCE.asMap("state", index, "pos", pos));
                continue;
            }
            blocks.add(FaweCache.INSTANCE.asMap("state", index, "pos", pos, "nbt", baseBlock.getNbtData()));
        }
        if (!blocks.isEmpty()) {
            structure.put("blocks", blocks);
        }
        ArrayList<Map<String, Object>> entities = new ArrayList<Map<String, Object>>();
        for (Entity entity : clipboard.getEntities()) {
            Location loc = entity.getLocation();
            List<Double> pos = Arrays.asList(loc.getX(), loc.getY(), loc.getZ());
            List<Integer> blockPos = Arrays.asList(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
            BaseEntity baseEntity = entity.getState();
            if (baseEntity == null) continue;
            CompoundTag nbt = baseEntity.getNbtData();
            Object nbtMap = nbt.getValue();
            nbtMap.put("Rotation", this.writeRotation(entity.getLocation()));
            nbtMap.put("id", new StringTag(baseEntity.getType().getId()));
            Map<String, Object> entityMap = FaweCache.INSTANCE.asMap("pos", pos, "blockPos", blockPos, "nbt", nbt);
            entities.add(entityMap);
        }
        if (!entities.isEmpty()) {
            structure.put("entities", entities);
        }
        this.out.writeNamedTag("", FaweCache.INSTANCE.asTag(structure));
        this.close();
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
        if (this.out != null) {
            this.out.close();
        }
    }
}

