/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.function.mask;

import com.fastasyncworldedit.core.function.mask.CachedMask;
import com.fastasyncworldedit.core.function.mask.ResettableMask;
import com.fastasyncworldedit.core.math.MutableBlockVector3;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.AbstractExtentMask;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.SolidBlockMask;
import com.sk89q.worldedit.math.BlockVector3;
import java.util.Arrays;

public class AngleMask
extends AbstractExtentMask
implements ResettableMask {
    protected static double ADJACENT_MOD = 0.5;
    protected static double DIAGONAL_MOD = 1.0 / Math.sqrt(8.0);
    protected final CachedMask mask;
    protected final double max;
    protected final double min;
    protected final boolean overlay;
    protected final boolean checkFirst;
    protected final int maxY;
    protected final int minY;
    protected final int distance;
    protected transient int cacheBotX = Integer.MIN_VALUE;
    protected transient int cacheBotZ = Integer.MIN_VALUE;
    protected transient short[] cacheHeights;
    protected transient int lastY;
    protected transient int lastX = Integer.MIN_VALUE;
    protected transient int lastZ = Integer.MIN_VALUE;
    protected transient boolean lastValue;

    public AngleMask(Extent extent, double min, double max, boolean overlay, int distance) {
        super(extent);
        this.mask = new CachedMask(new SolidBlockMask(extent));
        this.min = min;
        this.max = max;
        this.checkFirst = max >= Math.tan(1.5707963267948966);
        this.maxY = extent.getMaxY();
        this.minY = extent.getMinY();
        this.overlay = overlay;
        this.distance = distance;
    }

    @Override
    public void reset() {
        this.cacheBotX = Integer.MIN_VALUE;
        this.cacheBotZ = Integer.MIN_VALUE;
        this.lastX = Integer.MIN_VALUE;
        this.lastY = Integer.MIN_VALUE;
        this.lastZ = Integer.MIN_VALUE;
        if (this.cacheHeights != null) {
            Arrays.fill(this.cacheHeights, (short)0);
        }
    }

    protected int getHeight(Extent extent, int x, int y, int z) {
        int index;
        int rx = x - this.cacheBotX + 16;
        int rz = z - this.cacheBotZ + 16;
        if ((rx & 0xFF) != rx || (rz & 0xFF) != rz) {
            this.cacheBotX = x - 16;
            this.cacheBotZ = z - 16;
            rx = x - this.cacheBotX + 16;
            rz = z - this.cacheBotZ + 16;
            index = rx + (rz << 8);
            if (this.cacheHeights == null) {
                this.cacheHeights = new short[65536];
                Arrays.fill(this.cacheHeights, (short)this.minY);
            } else {
                Arrays.fill(this.cacheHeights, (short)this.minY);
            }
        } else {
            index = rx + (rz << 8);
        }
        int result = this.cacheHeights[index];
        if (y > result) {
            result = this.lastY = extent.getNearestSurfaceTerrainBlock(x, z, this.lastY, this.minY, this.maxY);
            this.cacheHeights[index] = (short)this.lastY;
        }
        return result;
    }

    protected boolean testSlope(Extent extent, int x, int y, int z) {
        this.lastY = y;
        double slope = (double)Math.abs(this.getHeight(extent, x + this.distance, y, z) - this.getHeight(extent, x - this.distance, y, z)) * ADJACENT_MOD;
        if (this.checkFirst) {
            if (slope >= this.min) {
                this.lastValue = true;
                return true;
            }
            slope = Math.max(slope, (double)Math.abs(this.getHeight(extent, x, y, z + this.distance) - this.getHeight(extent, x, y, z - this.distance)) * ADJACENT_MOD);
            slope = Math.max(slope, (double)Math.abs(this.getHeight(extent, x + this.distance, y, z + this.distance) - this.getHeight(extent, x - this.distance, y, z - this.distance)) * DIAGONAL_MOD);
            this.lastValue = (slope = Math.max(slope, (double)Math.abs(this.getHeight(extent, x - this.distance, y, z + this.distance) - this.getHeight(extent, x + this.distance, y, z - this.distance)) * DIAGONAL_MOD)) >= this.min;
            return this.lastValue;
        }
        slope = Math.max(slope, (double)Math.abs(this.getHeight(extent, x, y, z + this.distance) - this.getHeight(extent, x, y, z - this.distance)) * ADJACENT_MOD);
        slope = Math.max(slope, (double)Math.abs(this.getHeight(extent, x + this.distance, y, z + this.distance) - this.getHeight(extent, x - this.distance, y, z - this.distance)) * DIAGONAL_MOD);
        this.lastValue = (slope = Math.max(slope, (double)Math.abs(this.getHeight(extent, x - this.distance, y, z + this.distance) - this.getHeight(extent, x + this.distance, y, z - this.distance)) * DIAGONAL_MOD)) >= this.min && slope <= this.max;
        return this.lastValue;
    }

    private boolean adjacentAir(Extent extent, MutableBlockVector3 mutable) {
        int z;
        int y;
        int x = mutable.getBlockX();
        if (!this.mask.test(extent, mutable.setComponents(x + 1, y = mutable.getBlockY(), z = mutable.getBlockZ()))) {
            return true;
        }
        if (!this.mask.test(extent, mutable.setComponents(x - 1, y, z))) {
            return true;
        }
        if (!this.mask.test(extent, mutable.setComponents(x, y, z + 1))) {
            return true;
        }
        if (!this.mask.test(extent, mutable.setComponents(x, y, z - 1))) {
            return true;
        }
        if (y != this.maxY && !this.mask.test(extent, mutable.setComponents(x, y + 1, z))) {
            return true;
        }
        return y != this.minY && !this.mask.test(extent, mutable.setComponents(x, y - 1, z));
    }

    @Override
    public boolean test(BlockVector3 vector) {
        if (!this.mask.test(vector)) {
            return false;
        }
        int y = vector.getBlockY();
        if (this.overlay) {
            MutableBlockVector3 mutable = new MutableBlockVector3(vector);
            if (y < this.maxY && !this.adjacentAir(null, mutable)) {
                return false;
            }
        }
        int x = vector.getBlockX();
        int z = vector.getBlockZ();
        return this.testSlope(this.getExtent(), x, y, z);
    }

    @Override
    public boolean test(Extent extent, BlockVector3 vector) {
        int height;
        int z;
        int x = vector.getBlockX();
        int y = vector.getBlockY();
        this.lastX = x;
        if (this.lastX == this.lastX & (this.lastZ = (z = vector.getBlockZ())) == this.lastZ && y <= (height = this.getHeight(extent, x, y, z))) {
            return this.overlay ? this.lastValue && y == height : this.lastValue;
        }
        MutableBlockVector3 mutable = new MutableBlockVector3(x, y, z);
        if (!this.mask.test(extent, mutable)) {
            return false;
        }
        if (this.overlay && y < this.maxY && !this.adjacentAir(extent, mutable)) {
            this.lastValue = false;
            return false;
        }
        return this.testSlope(extent, x, y, z);
    }

    @Override
    public Mask copy() {
        return new AngleMask(this.getExtent(), this.min, this.max, this.overlay, this.distance);
    }
}

