/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.history.change;

import com.fastasyncworldedit.core.internal.io.FaweInputStream;
import com.fastasyncworldedit.core.internal.io.FaweOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4BlockOutputStream;

public interface StreamChange {
    public void flushChanges(FaweOutputStream var1) throws IOException;

    public void undoChanges(FaweInputStream var1) throws IOException;

    public void redoChanges(FaweInputStream var1) throws IOException;

    default public void flushChanges(File file) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
             LZ4BlockOutputStream compressed = new LZ4BlockOutputStream((OutputStream)out);
             FaweOutputStream fos = new FaweOutputStream((OutputStream)compressed);){
            this.flushChanges(fos);
        }
    }

    default public void undoChanges(File file) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
             LZ4BlockInputStream compressed = new LZ4BlockInputStream((InputStream)in);
             FaweInputStream fis = new FaweInputStream((InputStream)compressed);){
            this.undoChanges(fis);
        }
    }

    default public void redoChanges(File file) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
             LZ4BlockInputStream compressed = new LZ4BlockInputStream((InputStream)in);
             FaweInputStream fis = new FaweInputStream((InputStream)compressed);){
            this.redoChanges(fis);
        }
    }
}

