/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.math;

import java.util.Arrays;

public class FastBitSet {
    private final int size;
    private final long[] bits;

    public FastBitSet(int size) {
        this.size = size;
        this.bits = new long[size + 64 >> 6];
    }

    public FastBitSet(long[] bits, int size) {
        this.bits = bits;
        this.size = size;
    }

    public static long[] create(int size) {
        return new long[size + 64 >> 6];
    }

    public static boolean get(long[] bits, int i) {
        return (bits[i >> 6] & 1L << (i & 0x3F)) != 0L;
    }

    public static void set(long[] bits, int i) {
        int n = i >> 6;
        bits[n] = bits[n] | 1L << (i & 0x3F);
    }

    public static void clear(long[] bits, int i) {
        int n = i >> 6;
        bits[n] = bits[n] & (1L << (i & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static void set(long[] bits, int i, boolean v) {
        if (v) {
            FastBitSet.set(bits, i);
        } else {
            FastBitSet.clear(bits, i);
        }
    }

    public static void setRange(long[] bits, int b, int e) {
        int bt = b >> 6;
        int et = e >> 6;
        if (bt != et) {
            FastBitSet.fill(bits, bt + 1, et, -1L);
            int n = bt;
            bits[n] = bits[n] | -1L << (b & 0x3F);
            int n2 = et;
            bits[n2] = bits[n2] | -1L << (e & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL;
        } else {
            int n = bt;
            bits[n] = bits[n] | -1L << (b & 0x3F) & (-1L << (e & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public static void clearRange(long[] bits, int b, int e) {
        int bt = b >> 6;
        int et = e >> 6;
        if (bt != et) {
            FastBitSet.fill(bits, bt + 1, et, 0L);
            int n = bt;
            bits[n] = bits[n] & (-1L << (b & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
            int n2 = et;
            bits[n2] = bits[n2] & -1L << (e & 0x3F);
        } else {
            int n = bt;
            bits[n] = bits[n] & (-1L << (b & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL | -1L << (e & 0x3F));
        }
    }

    public static void setAll(long[] bits) {
        Arrays.fill(bits, -1L);
    }

    public static void unsetAll(long[] bits) {
        Arrays.fill(bits, 0L);
    }

    public static void and(long[] bits, long[] other) {
        int end = Math.min(other.length, bits.length);
        for (int i = 0; i < end; ++i) {
            int n = i;
            bits[n] = bits[n] & other[i];
        }
    }

    public static void or(long[] bits, long[] other) {
        int end = Math.min(other.length, bits.length);
        for (int i = 0; i < end; ++i) {
            int n = i;
            bits[n] = bits[n] | other[i];
        }
    }

    private static void fill(long[] a, int b, int e, long l) {
        for (int i = b; i < e; ++i) {
            a[i] = l;
        }
    }

    public boolean get(int i) {
        return (this.bits[i >> 6] & 1L << (i & 0x3F)) != 0L;
    }

    public void set(int i) {
        int n = i >> 6;
        this.bits[n] = this.bits[n] | 1L << (i & 0x3F);
    }

    public void clear(int i) {
        int n = i >> 6;
        this.bits[n] = this.bits[n] & (1L << (i & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void set(int i, boolean v) {
        if (v) {
            this.set(i);
        } else {
            this.clear(i);
        }
    }

    public void setRange(int b, int e) {
        int bt = b >> 6;
        int et = e >> 6;
        if (bt != et) {
            FastBitSet.fill(this.bits, bt + 1, et, -1L);
            int n = bt;
            this.bits[n] = this.bits[n] | -1L << (b & 0x3F);
            int n2 = et;
            this.bits[n2] = this.bits[n2] | -1L << (e & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL;
        } else {
            int n = bt;
            this.bits[n] = this.bits[n] | -1L << (b & 0x3F) & (-1L << (e & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public void clearRange(int b, int e) {
        int bt = b >> 6;
        int et = e >> 6;
        if (bt != et) {
            FastBitSet.fill(this.bits, bt + 1, et, 0L);
            int n = bt;
            this.bits[n] = this.bits[n] & (-1L << (b & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
            int n2 = et;
            this.bits[n2] = this.bits[n2] & -1L << (e & 0x3F);
        } else {
            int n = bt;
            this.bits[n] = this.bits[n] & (-1L << (b & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL | -1L << (e & 0x3F));
        }
    }

    public void and(FastBitSet other) {
        int end = Math.min(other.bits.length, this.bits.length);
        for (int i = 0; i < end; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] & other.bits[i];
        }
    }

    public void or(FastBitSet other) {
        int end = Math.min(other.bits.length, this.bits.length);
        for (int i = 0; i < end; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] | other.bits[i];
        }
    }

    public int cardinality() {
        if (this.size == 0) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < this.bits.length - 1; ++i) {
            count += Long.bitCount(this.bits[i]);
        }
        return count + Long.bitCount(this.bits[this.bits.length - 1] & (-1L << (this.size & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public int size() {
        return this.size;
    }

    public IntIterator iterator() {
        return new IntIterator();
    }

    public class IntIterator {
        int index = 0;
        long bitBuffer = 0L;
        int value = 0;

        public boolean next() {
            while (this.bitBuffer == 0L) {
                if (this.index >= FastBitSet.this.bits.length) {
                    return false;
                }
                this.bitBuffer = FastBitSet.this.bits[this.index];
                ++this.index;
            }
            long lowBit = Long.lowestOneBit(this.bitBuffer);
            int bitIndex = Long.bitCount(lowBit - 1L);
            this.value = (this.index - 1 << 6) + bitIndex;
            this.bitBuffer ^= lowBit;
            return true;
        }

        public int getValue() {
            return this.value;
        }
    }
}

