/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.queue;

import com.fastasyncworldedit.core.extent.processor.EmptyBatchProcessor;
import com.fastasyncworldedit.core.extent.processor.MultiBatchProcessor;
import com.fastasyncworldedit.core.extent.processor.ProcessorScope;
import com.fastasyncworldedit.core.queue.IChunk;
import com.fastasyncworldedit.core.queue.IChunkGet;
import com.fastasyncworldedit.core.queue.IChunkSet;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector3;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Function;
import javax.annotation.Nullable;

public interface IBatchProcessor {
    public IChunkSet processSet(IChunk var1, IChunkGet var2, IChunkSet var3);

    default public Future<?> postProcessSet(IChunk chunk, IChunkGet get, IChunkSet set) {
        return CompletableFuture.completedFuture(null);
    }

    default public void postProcess(IChunk chunk, IChunkGet get, IChunkSet set) {
        this.postProcessSet(chunk, get, set);
    }

    default public boolean processGet(int chunkX, int chunkZ) {
        return true;
    }

    @Nullable
    public Extent construct(Extent var1);

    default public boolean trimY(IChunkSet set, int minY, int maxY, boolean keepInsideRange) {
        int minLayer = minY - 1 >> 4;
        int maxLayer = maxY + 1 >> 4;
        if (keepInsideRange) {
            int i;
            int index;
            char[] arr;
            int layer;
            for (layer = set.getMinSectionPosition(); layer <= minLayer; ++layer) {
                if (!set.hasSection(layer)) continue;
                if (layer == minLayer) {
                    arr = set.loadIfPresent(layer);
                    if (arr != null) {
                        index = (minY & 0xF) << 8;
                        for (i = 0; i < index; ++i) {
                            arr[i] = '\u0000';
                        }
                    } else {
                        arr = new char[4096];
                    }
                    set.setBlocks(layer, arr);
                    continue;
                }
                set.setBlocks(layer, null);
            }
            for (layer = maxLayer; layer < set.getMaxSectionPosition(); ++layer) {
                if (!set.hasSection(layer)) continue;
                if (layer == maxLayer) {
                    arr = set.loadIfPresent(layer);
                    if (arr != null) {
                        for (i = index = (maxY + 1 & 0xF) << 8; i < arr.length; ++i) {
                            arr[i] = '\u0000';
                        }
                    } else {
                        arr = new char[4096];
                    }
                    set.setBlocks(layer, arr);
                    continue;
                }
                set.setBlocks(layer, null);
            }
            try {
                for (layer = minY - 15 >> 4; layer < maxY + 15 >> 4; ++layer) {
                    if (!set.hasSection(layer)) continue;
                    return true;
                }
            }
            catch (ArrayIndexOutOfBoundsException exception) {
                WorldEdit.logger.error("IBatchProcessor: minY = {} , layer = {}", (Object)minY, (Object)(minY - 15 >> 4), (Object)exception);
            }
            return false;
        }
        int chunkMaxY = (set.getMaxSectionPosition() << 4) + 15;
        int chunkMinY = set.getMinSectionPosition() << 4;
        if (maxY >= chunkMaxY && minY <= chunkMinY) {
            set.reset();
            return false;
        }
        boolean hasBlocks = false;
        for (int layer = set.getMinSectionPosition(); layer <= set.getMaxSectionPosition(); ++layer) {
            int index;
            int i;
            char[] arr;
            if (layer < minLayer || layer > maxLayer) {
                hasBlocks |= set.hasSection(layer);
                continue;
            }
            if (layer == minLayer) {
                arr = set.loadIfPresent(layer);
                if (arr != null) {
                    for (i = index = (minY & 0xF) << 8; i < 4096; ++i) {
                        arr[i] = '\u0000';
                    }
                }
                set.setBlocks(layer, arr);
                continue;
            }
            if (layer == maxLayer) {
                arr = set.loadIfPresent(layer);
                if (arr != null) {
                    index = (maxY + 1 & 0xF) << 8;
                    for (i = 0; i < index; ++i) {
                        arr[i] = '\u0000';
                    }
                }
                set.setBlocks(layer, arr);
                continue;
            }
            set.setBlocks(layer, null);
        }
        return hasBlocks;
    }

    default public boolean trimNBT(IChunkSet set, Function<BlockVector3, Boolean> contains) {
        Map<BlockVector3, CompoundTag> tiles;
        Set<CompoundTag> ents = set.getEntities();
        if (!ents.isEmpty()) {
            ents.removeIf(ent -> (Boolean)contains.apply(ent.getEntityPosition().toBlockPoint()) == false);
        }
        if (!(tiles = set.getTiles()).isEmpty()) {
            tiles.entrySet().removeIf(blockVector3CompoundTagEntry -> (Boolean)contains.apply((BlockVector3)blockVector3CompoundTagEntry.getKey()) == false);
        }
        return !tiles.isEmpty() || !ents.isEmpty();
    }

    default public IBatchProcessor join(IBatchProcessor other) {
        return MultiBatchProcessor.of(this, other);
    }

    default public IBatchProcessor joinPost(IBatchProcessor other) {
        return MultiBatchProcessor.of(this, other);
    }

    default public void flush() {
    }

    default public <T extends IBatchProcessor> IBatchProcessor remove(Class<T> clazz) {
        if (clazz.isInstance(this)) {
            return EmptyBatchProcessor.getInstance();
        }
        return this;
    }

    default public ProcessorScope getScope() {
        return ProcessorScope.CUSTOM;
    }
}

