/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.queue.implementation;

import com.fastasyncworldedit.core.Fawe;
import com.fastasyncworldedit.core.FaweCache;
import com.fastasyncworldedit.core.configuration.Settings;
import com.fastasyncworldedit.core.extent.NullExtent;
import com.fastasyncworldedit.core.extent.PassthroughExtent;
import com.fastasyncworldedit.core.extent.clipboard.WorldCopyClipboard;
import com.fastasyncworldedit.core.extent.filter.CountFilter;
import com.fastasyncworldedit.core.extent.filter.DistrFilter;
import com.fastasyncworldedit.core.extent.filter.LinkedFilter;
import com.fastasyncworldedit.core.extent.filter.block.ChunkFilterBlock;
import com.fastasyncworldedit.core.extent.processor.BatchProcessorHolder;
import com.fastasyncworldedit.core.extent.processor.MultiBatchProcessor;
import com.fastasyncworldedit.core.function.mask.BlockMaskBuilder;
import com.fastasyncworldedit.core.internal.exception.FaweException;
import com.fastasyncworldedit.core.queue.Filter;
import com.fastasyncworldedit.core.queue.IQueueChunk;
import com.fastasyncworldedit.core.queue.IQueueExtent;
import com.fastasyncworldedit.core.queue.implementation.QueueHandler;
import com.fastasyncworldedit.core.queue.implementation.SingleThreadQueueExtent;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.function.mask.AbstractExtentMask;
import com.sk89q.worldedit.function.mask.BlockMask;
import com.sk89q.worldedit.function.mask.ExistingBlockMask;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.pattern.BlockPattern;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.Countable;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ForkJoinTask;
import java.util.stream.IntStream;
import org.apache.logging.log4j.Logger;

public class ParallelQueueExtent
extends PassthroughExtent {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    private final World world;
    private final QueueHandler handler;
    private final BatchProcessorHolder processor;
    private final BatchProcessorHolder postProcessor;
    private final boolean[] faweExceptionReasonsUsed = new boolean[FaweException.Type.values().length];
    private final boolean fastmode;
    private int changes;
    private int lastException = Integer.MIN_VALUE;
    private int exceptionCount = 0;

    public ParallelQueueExtent(QueueHandler handler, World world, boolean fastmode) {
        super(handler.getQueue(world, new BatchProcessorHolder(), new BatchProcessorHolder()));
        this.world = world;
        this.handler = handler;
        this.processor = (BatchProcessorHolder)this.getExtent().getProcessor();
        if (this.processor.getProcessor() instanceof MultiBatchProcessor) {
            ((MultiBatchProcessor)this.processor.getProcessor()).setFaweExceptionArray(this.faweExceptionReasonsUsed);
        }
        this.postProcessor = (BatchProcessorHolder)this.getExtent().getPostProcessor();
        if (this.postProcessor.getProcessor() instanceof MultiBatchProcessor) {
            ((MultiBatchProcessor)this.postProcessor.getProcessor()).setFaweExceptionArray(this.faweExceptionReasonsUsed);
        }
        this.fastmode = fastmode;
    }

    @Override
    public IQueueExtent<IQueueChunk> getExtent() {
        return (IQueueExtent)super.getExtent();
    }

    @Override
    public boolean cancel() {
        if (super.cancel()) {
            this.processor.setProcessor(new NullExtent((Extent)this, FaweCache.MANUAL));
            this.postProcessor.setPostProcessor(new NullExtent((Extent)this, FaweCache.MANUAL));
            return true;
        }
        return false;
    }

    private IQueueExtent<IQueueChunk> getNewQueue() {
        return this.handler.getQueue(this.world, this.processor, this.postProcessor);
    }

    @Override
    public <T extends Filter> T apply(Region region, T filter, boolean full) {
        Set<BlockVector2> chunks = region.getChunks();
        Iterator<BlockVector2> chunksIter = chunks.iterator();
        int size = Math.min(chunks.size(), Settings.settings().QUEUE.PARALLEL_THREADS);
        if (size <= 1 && chunksIter.hasNext()) {
            BlockVector2 pos = chunksIter.next();
            this.getExtent().apply(null, filter, region, pos.getX(), pos.getZ(), full);
        } else {
            ForkJoinTask[] tasks;
            for (ForkJoinTask task : tasks = (ForkJoinTask[])IntStream.range(0, size).mapToObj(i -> this.handler.submit(() -> {
                block15: {
                    try {
                        Filter newFilter = filter.fork();
                        SingleThreadQueueExtent queue = (SingleThreadQueueExtent)this.getNewQueue();
                        queue.setFastMode(this.fastmode);
                        queue.setFaweExceptionArray(this.faweExceptionReasonsUsed);
                        SingleThreadQueueExtent singleThreadQueueExtent = queue;
                        synchronized (singleThreadQueueExtent) {
                            try {
                                ChunkFilterBlock block = null;
                                while (true) {
                                    int chunkZ;
                                    int chunkX;
                                    Iterator iterator = chunksIter;
                                    synchronized (iterator) {
                                        if (!chunksIter.hasNext()) {
                                            break;
                                        }
                                        BlockVector2 pos = (BlockVector2)chunksIter.next();
                                        chunkX = pos.getX();
                                        chunkZ = pos.getZ();
                                    }
                                    block = queue.apply(block, newFilter, region, chunkX, chunkZ, full);
                                }
                                queue.flush();
                            }
                            catch (Throwable t) {
                                if (t instanceof FaweException) {
                                    Fawe.handleFaweException(this.faweExceptionReasonsUsed, (FaweException)t, LOGGER);
                                }
                                if (t.getCause() instanceof FaweException) {
                                    Fawe.handleFaweException(this.faweExceptionReasonsUsed, (FaweException)t.getCause(), LOGGER);
                                }
                                throw t;
                            }
                        }
                    }
                    catch (Throwable e) {
                        int hash;
                        String message = e.getMessage();
                        int n = hash = message != null ? message.hashCode() : 0;
                        if (this.lastException != hash) {
                            this.lastException = hash;
                            this.exceptionCount = 0;
                            LOGGER.catching(e);
                        }
                        if (this.exceptionCount >= Settings.settings().QUEUE.PARALLEL_THREADS) break block15;
                        ++this.exceptionCount;
                        LOGGER.warn(message);
                    }
                }
            })).toArray(ForkJoinTask[]::new)) {
                if (task == null) continue;
                task.quietlyJoin();
            }
            filter.join();
        }
        return filter;
    }

    @Override
    public int countBlocks(Region region, Mask searchMask) {
        return ((CountFilter)this.apply(region, searchMask.toFilter(new CountFilter()), searchMask.replacesAir()).getParent()).getTotal();
    }

    @Override
    public <B extends BlockStateHolder<B>> int setBlocks(Region region, B block) throws MaxChangedBlocksException {
        Mask mask = new BlockMaskBuilder().add(block).build(this).inverse();
        this.changes = this.apply(region, mask.toFilter(block), mask.replacesAir()).getBlocksApplied();
        return this.changes;
    }

    @Override
    public int setBlocks(Region region, Pattern pattern) throws MaxChangedBlocksException {
        this.changes = this.apply(region, new LinkedFilter<Pattern, CountFilter>(pattern, new CountFilter()), true).getChild().getTotal();
        return this.changes;
    }

    @Override
    public int setBlocks(Set<BlockVector3> vset, Pattern pattern) {
        if (vset instanceof Region) {
            this.changes = this.setBlocks((Region)((Object)vset), pattern);
            return this.changes;
        }
        for (BlockVector3 blockVector3 : vset) {
            if (!pattern.apply(this, blockVector3, blockVector3)) continue;
            ++this.changes;
        }
        return this.changes;
    }

    @Override
    public int replaceBlocks(Region region, Mask mask, Pattern pattern) throws MaxChangedBlocksException {
        boolean full = mask.replacesAir();
        this.changes = this.apply(region, mask.toFilter(pattern), full).getBlocksApplied();
        return this.changes;
    }

    @Override
    public List<Countable<BlockState>> getBlockDistributionWithData(Region region) {
        return this.apply(region, new DistrFilter(), true).getDistribution();
    }

    @Override
    public List<Countable<BlockType>> getBlockDistribution(Region region) {
        return this.apply(region, new DistrFilter(), true).getTypeDistribution();
    }

    @Override
    public Clipboard lazyCopy(Region region) {
        WorldCopyClipboard clipboard = new WorldCopyClipboard(() -> this, region);
        clipboard.setOrigin(region.getMinimumPoint());
        return clipboard;
    }

    @Override
    public int countBlocks(Region region, Set<BaseBlock> searchBlocks) {
        BlockMask mask = new BlockMask((Extent)this, searchBlocks);
        return this.countBlocks(region, mask);
    }

    @Override
    public <B extends BlockStateHolder<B>> int replaceBlocks(Region region, Set<BaseBlock> filter, B replacement) throws MaxChangedBlocksException {
        return this.replaceBlocks(region, filter, (Pattern)new BlockPattern(replacement));
    }

    @Override
    public int replaceBlocks(Region region, Set<BaseBlock> filter, Pattern pattern) throws MaxChangedBlocksException {
        AbstractExtentMask mask = filter == null ? new ExistingBlockMask(this) : new BlockMask((Extent)this, filter);
        return this.replaceBlocks(region, mask, pattern);
    }
}

