/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.queue.implementation;

import com.fastasyncworldedit.core.Fawe;
import com.fastasyncworldedit.core.FaweCache;
import com.fastasyncworldedit.core.configuration.Settings;
import com.fastasyncworldedit.core.queue.IBatchProcessor;
import com.fastasyncworldedit.core.queue.IChunkCache;
import com.fastasyncworldedit.core.queue.IChunkGet;
import com.fastasyncworldedit.core.queue.IChunkSet;
import com.fastasyncworldedit.core.queue.IQueueChunk;
import com.fastasyncworldedit.core.queue.IQueueExtent;
import com.fastasyncworldedit.core.queue.Trimable;
import com.fastasyncworldedit.core.queue.implementation.SingleThreadQueueExtent;
import com.fastasyncworldedit.core.queue.implementation.chunk.ChunkCache;
import com.fastasyncworldedit.core.util.MemUtil;
import com.fastasyncworldedit.core.util.TaskManager;
import com.fastasyncworldedit.core.util.collection.CleanableThreadLocal;
import com.fastasyncworldedit.core.util.task.FaweForkJoinWorkerThreadFactory;
import com.fastasyncworldedit.core.wrappers.WorldWrapper;
import com.google.common.util.concurrent.Futures;
import com.sk89q.worldedit.world.World;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Supplier;

public abstract class QueueHandler
implements Trimable,
Runnable {
    private static final int PROCESSORS = Runtime.getRuntime().availableProcessors();
    private final ForkJoinPool forkJoinPoolPrimary = new ForkJoinPool(PROCESSORS, new FaweForkJoinWorkerThreadFactory("FAWE Fork Join Pool Primary - %s"), null, false);
    private final ForkJoinPool forkJoinPoolSecondary = new ForkJoinPool(PROCESSORS, new FaweForkJoinWorkerThreadFactory("FAWE Fork Join Pool Secondary - %s"), null, false);
    private final ThreadPoolExecutor blockingExecutor = FaweCache.INSTANCE.newBlockingExecutor();
    private final ConcurrentLinkedQueue<FutureTask> syncTasks = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<FutureTask> syncWhenFree = new ConcurrentLinkedQueue();
    private final Map<World, WeakReference<IChunkCache<IChunkGet>>> chunkGetCache = new HashMap<World, WeakReference<IChunkCache<IChunkGet>>>();
    private final CleanableThreadLocal<IQueueExtent<IQueueChunk>> queuePool = new CleanableThreadLocal<IQueueExtent>(this::create);
    private long last;
    private long allocate = 50L;

    protected QueueHandler() {
        TaskManager.taskManager().repeat(this, 1);
    }

    @Override
    public void run() {
        if (!Fawe.isMainThread()) {
            throw new IllegalStateException("Not main thread");
        }
        if (!this.syncTasks.isEmpty()) {
            long currentAllocate = this.getAllocate();
            if (!MemUtil.isMemoryFree()) {
                // empty if block
            }
            this.operate(this.syncTasks, this.last, currentAllocate);
        } else if (!this.syncWhenFree.isEmpty()) {
            this.operate(this.syncWhenFree, this.last, this.getAllocate());
        }
    }

    public boolean isUnderutilized() {
        return this.blockingExecutor.getActiveCount() < this.blockingExecutor.getMaximumPoolSize();
    }

    private long getAllocate() {
        long now = System.currentTimeMillis();
        double targetTPS = 18.0 - Math.max((double)Settings.settings().QUEUE.EXTRA_TIME_MS * 0.05, 0.0);
        this.last = now;
        long diff = 50L + this.last - this.last;
        long absDiff = Math.abs(diff);
        if (diff == 0L) {
            this.allocate = Math.min(50L, this.allocate + 1L);
        } else if (diff < 0L) {
            this.allocate = Math.max(5L, this.allocate + diff);
        } else if (!Fawe.instance().getTimer().isAbove(targetTPS)) {
            this.allocate = Math.max(5L, this.allocate - 1L);
        }
        return this.allocate - absDiff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void operate(Queue<FutureTask> queue, long start, long currentAllocate) {
        boolean wait = false;
        do {
            Runnable task;
            if ((task = (Runnable)queue.poll()) == null) {
                if (!wait) break;
                ConcurrentLinkedQueue<FutureTask> concurrentLinkedQueue = this.syncTasks;
                synchronized (concurrentLinkedQueue) {
                    try {
                        queue.wait(1L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                task = queue.poll();
                wait = false;
            }
            if (task == null) continue;
            task.run();
            wait = true;
        } while (System.currentTimeMillis() - start < currentAllocate);
    }

    @Deprecated(forRemoval=true, since="2.6.2")
    public <T extends Future<T>> void complete(Future<T> task) {
        try {
            while (task != null) {
                task = (Future)task.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
    }

    public <T> Future<T> async(Runnable run, T value) {
        return this.forkJoinPoolSecondary.submit(run, (Object)value);
    }

    public Future<?> async(Runnable run) {
        return this.forkJoinPoolSecondary.submit(run);
    }

    public <T> Future<T> async(Callable<T> call) {
        return this.forkJoinPoolSecondary.submit((Callable)call);
    }

    public ForkJoinTask submit(Runnable run) {
        return this.forkJoinPoolPrimary.submit(run);
    }

    public <T> Future<T> sync(Runnable run) {
        return this.sync(run, this.syncTasks);
    }

    public <T> Future<T> sync(Callable<T> call) throws Exception {
        return this.sync(call, this.syncTasks);
    }

    public <T> Future<T> sync(Supplier<T> supplier) {
        return this.sync(supplier, this.syncTasks);
    }

    public <T> Future<T> syncWhenFree(Runnable run, T value) {
        return this.sync(run, value, this.syncWhenFree);
    }

    public <T> Future<T> syncWhenFree(Runnable run) {
        return this.sync(run, this.syncWhenFree);
    }

    public <T> Future<T> syncWhenFree(Callable<T> call) throws Exception {
        return this.sync(call, this.syncWhenFree);
    }

    public <T> Future<T> syncWhenFree(Supplier<T> supplier) {
        return this.sync(supplier, this.syncWhenFree);
    }

    private <T> Future<T> sync(Runnable run, T value, Queue<FutureTask> queue) {
        if (Fawe.isMainThread()) {
            run.run();
            return Futures.immediateFuture(value);
        }
        FutureTask<T> result = new FutureTask<T>(run, value);
        queue.add(result);
        this.notifySync(queue);
        return result;
    }

    private <T> Future<T> sync(Runnable run, Queue<FutureTask> queue) {
        if (Fawe.isMainThread()) {
            run.run();
            return Futures.immediateCancelledFuture();
        }
        FutureTask<Object> result = new FutureTask<Object>(run, null);
        queue.add(result);
        this.notifySync(queue);
        return result;
    }

    private <T> Future<T> sync(Callable<T> call, Queue<FutureTask> queue) throws Exception {
        if (Fawe.isMainThread()) {
            return Futures.immediateFuture(call.call());
        }
        FutureTask<T> result = new FutureTask<T>(call);
        queue.add(result);
        this.notifySync(queue);
        return result;
    }

    private <T> Future<T> sync(Supplier<T> call, Queue<FutureTask> queue) {
        if (Fawe.isMainThread()) {
            return Futures.immediateFuture(call.get());
        }
        FutureTask<Object> result = new FutureTask<Object>(call::get);
        queue.add(result);
        this.notifySync(queue);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySync(Object object) {
        Object object2 = object;
        synchronized (object2) {
            object.notifyAll();
        }
    }

    public <T extends Future<T>> T submit(IQueueChunk<T> chunk) {
        return (T)this.blockingExecutor.submit(chunk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IChunkCache<IChunkGet> getOrCreateWorldCache(World world) {
        world = WorldWrapper.unwrap(world);
        Map<World, WeakReference<IChunkCache<IChunkGet>>> map = this.chunkGetCache;
        synchronized (map) {
            IChunkCache cached;
            WeakReference<IChunkCache<IChunkGet>> ref = this.chunkGetCache.get(world);
            if (ref != null && (cached = (IChunkCache)ref.get()) != null) {
                return cached;
            }
            ChunkCache<IChunkGet> created = new ChunkCache<IChunkGet>(world);
            this.chunkGetCache.put(world, new WeakReference<ChunkCache<IChunkGet>>(created));
            return created;
        }
    }

    public IQueueExtent<IQueueChunk> create() {
        return new SingleThreadQueueExtent();
    }

    public void unCache() {
        this.queuePool.set(null);
    }

    private IQueueExtent<IQueueChunk> pool() {
        IQueueExtent<IQueueChunk> queue = (IQueueExtent<IQueueChunk>)this.queuePool.get();
        if (queue == null) {
            queue = this.queuePool.init();
            this.queuePool.set(queue);
        }
        return queue;
    }

    @Deprecated(forRemoval=true, since="2.6.2")
    public void startSet(boolean parallel) {
        this.startUnsafe(parallel);
    }

    @Deprecated(forRemoval=true, since="2.6.2")
    public void endSet(boolean parallel) {
        this.startUnsafe(parallel);
    }

    public abstract void startUnsafe(boolean var1);

    public abstract void endUnsafe(boolean var1);

    public IQueueExtent<IQueueChunk> getQueue(World world) {
        return this.getQueue(world, null, null);
    }

    public IQueueExtent<IQueueChunk> getQueue(World world, IBatchProcessor processor, IBatchProcessor postProcessor) {
        IQueueExtent<IQueueChunk> queue = this.pool();
        IChunkCache<IChunkGet> cacheGet = this.getOrCreateWorldCache(world);
        IChunkCache<IChunkSet> set = null;
        queue.init(world, cacheGet, set);
        if (processor != null) {
            queue.setProcessor(processor);
        }
        if (postProcessor != null) {
            queue.setPostProcessor(postProcessor);
        }
        return queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean trim(boolean aggressive) {
        boolean result = true;
        Map<World, WeakReference<IChunkCache<IChunkGet>>> map = this.chunkGetCache;
        synchronized (map) {
            Iterator<Map.Entry<World, WeakReference<IChunkCache<IChunkGet>>>> iter = this.chunkGetCache.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<World, WeakReference<IChunkCache<IChunkGet>>> entry = iter.next();
                WeakReference<IChunkCache<IChunkGet>> value = entry.getValue();
                IChunkCache cache = (IChunkCache)value.get();
                if (cache.trim(aggressive)) {
                    iter.remove();
                    continue;
                }
                result = false;
            }
        }
        return result;
    }

    public ExecutorService getForkJoinPoolPrimary() {
        return this.forkJoinPoolPrimary;
    }

    public ExecutorService getForkJoinPoolSecondary() {
        return this.forkJoinPoolSecondary;
    }
}

