/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.queue.implementation.chunk;

import com.fastasyncworldedit.core.FaweCache;
import com.fastasyncworldedit.core.configuration.Settings;
import com.fastasyncworldedit.core.extent.filter.block.ChunkFilterBlock;
import com.fastasyncworldedit.core.extent.processor.EmptyBatchProcessor;
import com.fastasyncworldedit.core.extent.processor.heightmap.HeightMapType;
import com.fastasyncworldedit.core.queue.Filter;
import com.fastasyncworldedit.core.queue.IChunk;
import com.fastasyncworldedit.core.queue.IChunkGet;
import com.fastasyncworldedit.core.queue.IChunkSet;
import com.fastasyncworldedit.core.queue.IQueueChunk;
import com.fastasyncworldedit.core.queue.IQueueExtent;
import com.fastasyncworldedit.core.queue.Pool;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;

public class ChunkHolder<T extends Future<T>>
implements IQueueChunk<T> {
    private static final Pool<ChunkHolder> POOL = FaweCache.INSTANCE.registerPool(ChunkHolder.class, ChunkHolder::new, Settings.settings().QUEUE.POOL);
    private final Lock calledLock = new ReentrantLock();
    private volatile IChunkGet chunkExisting;
    private volatile IChunkSet chunkSet;
    private IBlockDelegate delegate = NULL;
    private IQueueExtent<? extends IChunk> extent;
    private int chunkX;
    private int chunkZ;
    private boolean fastmode;
    private int bitMask = -1;
    private boolean isInit = false;
    private boolean createCopy = false;
    private long initTime = -1L;
    private static final IBlockDelegate BOTH = new IBlockDelegate(){

        public IChunkGet get(ChunkHolder chunk) {
            return chunk.chunkExisting;
        }

        @Override
        public IChunkSet set(ChunkHolder chunk) {
            return chunk.chunkSet;
        }

        @Override
        public boolean setBiome(ChunkHolder chunk, int x, int y, int z, BiomeType biome) {
            return chunk.chunkSet.setBiome(x, y, z, biome);
        }

        public <B extends BlockStateHolder<B>> boolean setBlock(ChunkHolder chunk, int x, int y, int z, B block) {
            return chunk.chunkSet.setBlock(x, y, z, block);
        }

        @Override
        public void setSkyLight(ChunkHolder chunk, int x, int y, int z, int value) {
            chunk.chunkSet.setSkyLight(x, y, z, value);
        }

        @Override
        public void setBlockLight(ChunkHolder chunk, int x, int y, int z, int value) {
            chunk.chunkSet.setBlockLight(x, y, z, value);
        }

        @Override
        public void removeSectionLighting(ChunkHolder chunk, int layer, boolean sky) {
            chunk.chunkSet.removeSectionLighting(layer, sky);
            chunk.chunkExisting.removeSectionLighting(layer, sky);
        }

        @Override
        public void setFullBright(ChunkHolder chunk, int layer) {
            chunk.chunkSet.setFullBright(layer);
        }

        @Override
        public void setLightLayer(ChunkHolder chunk, int layer, char[] toSet) {
            chunk.chunkSet.setLightLayer(layer, toSet);
        }

        @Override
        public void setSkyLightLayer(ChunkHolder chunk, int layer, char[] toSet) {
            chunk.chunkSet.setSkyLightLayer(layer, toSet);
        }

        @Override
        public void setHeightMap(ChunkHolder chunk, HeightMapType type, int[] heightMap) {
            chunk.chunkSet.setHeightMap(type, heightMap);
        }

        @Override
        public BiomeType getBiome(ChunkHolder chunk, int x, int y, int z) {
            return chunk.chunkExisting.getBiomeType(x, y, z);
        }

        @Override
        public BlockState getBlock(ChunkHolder chunk, int x, int y, int z) {
            return chunk.chunkExisting.getBlock(x, y, z);
        }

        @Override
        public BaseBlock getFullBlock(ChunkHolder chunk, int x, int y, int z) {
            return chunk.chunkExisting.getFullBlock(x, y, z);
        }

        @Override
        public int getSkyLight(ChunkHolder chunk, int x, int y, int z) {
            if (chunk.chunkSet.getSkyLight() != null) {
                char setLightValue;
                int layer = y >> 4;
                if ((layer -= chunk.chunkSet.getMinSectionPosition()) >= 0 && layer < chunk.chunkSet.getSectionCount() && chunk.chunkSet.getSkyLight()[layer] != null && (setLightValue = chunk.chunkSet.getSkyLight()[layer][(y & 0xF) << 8 | (z & 0xF) << 4 | x & 0xF]) < '\u0010') {
                    return setLightValue;
                }
            }
            return chunk.chunkExisting.getSkyLight(x, y, z);
        }

        @Override
        public int getEmittedLight(ChunkHolder chunk, int x, int y, int z) {
            if (chunk.chunkSet.getLight() != null) {
                char setLightValue;
                int layer = y >> 4;
                if ((layer -= chunk.chunkSet.getMinSectionPosition()) >= 0 && layer < chunk.chunkSet.getSectionCount() && chunk.chunkSet.getLight()[layer] != null && (setLightValue = chunk.chunkSet.getLight()[layer][(y & 0xF) << 8 | (z & 0xF) << 4 | x & 0xF]) < '\u0010') {
                    return setLightValue;
                }
            }
            return chunk.chunkExisting.getEmittedLight(x, y, z);
        }

        @Override
        public int getBrightness(ChunkHolder chunk, int x, int y, int z) {
            return chunk.chunkExisting.getBrightness(x, y, z);
        }

        @Override
        public int getOpacity(ChunkHolder chunk, int x, int y, int z) {
            return chunk.chunkExisting.getOpacity(x, y, z);
        }

        @Override
        public int[] getHeightMap(ChunkHolder chunk, HeightMapType type) {
            return chunk.chunkExisting.getHeightMap(type);
        }

        @Override
        public void flushLightToGet(ChunkHolder chunk) {
            chunk.chunkExisting.setLightingToGet(chunk.chunkSet.getLight(), chunk.chunkSet.getMinSectionPosition(), chunk.chunkSet.getMaxSectionPosition());
            chunk.chunkExisting.setSkyLightingToGet(chunk.chunkSet.getSkyLight(), chunk.chunkSet.getMinSectionPosition(), chunk.chunkSet.getMaxSectionPosition());
        }

        @Override
        public void setLightingToGet(ChunkHolder chunk, char[][] lighting) {
            chunk.chunkExisting.setLightingToGet(lighting, chunk.chunkSet.getMinSectionPosition(), chunk.chunkSet.getMaxSectionPosition());
        }

        @Override
        public void setSkyLightingToGet(ChunkHolder chunk, char[][] lighting) {
            chunk.chunkExisting.setSkyLightingToGet(lighting, chunk.chunkSet.getMinSectionPosition(), chunk.chunkSet.getMaxSectionPosition());
        }

        @Override
        public void setHeightmapToGet(ChunkHolder chunk, HeightMapType type, int[] data) {
            chunk.chunkExisting.setHeightmapToGet(type, data);
        }
    };
    private static final IBlockDelegate GET = new IBlockDelegate(){

        public IChunkGet get(ChunkHolder chunk) {
            return chunk.chunkExisting;
        }

        @Override
        public IChunkSet set(ChunkHolder chunk) {
            chunk.getOrCreateSet();
            chunk.delegate = BOTH;
            return chunk.chunkSet;
        }

        @Override
        public boolean setBiome(ChunkHolder chunk, int x, int y, int z, BiomeType biome) {
            chunk.getOrCreateSet();
            chunk.delegate = BOTH;
            return chunk.setBiome(x, y, z, biome);
        }

        public <B extends BlockStateHolder<B>> boolean setBlock(ChunkHolder chunk, int x, int y, int z, B block) {
            chunk.getOrCreateSet();
            chunk.delegate = BOTH;
            return chunk.setBlock(x, y, z, block);
        }

        @Override
        public void setSkyLight(ChunkHolder chunk, int x, int y, int z, int value) {
            chunk.getOrCreateSet();
            chunk.delegate = BOTH;
            chunk.setSkyLight(x, y, z, value);
        }

        @Override
        public void setBlockLight(ChunkHolder chunk, int x, int y, int z, int value) {
            chunk.getOrCreateSet();
            chunk.delegate = BOTH;
            chunk.setBlockLight(x, y, z, value);
        }

        @Override
        public void removeSectionLighting(ChunkHolder chunk, int layer, boolean sky) {
            chunk.getOrCreateSet();
            chunk.delegate = BOTH;
            chunk.removeSectionLighting(layer, sky);
        }

        @Override
        public void setFullBright(ChunkHolder chunk, int layer) {
            chunk.getOrCreateSet();
            chunk.delegate = BOTH;
            chunk.setFullBright(layer);
        }

        @Override
        public void setLightLayer(ChunkHolder chunk, int layer, char[] toSet) {
            chunk.getOrCreateSet();
            chunk.delegate = BOTH;
            chunk.setLightLayer(layer, toSet);
        }

        @Override
        public void setSkyLightLayer(ChunkHolder chunk, int layer, char[] toSet) {
            chunk.getOrCreateSet();
            chunk.delegate = BOTH;
            chunk.setSkyLightLayer(layer, toSet);
        }

        @Override
        public void setHeightMap(ChunkHolder chunk, HeightMapType type, int[] heightMap) {
            chunk.getOrCreateSet();
            chunk.delegate = BOTH;
            chunk.setHeightMap(type, heightMap);
        }

        @Override
        public BiomeType getBiome(ChunkHolder chunk, int x, int y, int z) {
            return chunk.chunkExisting.getBiomeType(x, y, z);
        }

        @Override
        public BlockState getBlock(ChunkHolder chunk, int x, int y, int z) {
            return chunk.chunkExisting.getBlock(x, y, z);
        }

        @Override
        public BaseBlock getFullBlock(ChunkHolder chunk, int x, int y, int z) {
            return chunk.chunkExisting.getFullBlock(x, y, z);
        }

        @Override
        public int getSkyLight(ChunkHolder chunk, int x, int y, int z) {
            return chunk.chunkExisting.getSkyLight(x, y, z);
        }

        @Override
        public int getEmittedLight(ChunkHolder chunk, int x, int y, int z) {
            return chunk.chunkExisting.getEmittedLight(x, y, z);
        }

        @Override
        public int getBrightness(ChunkHolder chunk, int x, int y, int z) {
            return chunk.chunkExisting.getBrightness(x, y, z);
        }

        @Override
        public int getOpacity(ChunkHolder chunk, int x, int y, int z) {
            return chunk.chunkExisting.getOpacity(x, y, z);
        }

        @Override
        public int[] getHeightMap(ChunkHolder chunk, HeightMapType type) {
            return chunk.chunkExisting.getHeightMap(type);
        }

        @Override
        public void flushLightToGet(ChunkHolder chunk) {
        }

        @Override
        public void setLightingToGet(ChunkHolder chunk, char[][] lighting) {
            chunk.chunkExisting.setLightingToGet(lighting, chunk.chunkSet.getMinSectionPosition(), chunk.chunkSet.getMaxSectionPosition());
        }

        @Override
        public void setSkyLightingToGet(ChunkHolder chunk, char[][] lighting) {
            chunk.chunkExisting.setSkyLightingToGet(lighting, chunk.chunkSet.getMinSectionPosition(), chunk.chunkSet.getMaxSectionPosition());
        }

        @Override
        public void setHeightmapToGet(ChunkHolder chunk, HeightMapType type, int[] data) {
            chunk.chunkExisting.setHeightmapToGet(type, data);
        }
    };
    private static final IBlockDelegate SET = new IBlockDelegate(){

        public IChunkGet get(ChunkHolder chunk) {
            chunk.getOrCreateGet();
            chunk.delegate = BOTH;
            return chunk.chunkExisting;
        }

        @Override
        public IChunkSet set(ChunkHolder chunk) {
            return chunk.chunkSet;
        }

        @Override
        public boolean setBiome(ChunkHolder chunk, int x, int y, int z, BiomeType biome) {
            return chunk.chunkSet.setBiome(x, y, z, biome);
        }

        public <B extends BlockStateHolder<B>> boolean setBlock(ChunkHolder chunk, int x, int y, int z, B block) {
            return chunk.chunkSet.setBlock(x, y, z, block);
        }

        @Override
        public void setSkyLight(ChunkHolder chunk, int x, int y, int z, int value) {
            chunk.chunkSet.setSkyLight(x, y, z, value);
        }

        @Override
        public void setBlockLight(ChunkHolder chunk, int x, int y, int z, int value) {
            chunk.chunkSet.setBlockLight(x, y, z, value);
        }

        @Override
        public void removeSectionLighting(ChunkHolder chunk, int layer, boolean sky) {
            chunk.getOrCreateGet();
            chunk.delegate = BOTH;
            chunk.removeSectionLighting(layer, sky);
        }

        @Override
        public void setFullBright(ChunkHolder chunk, int layer) {
            chunk.chunkSet.setFullBright(layer);
        }

        @Override
        public void setLightLayer(ChunkHolder chunk, int layer, char[] toSet) {
            chunk.chunkSet.setLightLayer(layer, toSet);
        }

        @Override
        public void setSkyLightLayer(ChunkHolder chunk, int layer, char[] toSet) {
            chunk.chunkSet.setSkyLightLayer(layer, toSet);
        }

        @Override
        public void setHeightMap(ChunkHolder chunk, HeightMapType type, int[] heightMap) {
            chunk.chunkSet.setHeightMap(type, heightMap);
        }

        @Override
        public BiomeType getBiome(ChunkHolder chunk, int x, int y, int z) {
            chunk.getOrCreateGet();
            chunk.delegate = BOTH;
            return chunk.getBiomeType(x, y, z);
        }

        @Override
        public BlockState getBlock(ChunkHolder chunk, int x, int y, int z) {
            chunk.getOrCreateGet();
            chunk.delegate = BOTH;
            return chunk.getBlock(x, y, z);
        }

        @Override
        public BaseBlock getFullBlock(ChunkHolder chunk, int x, int y, int z) {
            chunk.getOrCreateGet();
            chunk.delegate = BOTH;
            return chunk.getFullBlock(x, y, z);
        }

        @Override
        public int getSkyLight(ChunkHolder chunk, int x, int y, int z) {
            if (chunk.chunkSet.getSkyLight() != null) {
                char setLightValue;
                int layer = y >> 4;
                if ((layer -= chunk.chunkSet.getMinSectionPosition()) >= 0 && layer < chunk.chunkSet.getSectionCount() && chunk.chunkSet.getSkyLight()[layer] != null && (setLightValue = chunk.chunkSet.getSkyLight()[layer][(y & 0xF) << 8 | (z & 0xF) << 4 | x & 0xF]) < '\u0010') {
                    return setLightValue;
                }
            }
            chunk.getOrCreateGet();
            chunk.delegate = BOTH;
            return chunk.getSkyLight(x, y, z);
        }

        @Override
        public int getEmittedLight(ChunkHolder chunk, int x, int y, int z) {
            if (chunk.chunkSet.getLight() != null) {
                char setLightValue;
                int layer = y >> 4;
                if ((layer -= chunk.chunkSet.getMinSectionPosition()) >= 0 && layer < chunk.chunkSet.getSectionCount() && chunk.chunkSet.getLight()[layer] != null && (setLightValue = chunk.chunkSet.getLight()[layer][(y & 0xF) << 8 | (z & 0xF) << 4 | x & 0xF]) < '\u0010') {
                    return setLightValue;
                }
            }
            chunk.getOrCreateGet();
            chunk.delegate = BOTH;
            return chunk.getEmittedLight(x, y, z);
        }

        @Override
        public int getBrightness(ChunkHolder chunk, int x, int y, int z) {
            chunk.getOrCreateGet();
            chunk.delegate = BOTH;
            return chunk.getBrightness(x, y, z);
        }

        @Override
        public int getOpacity(ChunkHolder chunk, int x, int y, int z) {
            chunk.getOrCreateGet();
            chunk.delegate = BOTH;
            return chunk.getOpacity(x, y, z);
        }

        @Override
        public int[] getHeightMap(ChunkHolder chunk, HeightMapType type) {
            chunk.getOrCreateGet();
            chunk.delegate = BOTH;
            return chunk.getHeightMap(type);
        }

        @Override
        public void flushLightToGet(ChunkHolder chunk) {
            chunk.getOrCreateGet();
            chunk.delegate = BOTH;
            chunk.flushLightToGet();
        }

        @Override
        public void setLightingToGet(ChunkHolder chunk, char[][] lighting) {
            chunk.getOrCreateGet();
            chunk.delegate = BOTH;
            chunk.setLightingToGet(lighting, chunk.chunkSet.getMinSectionPosition(), chunk.chunkSet.getMaxSectionPosition());
        }

        @Override
        public void setSkyLightingToGet(ChunkHolder chunk, char[][] lighting) {
            chunk.getOrCreateGet();
            chunk.delegate = BOTH;
            chunk.setSkyLightingToGet(lighting, chunk.chunkSet.getMinSectionPosition(), chunk.chunkSet.getMaxSectionPosition());
        }

        @Override
        public void setHeightmapToGet(ChunkHolder chunk, HeightMapType type, int[] data) {
            chunk.getOrCreateGet();
            chunk.delegate = BOTH;
            chunk.setHeightmapToGet(type, data);
        }
    };
    private static final IBlockDelegate NULL = new IBlockDelegate(){

        public IChunkGet get(ChunkHolder chunk) {
            chunk.getOrCreateGet();
            chunk.delegate = GET;
            return chunk.chunkExisting;
        }

        @Override
        public IChunkSet set(ChunkHolder chunk) {
            chunk.getOrCreateSet();
            chunk.delegate = SET;
            return chunk.chunkSet;
        }

        @Override
        public boolean setBiome(ChunkHolder chunk, int x, int y, int z, BiomeType biome) {
            chunk.getOrCreateSet();
            chunk.delegate = SET;
            return chunk.setBiome(x, y, z, biome);
        }

        public <B extends BlockStateHolder<B>> boolean setBlock(ChunkHolder chunk, int x, int y, int z, B block) {
            chunk.getOrCreateSet();
            chunk.delegate = SET;
            return chunk.setBlock(x, y, z, block);
        }

        @Override
        public BiomeType getBiome(ChunkHolder chunk, int x, int y, int z) {
            chunk.getOrCreateGet();
            chunk.delegate = GET;
            return chunk.getBiomeType(x, y, z);
        }

        @Override
        public BlockState getBlock(ChunkHolder chunk, int x, int y, int z) {
            chunk.getOrCreateGet();
            chunk.delegate = GET;
            return chunk.getBlock(x, y, z);
        }

        @Override
        public BaseBlock getFullBlock(ChunkHolder chunk, int x, int y, int z) {
            chunk.getOrCreateGet();
            chunk.delegate = GET;
            return chunk.getFullBlock(x, y, z);
        }

        @Override
        public void setSkyLight(ChunkHolder chunk, int x, int y, int z, int value) {
            chunk.getOrCreateSet();
            chunk.delegate = SET;
            chunk.setSkyLight(x, y, z, value);
        }

        @Override
        public void setBlockLight(ChunkHolder chunk, int x, int y, int z, int value) {
            chunk.getOrCreateSet();
            chunk.delegate = SET;
            chunk.setBlockLight(x, y, z, value);
        }

        @Override
        public void removeSectionLighting(ChunkHolder chunk, int layer, boolean sky) {
            chunk.getOrCreateGet();
            chunk.getOrCreateSet();
            chunk.delegate = BOTH;
            chunk.removeSectionLighting(layer, sky);
        }

        @Override
        public void setFullBright(ChunkHolder chunk, int layer) {
            chunk.getOrCreateSet();
            chunk.delegate = SET;
            chunk.setFullBright(layer);
        }

        @Override
        public void setLightLayer(ChunkHolder chunk, int layer, char[] toSet) {
            chunk.getOrCreateSet();
            chunk.delegate = SET;
            chunk.setLightLayer(layer, toSet);
        }

        @Override
        public void setSkyLightLayer(ChunkHolder chunk, int layer, char[] toSet) {
            chunk.getOrCreateSet();
            chunk.delegate = SET;
            chunk.setSkyLightLayer(layer, toSet);
        }

        @Override
        public void setHeightMap(ChunkHolder chunk, HeightMapType type, int[] heightMap) {
            chunk.getOrCreateSet();
            chunk.delegate = SET;
            chunk.setHeightMap(type, heightMap);
        }

        @Override
        public int getSkyLight(ChunkHolder chunk, int x, int y, int z) {
            chunk.getOrCreateGet();
            chunk.delegate = GET;
            return chunk.getSkyLight(x, y, z);
        }

        @Override
        public int getEmittedLight(ChunkHolder chunk, int x, int y, int z) {
            chunk.getOrCreateGet();
            chunk.delegate = GET;
            return chunk.getEmittedLight(x, y, z);
        }

        @Override
        public int getBrightness(ChunkHolder chunk, int x, int y, int z) {
            chunk.getOrCreateGet();
            chunk.delegate = GET;
            return chunk.getBrightness(x, y, z);
        }

        @Override
        public int getOpacity(ChunkHolder chunk, int x, int y, int z) {
            chunk.getOrCreateGet();
            chunk.delegate = GET;
            return chunk.getOpacity(x, y, z);
        }

        @Override
        public int[] getHeightMap(ChunkHolder chunk, HeightMapType type) {
            chunk.getOrCreateGet();
            chunk.delegate = GET;
            return chunk.getHeightMap(type);
        }

        @Override
        public void flushLightToGet(ChunkHolder chunk) {
        }

        @Override
        public void setLightingToGet(ChunkHolder chunk, char[][] lighting) {
            chunk.getOrCreateGet();
            chunk.delegate = GET;
            chunk.setLightingToGet(lighting, chunk.chunkSet.getMinSectionPosition(), chunk.chunkSet.getMaxSectionPosition());
        }

        @Override
        public void setSkyLightingToGet(ChunkHolder chunk, char[][] lighting) {
            chunk.getOrCreateGet();
            chunk.delegate = GET;
            chunk.setSkyLightingToGet(lighting, chunk.chunkSet.getMinSectionPosition(), chunk.chunkSet.getMaxSectionPosition());
        }

        @Override
        public void setHeightmapToGet(ChunkHolder chunk, HeightMapType type, int[] data) {
            chunk.getOrCreateGet();
            chunk.delegate = GET;
            chunk.setHeightmapToGet(type, data);
        }
    };

    public static ChunkHolder newInstance() {
        return POOL.poll();
    }

    private ChunkHolder() {
    }

    public void init(IBlockDelegate delegate) {
        this.delegate = delegate;
    }

    @Override
    public synchronized void recycle() {
        this.calledLock.lock();
        this.delegate = NULL;
        if (this.chunkSet != null) {
            this.chunkSet.recycle();
            this.chunkSet = null;
        }
        this.chunkExisting = null;
        this.extent = null;
        POOL.offer(this);
        this.calledLock.unlock();
    }

    public long initAge() {
        return System.currentTimeMillis() - this.initTime;
    }

    public synchronized IBlockDelegate getDelegate() {
        return this.delegate;
    }

    private void checkAndWaitOnCalledLock() {
        if (!this.calledLock.tryLock()) {
            this.calledLock.lock();
        }
        this.calledLock.unlock();
    }

    @Override
    public boolean setTile(int x, int y, int z, CompoundTag tag) {
        this.checkAndWaitOnCalledLock();
        return this.delegate.set(this).setTile(x, y, z, tag);
    }

    @Override
    public CompoundTag getTile(int x, int y, int z) {
        this.checkAndWaitOnCalledLock();
        return this.delegate.set(this).getTile(x, y, z);
    }

    @Override
    public void setEntity(CompoundTag tag) {
        this.checkAndWaitOnCalledLock();
        this.delegate.set(this).setEntity(tag);
    }

    @Override
    public void removeEntity(UUID uuid) {
        this.checkAndWaitOnCalledLock();
        this.delegate.set(this).removeEntity(uuid);
    }

    @Override
    public Set<UUID> getEntityRemoves() {
        this.checkAndWaitOnCalledLock();
        return this.delegate.set(this).getEntityRemoves();
    }

    @Override
    public BiomeType[][] getBiomes() {
        this.checkAndWaitOnCalledLock();
        return this.delegate.set(this).getBiomes();
    }

    @Override
    public char[][] getLight() {
        this.checkAndWaitOnCalledLock();
        return this.delegate.set(this).getLight();
    }

    @Override
    public char[][] getSkyLight() {
        this.checkAndWaitOnCalledLock();
        return this.delegate.set(this).getSkyLight();
    }

    @Override
    public void setBlocks(int layer, char[] data) {
        this.checkAndWaitOnCalledLock();
        this.delegate.set(this).setBlocks(layer, data);
    }

    @Override
    public char[] load(int layer) {
        return this.getOrCreateGet().load(layer);
    }

    @Override
    @Nullable
    public char[] loadIfPresent(int layer) {
        if (this.chunkExisting == null) {
            return null;
        }
        return this.chunkExisting.loadIfPresent(layer);
    }

    @Override
    public boolean isFastMode() {
        return this.fastmode;
    }

    @Override
    public void setFastMode(boolean fastmode) {
        this.checkAndWaitOnCalledLock();
        this.fastmode = fastmode;
    }

    @Override
    public void setBitMask(int bitMask) {
        this.checkAndWaitOnCalledLock();
        this.bitMask = bitMask;
    }

    @Override
    public int getBitMask() {
        return this.bitMask;
    }

    @Override
    public boolean hasBiomes(int layer) {
        this.checkAndWaitOnCalledLock();
        return this.chunkSet != null && this.chunkSet.hasBiomes(layer);
    }

    public boolean isInit() {
        return this.isInit;
    }

    @Override
    public CompoundTag getEntity(UUID uuid) {
        this.checkAndWaitOnCalledLock();
        return this.delegate.get(this).getEntity(uuid);
    }

    @Override
    public void setCreateCopy(boolean createCopy) {
        this.checkAndWaitOnCalledLock();
        this.createCopy = createCopy;
    }

    @Override
    public boolean isCreateCopy() {
        return this.createCopy;
    }

    @Override
    public void setLightingToGet(char[][] lighting, int minSectionPosition, int maxSectionPosition) {
        this.checkAndWaitOnCalledLock();
        this.delegate.setLightingToGet(this, lighting);
    }

    @Override
    public void setSkyLightingToGet(char[][] lighting, int minSectionPosition, int maxSectionPosition) {
        this.checkAndWaitOnCalledLock();
        this.delegate.setSkyLightingToGet(this, lighting);
    }

    @Override
    public void setHeightmapToGet(HeightMapType type, int[] data) {
        this.checkAndWaitOnCalledLock();
        this.delegate.setHeightmapToGet(this, type, data);
    }

    @Override
    public int getMaxY() {
        return this.getOrCreateGet().getMaxY();
    }

    @Override
    public int getMinY() {
        return this.getOrCreateGet().getMinY();
    }

    @Override
    public int getMaxSectionPosition() {
        return this.getOrCreateGet().getMaxSectionPosition();
    }

    @Override
    public int getMinSectionPosition() {
        return this.getOrCreateGet().getMinSectionPosition();
    }

    public void flushLightToGet() {
        this.checkAndWaitOnCalledLock();
        this.delegate.flushLightToGet(this);
    }

    @Override
    public Map<BlockVector3, CompoundTag> getTiles() {
        this.checkAndWaitOnCalledLock();
        return this.delegate.get(this).getTiles();
    }

    @Override
    public Set<CompoundTag> getEntities() {
        this.checkAndWaitOnCalledLock();
        return this.delegate.get(this).getEntities();
    }

    @Override
    public boolean hasSection(int layer) {
        this.checkAndWaitOnCalledLock();
        return this.chunkExisting != null && this.chunkExisting.hasSection(layer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void filterBlocks(Filter filter, ChunkFilterBlock block, @Nullable Region region, boolean full) {
        IChunkGet get = this.getOrCreateGet();
        IChunkSet set = this.getOrCreateSet();
        set.setFastMode(this.fastmode);
        try {
            block.filter(this, get, set, filter, region, full);
        }
        finally {
            filter.finishChunk(this);
        }
    }

    @Override
    public synchronized boolean trim(boolean aggressive) {
        boolean result;
        this.chunkExisting.trim(aggressive);
        if (this.chunkSet != null && (result = this.chunkSet.trim(aggressive))) {
            this.delegate = NULL;
            this.chunkExisting = null;
            this.chunkSet = null;
            return true;
        }
        if (aggressive) {
            this.chunkExisting = null;
            if (this.delegate == BOTH) {
                this.delegate = SET;
            } else if (this.delegate == GET) {
                this.delegate = NULL;
            }
        }
        return false;
    }

    @Override
    public synchronized boolean trim(boolean aggressive, int layer) {
        return this.trim(aggressive);
    }

    @Override
    public int getSectionCount() {
        return this.getOrCreateGet().getSectionCount();
    }

    @Override
    public boolean isEmpty() {
        this.checkAndWaitOnCalledLock();
        return this.chunkSet == null || this.chunkSet.isEmpty();
    }

    public final IChunkGet getOrCreateGet() {
        this.checkAndWaitOnCalledLock();
        if (this.chunkExisting == null) {
            this.chunkExisting = this.newWrappedGet();
            this.chunkExisting.trim(false);
        }
        return this.chunkExisting;
    }

    public final IChunkSet getOrCreateSet() {
        this.checkAndWaitOnCalledLock();
        if (this.chunkSet == null) {
            this.chunkSet = this.newWrappedSet();
        }
        return this.chunkSet;
    }

    private IChunkSet newWrappedSet() {
        return this.extent.getCachedSet(this.chunkX, this.chunkZ);
    }

    private synchronized IChunkGet newWrappedGet() {
        return this.extent.getCachedGet(this.chunkX, this.chunkZ);
    }

    @Override
    public synchronized <V extends IChunk> void init(IQueueExtent<V> extent, int chunkX, int chunkZ) {
        this.initTime = System.currentTimeMillis();
        this.extent = extent;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        if (this.chunkSet != null) {
            this.chunkSet.reset();
            this.delegate = SET;
        } else {
            this.delegate = NULL;
        }
        this.chunkExisting = null;
        this.isInit = true;
    }

    @Override
    public synchronized T call() {
        this.calledLock.lock();
        if (this.chunkSet != null && !this.chunkSet.isEmpty()) {
            this.delegate = GET;
            this.chunkSet.setBitMask(this.bitMask);
            try {
                IChunkSet copy = this.chunkSet.createCopy();
                this.chunkSet = null;
                return this.call(copy, () -> {});
            }
            catch (Throwable t) {
                this.calledLock.unlock();
                throw t;
            }
        }
        return null;
    }

    @Override
    public synchronized T call(IChunkSet set, Runnable finalize) {
        if (set != null) {
            IChunkGet get = this.getOrCreateGet();
            boolean postProcess = !(this.getExtent().getPostProcessor() instanceof EmptyBatchProcessor);
            get.setCreateCopy(postProcess);
            IChunkSet iChunkSet = this.getExtent().processSet(this, get, set);
            Runnable finalizer = postProcess ? () -> {
                this.getExtent().postProcess(this, get.getCopy(), iChunkSet);
                finalize.run();
            } : finalize;
            this.calledLock.unlock();
            return get.call(set, finalizer);
        }
        return null;
    }

    public IQueueExtent<? extends IChunk> getExtent() {
        return this.extent;
    }

    @Override
    public int getX() {
        return this.chunkX;
    }

    @Override
    public int getZ() {
        return this.chunkZ;
    }

    @Override
    public boolean setBiome(int x, int y, int z, BiomeType biome) {
        this.checkAndWaitOnCalledLock();
        return this.delegate.setBiome(this, x, y, z, biome);
    }

    @Override
    public <B extends BlockStateHolder<B>> boolean setBlock(int x, int y, int z, B block) {
        this.checkAndWaitOnCalledLock();
        return this.delegate.setBlock(this, x, y, z, block);
    }

    @Override
    public BiomeType getBiomeType(int x, int y, int z) {
        this.checkAndWaitOnCalledLock();
        return this.delegate.getBiome(this, x, y, z);
    }

    @Override
    public BlockState getBlock(int x, int y, int z) {
        this.checkAndWaitOnCalledLock();
        return this.delegate.getBlock(this, x, y, z);
    }

    @Override
    public BaseBlock getFullBlock(int x, int y, int z) {
        this.checkAndWaitOnCalledLock();
        return this.delegate.getFullBlock(this, x, y, z);
    }

    @Override
    public void setSkyLight(int x, int y, int z, int value) {
        this.checkAndWaitOnCalledLock();
        this.delegate.setSkyLight(this, x, y, z, value);
    }

    @Override
    public void setHeightMap(HeightMapType type, int[] heightMap) {
        this.checkAndWaitOnCalledLock();
        this.delegate.setHeightMap(this, type, heightMap);
    }

    @Override
    public void removeSectionLighting(int layer, boolean sky) {
        this.checkAndWaitOnCalledLock();
        this.delegate.removeSectionLighting(this, layer, sky);
    }

    @Override
    public void setFullBright(int layer) {
        this.checkAndWaitOnCalledLock();
        this.delegate.setFullBright(this, layer);
    }

    @Override
    public void setBlockLight(int x, int y, int z, int value) {
        this.checkAndWaitOnCalledLock();
        this.delegate.setBlockLight(this, x, y, z, value);
    }

    @Override
    public void setLightLayer(int layer, char[] toSet) {
        this.checkAndWaitOnCalledLock();
        this.delegate.setLightLayer(this, layer, toSet);
    }

    @Override
    public void setSkyLightLayer(int layer, char[] toSet) {
        this.checkAndWaitOnCalledLock();
        this.delegate.setSkyLightLayer(this, layer, toSet);
    }

    @Override
    public int getSkyLight(int x, int y, int z) {
        this.checkAndWaitOnCalledLock();
        return this.delegate.getSkyLight(this, x, y, z);
    }

    @Override
    public int getEmittedLight(int x, int y, int z) {
        this.checkAndWaitOnCalledLock();
        return this.delegate.getEmittedLight(this, x, y, z);
    }

    @Override
    public int getBrightness(int x, int y, int z) {
        this.checkAndWaitOnCalledLock();
        return this.delegate.getBrightness(this, x, y, z);
    }

    @Override
    public int getOpacity(int x, int y, int z) {
        this.checkAndWaitOnCalledLock();
        return this.delegate.getOpacity(this, x, y, z);
    }

    @Override
    public int[] getHeightMap(HeightMapType type) {
        this.checkAndWaitOnCalledLock();
        return this.delegate.getHeightMap(this, type);
    }

    public static interface IBlockDelegate {
        public <C extends Future<C>> IChunkGet get(ChunkHolder<C> var1);

        public IChunkSet set(ChunkHolder var1);

        public boolean setBiome(ChunkHolder var1, int var2, int var3, int var4, BiomeType var5);

        public <T extends BlockStateHolder<T>> boolean setBlock(ChunkHolder var1, int var2, int var3, int var4, T var5);

        public BiomeType getBiome(ChunkHolder var1, int var2, int var3, int var4);

        public BlockState getBlock(ChunkHolder var1, int var2, int var3, int var4);

        public BaseBlock getFullBlock(ChunkHolder var1, int var2, int var3, int var4);

        public void setSkyLight(ChunkHolder var1, int var2, int var3, int var4, int var5);

        public void setBlockLight(ChunkHolder var1, int var2, int var3, int var4, int var5);

        public void removeSectionLighting(ChunkHolder var1, int var2, boolean var3);

        public void setFullBright(ChunkHolder var1, int var2);

        public void setLightLayer(ChunkHolder var1, int var2, char[] var3);

        public void setSkyLightLayer(ChunkHolder var1, int var2, char[] var3);

        public void setHeightMap(ChunkHolder var1, HeightMapType var2, int[] var3);

        public int getSkyLight(ChunkHolder var1, int var2, int var3, int var4);

        public int getEmittedLight(ChunkHolder var1, int var2, int var3, int var4);

        public int getBrightness(ChunkHolder var1, int var2, int var3, int var4);

        public int getOpacity(ChunkHolder var1, int var2, int var3, int var4);

        public int[] getHeightMap(ChunkHolder var1, HeightMapType var2);

        public void flushLightToGet(ChunkHolder var1);

        public void setLightingToGet(ChunkHolder var1, char[][] var2);

        public void setSkyLightingToGet(ChunkHolder var1, char[][] var2);

        public void setHeightmapToGet(ChunkHolder var1, HeightMapType var2, int[] var3);
    }
}

