/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.util;

import com.fastasyncworldedit.core.Fawe;
import com.fastasyncworldedit.core.FaweVersion;
import com.fastasyncworldedit.core.configuration.Caption;
import com.fastasyncworldedit.core.configuration.Settings;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.event.ClickEvent;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;

public class UpdateNotification {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    private static boolean hasUpdate;
    private static String faweVersion;

    public static void doUpdateCheck() {
        if (Settings.settings().ENABLED_COMPONENTS.UPDATE_NOTIFICATIONS) {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://ci.athion.net/job/FastAsyncWorldEdit/api/xml/")).timeout(Duration.of(10L, ChronoUnit.SECONDS)).build();
            HttpClient.newHttpClient().sendAsync(request, HttpResponse.BodyHandlers.ofInputStream()).whenComplete((response, thrown) -> {
                if (thrown != null) {
                    LOGGER.error("Update check failed: {} ", (Object)thrown.getMessage());
                }
                UpdateNotification.processResponseBody((InputStream)response.body());
            });
        }
    }

    private static void processResponseBody(InputStream body) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(body);
            faweVersion = doc.getElementsByTagName("lastSuccessfulBuild").item(0).getFirstChild().getTextContent();
            FaweVersion faweVersion = Fawe.instance().getVersion();
            if (faweVersion.build == 0) {
                LOGGER.warn("You are using a snapshot or a custom version of FAWE. This is not an official build distributed via https://www.spigotmc.org/resources/13932/");
                return;
            }
            if (faweVersion.build < Integer.parseInt(UpdateNotification.faweVersion)) {
                hasUpdate = true;
                int versionDifference = Integer.parseInt(UpdateNotification.faweVersion) - faweVersion.build;
                LOGGER.warn("An update for FastAsyncWorldEdit is available. You are {} build(s) out of date.\nYou are running build {}, the latest version is build {}.\nUpdate at https://www.spigotmc.org/resources/13932/", (Object)versionDifference, (Object)faweVersion.build, (Object)UpdateNotification.faweVersion);
            }
        }
        catch (Exception ignored) {
            LOGGER.error("Unable to check for updates. Skipping.");
        }
    }

    public static void doUpdateNotification(Actor actor) {
        if (Settings.settings().ENABLED_COMPONENTS.UPDATE_NOTIFICATIONS && actor.hasPermission("fawe.admin") && hasUpdate) {
            FaweVersion faweVersion = Fawe.instance().getVersion();
            int versionDifference = Integer.parseInt(UpdateNotification.faweVersion) - faweVersion.build;
            actor.print((Component)Caption.of("fawe.info.update-available", versionDifference, faweVersion.build, UpdateNotification.faweVersion, TextComponent.of((String)"https://www.spigotmc.org/resources/13932/").clickEvent(ClickEvent.openUrl((String)"https://www.spigotmc.org/resources/13932/"))));
        }
    }

    static {
        faweVersion = "";
    }
}

