/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.util;

import com.fastasyncworldedit.core.configuration.Caption;
import com.fastasyncworldedit.core.configuration.Settings;
import com.fastasyncworldedit.core.extent.NullExtent;
import com.fastasyncworldedit.core.internal.exception.FaweException;
import com.fastasyncworldedit.core.regions.FaweMask;
import com.fastasyncworldedit.core.regions.FaweMaskManager;
import com.fastasyncworldedit.core.regions.RegionWrapper;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.logging.log4j.Logger;

public class WEManager {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    private static WEManager INSTANCE;
    @Deprecated(forRemoval=true, since="2.0.0")
    public static WEManager IMP;
    private final ArrayDeque<FaweMaskManager> managers = new ArrayDeque();

    public static WEManager weManager() {
        if (INSTANCE == null) {
            INSTANCE = new WEManager();
        }
        return INSTANCE;
    }

    public ArrayDeque<FaweMaskManager> getManagers() {
        return this.managers;
    }

    public void addManager(FaweMaskManager manager) {
        if (manager.isExclusive()) {
            this.managers.addFirst(manager);
        } else {
            this.managers.add(manager);
        }
    }

    public void addManagers(Collection<FaweMaskManager> managers) {
        for (FaweMaskManager manager : managers) {
            this.addManager(manager);
        }
    }

    public void cancelEditSafe(AbstractDelegateExtent parent, FaweException reason) throws FaweException {
        Extent currentExtent = parent.getExtent();
        if (!(currentExtent instanceof NullExtent)) {
            parent.extent = new NullExtent(parent.extent, reason);
        }
        throw reason;
    }

    public void cancelEdit(AbstractDelegateExtent parent, FaweException reason) throws WorldEditException {
        this.cancelEditSafe(parent, reason);
    }

    public boolean isIn(int x, int y, int z, Region region) {
        return region.contains(x, y, z);
    }

    public Region[] getMask(Player player) {
        return this.getMask(player, FaweMaskManager.MaskType.getDefaultMaskType(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Region[] getMask(Player player, FaweMaskManager.MaskType type, boolean isWhitelist) {
        HashSet<FaweMask> hashSet;
        if (!Settings.settings().REGION_RESTRICTIONS || player.hasPermission("fawe.bypass.regions")) {
            return new Region[]{RegionWrapper.GLOBAL()};
        }
        Location loc = player.getLocation();
        String world = player.getWorld().getName();
        if (!world.equals(player.getMeta("lastMaskWorld"))) {
            player.deleteMeta("lastMaskWorld");
            player.deleteMeta("lastMask");
        }
        player.setMeta("lastMaskWorld", world);
        HashSet<FaweMask> masks = (HashSet<FaweMask>)player.getMeta("lastMask");
        HashSet<Region> regions = new HashSet<Region>();
        if (masks == null || !isWhitelist) {
            masks = new HashSet<FaweMask>();
        } else {
            hashSet = masks;
            synchronized (hashSet) {
                boolean removed = false;
                boolean inMask = false;
                if (!masks.isEmpty()) {
                    Iterator iterator = masks.iterator();
                    while (iterator.hasNext()) {
                        FaweMask mask = (FaweMask)iterator.next();
                        if (mask.isValid(player, type, false)) {
                            Region region = mask.getRegion();
                            inMask |= region.contains(loc.toBlockPoint());
                            regions.add(region);
                            continue;
                        }
                        if (Settings.settings().ENABLED_COMPONENTS.DEBUG) {
                            player.printDebug((Component)Caption.of("fawe.error.region-mask-invalid", mask.getClass().getSimpleName()));
                        }
                        removed = true;
                        iterator.remove();
                    }
                }
                if (!removed && inMask) {
                    return regions.toArray(new Region[0]);
                }
            }
        }
        hashSet = masks;
        synchronized (hashSet) {
            for (FaweMaskManager manager : this.managers) {
                if (player.hasPermission("fawe." + manager.getKey())) {
                    try {
                        FaweMask mask;
                        if (manager.isExclusive() && !masks.isEmpty() || (mask = manager.getMask(player, FaweMaskManager.MaskType.getDefaultMaskType(), isWhitelist, masks.isEmpty())) == null) continue;
                        regions.add(mask.getRegion());
                        masks.add(mask);
                        if (!manager.isExclusive()) continue;
                        break;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                player.printError((Component)TextComponent.of((String)("Missing permission fawe." + manager.getKey())));
            }
            if (isWhitelist) {
                if (!masks.isEmpty()) {
                    player.setMeta("lastMask", masks);
                } else {
                    player.deleteMeta("lastMask");
                }
            }
        }
        return regions.toArray(new Region[0]);
    }

    public boolean intersects(Region region1, Region region2) {
        BlockVector3 rg1P1 = region1.getMinimumPoint();
        BlockVector3 rg1P2 = region1.getMaximumPoint();
        BlockVector3 rg2P1 = region2.getMinimumPoint();
        BlockVector3 rg2P2 = region2.getMaximumPoint();
        return rg1P1.getBlockX() <= rg2P2.getBlockX() && rg1P2.getBlockX() >= rg2P1.getBlockX() && rg1P1.getBlockZ() <= rg2P2.getBlockZ() && rg1P2.getBlockZ() >= rg2P1.getBlockZ();
    }

    public boolean regionContains(Region selection, HashSet<Region> mask) {
        for (Region region : mask) {
            if (!this.intersects(region, selection)) continue;
            return true;
        }
        return false;
    }

    static {
        IMP = new WEManager();
    }
}

