/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.util.task;

import com.fastasyncworldedit.core.configuration.Settings;
import com.fastasyncworldedit.core.util.task.FaweForkJoinWorkerThreadFactory;
import com.fastasyncworldedit.core.util.task.KeyQueuedExecutorService;
import java.io.Closeable;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.function.Supplier;

public class AsyncNotifyKeyedQueue
implements Closeable {
    private static final KeyQueuedExecutorService<UUID> QUEUE_SUBMISSIONS = new KeyQueuedExecutorService(new ForkJoinPool(Settings.settings().QUEUE.PARALLEL_THREADS, new FaweForkJoinWorkerThreadFactory("AsyncNotifyKeyedQueue - %s"), null, false));
    private final Thread.UncaughtExceptionHandler handler;
    private final Supplier<UUID> key;
    private volatile boolean closed;

    public AsyncNotifyKeyedQueue(Thread.UncaughtExceptionHandler handler, Supplier<UUID> key) {
        this.handler = handler;
        this.key = key;
    }

    public Thread.UncaughtExceptionHandler getHandler() {
        return this.handler;
    }

    public <T> Future<T> run(Runnable task) {
        return this.call(() -> {
            task.run();
            return null;
        });
    }

    public <T> Future<T> call(Callable<T> task) {
        Future[] self = new Future[1];
        Callable<Object> wrapped = () -> {
            if (!this.closed) {
                try {
                    return task.call();
                }
                catch (Throwable e) {
                    this.handler.uncaughtException(Thread.currentThread(), e);
                }
            }
            if (self[0] != null) {
                self[0].cancel(true);
            }
            return null;
        };
        self[0] = QUEUE_SUBMISSIONS.submit(this.key.get(), wrapped);
        return self[0];
    }

    @Override
    public void close() {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

