/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.jnbt;

import com.fastasyncworldedit.core.jnbt.NumberTag;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.sk89q.jnbt.AdventureNBTConverter;
import com.sk89q.jnbt.CompoundTagBuilder;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.nbt.BinaryTag;
import com.sk89q.worldedit.util.nbt.BinaryTagLike;
import com.sk89q.worldedit.util.nbt.CompoundBinaryTag;
import com.sk89q.worldedit.util.nbt.NumberBinaryTag;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@Deprecated
public class CompoundTag
extends Tag {
    private final CompoundBinaryTag innerTag;

    public CompoundTag(Map<String, Tag> value) {
        this(((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().put(Maps.transformValues(value, BinaryTagLike::asBinaryTag))).build());
    }

    public CompoundTag(CompoundBinaryTag adventureTag) {
        this.innerTag = adventureTag;
    }

    public boolean containsKey(String key) {
        return this.innerTag.keySet().contains(key);
    }

    @Override
    public Map<String, Tag> getValue() {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (String key : this.innerTag.keySet()) {
            map.put((Object)key, (Object)AdventureNBTConverter.fromAdventure(this.innerTag.get(key)));
        }
        return map.build();
    }

    public CompoundTag setValue(Map<String, Tag> value) {
        return new CompoundTag(value);
    }

    public CompoundTagBuilder createBuilder() {
        return new CompoundTagBuilder(this.innerTag);
    }

    public byte[] getByteArray(String key) {
        return this.innerTag.getByteArray(key);
    }

    public byte getByte(String key) {
        return this.innerTag.getByte(key);
    }

    public double getDouble(String key) {
        return this.innerTag.getDouble(key);
    }

    public double asDouble(String key) {
        BinaryTag tag = this.innerTag.get(key);
        if (tag instanceof NumberBinaryTag) {
            return ((NumberBinaryTag)tag).doubleValue();
        }
        return 0.0;
    }

    public float getFloat(String key) {
        return this.innerTag.getFloat(key);
    }

    public int[] getIntArray(String key) {
        return this.innerTag.getIntArray(key);
    }

    public int getInt(String key) {
        return this.innerTag.getInt(key);
    }

    public int asInt(String key) {
        BinaryTag tag = this.innerTag.get(key);
        if (tag instanceof NumberBinaryTag) {
            return ((NumberBinaryTag)tag).intValue();
        }
        return 0;
    }

    public List<Tag> getList(String key) {
        return this.getListTag(key).getValue();
    }

    public ListTag getListTag(String key) {
        return new ListTag(this.innerTag.getList(key));
    }

    public <T extends Tag> List<T> getList(String key, Class<T> listType) {
        ListTag listTag = this.getListTag(key);
        if (listTag.getType().equals(listType)) {
            return listTag.getValue();
        }
        return Collections.emptyList();
    }

    public long[] getLongArray(String key) {
        return this.innerTag.getLongArray(key);
    }

    public long getLong(String key) {
        return this.innerTag.getLong(key);
    }

    public long asLong(String key) {
        BinaryTag tag = this.innerTag.get(key);
        if (tag instanceof NumberBinaryTag) {
            return ((NumberBinaryTag)tag).longValue();
        }
        return 0L;
    }

    public short getShort(String key) {
        return this.innerTag.getShort(key);
    }

    public String getString(String key) {
        return this.innerTag.getString(key);
    }

    public CompoundBinaryTag asBinaryTag() {
        return this.innerTag;
    }

    public UUID getUUID() {
        UUID uuid;
        if (this.containsKey("UUID")) {
            int[] arr = this.getIntArray("UUID");
            uuid = new UUID((long)arr[0] << 32 | (long)arr[1] & 0xFFFFFFFFL, (long)arr[2] << 32 | (long)arr[3] & 0xFFFFFFFFL);
        } else if (this.containsKey("UUIDMost")) {
            uuid = new UUID(this.getLong("UUIDMost"), this.getLong("UUIDLeast"));
        } else if (this.containsKey("WorldUUIDMost")) {
            uuid = new UUID(this.getLong("WorldUUIDMost"), this.getLong("WorldUUIDLeast"));
        } else if (this.containsKey("PersistentIDMSB")) {
            uuid = new UUID(this.getLong("PersistentIDMSB"), this.getLong("PersistentIDLSB"));
        } else {
            return null;
        }
        return uuid;
    }

    public Vector3 getEntityPosition() {
        List<Tag> posTags = this.getList("Pos");
        double x = ((NumberTag)posTags.get(0)).getValue().doubleValue();
        double y = ((NumberTag)posTags.get(1)).getValue().doubleValue();
        double z = ((NumberTag)posTags.get(2)).getValue().doubleValue();
        return Vector3.at(x, y, z);
    }

    public Location getEntityLocation(Extent extent) {
        List<Tag> rotTag = this.getList("Rotation");
        float yaw = ((NumberTag)rotTag.get(0)).getValue().floatValue();
        float pitch = ((NumberTag)rotTag.get(1)).getValue().floatValue();
        return new Location(extent, this.getEntityPosition(), yaw, pitch);
    }

    @Override
    public int getTypeCode() {
        return 10;
    }

    @Override
    public Map<String, Object> toRaw() {
        HashMap<String, Object> raw = new HashMap<String, Object>();
        if (this.getValue().isEmpty()) {
            return raw;
        }
        for (Map.Entry entry : this.getValue().entrySet()) {
            raw.put((String)entry.getKey(), ((Tag)entry.getValue()).toRaw());
        }
        return raw;
    }
}

