/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.GenerationCommands;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.command.util.annotation.Confirm;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.internal.annotation.Radii;
import com.sk89q.worldedit.internal.annotation.Selection;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.TreeGenerator;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.biome.BiomeType;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandParts;
import org.enginehub.piston.part.NoArgCommandFlag;

public final class GenerationCommandsRegistration
implements CommandRegistration<GenerationCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<Pattern> pattern_Key = Key.of(Pattern.class);
    private static final Key<Double> double_radii2_Key = Key.of(Double.class, (Annotation)new Object(){

        Annotation a(@Radii(value=2) Object ah) {
            try {
                return this.getClass().getDeclaredMethod("a", Object.class).getParameterAnnotations()[0][0];
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }.a(null));
    private static final Key<Integer> integer_Key = Key.of(Integer.class);
    private static final Key<Double> double_Key = Key.of(Double.class);
    private static final Key<Double> double_radii3_Key = Key.of(Double.class, (Annotation)new Object(){

        Annotation a(@Radii(value=3) Object ah) {
            try {
                return this.getClass().getDeclaredMethod("a", Object.class).getParameterAnnotations()[0][0];
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }.a(null));
    private static final Key<TreeGenerator.TreeType> treeType_Key = Key.of(TreeGenerator.TreeType.class);
    private static final Key<Integer> integer_confirmcom_sk89q_worldedit_command_util_annotation_Confirm_Processor_RADIUS_Key = Key.of(Integer.class, (Annotation)new Object(){

        Annotation a(@Confirm(value=Confirm.Processor.RADIUS) Object ah) {
            try {
                return this.getClass().getDeclaredMethod("a", Object.class).getParameterAnnotations()[0][0];
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }.a(null));
    private static final Key<String> string_Key = Key.of(String.class);
    private static final Key<BiomeType> biomeType_Key = Key.of(BiomeType.class);
    private static final Key<Mask> mask_Key = Key.of(Mask.class);
    private static final Key<Boolean> boolean_Key = Key.of(Boolean.class);
    private static final Key<BlockVector2> blockVector2_Key = Key.of(BlockVector2.class);
    private static final Key<Vector3> vector3_Key = Key.of(Vector3.class);
    private static final Key<Actor> actor_Key = Key.of(Actor.class);
    private static final Key<LocalSession> localSession_Key = Key.of(LocalSession.class);
    private static final Key<EditSession> editSession_Key = Key.of(EditSession.class);
    private static final Key<Region> region_selection_Key = Key.of(Region.class, Selection.class);
    private CommandManager commandManager;
    private GenerationCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final CommandArgument patternPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"pattern"), (Component)TextComponent.of((String)"The pattern of blocks to generate")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(pattern_Key)).build();
    private final CommandArgument radiiPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radii"), (Component)TextComponent.of((String)"The radii of the cylinder. 1st is N/S, 2nd is E/W")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(double_radii2_Key)).build();
    private final CommandArgument heightPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"height"), (Component)TextComponent.of((String)"The height of the cylinder")).defaultsTo((Iterable)ImmutableList.of((Object)"1")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument thicknessPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"thickness"), (Component)TextComponent.of((String)"Thickness of the cyclinder. 0 creates a normal //hcyl.")).defaultsTo((Iterable)ImmutableList.of((Object)"0")).ofTypes((Collection)ImmutableList.of(double_Key)).build();
    private final NoArgCommandFlag hollowPart = CommandParts.flag((char)'h', (Component)TextComponent.of((String)"Make a hollow cylinder")).build();
    private final CommandArgument radiiPart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radii"), (Component)TextComponent.of((String)"The radii of the cone. 1st is N/S, 2nd is E/W")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(double_radii2_Key)).build();
    private final CommandArgument heightPart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"height"), (Component)TextComponent.of((String)"The height of the cone")).defaultsTo((Iterable)ImmutableList.of((Object)"1")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final NoArgCommandFlag hollowPart2 = CommandParts.flag((char)'h', (Component)TextComponent.of((String)"Make a hollow cone")).build();
    private final CommandArgument thicknessPart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"thickness"), (Component)TextComponent.of((String)"Thickness of the hollow cone")).defaultsTo((Iterable)ImmutableList.of((Object)"1")).ofTypes((Collection)ImmutableList.of(double_Key)).build();
    private final CommandArgument radiiPart3 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radii"), (Component)TextComponent.of((String)"The radii of the sphere. Order is N/S, U/D, E/W")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(double_radii3_Key)).build();
    private final NoArgCommandFlag raisedPart = CommandParts.flag((char)'r', (Component)TextComponent.of((String)"Raise the bottom of the sphere to the placement position")).build();
    private final NoArgCommandFlag hollowPart3 = CommandParts.flag((char)'h', (Component)TextComponent.of((String)"Make a hollow sphere")).build();
    private final CommandArgument sizePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"size"), (Component)TextComponent.of((String)"The size of the forest, in blocks")).defaultsTo((Iterable)ImmutableList.of((Object)"10")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument typePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"type"), (Component)TextComponent.of((String)"The type of forest")).defaultsTo((Iterable)ImmutableList.of((Object)"tree")).ofTypes((Collection)ImmutableList.of(treeType_Key)).build();
    private final CommandArgument densityPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"density"), (Component)TextComponent.of((String)"The density of the forest, between 0 and 100")).defaultsTo((Iterable)ImmutableList.of((Object)"5")).ofTypes((Collection)ImmutableList.of(double_Key)).build();
    private final CommandArgument sizePart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"size"), (Component)TextComponent.of((String)"The size of the patch")).defaultsTo((Iterable)ImmutableList.of((Object)"10")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument densityPart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"density"), (Component)TextComponent.of((String)"//TODO ")).defaultsTo((Iterable)ImmutableList.of((Object)"0.02")).ofTypes((Collection)ImmutableList.of(double_Key)).build();
    private final CommandArgument patternPart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"pattern"), (Component)TextComponent.of((String)"The pattern of blocks to set")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(pattern_Key)).build();
    private final CommandArgument sizePart3 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"size"), (Component)TextComponent.of((String)"The size of the pyramid")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(integer_confirmcom_sk89q_worldedit_command_util_annotation_Confirm_Processor_RADIUS_Key)).build();
    private final NoArgCommandFlag hollowPart4 = CommandParts.flag((char)'h', (Component)TextComponent.of((String)"Make a hollow pyramid")).build();
    private final CommandArgument expressionPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"expression"), (Component)TextComponent.of((String)"Expression to test block placement locations and set block type")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(string_Key)).variable(true).build();
    private final NoArgCommandFlag hollowPart5 = CommandParts.flag((char)'h', (Component)TextComponent.of((String)"Generate a hollow shape")).build();
    private final NoArgCommandFlag useRawCoordsPart = CommandParts.flag((char)'r', (Component)TextComponent.of((String)"Use the game's coordinate origin")).build();
    private final NoArgCommandFlag offsetPart = CommandParts.flag((char)'o', (Component)TextComponent.of((String)"Use the placement's coordinate origin")).build();
    private final NoArgCommandFlag offsetCenterPart = CommandParts.flag((char)'c', (Component)TextComponent.of((String)"Use the selection's center as origin")).build();
    private final CommandArgument targetPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"target"), (Component)TextComponent.of((String)"The biome type to set")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(biomeType_Key)).build();
    private final CommandArgument expressionPart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"expression"), (Component)TextComponent.of((String)"Expression to test block placement locations and set biome type. Requires x,y,z variables be present")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(string_Key)).variable(true).build();
    private final CommandArgument sizeOptPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"size"), (Component)TextComponent.of((String)"TODO")).defaultsTo((Iterable)ImmutableList.of((Object)"8")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument frequencyOptPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"frequency"), (Component)TextComponent.of((String)"TODO")).defaultsTo((Iterable)ImmutableList.of((Object)"40")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument rarityOptPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"rarity"), (Component)TextComponent.of((String)"TODO")).defaultsTo((Iterable)ImmutableList.of((Object)"7")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument minYOptPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"minY"), (Component)TextComponent.of((String)"TODO")).defaultsTo((Iterable)ImmutableList.of((Object)"8")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument maxYOptPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"maxY"), (Component)TextComponent.of((String)"TODO")).defaultsTo((Iterable)ImmutableList.of((Object)"127")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument systemFrequencyOptPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"systemFrequency"), (Component)TextComponent.of((String)"TODO")).defaultsTo((Iterable)ImmutableList.of((Object)"1")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument individualRarityOptPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"individualRarity"), (Component)TextComponent.of((String)"TODO")).defaultsTo((Iterable)ImmutableList.of((Object)"25")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument pocketChanceOptPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"pocketChance"), (Component)TextComponent.of((String)"TODO")).defaultsTo((Iterable)ImmutableList.of((Object)"0")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument pocketMinOptPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"pocketMin"), (Component)TextComponent.of((String)"TODO")).defaultsTo((Iterable)ImmutableList.of((Object)"0")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument pocketMaxOptPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"pocketMax"), (Component)TextComponent.of((String)"TODO")).defaultsTo((Iterable)ImmutableList.of((Object)"3")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument maskPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"mask"), (Component)TextComponent.of((String)"Mask")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(mask_Key)).build();
    private final CommandArgument imageURLPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"imageURL"), (Component)TextComponent.of((String)"Image URL (imgur only)")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(string_Key)).build();
    private final CommandArgument randomizePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"randomize"), (Component)TextComponent.of((String)"boolean")).defaultsTo((Iterable)ImmutableList.of((Object)"true")).ofTypes((Collection)ImmutableList.of(boolean_Key)).build();
    private final CommandArgument thresholdPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"threshold"), (Component)TextComponent.of((String)"TODO")).defaultsTo((Iterable)ImmutableList.of((Object)"100")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument dimensionsPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"dimensions"), (Component)TextComponent.of((String)"BlockVector2")).defaultsTo((Iterable)ImmutableList.of((Object)"")).ofTypes((Collection)ImmutableList.of(blockVector2_Key)).build();
    private final CommandArgument materialPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"material"), (Component)TextComponent.of((String)"Pattern")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(pattern_Key)).build();
    private final CommandArgument sizePart4 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"size"), (Component)TextComponent.of((String)"Ore vein size")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument freqPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"freq"), (Component)TextComponent.of((String)"Ore vein frequency (number of times to attempt to place ore)")).defaultsTo((Iterable)ImmutableList.of((Object)"10")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument rarityPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"rarity"), (Component)TextComponent.of((String)"Ore vein rarity (% chance each attempt is placed)")).defaultsTo((Iterable)ImmutableList.of((Object)"100")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument minYPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"minY"), (Component)TextComponent.of((String)"Ore vein min y")).defaultsTo((Iterable)ImmutableList.of((Object)"0")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument maxYPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"maxY"), (Component)TextComponent.of((String)"Ore vein max y")).defaultsTo((Iterable)ImmutableList.of((Object)"63")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument patternPart3 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"pattern"), (Component)TextComponent.of((String)"Pattern")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(pattern_Key)).build();
    private final CommandArgument sizePart5 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"size"), (Component)TextComponent.of((String)"size")).defaultsTo((Iterable)ImmutableList.of((Object)"5")).ofTypes((Collection)ImmutableList.of(double_Key)).build();
    private final CommandArgument radiusPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"radius")).defaultsTo((Iterable)ImmutableList.of((Object)"5")).ofTypes((Collection)ImmutableList.of(vector3_Key)).build();
    private final CommandArgument sphericityPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"roundness"), (Component)TextComponent.of((String)"roundness")).defaultsTo((Iterable)ImmutableList.of((Object)"100")).ofTypes((Collection)ImmutableList.of(double_Key)).build();
    private final CommandArgument frequencyPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"frequency"), (Component)TextComponent.of((String)"double")).defaultsTo((Iterable)ImmutableList.of((Object)"30")).ofTypes((Collection)ImmutableList.of(double_Key)).build();
    private final CommandArgument amplitudePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"amplitude"), (Component)TextComponent.of((String)"double")).defaultsTo((Iterable)ImmutableList.of((Object)"50")).ofTypes((Collection)ImmutableList.of(double_Key)).build();

    private GenerationCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static GenerationCommandsRegistration builder() {
        return new GenerationCommandsRegistration();
    }

    public GenerationCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public GenerationCommandsRegistration containerInstance(GenerationCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    @Override
    public GenerationCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public GenerationCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    public void build() {
        this.commandManager.register("/hcyl", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Generates a hollow cylinder."));
            b.parts((Collection)ImmutableList.of((Object)this.patternPart, (Object)this.radiiPart, (Object)this.heightPart, (Object)this.thicknessPart));
            b.action(this::cmd$_hcyl);
            Method commandMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"hcyl", (Class[])new Class[]{Actor.class, LocalSession.class, EditSession.class, Pattern.class, List.class, Integer.TYPE, Double.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/cyl", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Generates a cylinder."));
            b.parts((Collection)ImmutableList.of((Object)this.patternPart, (Object)this.radiiPart, (Object)this.heightPart, (Object)this.hollowPart));
            b.action(this::cmd$_cyl);
            Method commandMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"cyl", (Class[])new Class[]{Actor.class, LocalSession.class, EditSession.class, Pattern.class, List.class, Integer.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/cone", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Generates a cone."));
            b.parts((Collection)ImmutableList.of((Object)this.patternPart, (Object)this.radiiPart2, (Object)this.heightPart2, (Object)this.hollowPart2, (Object)this.thicknessPart2));
            b.action(this::cmd$_cone);
            Method commandMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"cone", (Class[])new Class[]{Actor.class, LocalSession.class, EditSession.class, Pattern.class, List.class, Integer.TYPE, Boolean.TYPE, Double.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/hsphere", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Generates a hollow sphere."));
            b.parts((Collection)ImmutableList.of((Object)this.patternPart, (Object)this.radiiPart3, (Object)this.raisedPart));
            b.action(this::cmd$_hsphere);
            Method commandMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"hsphere", (Class[])new Class[]{Actor.class, LocalSession.class, EditSession.class, Pattern.class, List.class, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/sphere", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Generates a filled sphere."));
            b.parts((Collection)ImmutableList.of((Object)this.patternPart, (Object)this.radiiPart3, (Object)this.raisedPart, (Object)this.hollowPart3));
            b.action(this::cmd$_sphere);
            Method commandMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"sphere", (Class[])new Class[]{Actor.class, LocalSession.class, EditSession.class, Pattern.class, List.class, Boolean.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("forestgen", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"/forestgen"));
            b.description((Component)TextComponent.of((String)"Generate a forest"));
            b.parts((Collection)ImmutableList.of((Object)this.sizePart, (Object)this.typePart, (Object)this.densityPart));
            b.action(this::cmd$forestgen);
            Method commandMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"forestGen", (Class[])new Class[]{Actor.class, LocalSession.class, EditSession.class, Integer.TYPE, TreeGenerator.TreeType.class, Double.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("pumpkins", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"/pumpkins"));
            b.description((Component)TextComponent.of((String)"Generate pumpkin patches"));
            b.parts((Collection)ImmutableList.of((Object)this.sizePart2, (Object)this.densityPart2));
            b.action(this::cmd$pumpkins);
            Method commandMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"pumpkins", (Class[])new Class[]{Actor.class, LocalSession.class, EditSession.class, Integer.TYPE, Double.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/hpyramid", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Generate a hollow pyramid"));
            b.parts((Collection)ImmutableList.of((Object)this.patternPart2, (Object)this.sizePart3));
            b.action(this::cmd$_hpyramid);
            Method commandMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"hollowPyramid", (Class[])new Class[]{Actor.class, LocalSession.class, EditSession.class, Pattern.class, Integer.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/pyramid", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Generate a filled pyramid"));
            b.parts((Collection)ImmutableList.of((Object)this.patternPart2, (Object)this.sizePart3, (Object)this.hollowPart4));
            b.action(this::cmd$_pyramid);
            Method commandMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"pyramid", (Class[])new Class[]{Actor.class, LocalSession.class, EditSession.class, Pattern.class, Integer.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/generate", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"/gen", (Object)"/g"));
            b.description((Component)TextComponent.of((String)"Generates a shape according to a formula."));
            b.footer((Component)TextComponent.of((String)"For details, see https://ehub.to/we/expr"));
            b.parts((Collection)ImmutableList.of((Object)this.patternPart2, (Object)this.expressionPart, (Object)this.hollowPart5, (Object)this.useRawCoordsPart, (Object)this.offsetPart, (Object)this.offsetCenterPart));
            b.action(this::cmd$_generate);
            Method commandMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"generate", (Class[])new Class[]{Actor.class, LocalSession.class, EditSession.class, Region.class, Pattern.class, List.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/generatebiome", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"/genbiome", (Object)"/gb"));
            b.description((Component)TextComponent.of((String)"Sets biome according to a formula."));
            b.footer((Component)TextComponent.of((String)"Formula must return positive numbers (true) if the point is inside the shape\nSets the biome of blocks in that shape.\nFor details, see https://ehub.to/we/expr"));
            b.parts((Collection)ImmutableList.of((Object)this.targetPart, (Object)this.expressionPart2, (Object)this.hollowPart5, (Object)this.useRawCoordsPart, (Object)this.offsetPart, (Object)this.offsetCenterPart));
            b.action(this::cmd$_generatebiome);
            Method commandMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"generateBiome", (Class[])new Class[]{Actor.class, LocalSession.class, EditSession.class, Region.class, BiomeType.class, List.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/caves", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Generates a cave network"));
            b.parts((Collection)ImmutableList.of((Object)this.sizeOptPart, (Object)this.frequencyOptPart, (Object)this.rarityOptPart, (Object)this.minYOptPart, (Object)this.maxYOptPart, (Object)this.systemFrequencyOptPart, (Object)this.individualRarityOptPart, (Object)this.pocketChanceOptPart, (Object)this.pocketMinOptPart, (Object)this.pocketMaxOptPart));
            b.action(this::cmd$_caves);
            Method commandMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"caves", (Class[])new Class[]{Actor.class, LocalSession.class, EditSession.class, Region.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/ores", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Generates ores"));
            b.parts((Collection)ImmutableList.of((Object)this.maskPart));
            b.action(this::cmd$_ores);
            Method commandMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"ores", (Class[])new Class[]{Actor.class, LocalSession.class, EditSession.class, Region.class, Mask.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/img", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"/image", (Object)"image"));
            b.description((Component)TextComponent.of((String)"Generate an image"));
            b.parts((Collection)ImmutableList.of((Object)this.imageURLPart, (Object)this.randomizePart, (Object)this.thresholdPart, (Object)this.dimensionsPart));
            b.action(this::cmd$_img);
            Method commandMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"image", (Class[])new Class[]{Actor.class, LocalSession.class, EditSession.class, String.class, Boolean.TYPE, Integer.TYPE, BlockVector2.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/ore", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Generates ores"));
            b.parts((Collection)ImmutableList.of((Object)this.maskPart, (Object)this.materialPart, (Object)this.sizePart4, (Object)this.freqPart, (Object)this.rarityPart, (Object)this.minYPart, (Object)this.maxYPart));
            b.action(this::cmd$_ore);
            Method commandMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"ore", (Class[])new Class[]{Actor.class, LocalSession.class, EditSession.class, Region.class, Mask.class, Pattern.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/blob", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"/rock"));
            b.description((Component)TextComponent.of((String)"Creates a distorted sphere"));
            b.parts((Collection)ImmutableList.of((Object)this.patternPart3, (Object)this.sizePart5, (Object)this.radiusPart, (Object)this.sphericityPart, (Object)this.frequencyPart, (Object)this.amplitudePart));
            b.action(this::cmd$_blob);
            Method commandMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"blobBrush", (Class[])new Class[]{Actor.class, LocalSession.class, EditSession.class, Pattern.class, Double.TYPE, Vector3.class, Double.TYPE, Double.TYPE, Double.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
    }

    private int cmd$_hcyl(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"hcyl", (Class[])new Class[]{Actor.class, LocalSession.class, EditSession.class, Pattern.class, List.class, Integer.TYPE, Double.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.hcyl(this.extract$actor(parameters), this.extract$session(parameters), this.extract$editSession(parameters), this.extract$pattern(parameters), this.extract$radii(parameters), this.extract$height(parameters), this.extract$thickness(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_cyl(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"cyl", (Class[])new Class[]{Actor.class, LocalSession.class, EditSession.class, Pattern.class, List.class, Integer.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.cyl(this.extract$actor(parameters), this.extract$session(parameters), this.extract$editSession(parameters), this.extract$pattern(parameters), this.extract$radii(parameters), this.extract$height(parameters), this.extract$hollow(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_cone(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"cone", (Class[])new Class[]{Actor.class, LocalSession.class, EditSession.class, Pattern.class, List.class, Integer.TYPE, Boolean.TYPE, Double.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.cone(this.extract$actor(parameters), this.extract$session(parameters), this.extract$editSession(parameters), this.extract$pattern(parameters), this.extract$radii2(parameters), this.extract$height2(parameters), this.extract$hollow2(parameters), this.extract$thickness2(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_hsphere(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"hsphere", (Class[])new Class[]{Actor.class, LocalSession.class, EditSession.class, Pattern.class, List.class, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.hsphere(this.extract$actor(parameters), this.extract$session(parameters), this.extract$editSession(parameters), this.extract$pattern(parameters), this.extract$radii3(parameters), this.extract$raised(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_sphere(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"sphere", (Class[])new Class[]{Actor.class, LocalSession.class, EditSession.class, Pattern.class, List.class, Boolean.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.sphere(this.extract$actor(parameters), this.extract$session(parameters), this.extract$editSession(parameters), this.extract$pattern(parameters), this.extract$radii3(parameters), this.extract$raised(parameters), this.extract$hollow3(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$forestgen(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"forestGen", (Class[])new Class[]{Actor.class, LocalSession.class, EditSession.class, Integer.TYPE, TreeGenerator.TreeType.class, Double.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.forestGen(this.extract$actor(parameters), this.extract$session(parameters), this.extract$editSession(parameters), this.extract$size(parameters), this.extract$type(parameters), this.extract$density(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$pumpkins(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"pumpkins", (Class[])new Class[]{Actor.class, LocalSession.class, EditSession.class, Integer.TYPE, Double.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.pumpkins(this.extract$actor(parameters), this.extract$session(parameters), this.extract$editSession(parameters), this.extract$size2(parameters), this.extract$density2(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_hpyramid(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"hollowPyramid", (Class[])new Class[]{Actor.class, LocalSession.class, EditSession.class, Pattern.class, Integer.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.hollowPyramid(this.extract$actor(parameters), this.extract$session(parameters), this.extract$editSession(parameters), this.extract$pattern2(parameters), this.extract$size3(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_pyramid(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"pyramid", (Class[])new Class[]{Actor.class, LocalSession.class, EditSession.class, Pattern.class, Integer.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.pyramid(this.extract$actor(parameters), this.extract$session(parameters), this.extract$editSession(parameters), this.extract$pattern2(parameters), this.extract$size3(parameters), this.extract$hollow4(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_generate(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"generate", (Class[])new Class[]{Actor.class, LocalSession.class, EditSession.class, Region.class, Pattern.class, List.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.generate(this.extract$actor(parameters), this.extract$session(parameters), this.extract$editSession(parameters), this.extract$region(parameters), this.extract$pattern2(parameters), this.extract$expression(parameters), this.extract$hollow5(parameters), this.extract$useRawCoords(parameters), this.extract$offset(parameters), this.extract$offsetCenter(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_generatebiome(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"generateBiome", (Class[])new Class[]{Actor.class, LocalSession.class, EditSession.class, Region.class, BiomeType.class, List.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.generateBiome(this.extract$actor(parameters), this.extract$session(parameters), this.extract$editSession(parameters), this.extract$region(parameters), this.extract$target(parameters), this.extract$expression2(parameters), this.extract$hollow5(parameters), this.extract$useRawCoords(parameters), this.extract$offset(parameters), this.extract$offsetCenter(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_caves(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"caves", (Class[])new Class[]{Actor.class, LocalSession.class, EditSession.class, Region.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.caves(this.extract$actor(parameters), this.extract$session(parameters), this.extract$editSession(parameters), this.extract$region(parameters), this.extract$sizeOpt(parameters), this.extract$frequencyOpt(parameters), this.extract$rarityOpt(parameters), this.extract$minYOpt(parameters), this.extract$maxYOpt(parameters), this.extract$systemFrequencyOpt(parameters), this.extract$individualRarityOpt(parameters), this.extract$pocketChanceOpt(parameters), this.extract$pocketMinOpt(parameters), this.extract$pocketMaxOpt(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_ores(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"ores", (Class[])new Class[]{Actor.class, LocalSession.class, EditSession.class, Region.class, Mask.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.ores(this.extract$actor(parameters), this.extract$session(parameters), this.extract$editSession(parameters), this.extract$region(parameters), this.extract$mask(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_img(CommandParameters parameters) throws WorldEditException, IOException, URISyntaxException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"image", (Class[])new Class[]{Actor.class, LocalSession.class, EditSession.class, String.class, Boolean.TYPE, Integer.TYPE, BlockVector2.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.image(this.extract$actor(parameters), this.extract$session(parameters), this.extract$editSession(parameters), this.extract$imageURL(parameters), this.extract$randomize(parameters), this.extract$threshold(parameters), this.extract$dimensions(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_ore(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"ore", (Class[])new Class[]{Actor.class, LocalSession.class, EditSession.class, Region.class, Mask.class, Pattern.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.ore(this.extract$actor(parameters), this.extract$session(parameters), this.extract$editSession(parameters), this.extract$region(parameters), this.extract$mask(parameters), this.extract$material(parameters), this.extract$size4(parameters), this.extract$freq(parameters), this.extract$rarity(parameters), this.extract$minY(parameters), this.extract$maxY(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_blob(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(GenerationCommands.class, (String)"blobBrush", (Class[])new Class[]{Actor.class, LocalSession.class, EditSession.class, Pattern.class, Double.TYPE, Vector3.class, Double.TYPE, Double.TYPE, Double.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.blobBrush(this.extract$actor(parameters), this.extract$session(parameters), this.extract$editSession(parameters), this.extract$pattern3(parameters), this.extract$size5(parameters), this.extract$radius(parameters), this.extract$sphericity(parameters), this.extract$frequency(parameters), this.extract$amplitude(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private Actor extract$actor(CommandParameters parameters) {
        return (Actor)RegistrationUtil.requireOptional(actor_Key, (String)"actor", (Optional)parameters.injectedValue(actor_Key));
    }

    private LocalSession extract$session(CommandParameters parameters) {
        return (LocalSession)RegistrationUtil.requireOptional(localSession_Key, (String)"session", (Optional)parameters.injectedValue(localSession_Key));
    }

    private EditSession extract$editSession(CommandParameters parameters) {
        return (EditSession)RegistrationUtil.requireOptional(editSession_Key, (String)"editSession", (Optional)parameters.injectedValue(editSession_Key));
    }

    private Pattern extract$pattern(CommandParameters parameters) {
        return (Pattern)this.patternPart.value(parameters).asSingle(pattern_Key);
    }

    private List<Double> extract$radii(CommandParameters parameters) {
        return this.radiiPart.value(parameters).asMultiple(double_radii2_Key);
    }

    private int extract$height(CommandParameters parameters) {
        return (Integer)this.heightPart.value(parameters).asSingle(integer_Key);
    }

    private double extract$thickness(CommandParameters parameters) {
        return (Double)this.thicknessPart.value(parameters).asSingle(double_Key);
    }

    private boolean extract$hollow(CommandParameters parameters) {
        return this.hollowPart.in(parameters);
    }

    private List<Double> extract$radii2(CommandParameters parameters) {
        return this.radiiPart2.value(parameters).asMultiple(double_radii2_Key);
    }

    private int extract$height2(CommandParameters parameters) {
        return (Integer)this.heightPart2.value(parameters).asSingle(integer_Key);
    }

    private boolean extract$hollow2(CommandParameters parameters) {
        return this.hollowPart2.in(parameters);
    }

    private double extract$thickness2(CommandParameters parameters) {
        return (Double)this.thicknessPart2.value(parameters).asSingle(double_Key);
    }

    private List<Double> extract$radii3(CommandParameters parameters) {
        return this.radiiPart3.value(parameters).asMultiple(double_radii3_Key);
    }

    private boolean extract$raised(CommandParameters parameters) {
        return this.raisedPart.in(parameters);
    }

    private boolean extract$hollow3(CommandParameters parameters) {
        return this.hollowPart3.in(parameters);
    }

    private int extract$size(CommandParameters parameters) {
        return (Integer)this.sizePart.value(parameters).asSingle(integer_Key);
    }

    private TreeGenerator.TreeType extract$type(CommandParameters parameters) {
        return (TreeGenerator.TreeType)((Object)this.typePart.value(parameters).asSingle(treeType_Key));
    }

    private double extract$density(CommandParameters parameters) {
        return (Double)this.densityPart.value(parameters).asSingle(double_Key);
    }

    private int extract$size2(CommandParameters parameters) {
        return (Integer)this.sizePart2.value(parameters).asSingle(integer_Key);
    }

    private double extract$density2(CommandParameters parameters) {
        return (Double)this.densityPart2.value(parameters).asSingle(double_Key);
    }

    private Pattern extract$pattern2(CommandParameters parameters) {
        return (Pattern)this.patternPart2.value(parameters).asSingle(pattern_Key);
    }

    private int extract$size3(CommandParameters parameters) {
        return (Integer)this.sizePart3.value(parameters).asSingle(integer_confirmcom_sk89q_worldedit_command_util_annotation_Confirm_Processor_RADIUS_Key);
    }

    private boolean extract$hollow4(CommandParameters parameters) {
        return this.hollowPart4.in(parameters);
    }

    private Region extract$region(CommandParameters parameters) {
        return (Region)RegistrationUtil.requireOptional(region_selection_Key, (String)"region", (Optional)parameters.injectedValue(region_selection_Key));
    }

    private List<String> extract$expression(CommandParameters parameters) {
        return this.expressionPart.value(parameters).asMultiple(string_Key);
    }

    private boolean extract$hollow5(CommandParameters parameters) {
        return this.hollowPart5.in(parameters);
    }

    private boolean extract$useRawCoords(CommandParameters parameters) {
        return this.useRawCoordsPart.in(parameters);
    }

    private boolean extract$offset(CommandParameters parameters) {
        return this.offsetPart.in(parameters);
    }

    private boolean extract$offsetCenter(CommandParameters parameters) {
        return this.offsetCenterPart.in(parameters);
    }

    private BiomeType extract$target(CommandParameters parameters) {
        return (BiomeType)this.targetPart.value(parameters).asSingle(biomeType_Key);
    }

    private List<String> extract$expression2(CommandParameters parameters) {
        return this.expressionPart2.value(parameters).asMultiple(string_Key);
    }

    private int extract$sizeOpt(CommandParameters parameters) {
        return (Integer)this.sizeOptPart.value(parameters).asSingle(integer_Key);
    }

    private int extract$frequencyOpt(CommandParameters parameters) {
        return (Integer)this.frequencyOptPart.value(parameters).asSingle(integer_Key);
    }

    private int extract$rarityOpt(CommandParameters parameters) {
        return (Integer)this.rarityOptPart.value(parameters).asSingle(integer_Key);
    }

    private int extract$minYOpt(CommandParameters parameters) {
        return (Integer)this.minYOptPart.value(parameters).asSingle(integer_Key);
    }

    private int extract$maxYOpt(CommandParameters parameters) {
        return (Integer)this.maxYOptPart.value(parameters).asSingle(integer_Key);
    }

    private int extract$systemFrequencyOpt(CommandParameters parameters) {
        return (Integer)this.systemFrequencyOptPart.value(parameters).asSingle(integer_Key);
    }

    private int extract$individualRarityOpt(CommandParameters parameters) {
        return (Integer)this.individualRarityOptPart.value(parameters).asSingle(integer_Key);
    }

    private int extract$pocketChanceOpt(CommandParameters parameters) {
        return (Integer)this.pocketChanceOptPart.value(parameters).asSingle(integer_Key);
    }

    private int extract$pocketMinOpt(CommandParameters parameters) {
        return (Integer)this.pocketMinOptPart.value(parameters).asSingle(integer_Key);
    }

    private int extract$pocketMaxOpt(CommandParameters parameters) {
        return (Integer)this.pocketMaxOptPart.value(parameters).asSingle(integer_Key);
    }

    private Mask extract$mask(CommandParameters parameters) {
        return (Mask)this.maskPart.value(parameters).asSingle(mask_Key);
    }

    private String extract$imageURL(CommandParameters parameters) {
        return (String)this.imageURLPart.value(parameters).asSingle(string_Key);
    }

    private boolean extract$randomize(CommandParameters parameters) {
        return (Boolean)this.randomizePart.value(parameters).asSingle(boolean_Key);
    }

    private int extract$threshold(CommandParameters parameters) {
        return (Integer)this.thresholdPart.value(parameters).asSingle(integer_Key);
    }

    private BlockVector2 extract$dimensions(CommandParameters parameters) {
        return (BlockVector2)this.dimensionsPart.value(parameters).asSingle(blockVector2_Key);
    }

    private Pattern extract$material(CommandParameters parameters) {
        return (Pattern)this.materialPart.value(parameters).asSingle(pattern_Key);
    }

    private int extract$size4(CommandParameters parameters) {
        return (Integer)this.sizePart4.value(parameters).asSingle(integer_Key);
    }

    private int extract$freq(CommandParameters parameters) {
        return (Integer)this.freqPart.value(parameters).asSingle(integer_Key);
    }

    private int extract$rarity(CommandParameters parameters) {
        return (Integer)this.rarityPart.value(parameters).asSingle(integer_Key);
    }

    private int extract$minY(CommandParameters parameters) {
        return (Integer)this.minYPart.value(parameters).asSingle(integer_Key);
    }

    private int extract$maxY(CommandParameters parameters) {
        return (Integer)this.maxYPart.value(parameters).asSingle(integer_Key);
    }

    private Pattern extract$pattern3(CommandParameters parameters) {
        return (Pattern)this.patternPart3.value(parameters).asSingle(pattern_Key);
    }

    private double extract$size5(CommandParameters parameters) {
        return (Double)this.sizePart5.value(parameters).asSingle(double_Key);
    }

    private Vector3 extract$radius(CommandParameters parameters) {
        return (Vector3)this.radiusPart.value(parameters).asSingle(vector3_Key);
    }

    private double extract$sphericity(CommandParameters parameters) {
        return (Double)this.sphericityPart.value(parameters).asSingle(double_Key);
    }

    private double extract$frequency(CommandParameters parameters) {
        return (Double)this.frequencyPart.value(parameters).asSingle(double_Key);
    }

    private double extract$amplitude(CommandParameters parameters) {
        return (Double)this.amplitudePart.value(parameters).asSingle(double_Key);
    }
}

