/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command.tool;

import com.fastasyncworldedit.core.command.tool.MovableTool;
import com.fastasyncworldedit.core.command.tool.ResettableTool;
import com.fastasyncworldedit.core.command.tool.TargetMode;
import com.fastasyncworldedit.core.command.tool.brush.BrushSettings;
import com.fastasyncworldedit.core.command.tool.scroll.Scroll;
import com.fastasyncworldedit.core.command.tool.scroll.ScrollTool;
import com.fastasyncworldedit.core.configuration.Caption;
import com.fastasyncworldedit.core.extent.ResettableExtent;
import com.fastasyncworldedit.core.function.mask.MaskedTargetBlock;
import com.fastasyncworldedit.core.function.pattern.PatternTraverser;
import com.fastasyncworldedit.core.util.BrushCache;
import com.fastasyncworldedit.core.util.MaskTraverser;
import com.fastasyncworldedit.core.util.StringMan;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.blocks.BaseItem;
import com.sk89q.worldedit.command.tool.DoubleActionTraceTool;
import com.sk89q.worldedit.command.tool.TraceTool;
import com.sk89q.worldedit.command.tool.brush.Brush;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.MaskIntersection;
import com.sk89q.worldedit.function.mask.SolidBlockMask;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.internal.expression.Expression;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.session.request.Request;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.world.block.BlockType;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.annotation.Nullable;

public class BrushTool
implements DoubleActionTraceTool,
ScrollTool,
MovableTool,
ResettableTool,
Serializable,
TraceTool {
    protected static int MAX_RANGE = 500;
    protected int range = -1;
    private Mask traceMask = null;
    protected static int DEFAULT_RANGE = 240;
    private TargetMode targetMode = TargetMode.TARGET_BLOCK_RANGE;
    private int targetOffset;
    private transient BrushSettings primary = new BrushSettings();
    private transient BrushSettings secondary = new BrushSettings();
    private transient BrushSettings context = this.primary;
    private transient BaseItem holder;

    public BrushTool(String permission) {
        Preconditions.checkNotNull((Object)permission);
        this.getContext().addPermission(permission);
    }

    public BrushTool() {
    }

    public void setHolder(BaseItem holder) {
        this.holder = holder;
    }

    public boolean isSet() {
        return this.primary.getBrush() != null || this.secondary.getBrush() != null;
    }

    public void update() {
        if (this.holder != null) {
            BrushCache.setTool(this.holder, this);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeBoolean(this.primary == this.secondary);
        stream.writeObject(this.primary);
        if (this.primary != this.secondary) {
            stream.writeObject(this.secondary);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        boolean multi = stream.readBoolean();
        this.primary = (BrushSettings)stream.readObject();
        this.secondary = multi ? (BrushSettings)stream.readObject() : this.primary;
        this.context = this.primary;
    }

    public BrushSettings getContext() {
        BrushSettings tmp = this.context;
        if (tmp == null) {
            this.context = tmp = this.primary;
        }
        return tmp;
    }

    public void setContext(BrushSettings context) {
        this.context = context;
    }

    @Override
    public boolean canUse(Actor player) {
        if (this.primary == this.secondary) {
            return this.primary.canUse(player);
        }
        return this.primary.canUse(player) && this.secondary.canUse(player);
    }

    public ResettableExtent getTransform() {
        return this.getContext().getTransform();
    }

    public BrushSettings getPrimary() {
        return this.primary;
    }

    public BrushSettings getSecondary() {
        return this.secondary;
    }

    public BrushSettings getOffHand() {
        return this.context == this.primary ? this.secondary : this.primary;
    }

    public void setPrimary(BrushSettings primary) {
        Preconditions.checkNotNull((Object)primary);
        this.primary = primary;
        this.context = primary;
        this.update();
    }

    public void setSecondary(BrushSettings secondary) {
        Preconditions.checkNotNull((Object)secondary);
        this.secondary = secondary;
        this.context = secondary;
        this.update();
    }

    public void setTransform(ResettableExtent transform) {
        this.getContext().setTransform(transform);
        this.update();
    }

    public Mask getSourceMask() {
        return this.getContext().getSourceMask();
    }

    @Override
    public boolean reset() {
        Brush br = this.getBrush();
        if (br instanceof ResettableTool) {
            return ((ResettableTool)((Object)br)).reset();
        }
        return false;
    }

    public void setMask(Mask filter) {
        this.getContext().setMask(filter);
        this.update();
    }

    public Mask getMask() {
        return this.getContext().getMask();
    }

    @Nullable
    public Mask getTraceMask() {
        return this.traceMask;
    }

    public void setTraceMask(@Nullable Mask traceMask) {
        this.traceMask = traceMask;
        this.update();
    }

    public void setSourceMask(Mask filter) {
        this.getContext().setSourceMask(filter);
        this.update();
    }

    public void setBrush(Brush brush, String permission) {
        BrushSettings current = this.getContext();
        current.clearPerms();
        current.setBrush(brush);
        current.addPermission(permission);
        this.update();
    }

    public Brush getBrush() {
        return this.getContext().getBrush();
    }

    public void setFill(@Nullable Pattern material) {
        this.getContext().setFill(material);
    }

    @Nullable
    public Pattern getMaterial() {
        return this.getContext().getMaterial();
    }

    public double getSize() {
        return this.getContext().getSize();
    }

    public void setSize(double radius) {
        this.getContext().setSize(radius);
    }

    public void setSize(Expression radius) {
        this.getContext().setSize(radius);
    }

    public int getRange() {
        return this.range < 0 ? DEFAULT_RANGE : Math.min(this.range, MAX_RANGE);
    }

    public void setRange(int range) {
        this.range = range;
    }

    @Override
    public boolean actPrimary(Platform server, LocalConfiguration config, Player player, LocalSession session) {
        return this.act(BrushAction.PRIMARY, player, session);
    }

    public BlockVector3 getPosition(EditSession editSession, Player player) {
        Location loc = player.getLocation();
        switch (this.targetMode) {
            case TARGET_BLOCK_RANGE: {
                return this.offset(this.trace(editSession, player, this.getRange(), true), loc).toBlockPoint();
            }
            case FORWARD_POINT_PITCH: {
                int d = 0;
                float pitch = loc.getPitch();
                pitch = 23.0f - pitch / 4.0f;
                Vector3 vector = loc.getDirection().withY(0.0).normalize().multiply(d += (int)(Math.sin(Math.toRadians(pitch)) * 50.0)).add(loc.getX(), loc.getY(), loc.getZ());
                return this.offset(vector, loc).toBlockPoint();
            }
            case TARGET_POINT_HEIGHT: {
                BlockType block;
                int y;
                int height = loc.getBlockY();
                int x = loc.getBlockX();
                int z = loc.getBlockZ();
                for (y = height; y > editSession.getMinY() && !(block = editSession.getBlockType(x, y, z)).getMaterial().isMovementBlocker(); --y) {
                }
                int distance = height - y + 8;
                return this.offset(this.trace(editSession, player, distance, true), loc).toBlockPoint();
            }
            case TARGET_FACE_RANGE: {
                return this.offset(this.trace(editSession, player, this.getRange(), true), loc).toBlockPoint();
            }
        }
        return null;
    }

    private Vector3 offset(Vector3 target, Vector3 playerPos) {
        if (this.targetOffset == 0) {
            return target;
        }
        return target.subtract(target.subtract(playerPos).normalize().multiply(this.targetOffset));
    }

    private Vector3 trace(EditSession editSession, Player player, int range, boolean useLastBlock) {
        Mask mask = this.traceMask == null ? new SolidBlockMask(editSession) : this.traceMask;
        new MaskTraverser(mask).reset(editSession);
        MaskedTargetBlock tb = new MaskedTargetBlock(mask, player, range, 0.2);
        return tb.getMaskedTargetBlock(useLastBlock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean act(BrushAction action, Player player, LocalSession session) {
        switch (action) {
            case PRIMARY: {
                this.setContext(this.primary);
                break;
            }
            case SECONDARY: {
                this.setContext(this.secondary);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + action);
            }
        }
        BrushSettings current = this.getContext();
        Brush brush = current.getBrush();
        if (brush == null) {
            return false;
        }
        if (!current.canUse(player)) {
            player.print((Component)Caption.of("fawe.error.no-perm", StringMan.join(current.getPermissions(), ",")));
            return false;
        }
        try (EditSession editSession = session.createEditSession(player, current.toString());){
            ResettableExtent transform;
            Mask sourceMask;
            Location target = player.getBlockTrace(this.getRange(), true, this.traceMask);
            if (target == null) {
                editSession.cancel();
                player.print((Component)Caption.of("worldedit.tool.no-block", new Object[0]));
                boolean bl = true;
                return bl;
            }
            BlockBag bag = session.getBlockBag(player);
            Request.request().setEditSession(editSession);
            Mask mask = current.getMask();
            if (mask != null) {
                Mask existingMask = editSession.getMask();
                if (existingMask == null) {
                    editSession.setMask(mask);
                } else if (existingMask instanceof MaskIntersection) {
                    ((MaskIntersection)existingMask).add(mask);
                } else {
                    MaskIntersection newMask = new MaskIntersection(existingMask);
                    newMask.add(mask);
                    editSession.setMask(newMask);
                }
            }
            if ((sourceMask = current.getSourceMask()) != null) {
                editSession.addSourceMask(sourceMask);
            }
            if ((transform = current.getTransform()) != null) {
                editSession.addTransform(transform);
            }
            try {
                new PatternTraverser(current).reset(editSession);
                double size = current.getSize();
                WorldEdit.getInstance().checkMaxBrushRadius(size);
                brush.build(editSession, target.toBlockPoint(), current.getMaterial(), size);
            }
            catch (MaxChangedBlocksException e) {
                player.print((Component)Caption.of("worldedit.tool.max-block-changes", new Object[0]));
            }
            finally {
                session.remember(editSession);
                if (bag != null) {
                    bag.flushChanges();
                }
            }
        }
        finally {
            Request.reset();
        }
        return true;
    }

    @Override
    public boolean actSecondary(Platform server, LocalConfiguration config, Player player, LocalSession session) {
        return this.act(BrushAction.SECONDARY, player, session);
    }

    public void setScrollAction(Scroll scrollAction) {
        this.getContext().setScrollAction(scrollAction);
        this.update();
    }

    public void setTargetOffset(int targetOffset) {
        this.targetOffset = targetOffset;
        this.update();
    }

    public void setTargetMode(TargetMode targetMode) {
        this.targetMode = targetMode != null ? targetMode : TargetMode.TARGET_BLOCK_RANGE;
        this.update();
    }

    public TargetMode getTargetMode() {
        return this.targetMode;
    }

    public int getTargetOffset() {
        return this.targetOffset;
    }

    @Override
    public boolean increment(Player player, int amount) {
        BrushSettings current = this.getContext();
        Scroll tmp = current.getScrollAction();
        if (tmp != null) {
            tmp.setTool(this);
            return tmp.increment(player, amount);
        }
        return false;
    }

    @Override
    public boolean move(Player player) {
        return false;
    }

    static enum BrushAction {
        PRIMARY,
        SECONDARY;

    }
}

