/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command.util.annotation;

import com.fastasyncworldedit.core.configuration.Settings;
import com.sk89q.worldedit.command.util.annotation.Confirm;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import java.lang.reflect.Method;
import java.util.Optional;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.exception.StopExecutionException;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.inject.InjectedValueAccess;
import org.enginehub.piston.inject.Key;

public class ConfirmHandler
implements CommandCallListener {
    public void beforeCall(Method method, CommandParameters parameters) {
        Confirm confirmAnnotation = method.getAnnotation(Confirm.class);
        if (confirmAnnotation == null) {
            return;
        }
        Optional actorOpt = parameters.injectedValue(Key.of(Actor.class));
        if (actorOpt.isEmpty()) {
            return;
        }
        Actor actor = (Actor)actorOpt.get();
        if (!Settings.settings().getLimit((Actor)actor).CONFIRM_LARGE) {
            return;
        }
        if (!confirmAnnotation.value().passes(actor, (InjectedValueAccess)parameters, 1.0)) {
            throw new StopExecutionException((Component)TextComponent.empty());
        }
    }
}

