/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent;

import com.fastasyncworldedit.core.FaweCache;
import com.fastasyncworldedit.core.configuration.Settings;
import com.fastasyncworldedit.core.extent.NullExtent;
import com.fastasyncworldedit.core.extent.clipboard.WorldCopyClipboard;
import com.fastasyncworldedit.core.extent.filter.block.ExtentFilterBlock;
import com.fastasyncworldedit.core.extent.processor.ProcessorScope;
import com.fastasyncworldedit.core.function.generator.CavesGen;
import com.fastasyncworldedit.core.function.generator.GenBase;
import com.fastasyncworldedit.core.function.generator.OreGen;
import com.fastasyncworldedit.core.function.generator.Resource;
import com.fastasyncworldedit.core.function.generator.SchemGen;
import com.fastasyncworldedit.core.history.changeset.AbstractChangeSet;
import com.fastasyncworldedit.core.internal.exception.FaweException;
import com.fastasyncworldedit.core.math.MutableBlockVector3;
import com.fastasyncworldedit.core.queue.Filter;
import com.fastasyncworldedit.core.queue.IBatchProcessor;
import com.fastasyncworldedit.core.registry.state.PropertyGroup;
import com.fastasyncworldedit.core.util.ExtentTraverser;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.InputExtent;
import com.sk89q.worldedit.extent.OutputExtent;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.function.RegionMaskingFilter;
import com.sk89q.worldedit.function.block.BlockReplace;
import com.sk89q.worldedit.function.mask.AbstractExtentMask;
import com.sk89q.worldedit.function.mask.BlockMask;
import com.sk89q.worldedit.function.mask.ExistingBlockMask;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.function.pattern.BlockPattern;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.function.visitor.RegionVisitor;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.MathUtils;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.util.Countable;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;

public interface Extent
extends InputExtent,
OutputExtent {
    public BlockVector3 getMinimumPoint();

    public BlockVector3 getMaximumPoint();

    default public List<? extends Entity> getEntities(Region region) {
        return Collections.emptyList();
    }

    default public List<? extends Entity> getEntities() {
        return Collections.emptyList();
    }

    @Nullable
    default public Entity createEntity(Location location, BaseEntity entity) {
        return null;
    }

    @Nullable
    default public Entity createEntity(Location location, BaseEntity entity, UUID uuid) {
        return null;
    }

    default public void removeEntity(int x, int y, int z, UUID uuid) {
    }

    default public boolean isQueueEnabled() {
        return false;
    }

    default public void enableQueue() {
        if (!this.isQueueEnabled()) {
            throw FaweException._enableQueue;
        }
    }

    default public void disableQueue() {
        if (this.isQueueEnabled()) {
            throw FaweException._disableQueue;
        }
    }

    default public boolean isWorld() {
        return false;
    }

    default public boolean regenerateChunk(int x, int z, @Nullable BiomeType type, @Nullable Long seed) {
        return false;
    }

    default public int getHighestTerrainBlock(int x, int z, int minY, int maxY) {
        for (int y = maxY; y >= minY; --y) {
            BlockState block = this.getBlock(x, y, z);
            if (!block.getBlockType().getMaterial().isMovementBlocker()) continue;
            return y;
        }
        return minY;
    }

    default public int getHighestTerrainBlock(int x, int z, int minY, int maxY, Mask filter) {
        maxY = Math.min(maxY, this.getMaxY());
        minY = Math.max(this.getMinY(), minY);
        MutableBlockVector3 mutable = new MutableBlockVector3();
        for (int y = maxY; y >= minY; --y) {
            if (!filter.test(mutable.setComponents(x, y, z))) continue;
            return y;
        }
        return minY;
    }

    default public int getNearestSurfaceLayer(int x, int z, int y, int minY, int maxY) {
        boolean state;
        block9: {
            int data1;
            int clearanceAbove = maxY - y;
            int clearanceBelow = y - minY;
            int clearance = Math.min(clearanceAbove, clearanceBelow);
            BlockState block = this.getBlock(x, y, z);
            state = !block.getBlockType().getMaterial().isMovementBlocker();
            int data2 = data1 = PropertyGroup.LEVEL.get(block).intValue();
            int offset = state ? 0 : 1;
            for (int d = 0; d <= clearance; ++d) {
                int y1 = y + d;
                block = this.getBlock(x, y1, z);
                if (block.getBlockType().getMaterial().isMovementBlocker() == state) {
                    return (y1 - offset << 4) - (15 - (state ? PropertyGroup.LEVEL.get(block) : data1));
                }
                data1 = PropertyGroup.LEVEL.get(block);
                int y2 = y - d;
                block = this.getBlock(x, y2, z);
                if (block.getBlockType().getMaterial().isMovementBlocker() == state) {
                    return (y2 + offset << 4) - (15 - (state ? PropertyGroup.LEVEL.get(block) : data2));
                }
                data2 = PropertyGroup.LEVEL.get(block);
            }
            if (clearanceAbove == clearanceBelow) break block9;
            if (clearanceAbove < clearanceBelow) {
                for (layer = y - clearance - 1; layer >= minY; --layer) {
                    block = this.getBlock(x, layer, z);
                    if (block.getBlockType().getMaterial().isMovementBlocker() == state) {
                        return layer + offset << 4;
                    }
                    data1 = PropertyGroup.LEVEL.get(block);
                }
            } else {
                for (layer = y + clearance + 1; layer <= maxY; ++layer) {
                    block = this.getBlock(x, layer, z);
                    if (block.getBlockType().getMaterial().isMovementBlocker() == state) {
                        return (layer - offset << 4) - (15 - (state ? PropertyGroup.LEVEL.get(block) : data2));
                    }
                    data2 = PropertyGroup.LEVEL.get(block);
                }
            }
        }
        return (state ? minY : maxY) << 4;
    }

    default public int getNearestSurfaceTerrainBlock(int x, int z, int y, int minY, int maxY, int failedMin, int failedMax, Mask mask) {
        boolean state;
        block6: {
            y = Math.max(minY, Math.min(maxY, y));
            int clearanceAbove = maxY - y;
            int clearanceBelow = y - minY;
            int clearance = Math.min(clearanceAbove, clearanceBelow);
            MutableBlockVector3 pos = MutableBlockVector3.get(x, y, z);
            state = !mask.test(pos);
            int offset = state ? 0 : 1;
            for (int d = 0; d <= clearance; ++d) {
                int y1 = y + d;
                if (mask.test(((BlockVector3)pos).mutY(y1)) != state) {
                    return y1 - offset;
                }
                int y2 = y - d;
                if (mask.test(((BlockVector3)pos).mutY(y2)) == state) continue;
                return y2 + offset;
            }
            if (clearanceAbove == clearanceBelow) break block6;
            if (clearanceAbove < clearanceBelow) {
                for (layer = y - clearance - 1; layer >= minY; --layer) {
                    if (mask.test(((BlockVector3)pos).mutY(layer)) == state) continue;
                    return layer + offset;
                }
            } else {
                for (layer = y + clearance + 1; layer <= maxY; ++layer) {
                    if (mask.test(((BlockVector3)pos).mutY(layer)) == state) continue;
                    return layer - offset;
                }
            }
        }
        return state ? failedMin : failedMax;
    }

    default public int getNearestSurfaceTerrainBlock(int x, int z, int y, int minY, int maxY, boolean ignoreAir) {
        return this.getNearestSurfaceTerrainBlock(x, z, y, minY, maxY, minY, maxY, ignoreAir);
    }

    default public int getNearestSurfaceTerrainBlock(int x, int z, int y, int minY, int maxY) {
        return this.getNearestSurfaceTerrainBlock(x, z, y, minY, maxY, minY, maxY);
    }

    default public int getNearestSurfaceTerrainBlock(int x, int z, int y, int minY, int maxY, int failedMin, int failedMax) {
        return this.getNearestSurfaceTerrainBlock(x, z, y, minY, maxY, failedMin, failedMax, true);
    }

    default public int getNearestSurfaceTerrainBlock(int x, int z, int y, int minY, int maxY, int failedMin, int failedMax, boolean ignoreAir) {
        int result;
        y = Math.max(minY, Math.min(maxY, y));
        int clearanceAbove = maxY - y;
        int clearanceBelow = y - minY;
        int clearance = Math.min(clearanceAbove, clearanceBelow);
        BlockState block = this.getBlock(x, y, z);
        boolean state = !block.getBlockType().getMaterial().isMovementBlocker();
        int offset = state ? 0 : 1;
        for (int d = 0; d <= clearance; ++d) {
            int y1 = y + d;
            block = this.getBlock(x, y1, z);
            if (block.getMaterial().isMovementBlocker() == state && block.getBlockType() != BlockTypes.__RESERVED__) {
                return y1 - offset;
            }
            int y2 = y - d;
            block = this.getBlock(x, y2, z);
            if (block.getMaterial().isMovementBlocker() != state || block.getBlockType() == BlockTypes.__RESERVED__) continue;
            return y2 + offset;
        }
        if (clearanceAbove != clearanceBelow) {
            if (clearanceAbove < clearanceBelow) {
                for (layer = y - clearance - 1; layer >= minY; --layer) {
                    block = this.getBlock(x, layer, z);
                    if (block.getMaterial().isMovementBlocker() != state || block.getBlockType() == BlockTypes.__RESERVED__) continue;
                    return layer + offset;
                }
            } else {
                for (layer = y + clearance + 1; layer <= maxY; ++layer) {
                    block = this.getBlock(x, layer, z);
                    if (block.getMaterial().isMovementBlocker() != state || block.getBlockType() == BlockTypes.__RESERVED__) continue;
                    return layer - offset;
                }
            }
        }
        int n = result = state ? failedMin : failedMax;
        if (result > minY && !ignoreAir) {
            block = this.getBlock(x, result, z);
            return block.getBlockType().getMaterial().isAir() ? -1 : result;
        }
        return result;
    }

    default public void addCaves(Region region) throws WorldEditException {
        this.generate(region, new CavesGen(8));
    }

    default public void generate(Region region, GenBase gen) throws WorldEditException {
        for (BlockVector2 chunkPos : region.getChunks()) {
            gen.generate(chunkPos, this);
        }
    }

    default public void addSchems(Region region, Mask mask, List<ClipboardHolder> clipboards, int rarity, boolean rotate) throws WorldEditException {
        this.spawnResource(region, new SchemGen(mask, this, clipboards, rotate), rarity, 1);
    }

    default public void spawnResource(Region region, Resource gen, int rarity, int frequency) throws WorldEditException {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (BlockVector2 chunkPos : region.getChunks()) {
            for (int i = 0; i < frequency; ++i) {
                if (random.nextInt(100) > rarity) continue;
                int x = (chunkPos.getBlockX() << 4) + random.nextInt(16);
                int z = (chunkPos.getBlockZ() << 4) + random.nextInt(16);
                gen.spawn(random, x, z);
            }
        }
    }

    default public boolean contains(BlockVector3 pt) {
        BlockVector3 min = this.getMinimumPoint();
        BlockVector3 max = this.getMaximumPoint();
        return pt.containedWithin(min, max);
    }

    default public boolean contains(int x, int y, int z) {
        BlockVector3 min = this.getMinimumPoint();
        BlockVector3 max = this.getMaximumPoint();
        return min.getX() <= x && max.getX() >= x && min.getY() <= y && max.getY() >= y && min.getZ() <= z && max.getZ() >= z;
    }

    default public void addOre(Region region, Mask mask, Pattern material, int size, int frequency, int rarity, int minY, int maxY) throws WorldEditException {
        this.spawnResource(region, new OreGen(this, mask, material, size, minY, maxY), rarity, frequency);
    }

    default public void addOres(Region region, Mask mask) throws WorldEditException {
        this.addOre(region, mask, BlockTypes.DIRT.getDefaultState(), 33, 10, 100, this.getMinY(), this.getMaxY());
        this.addOre(region, mask, BlockTypes.GRAVEL.getDefaultState(), 33, 8, 100, this.getMinY(), this.getMaxY());
        this.addOre(region, mask, BlockTypes.ANDESITE.getDefaultState(), 33, 10, 100, this.getMinY(), 79);
        this.addOre(region, mask, BlockTypes.DIORITE.getDefaultState(), 33, 10, 100, this.getMinY(), 79);
        this.addOre(region, mask, BlockTypes.GRANITE.getDefaultState(), 33, 10, 100, this.getMinY(), 79);
        this.addOre(region, mask, BlockTypes.COAL_ORE.getDefaultState(), 17, 20, 100, 0, 127);
        this.addOre(region, mask, BlockTypes.IRON_ORE.getDefaultState(), 9, 20, 100, 0, 63);
        this.addOre(region, mask, BlockTypes.GOLD_ORE.getDefaultState(), 9, 2, 100, 0, 31);
        this.addOre(region, mask, BlockTypes.REDSTONE_ORE.getDefaultState(), 8, 8, 100, 0, 15);
        this.addOre(region, mask, BlockTypes.DIAMOND_ORE.getDefaultState(), 8, 1, 100, 0, 15);
        this.addOre(region, mask, BlockTypes.LAPIS_ORE.getDefaultState(), 7, 1, 100, 0, 15);
        this.addOre(region, mask, BlockTypes.EMERALD_ORE.getDefaultState(), 5, 1, 100, 4, 31);
    }

    default public List<Countable<BlockType>> getBlockDistribution(Region region) {
        int[] counter = new int[BlockTypes.size()];
        for (BlockVector3 pt : region) {
            BlockType type = this.getBlock(pt).getBlockType();
            if (type == BlockTypes.__RESERVED__) {
                counter[1] = counter[1] + 1;
                continue;
            }
            int n = type.getInternalId();
            counter[n] = counter[n] + 1;
        }
        ArrayList<Countable<BlockType>> distribution = new ArrayList<Countable<BlockType>>();
        for (int i = 0; i < counter.length; ++i) {
            int count = counter[i];
            if (count == 0) continue;
            distribution.add(new Countable<BlockType>(BlockTypes.get(i), count));
        }
        Collections.sort(distribution);
        return distribution;
    }

    default public List<Countable<BlockState>> getBlockDistributionWithData(Region region) {
        int[][] counter = new int[BlockTypes.size()][];
        for (BlockVector3 pt : region) {
            int[] stateCounter;
            BlockState blk = this.getBlock(pt);
            BlockType type = blk.getBlockType();
            if (type == BlockTypes.__RESERVED__) {
                stateCounter = counter[1];
                if (stateCounter == null) {
                    counter[1] = stateCounter = new int[BlockTypes.AIR.getMaxStateId() + 1];
                }
                int n = BlockTypes.AIR.getDefaultState().getInternalPropertiesId();
                stateCounter[n] = stateCounter[n] + 1;
            }
            if ((stateCounter = counter[type.getInternalId()]) == null) {
                counter[type.getInternalId()] = stateCounter = new int[type.getMaxStateId() + 1];
            }
            int n = blk.getInternalPropertiesId();
            stateCounter[n] = stateCounter[n] + 1;
        }
        ArrayList<Countable<BlockState>> distribution = new ArrayList<Countable<BlockState>>();
        for (int typeId = 0; typeId < counter.length; ++typeId) {
            BlockType type = BlockTypes.get(typeId);
            int[] stateCount = counter[typeId];
            if (stateCount == null) continue;
            for (int propId = 0; propId < stateCount.length; ++propId) {
                int count = stateCount[propId];
                if (count == 0) continue;
                BlockState state = type.withPropertyId(propId);
                distribution.add(new Countable<BlockState>(state, count));
            }
        }
        return distribution;
    }

    @Override
    @Nullable
    default public Operation commit() {
        return null;
    }

    default public boolean cancel() {
        ExtentTraverser<Extent> traverser = new ExtentTraverser<Extent>(this);
        NullExtent nullExtent = new NullExtent(this, FaweCache.MANUAL);
        ExtentTraverser<Extent> next = traverser.next();
        if (next != null) {
            Extent child = next.get();
            if (child instanceof NullExtent) {
                return true;
            }
            traverser.setNext(nullExtent);
            child.cancel();
        }
        this.addProcessor(nullExtent);
        this.addPostProcessor(nullExtent);
        return true;
    }

    default public int getMinY() {
        return this.getMinimumPoint().getY();
    }

    default public int getMaxY() {
        return this.getMaximumPoint().getY();
    }

    default public Clipboard lazyCopy(Region region) {
        WorldCopyClipboard faweClipboard = new WorldCopyClipboard(() -> this, region);
        faweClipboard.setOrigin(region.getMinimumPoint());
        return faweClipboard;
    }

    default public int countBlocks(Region region, Set<BaseBlock> searchBlocks) {
        BlockMask mask = new BlockMask(this, searchBlocks);
        return this.countBlocks(region, mask);
    }

    default public int countBlocks(Region region, Mask searchMask) {
        RegionVisitor visitor = new RegionVisitor(region, searchMask::test, this);
        Operations.completeBlindly(visitor);
        return visitor.getAffected();
    }

    default public <B extends BlockStateHolder<B>> int setBlocks(Region region, B block) throws MaxChangedBlocksException {
        Preconditions.checkNotNull((Object)region);
        Preconditions.checkNotNull(block);
        boolean hasNbt = block instanceof BaseBlock && block.hasNbtData();
        int changes = 0;
        for (BlockVector3 pos : region) {
            if (!this.setBlock(pos, block)) continue;
            ++changes;
        }
        return changes;
    }

    default public int setBlocks(Region region, Pattern pattern) throws MaxChangedBlocksException {
        Preconditions.checkNotNull((Object)region);
        Preconditions.checkNotNull((Object)pattern);
        if (pattern instanceof BlockPattern) {
            return this.setBlocks(region, (BlockStateHolder)((BlockPattern)pattern).getBlock());
        }
        if (pattern instanceof BlockStateHolder) {
            return this.setBlocks(region, (BlockStateHolder)pattern);
        }
        int count = 0;
        for (BlockVector3 pos : region) {
            if (!pattern.apply(this, pos, pos)) continue;
            ++count;
        }
        return count;
    }

    default public <B extends BlockStateHolder<B>> int replaceBlocks(Region region, Set<BaseBlock> filter, B replacement) throws MaxChangedBlocksException {
        return this.replaceBlocks(region, filter, (Pattern)replacement);
    }

    default public int replaceBlocks(Region region, Set<BaseBlock> filter, Pattern pattern) throws MaxChangedBlocksException {
        AbstractExtentMask mask = filter == null ? new ExistingBlockMask(this) : new BlockMask(this, filter);
        return this.replaceBlocks(region, mask, pattern);
    }

    default public int replaceBlocks(Region region, Mask mask, Pattern pattern) throws MaxChangedBlocksException {
        Preconditions.checkNotNull((Object)region);
        Preconditions.checkNotNull((Object)mask);
        Preconditions.checkNotNull((Object)pattern);
        BlockReplace replace = new BlockReplace(this, pattern);
        RegionMaskingFilter filter = new RegionMaskingFilter(this, mask, replace);
        RegionVisitor visitor = new RegionVisitor(region, filter, this);
        Operations.completeLegacy(visitor);
        return visitor.getAffected();
    }

    default public int center(Region region, Pattern pattern) throws MaxChangedBlocksException {
        Preconditions.checkNotNull((Object)region);
        Preconditions.checkNotNull((Object)pattern);
        Vector3 center = region.getCenter();
        CuboidRegion centerRegion = new CuboidRegion(this instanceof World ? (World)this : null, BlockVector3.at((int)center.getX(), (int)center.getY(), (int)center.getZ()), BlockVector3.at(MathUtils.roundHalfUp(center.getX()), center.getY(), MathUtils.roundHalfUp(center.getZ())));
        return this.setBlocks((Region)centerRegion, pattern);
    }

    default public int setBlocks(Set<BlockVector3> vset, Pattern pattern) {
        if (vset instanceof Region) {
            return this.setBlocks((Region)((Object)vset), pattern);
        }
        int count = 0;
        for (BlockVector3 pos : vset) {
            if (!pattern.apply(this, pos, pos)) continue;
            ++count;
        }
        return count;
    }

    default public boolean relight(int x, int y, int z) {
        return false;
    }

    default public boolean relightBlock(int x, int y, int z) {
        return false;
    }

    default public boolean relightSky(int x, int y, int z) {
        return false;
    }

    default public Extent addProcessor(IBatchProcessor processor) {
        return processor.construct(this);
    }

    default public Extent addPostProcessor(IBatchProcessor processor) {
        if (processor.getScope() != ProcessorScope.READING_SET_BLOCKS) {
            throw new IllegalArgumentException("You cannot alter blocks in a PostProcessor");
        }
        return processor.construct(this);
    }

    default public Extent enableHistory(AbstractChangeSet changeSet) {
        if (Settings.settings().HISTORY.SEND_BEFORE_HISTORY) {
            return this.addPostProcessor(changeSet);
        }
        return this.addProcessor(changeSet);
    }

    default public Extent disableHistory() {
        return this;
    }

    default public <T extends Filter> T apply(Region region, T filter, boolean full) {
        return this.apply(region, filter);
    }

    default public <T extends Filter> T apply(Iterable<BlockVector3> positions, T filter) {
        ExtentFilterBlock block = new ExtentFilterBlock(this);
        for (BlockVector3 pos : positions) {
            filter.applyBlock(block.init(pos));
        }
        return filter;
    }
}

