/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.block;

import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.LayerFunction;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.registry.state.BooleanProperty;
import com.sk89q.worldedit.registry.state.EnumProperty;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.Locale;
import java.util.Map;

public class SnowSimulator
implements LayerFunction {
    public static final BooleanProperty snowy = (BooleanProperty)BlockTypes.GRASS_BLOCK.getProperty("snowy");
    private static final EnumProperty slab = (EnumProperty)BlockTypes.SANDSTONE_SLAB.getProperty("type");
    private static final EnumProperty stair = (EnumProperty)BlockTypes.SANDSTONE_STAIRS.getProperty("half");
    private static final EnumProperty trapdoor = (EnumProperty)BlockTypes.ACACIA_TRAPDOOR.getProperty("half");
    private static final BooleanProperty trapdoorOpen = (BooleanProperty)BlockTypes.ACACIA_TRAPDOOR.getProperty("open");
    private final BlockState ice = BlockTypes.ICE.getDefaultState();
    private final BlockState snow = BlockTypes.SNOW.getDefaultState();
    private final BlockState snowBlock = BlockTypes.SNOW_BLOCK.getDefaultState();
    private final Property<Integer> snowLayersProperty = BlockTypes.SNOW.getProperty("layers");
    private final Property<Integer> waterLevelProperty = BlockTypes.WATER.getProperty("level");
    private final Extent extent;
    private final boolean stack;
    private int affected;

    public SnowSimulator(Extent extent, boolean stack) {
        this.extent = extent;
        this.stack = stack;
        this.affected = 0;
    }

    public int getAffected() {
        return this.affected;
    }

    @Override
    public boolean isGround(BlockVector3 position) {
        BlockState block = this.extent.getBlock(position);
        if (block.getBlockType().getMaterial().isAir() || this.stack && block.getBlockType() == BlockTypes.SNOW) {
            return false;
        }
        if (block.getBlockType() == BlockTypes.WATER) {
            return true;
        }
        return block.getBlockType().getMaterial().isMovementBlocker();
    }

    @Override
    public boolean apply(BlockVector3 position, int depth) throws WorldEditException {
        if (depth > 0) {
            return false;
        }
        BlockState block = this.extent.getBlock(position);
        if (block.getBlockType() == BlockTypes.WATER) {
            if (block.getState(this.waterLevelProperty) == 0 && this.extent.setBlock(position, this.ice)) {
                ++this.affected;
            }
            return false;
        }
        if (position.getBlockY() == this.extent.getMaximumPoint().getBlockY()) {
            return false;
        }
        BlockVector3 abovePosition = position.add(0, 1, 0);
        BlockState above = this.extent.getBlock(abovePosition);
        if (!(above.getBlockType().getMaterial().isAir() || this.stack && above.getBlockType() == BlockTypes.SNOW)) {
            return false;
        }
        if (!block.getBlockType().getId().toLowerCase(Locale.ROOT).contains("ice") && this.extent.getEmittedLight(abovePosition) > 10) {
            return false;
        }
        if (!block.getBlockType().getMaterial().isFullCube()) {
            Map<Property<?>, Object> states = block.getStates();
            if (states.containsKey(slab) && block.getState(slab).equalsIgnoreCase("bottom")) {
                return false;
            }
            if (states.containsKey(trapdoorOpen) && states.containsKey(trapdoor) && (block.getState(trapdoorOpen).booleanValue() || block.getState(trapdoor).equalsIgnoreCase("bottom"))) {
                return false;
            }
            if (states.containsKey(stair) && block.getState(stair).equalsIgnoreCase("bottom")) {
                return false;
            }
            return false;
        }
        if (!block.getBlockType().getId().toLowerCase(Locale.ROOT).contains("ice") && block.getBlockType().getMaterial().isTranslucent()) {
            return false;
        }
        if (this.stack && above.getBlockType() == BlockTypes.SNOW) {
            int currentHeight = above.getState(this.snowLayersProperty);
            if (!this.snowLayersProperty.getValues().contains(currentHeight + 2)) {
                if (this.extent.setBlock(abovePosition, this.snowBlock)) {
                    if (block.getStates().containsKey(snowy)) {
                        this.extent.setBlock(position, block.with((Property)snowy, (Object)true));
                    }
                    ++this.affected;
                }
            } else if (this.extent.setBlock(abovePosition, above.with(this.snowLayersProperty, (Object)(currentHeight + 1)))) {
                if (block.getStates().containsKey(snowy)) {
                    this.extent.setBlock(position, block.with((Property)snowy, (Object)true));
                }
                ++this.affected;
            }
            return false;
        }
        if (this.extent.setBlock(abovePosition, this.snow)) {
            if (block.getStates().containsKey(snowy)) {
                this.extent.setBlock(position, block.with((Property)snowy, (Object)true));
            }
            ++this.affected;
        }
        return false;
    }
}

