/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.mask;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.function.mask.AbstractMask;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.Mask2D;
import com.sk89q.worldedit.function.mask.MaskIntersection2D;
import com.sk89q.worldedit.function.mask.Masks;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.math.BlockVector3;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Logger;

public class MaskIntersection
extends AbstractMask {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    protected final Set<Mask> masks;
    protected Mask[] masksArray;
    protected boolean defaultReturn;

    public MaskIntersection(Collection<Mask> masks) {
        Preconditions.checkNotNull(masks);
        this.masks = new LinkedHashSet<Mask>(masks);
        this.formArray();
    }

    public static Mask of(Mask ... masks) {
        LinkedHashSet<Mask> set = new LinkedHashSet<Mask>();
        for (Mask mask : masks) {
            if (mask == Masks.alwaysFalse()) {
                return mask;
            }
            if (mask == null || mask == Masks.alwaysTrue()) continue;
            if (mask.getClass() == MaskIntersection.class) {
                set.addAll(((MaskIntersection)mask).getMasks());
                continue;
            }
            set.add(mask);
        }
        switch (set.size()) {
            case 0: {
                return Masks.alwaysTrue();
            }
            case 1: {
                return (Mask)set.iterator().next();
            }
        }
        return new MaskIntersection(set).optimize();
    }

    public MaskIntersection(Mask ... mask) {
        this(Arrays.asList((Mask[])Preconditions.checkNotNull((Object)mask)));
    }

    private void formArray() {
        this.masksArray = this.masks.isEmpty() ? new Mask[]{Masks.alwaysFalse()} : this.masks.toArray(new Mask[0]);
        this.defaultReturn = this.masksArray.length != 0;
    }

    public Function<Map.Entry<Mask, Mask>, Mask> pairingFunction() {
        return input -> ((Mask)input.getKey()).tryCombine((Mask)input.getValue());
    }

    private boolean optimizeMasks(Set<Mask> ignore) {
        boolean changed = false;
        for (int i = 0; i < this.masksArray.length; ++i) {
            Mask mask = this.masksArray[i];
            if (ignore.contains(mask)) continue;
            Mask newMask = mask.tryOptimize();
            if (newMask != null) {
                changed = true;
                this.masksArray[i] = newMask;
                continue;
            }
            ignore.add(mask);
        }
        if (changed) {
            this.masks.clear();
            Collections.addAll(this.masks, this.masksArray);
        }
        boolean formArray = false;
        for (Mask mask : this.masksArray) {
            if (mask.getClass() != this.getClass()) continue;
            this.masks.remove(mask);
            this.masks.addAll(((MaskIntersection)mask).getMasks());
            formArray = true;
            changed = true;
        }
        if (formArray) {
            this.formArray();
        }
        return changed;
    }

    @Override
    public Mask tryOptimize() {
        int maxIteration = 1000;
        HashSet<Mask> optimized = new HashSet<Mask>();
        HashSet<Map.Entry<Mask, Mask>> failedCombines = new HashSet<Map.Entry<Mask, Mask>>();
        boolean changed = false;
        while (this.combineMasks(this.pairingFunction(), failedCombines)) {
            changed = true;
        }
        if (this.masks.isEmpty()) {
            this.formArray();
            return Masks.alwaysTrue();
        }
        if (this.masks.size() == 1) {
            this.formArray();
            return this.masks.iterator().next();
        }
        do {
            changed |= this.optimizeMasks(optimized);
        } while (this.combineMasks(this.pairingFunction(), failedCombines) && --maxIteration > 0);
        if (maxIteration == 0) {
            LOGGER.error("Failed optimize MaskIntersection");
            for (Mask mask : this.masks) {
                LOGGER.error(mask.getClass() + " / " + mask);
            }
        }
        this.formArray();
        if (this.masks.isEmpty()) {
            return Masks.alwaysTrue();
        }
        if (this.masks.size() == 1) {
            return this.masks.iterator().next();
        }
        return changed ? this : null;
    }

    private boolean combineMasks(Function<Map.Entry<Mask, Mask>, Mask> pairing, Set<Map.Entry<Mask, Mask>> failedCombines) {
        boolean hasOptimized = false;
        while (true) {
            Mask[] result = null;
            block1: for (Mask mask : this.masks) {
                for (Mask other : this.masks) {
                    AbstractMap.SimpleEntry<Mask, Mask> pair;
                    if (mask == other || failedCombines.contains(pair = new AbstractMap.SimpleEntry<Mask, Mask>(mask, other))) continue;
                    Mask combined = pairing.apply(pair);
                    if (combined != null) {
                        result = new Mask[]{combined, mask, other};
                        break block1;
                    }
                    failedCombines.add(pair);
                }
            }
            if (result == null) break;
            this.masks.remove(result[1]);
            this.masks.remove(result[2]);
            this.masks.add((Mask)result[0]);
            hasOptimized = true;
        }
        return hasOptimized;
    }

    public void add(Collection<Mask> masks) {
        Preconditions.checkNotNull(masks);
        this.masks.addAll(masks);
        this.formArray();
    }

    public void add(Mask ... mask) {
        this.add(Arrays.asList((Mask[])Preconditions.checkNotNull((Object)mask)));
    }

    public Collection<Mask> getMasks() {
        return this.masks;
    }

    public final Mask[] getMasksArray() {
        return this.masksArray;
    }

    @Override
    public boolean test(BlockVector3 vector) {
        for (Mask mask : this.masksArray) {
            if (mask.test(vector)) continue;
            return false;
        }
        return this.defaultReturn;
    }

    @Override
    @Nullable
    public Mask2D toMask2D() {
        ArrayList<Mask2D> mask2dList = new ArrayList<Mask2D>();
        for (Mask mask : this.masks) {
            Mask2D mask2d = mask.toMask2D();
            if (mask2d != null) {
                mask2dList.add(mask2d);
                continue;
            }
            return null;
        }
        return new MaskIntersection2D(mask2dList);
    }

    @Override
    public Mask copy() {
        Set<Mask> masks = this.masks.stream().map(Mask::copy).collect(Collectors.toSet());
        return new MaskIntersection(masks);
    }

    @Override
    public boolean replacesAir() {
        for (Mask mask : this.masksArray) {
            if (!mask.replacesAir()) continue;
            return true;
        }
        return false;
    }
}

