/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.operation;

import com.fastasyncworldedit.core.history.changeset.AbstractChangeSet;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.RunContext;
import com.sk89q.worldedit.history.UndoContext;
import com.sk89q.worldedit.history.change.Change;
import com.sk89q.worldedit.history.changeset.ChangeSet;
import java.util.Iterator;

public class ChangeSetExecutor
implements Operation {
    private final Iterator<Change> iterator;
    private final Type type;
    private final UndoContext context;

    private ChangeSetExecutor(ChangeSet changeSet, Type type, UndoContext context, BlockBag blockBag, int inventory) {
        Preconditions.checkNotNull((Object)changeSet);
        Preconditions.checkNotNull((Object)((Object)type));
        Preconditions.checkNotNull((Object)context);
        this.type = type;
        this.context = context;
        this.iterator = changeSet instanceof AbstractChangeSet ? ((AbstractChangeSet)changeSet).getIterator(blockBag, inventory, type == Type.REDO) : (type == Type.UNDO ? changeSet.backwardIterator() : changeSet.forwardIterator());
    }

    @Override
    public Operation resume(RunContext run) throws WorldEditException {
        while (this.iterator.hasNext()) {
            Change change = this.iterator.next();
            this.type.perform(change, this.context);
        }
        return null;
    }

    @Override
    public void cancel() {
    }

    public static ChangeSetExecutor create(ChangeSet changeSet, UndoContext context, Type type, BlockBag blockBag, int inventory) {
        return new ChangeSetExecutor(changeSet, type, context, blockBag, inventory);
    }

    public static ChangeSetExecutor createUndo(ChangeSet changeSet, UndoContext context) {
        return new ChangeSetExecutor(changeSet, Type.UNDO, context, null, 0);
    }

    public static ChangeSetExecutor createRedo(ChangeSet changeSet, UndoContext context) {
        return new ChangeSetExecutor(changeSet, Type.REDO, context, null, 0);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Type {
        UNDO{

            @Override
            public void perform(Change change, UndoContext context) {
                change.undo(context);
            }
        }
        ,
        REDO{

            @Override
            public void perform(Change change, UndoContext context) {
                change.redo(context);
            }
        };


        public void perform(Change change, UndoContext context) {
        }
    }
}

