/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.pattern;

import com.fastasyncworldedit.core.math.random.SimpleRandom;
import com.fastasyncworldedit.core.math.random.TrueRandom;
import com.fastasyncworldedit.core.util.collection.RandomCollection;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.pattern.AbstractPattern;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.block.BaseBlock;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class RandomPattern
extends AbstractPattern {
    private final SimpleRandom random;
    private Map<Pattern, Double> weights = new HashMap<Pattern, Double>();
    private RandomCollection<Pattern> collection;
    private LinkedHashSet<Pattern> patterns = new LinkedHashSet();

    public RandomPattern() {
        this(new TrueRandom());
    }

    public RandomPattern(SimpleRandom random) {
        this.random = random;
    }

    public RandomPattern(SimpleRandom random, RandomPattern parent) {
        this.random = random;
        this.weights = parent.weights;
        this.collection = RandomCollection.of(this.weights, random);
        this.patterns = parent.patterns;
    }

    public void add(Pattern pattern, double chance) {
        Preconditions.checkNotNull((Object)pattern);
        Double existingWeight = this.weights.get(pattern);
        if (existingWeight != null) {
            chance += existingWeight.doubleValue();
        }
        this.weights.put(pattern, chance);
        this.collection = RandomCollection.of(this.weights, this.random);
        this.patterns.add(pattern);
    }

    public Set<Pattern> getPatterns() {
        return this.patterns;
    }

    public RandomCollection<Pattern> getCollection() {
        return this.collection;
    }

    @Override
    public BaseBlock applyBlock(BlockVector3 position) {
        return this.collection.next(position.getBlockX(), position.getBlockY(), position.getBlockZ()).applyBlock(position);
    }

    @Override
    public boolean apply(Extent extent, BlockVector3 get, BlockVector3 set) throws WorldEditException {
        return this.collection.next(get.getBlockX(), get.getBlockY(), get.getBlockZ()).apply(extent, get, set);
    }
}

