/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.chunk;

import com.fastasyncworldedit.core.util.NbtUtils;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.util.nbt.BinaryTag;
import com.sk89q.worldedit.util.nbt.BinaryTagTypes;
import com.sk89q.worldedit.util.nbt.ByteArrayBinaryTag;
import com.sk89q.worldedit.util.nbt.CompoundBinaryTag;
import com.sk89q.worldedit.util.nbt.IntBinaryTag;
import com.sk89q.worldedit.util.nbt.ListBinaryTag;
import com.sk89q.worldedit.world.DataException;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.chunk.Chunk;
import com.sk89q.worldedit.world.registry.LegacyMapper;
import com.sk89q.worldedit.world.storage.InvalidFormatException;
import java.util.HashMap;
import java.util.Map;

public class OldChunk
implements Chunk {
    private final CompoundBinaryTag rootTag;
    private final byte[] blocks;
    private final byte[] data;
    private final int rootX;
    private final int rootZ;
    private Map<BlockVector3, CompoundBinaryTag> tileEntities;

    @Deprecated
    public OldChunk(CompoundTag tag) throws DataException {
        this(tag.asBinaryTag());
    }

    public OldChunk(CompoundBinaryTag tag) throws DataException {
        this.rootTag = tag;
        this.blocks = ((ByteArrayBinaryTag)NbtUtils.getChildTag(this.rootTag, "Blocks", BinaryTagTypes.BYTE_ARRAY)).value();
        this.data = ((ByteArrayBinaryTag)NbtUtils.getChildTag(this.rootTag, "Data", BinaryTagTypes.BYTE_ARRAY)).value();
        this.rootX = ((IntBinaryTag)NbtUtils.getChildTag(this.rootTag, "xPos", BinaryTagTypes.INT)).value();
        this.rootZ = ((IntBinaryTag)NbtUtils.getChildTag(this.rootTag, "zPos", BinaryTagTypes.INT)).value();
        int size = 32768;
        if (this.blocks.length != size) {
            throw new InvalidFormatException("Chunk blocks byte array expected to be " + size + " bytes; found " + this.blocks.length);
        }
        if (this.data.length != size / 2) {
            throw new InvalidFormatException("Chunk block data byte array expected to be " + size + " bytes; found " + this.data.length);
        }
    }

    private void populateTileEntities() throws DataException {
        ListBinaryTag tags = (ListBinaryTag)NbtUtils.getChildTag(this.rootTag, "TileEntities", BinaryTagTypes.LIST);
        this.tileEntities = new HashMap<BlockVector3, CompoundBinaryTag>();
        for (BinaryTag tag : tags) {
            if (!(tag instanceof CompoundBinaryTag)) {
                throw new InvalidFormatException("CompoundTag expected in TileEntities");
            }
            CompoundBinaryTag t = (CompoundBinaryTag)tag;
            int x = 0;
            int y = 0;
            int z = 0;
            CompoundBinaryTag.Builder values = CompoundBinaryTag.builder();
            for (String key : t.keySet()) {
                BinaryTag value = t.get(key);
                switch (key) {
                    case "x": {
                        if (!(value instanceof IntBinaryTag)) break;
                        x = ((IntBinaryTag)value).value();
                        break;
                    }
                    case "y": {
                        if (!(value instanceof IntBinaryTag)) break;
                        y = ((IntBinaryTag)value).value();
                        break;
                    }
                    case "z": {
                        if (!(value instanceof IntBinaryTag)) break;
                        z = ((IntBinaryTag)value).value();
                        break;
                    }
                }
                values.put(key, value);
            }
            BlockVector3 vec = BlockVector3.at(x, y, z);
            this.tileEntities.put(vec, values.build());
        }
    }

    private CompoundBinaryTag getBlockTileEntity(BlockVector3 position) throws DataException {
        if (this.tileEntities == null) {
            this.populateTileEntities();
        }
        CompoundBinaryTag values = this.tileEntities.get(position);
        return values;
    }

    @Override
    public BaseBlock getBlock(BlockVector3 position) throws DataException {
        int dataVal;
        byte id;
        if (position.getY() >= 128) {
            return BlockTypes.VOID_AIR.getDefaultState().toBaseBlock();
        }
        int x = position.getX() - this.rootX * 16;
        int y = position.getY();
        int z = position.getZ() - this.rootZ * 16;
        int index = y + (z * 128 + x * 128 * 16);
        try {
            id = this.blocks[index];
        }
        catch (IndexOutOfBoundsException e) {
            throw new DataException("Chunk does not contain position " + position);
        }
        boolean shift = index % 2 == 0;
        index /= 2;
        try {
            dataVal = !shift ? (this.data[index] & 0xF0) >> 4 : this.data[index] & 0xF;
        }
        catch (IndexOutOfBoundsException e) {
            throw new DataException("Chunk does not contain position " + position);
        }
        BlockState state = LegacyMapper.getInstance().getBlockFromLegacy(id, dataVal);
        if (state == null) {
            WorldEdit.logger.warn("Unknown legacy block " + id + ":" + dataVal + " found when loading legacy anvil chunk.");
            return BlockTypes.AIR.getDefaultState().toBaseBlock();
        }
        CompoundBinaryTag tileEntity = this.getBlockTileEntity(position);
        if (tileEntity != null) {
            return state.toBaseBlock(tileEntity);
        }
        return state.toBaseBlock();
    }
}

