/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.storage;

import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.world.DataException;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.storage.ChunkStore;
import com.sk89q.worldedit.world.storage.ChunkStoreHelper;
import com.sk89q.worldedit.world.storage.McRegionReader;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;

public abstract class McRegionChunkStore
extends ChunkStore {
    protected String curFilename = null;
    protected McRegionReader cachedReader = null;

    public static String getFilename(BlockVector2 position) {
        int x = position.getBlockX();
        int z = position.getBlockZ();
        return "r." + (x >> 5) + "." + (z >> 5) + ".mca";
    }

    protected McRegionReader getReader(BlockVector2 pos, String worldname, @Nullable String folderOverride) throws DataException, IOException {
        String filename = McRegionChunkStore.getFilename(pos);
        if (this.curFilename != null) {
            if (this.curFilename.equals(filename)) {
                return this.cachedReader;
            }
            try {
                this.cachedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        InputStream stream = this.getInputStream(filename, worldname, folderOverride);
        this.cachedReader = new McRegionReader(stream);
        return this.cachedReader;
    }

    @Override
    public CompoundTag getChunkTag(BlockVector2 position, World world) throws DataException, IOException {
        return ChunkStoreHelper.readCompoundTag(() -> {
            McRegionReader reader = this.getReader(position, world.getName(), null);
            return reader.getChunkInputStream(position);
        });
    }

    @Override
    public CompoundTag getEntitiesTag(BlockVector2 position, World world) {
        try {
            return ChunkStoreHelper.readCompoundTag(() -> {
                McRegionReader reader = this.getReader(position, world.getName(), "entities");
                return reader.getChunkInputStream(position);
            });
        }
        catch (DataException | IOException e) {
            return null;
        }
    }

    protected abstract InputStream getInputStream(String var1, String var2, @Nullable String var3) throws IOException, DataException;

    @Override
    public void close() throws IOException {
        if (this.cachedReader != null) {
            this.cachedReader.close();
        }
    }
}

