/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v388.serializer;

import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.BedrockPacketHelper;
import com.nukkitx.protocol.bedrock.BedrockSession;
import com.nukkitx.protocol.bedrock.data.inventory.ContainerMixData;
import com.nukkitx.protocol.bedrock.data.inventory.CraftingData;
import com.nukkitx.protocol.bedrock.data.inventory.CraftingDataType;
import com.nukkitx.protocol.bedrock.data.inventory.PotionMixData;
import com.nukkitx.protocol.bedrock.packet.CraftingDataPacket;
import com.nukkitx.protocol.bedrock.v361.serializer.CraftingDataSerializer_v361;
import io.netty.buffer.ByteBuf;
import java.util.Collection;

public class CraftingDataSerializer_v388
extends CraftingDataSerializer_v361 {
    public static final CraftingDataSerializer_v388 INSTANCE = new CraftingDataSerializer_v388();

    public void serialize(ByteBuf buffer, BedrockPacketHelper helper, CraftingDataPacket packet, BedrockSession session) {
        helper.writeArray(buffer, (Collection)packet.getCraftingData(), (buf, craftingData) -> {
            VarInts.writeInt((ByteBuf)buf, (int)craftingData.getType().ordinal());
            switch (craftingData.getType()) {
                case SHAPELESS: 
                case SHAPELESS_CHEMISTRY: 
                case SHULKER_BOX: {
                    this.writeShapelessRecipe((ByteBuf)buf, helper, (CraftingData)craftingData, session);
                    break;
                }
                case SHAPED: 
                case SHAPED_CHEMISTRY: {
                    this.writeShapedRecipe((ByteBuf)buf, helper, (CraftingData)craftingData, session);
                    break;
                }
                case FURNACE: 
                case FURNACE_DATA: {
                    this.writeFurnaceRecipe((ByteBuf)buf, helper, (CraftingData)craftingData, session);
                    break;
                }
                case MULTI: {
                    this.writeMultiRecipe((ByteBuf)buf, helper, (CraftingData)craftingData);
                }
            }
        });
        helper.writeArray(buffer, (Collection)packet.getPotionMixData(), (buf, potionMixData) -> {
            VarInts.writeInt((ByteBuf)buf, (int)potionMixData.getInputId());
            VarInts.writeInt((ByteBuf)buf, (int)potionMixData.getReagentId());
            VarInts.writeInt((ByteBuf)buf, (int)potionMixData.getOutputId());
        });
        helper.writeArray(buffer, (Collection)packet.getContainerMixData(), (buf, containerMixData) -> {
            VarInts.writeInt((ByteBuf)buf, (int)containerMixData.getInputId());
            VarInts.writeInt((ByteBuf)buf, (int)containerMixData.getReagentId());
            VarInts.writeInt((ByteBuf)buf, (int)containerMixData.getOutputId());
        });
        buffer.writeBoolean(packet.isCleanRecipes());
    }

    public void deserialize(ByteBuf buffer, BedrockPacketHelper helper, CraftingDataPacket packet, BedrockSession session) {
        helper.readArray(buffer, (Collection)packet.getCraftingData(), buf -> {
            int typeInt = VarInts.readInt((ByteBuf)buf);
            CraftingDataType type = CraftingDataType.byId((int)typeInt);
            switch (type) {
                case SHAPELESS: 
                case SHAPELESS_CHEMISTRY: 
                case SHULKER_BOX: {
                    return this.readShapelessRecipe((ByteBuf)buf, helper, type, session);
                }
                case SHAPED: 
                case SHAPED_CHEMISTRY: {
                    return this.readShapedRecipe((ByteBuf)buf, helper, type, session);
                }
                case FURNACE: 
                case FURNACE_DATA: {
                    return this.readFurnaceRecipe((ByteBuf)buf, helper, type, session);
                }
                case MULTI: {
                    return this.readMultiRecipe((ByteBuf)buf, helper, type);
                }
            }
            throw new IllegalArgumentException("Unhandled crafting data type: " + type);
        });
        helper.readArray(buffer, (Collection)packet.getPotionMixData(), buf -> {
            int fromPotionId = VarInts.readInt((ByteBuf)buf);
            int ingredient = VarInts.readInt((ByteBuf)buf);
            int toPotionId = VarInts.readInt((ByteBuf)buf);
            return new PotionMixData(fromPotionId, 0, ingredient, 0, toPotionId, 0);
        });
        helper.readArray(buffer, (Collection)packet.getContainerMixData(), buf -> {
            int fromItemId = VarInts.readInt((ByteBuf)buf);
            int ingredient = VarInts.readInt((ByteBuf)buf);
            int toItemId = VarInts.readInt((ByteBuf)buf);
            return new ContainerMixData(fromItemId, ingredient, toItemId);
        });
        packet.setCleanRecipes(buffer.readBoolean());
    }

    protected CraftingDataSerializer_v388() {
    }
}

