/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.db.TownyDataSource;
import com.palmergames.bukkit.towny.event.townblockstatus.NationZoneTownBlockStatusEvent;
import com.palmergames.bukkit.towny.exceptions.KeyAlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.PlayerCache;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.ResidentList;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.metadata.CustomDataField;
import com.palmergames.bukkit.towny.permissions.TownyPermissionSource;
import com.palmergames.bukkit.towny.tasks.TeleportWarmupTimerTask;
import com.palmergames.bukkit.towny.war.eventwar.War;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class TownyAPI {
    private static TownyAPI instance;
    private final Towny towny = Towny.getPlugin();
    private final TownyUniverse townyUniverse = TownyUniverse.getInstance();

    private TownyAPI() {
    }

    public Location getTownSpawnLocation(Player player) {
        Resident resident = this.townyUniverse.getResident(player.getUniqueId());
        if (resident == null) {
            return null;
        }
        try {
            if (resident.hasTown()) {
                Town town = resident.getTown();
                return town.getSpawn();
            }
        }
        catch (TownyException townyException) {
            // empty catch block
        }
        return null;
    }

    public Location getNationSpawnLocation(Player player) {
        Resident resident = this.townyUniverse.getResident(player.getUniqueId());
        if (resident == null) {
            return null;
        }
        try {
            Town t;
            if (resident.hasTown() && (t = resident.getTown()).hasNation()) {
                Nation nation = t.getNation();
                return nation.getSpawn();
            }
        }
        catch (TownyException townyException) {
            // empty catch block
        }
        return null;
    }

    public Player getPlayer(Resident resident) {
        if (resident.isNPC()) {
            return null;
        }
        Player player = null;
        if (resident.hasUUID()) {
            player = BukkitTools.getPlayer(resident.getUUID());
        }
        if (player == null) {
            player = BukkitTools.getPlayerExact(resident.getName());
        }
        return player;
    }

    public UUID getPlayerUUID(Resident resident) {
        if (resident.isNPC()) {
            return null;
        }
        if (resident.hasUUID()) {
            return resident.getUUID();
        }
        Player player = BukkitTools.getPlayerExact(resident.getName());
        if (player != null) {
            return player.getUniqueId();
        }
        return null;
    }

    public List<Player> getOnlinePlayers(ResidentList owner) {
        ArrayList<Player> players = new ArrayList<Player>();
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null || !owner.hasResident(player.getName())) continue;
            players.add(player);
        }
        return players;
    }

    public List<Player> getOnlinePlayersInTown(Town town) {
        return this.getOnlinePlayers(town);
    }

    public List<Player> getOnlinePlayersInNation(Nation nation) {
        return this.getOnlinePlayers(nation);
    }

    public List<Player> getOnlinePlayersAlliance(Nation nation) {
        ArrayList<Player> players = new ArrayList<Player>(this.getOnlinePlayers(nation));
        if (!nation.getAllies().isEmpty()) {
            for (Nation nations : nation.getAllies()) {
                players.addAll(this.getOnlinePlayers(nations));
            }
        }
        return players;
    }

    public boolean isWilderness(Block block) {
        return this.isWilderness(block.getLocation());
    }

    public boolean isWilderness(Location location) {
        return this.isWilderness(WorldCoord.parseWorldCoord(location));
    }

    public boolean isWilderness(WorldCoord worldCoord) {
        try {
            if (worldCoord.hasTownBlock() && worldCoord.getTownBlock().hasTown()) {
                return false;
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        return true;
    }

    public boolean isTownyWorld(World world) {
        try {
            return this.townyUniverse.getDataSource().getWorld(world.getName()).isUsingTowny();
        }
        catch (NotRegisteredException e) {
            return false;
        }
    }

    public TownyWorld getTownyWorld(String worldName) {
        try {
            TownyWorld townyWorld = this.townyUniverse.getDataSource().getWorld(worldName);
            return townyWorld;
        }
        catch (NotRegisteredException e) {
            return null;
        }
    }

    public Town getTown(Location location) {
        try {
            TownBlock tb;
            WorldCoord worldCoord = WorldCoord.parseWorldCoord(location);
            if (worldCoord.hasTownBlock() && (tb = worldCoord.getTownBlock()).hasTown()) {
                return tb.getTown();
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        return null;
    }

    public String getTownName(Location location) {
        Town town = this.getTown(location);
        return town != null ? town.getName() : null;
    }

    public UUID getTownUUID(Location location) {
        Town town = this.getTown(location);
        return town != null ? town.getUUID() : null;
    }

    public TownBlock getTownBlock(Location location) {
        try {
            WorldCoord worldCoord = WorldCoord.parseWorldCoord(location);
            if (worldCoord.hasTownBlock()) {
                return worldCoord.getTownBlock();
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        return null;
    }

    public List<Resident> getActiveResidents() {
        ArrayList<Resident> activeResidents = new ArrayList<Resident>();
        for (Resident resident : this.townyUniverse.getResidents()) {
            if (!this.isActiveResident(resident)) continue;
            activeResidents.add(resident);
        }
        return activeResidents;
    }

    public boolean isActiveResident(Resident resident) {
        return System.currentTimeMillis() - resident.getLastOnline() < 20L * TownySettings.getInactiveAfter() || BukkitTools.isOnline(resident.getName());
    }

    public TownyDataSource getDataSource() {
        return this.townyUniverse.getDataSource();
    }

    @Deprecated
    public TownyPermissionSource getPermissionSource() {
        return this.townyUniverse.getPermissionSource();
    }

    public boolean isWarTime() {
        return this.townyUniverse.getWarEvent() != null && this.townyUniverse.getWarEvent().isWarTime();
    }

    public List<Resident> getOnlineResidents(ResidentList owner) {
        ArrayList<Resident> onlineResidents = new ArrayList<Resident>();
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null) continue;
            for (Resident resident : owner.getResidents()) {
                if (!resident.getName().equalsIgnoreCase(player.getName())) continue;
                onlineResidents.add(resident);
            }
        }
        return onlineResidents;
    }

    public void jailTeleport(Player player, Location location) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.towny, () -> player.teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN), (long)TownySettings.getTeleportWarmupTime() * 20L);
    }

    @Deprecated
    public War getWarEvent() {
        return TownyUniverse.getInstance().getWarEvent();
    }

    public void clearWarEvent() {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        townyUniverse.getWarEvent().cancelTasks(BukkitTools.getScheduler());
        townyUniverse.setWarEvent(null);
    }

    public void requestTeleport(Player player, Location spawnLoc) {
        Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
        if (resident != null) {
            TeleportWarmupTimerTask.requestTeleport(resident, spawnLoc);
        }
    }

    public void abortTeleportRequest(Resident resident) {
        TeleportWarmupTimerTask.abortTeleportRequest(resident);
    }

    public void registerCustomDataField(CustomDataField<?> field) throws KeyAlreadyRegisteredException {
        this.townyUniverse.addCustomCustomDataField(field);
    }

    public boolean isNationZone(Location location) {
        if (!this.isWilderness(location)) {
            return false;
        }
        PlayerCache.TownBlockStatus status = this.hasNationZone(location);
        return status.equals((Object)PlayerCache.TownBlockStatus.NATION_ZONE);
    }

    public PlayerCache.TownBlockStatus hasNationZone(Location location) {
        return this.hasNationZone(WorldCoord.parseWorldCoord(location));
    }

    public PlayerCache.TownBlockStatus hasNationZone(WorldCoord worldCoord) {
        int distance;
        Town nearestTown = null;
        try {
            TownBlock nearestTownblock = worldCoord.getTownyWorld().getClosestTownblockWithNationFromCoord(worldCoord);
            if (nearestTownblock == null) {
                return PlayerCache.TownBlockStatus.UNCLAIMED_ZONE;
            }
            nearestTown = nearestTownblock.getTown();
            if (nearestTown == null || !nearestTown.hasNation()) {
                return PlayerCache.TownBlockStatus.UNCLAIMED_ZONE;
            }
            distance = (int)MathUtil.distance(worldCoord.getX(), nearestTownblock.getX(), worldCoord.getZ(), nearestTownblock.getZ());
        }
        catch (NotRegisteredException e1) {
            return PlayerCache.TownBlockStatus.UNCLAIMED_ZONE;
        }
        if (!nearestTown.isCapital() && TownySettings.getNationZonesCapitalsOnly()) {
            return PlayerCache.TownBlockStatus.UNCLAIMED_ZONE;
        }
        try {
            int nationZoneRadius = Integer.parseInt(TownySettings.getNationLevel(nearestTown.getNation()).get((Object)TownySettings.NationLevel.NATIONZONES_SIZE).toString());
            if (nearestTown.isCapital()) {
                nationZoneRadius += TownySettings.getNationZonesCapitalBonusSize();
            }
            if (distance <= nationZoneRadius) {
                NationZoneTownBlockStatusEvent event = new NationZoneTownBlockStatusEvent(nearestTown);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return PlayerCache.TownBlockStatus.UNCLAIMED_ZONE;
                }
                return PlayerCache.TownBlockStatus.NATION_ZONE;
            }
        }
        catch (NotRegisteredException | NumberFormatException exception) {
            // empty catch block
        }
        return PlayerCache.TownBlockStatus.UNCLAIMED_ZONE;
    }

    public static TownyAPI getInstance() {
        if (instance == null) {
            instance = new TownyAPI();
        }
        return instance;
    }
}

