/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.statusscreen.NationStatusScreenEvent;
import com.palmergames.bukkit.towny.event.statusscreen.ResidentStatusScreenEvent;
import com.palmergames.bukkit.towny.event.statusscreen.TownStatusScreenEvent;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.ResidentList;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.metadata.CustomDataField;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.utils.MoneyUtil;
import com.palmergames.bukkit.towny.utils.ResidentUtil;
import com.palmergames.bukkit.towny.war.common.townruin.TownRuinSettings;
import com.palmergames.bukkit.towny.war.common.townruin.TownRuinUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.util.StringMgmt;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.util.ChatPaginator;

public class TownyFormatter {
    public static final SimpleDateFormat lastOnlineFormat = new SimpleDateFormat("MMMMM dd '@' HH:mm");
    public static final SimpleDateFormat lastOnlineFormatIncludeYear = new SimpleDateFormat("MMMMM dd yyyy");
    public static final SimpleDateFormat registeredFormat = new SimpleDateFormat("MMM d yyyy");
    public static final String residentListPrefixFormat = "%3$s%1$s %4$s[%2$d]%3$s:%5$s ";
    public static final String embassyTownListPrefixFormat = "%3$s%1$s:%5$s ";

    public static void initialize() {
    }

    public static List<String> getFormattedOnlineResidents(String prefix, ResidentList residentList, Player player) {
        List<Resident> onlineResidents = ResidentUtil.getOnlineResidentsViewable(player, residentList);
        return TownyFormatter.getFormattedResidents(prefix, onlineResidents);
    }

    public static List<String> getFormattedResidents(Town town) {
        String[] residents = TownyFormatter.getFormattedNames(town.getResidents().toArray(new Resident[0]));
        return new ArrayList<String>(ChatTools.listArr(residents, "\u00a72" + Translation.of("res_list") + " " + "\u00a7a" + "[" + town.getNumResidents() + "]" + "\u00a72" + ":" + "\u00a7f" + " "));
    }

    public static List<String> getFormattedOutlaws(Town town) {
        String[] residents = TownyFormatter.getFormattedNames(town.getOutlaws().toArray(new Resident[0]));
        return new ArrayList<String>(ChatTools.listArr(residents, Translation.of("outlaws") + " "));
    }

    public static List<String> getFormattedResidents(String prefix, List<Resident> residentList) {
        return ChatTools.listArr(TownyFormatter.getFormattedNames(residentList), String.format(residentListPrefixFormat, prefix, residentList.size(), Translation.of("res_format_list_1"), Translation.of("res_format_list_2"), Translation.of("res_format_list_3")));
    }

    public static List<String> getFormattedTowns(String prefix, List<Town> townList) {
        TownyObject[] arrayTowns = townList.toArray(new Town[0]);
        return ChatTools.listArr(TownyFormatter.getFormattedNames(arrayTowns), String.format(embassyTownListPrefixFormat, prefix, townList.size(), Translation.of("res_format_list_1"), Translation.of("res_format_list_2"), Translation.of("res_format_list_3")));
    }

    public static String[] getFormattedNames(List<Resident> residentList) {
        return TownyFormatter.getFormattedNames(residentList.toArray(new Resident[0]));
    }

    public static String getTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("hh:mm aa");
        return sdf.format(System.currentTimeMillis());
    }

    public static List<String> getStatus(TownBlock townBlock) {
        List<String> out = new ArrayList<String>();
        try {
            Town town = townBlock.getTown();
            TownyWorld world = townBlock.getWorld();
            boolean preventPVP = CombatUtil.preventPvP(world, townBlock);
            TownyObject owner = townBlock.hasResident() ? townBlock.getResident() : townBlock.getTown();
            out.add(ChatTools.formatTitle(owner.getFormattedName() + (BukkitTools.isOnline(owner.getName()) ? Translation.of("online") : "")));
            if (!townBlock.getType().equals((Object)TownBlockType.RESIDENTIAL)) {
                out.add(Translation.of("status_plot_type") + townBlock.getType().toString());
            }
            out.add(Translation.of("status_perm") + (owner instanceof Resident ? townBlock.getPermissions().getColourString().replace("n", "t") : townBlock.getPermissions().getColourString().replace("f", "r")));
            out.add(Translation.of("status_perm") + (owner instanceof Resident ? townBlock.getPermissions().getColourString2().replace("n", "t") : townBlock.getPermissions().getColourString2().replace("f", "r")));
            out.add(Translation.of("status_pvp") + (!preventPVP ? Translation.of("status_on") : Translation.of("status_off")) + Translation.of("explosions") + (world.isForceExpl() || townBlock.getPermissions().explosion ? Translation.of("status_on") : Translation.of("status_off")) + Translation.of("firespread") + (town.isFire() || world.isForceFire() || townBlock.getPermissions().fire ? Translation.of("status_on") : Translation.of("status_off")) + Translation.of("mobspawns") + (world.isForceTownMobs() || townBlock.getPermissions().mobs ? Translation.of("status_on") : Translation.of("status_off")));
            if (townBlock.hasPlotObjectGroup()) {
                out.add(Translation.of("status_plot_group_name_and_size", townBlock.getPlotObjectGroup().getName(), townBlock.getPlotObjectGroup().getTownBlocks().size()));
            }
            out.addAll(TownyFormatter.getExtraFields(townBlock));
        }
        catch (NotRegisteredException e) {
            out.add("Error: " + e.getMessage());
        }
        out = TownyFormatter.formatStatusScreens(out);
        return out;
    }

    public static List<String> getStatus(Resident resident, Player player) {
        List<String> out = new ArrayList<String>();
        out.add(ChatTools.formatTitle(resident.getFormattedName() + (BukkitTools.isOnline(resident.getName()) && player != null && player.canSee(BukkitTools.getPlayer(resident.getName())) ? Translation.of("online2") : "")));
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(resident.getLastOnline());
        int currentYear = cal.get(1);
        cal.setTimeInMillis(System.currentTimeMillis());
        int lastOnlineYear = cal.get(1);
        if (!resident.isNPC()) {
            if (currentYear == lastOnlineYear) {
                out.add(Translation.of("registered_last_online", registeredFormat.format(resident.getRegistered()), lastOnlineFormat.format(resident.getLastOnline())));
            } else {
                out.add(Translation.of("registered_last_online", registeredFormat.format(resident.getRegistered()), lastOnlineFormatIncludeYear.format(resident.getLastOnline())));
            }
        } else {
            out.add(Translation.of("npc_created", registeredFormat.format(resident.getRegistered())));
        }
        out.add(Translation.of("owner_of_x_plots", resident.getTownBlocks().size()));
        out.add(Translation.of("status_perm") + resident.getPermissions().getColourString().replace("n", "t"));
        out.add(Translation.of("status_perm") + resident.getPermissions().getColourString2().replace("n", "t"));
        out.add(Translation.of("status_pvp") + (resident.getPermissions().pvp ? Translation.of("status_on") : Translation.of("status_off")) + Translation.of("explosions") + (resident.getPermissions().explosion ? Translation.of("status_on") : Translation.of("status_off")) + Translation.of("firespread") + (resident.getPermissions().fire ? Translation.of("status_on") : Translation.of("status_off")) + Translation.of("mobspawns") + (resident.getPermissions().mobs ? Translation.of("status_on") : Translation.of("status_off")));
        if (TownyEconomyHandler.isActive()) {
            out.add(Translation.of("status_bank", resident.getAccount().getHoldingFormattedBalance()));
        }
        String line = Translation.of("status_town");
        if (!resident.hasTown()) {
            line = line + Translation.of("status_no_town");
        } else {
            try {
                line = line + resident.getTown().getFormattedName();
            }
            catch (TownyException e) {
                line = line + "Error: " + e.getMessage();
            }
        }
        out.add(line);
        if (resident.isNPC()) {
            out.add(Translation.of("msg_status_npc", resident.getName()));
            out.addAll(TownyFormatter.getExtraFields(resident));
            out = TownyFormatter.formatStatusScreens(out);
            return out;
        }
        ArrayList<Town> townEmbassies = new ArrayList<Town>();
        try {
            String actualTown = resident.hasTown() ? resident.getTown().getName() : "";
            for (TownBlock tB : resident.getTownBlocks()) {
                if (actualTown.equals(tB.getTown().getName()) || townEmbassies.contains(tB.getTown())) continue;
                townEmbassies.add(tB.getTown());
            }
        }
        catch (NotRegisteredException actualTown) {
            // empty catch block
        }
        if (townEmbassies.size() > 0) {
            out.addAll(TownyFormatter.getFormattedTowns(Translation.of("status_embassy_town"), townEmbassies));
        }
        if (resident.hasTown() && !resident.getTownRanks().isEmpty()) {
            out.add(Translation.of("status_town_ranks") + StringMgmt.capitalize(StringMgmt.join(resident.getTownRanks(), ", ")));
        }
        if (resident.hasNation() && !resident.getNationRanks().isEmpty()) {
            out.add(Translation.of("status_nation_ranks") + StringMgmt.capitalize(StringMgmt.join(resident.getNationRanks(), ", ")));
        }
        if (resident.isJailed()) {
            out.add(Translation.of("jailed_in_town", resident.getJailTown()) + (resident.hasJailDays() ? Translation.of("msg_jailed_for_x_days", resident.getJailDays()) : ""));
        }
        List<Resident> friends = resident.getFriends();
        out.addAll(TownyFormatter.getFormattedResidents(Translation.of("status_friends"), friends));
        out.addAll(TownyFormatter.getExtraFields(resident));
        ResidentStatusScreenEvent event = new ResidentStatusScreenEvent(resident);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.hasAdditionalLines()) {
            out.addAll(event.getAdditionalLines());
        }
        out = TownyFormatter.formatStatusScreens(out);
        return out;
    }

    public static List<String> getRanks(Town town) {
        ArrayList<String> ranklist = new ArrayList<String>();
        String towntitle = town.getFormattedName();
        towntitle = towntitle + Translation.of("rank_list_title");
        ranklist.add(ChatTools.formatTitle(towntitle));
        ranklist.add(Translation.of("rank_list_mayor", town.getMayor().getFormattedName()));
        TownyFormatter.getRanks(town, ranklist);
        return ranklist;
    }

    private static void getRanks(Town town, List<String> ranklist) {
        Collection residents = town.getResidents();
        List<String> townRanks = TownyPerms.getTownRanks();
        ArrayList<Resident> residentWithRank = new ArrayList<Resident>();
        for (String rank : townRanks) {
            for (Resident r : residents) {
                if (r.getTownRanks() == null || !r.getTownRanks().contains(rank)) continue;
                residentWithRank.add(r);
            }
            ranklist.addAll(TownyFormatter.getFormattedResidents(StringMgmt.capitalize(rank), residentWithRank));
            residentWithRank.clear();
        }
    }

    public static List<String> formatStatusScreens(List<String> out) {
        ArrayList<String> formattedOut = new ArrayList<String>();
        for (String line : out) {
            for (String string : ChatPaginator.wordWrap((String)line, (int)Integer.MAX_VALUE)) {
                formattedOut.add(string);
            }
        }
        return formattedOut;
    }

    public static List<String> getStatus(Town town) {
        long registered;
        TownyWorld world;
        List<String> out = new ArrayList<String>();
        try {
            world = town.getHomeblockWorld();
        }
        catch (NullPointerException e) {
            world = TownyUniverse.getInstance().getDataSource().getWorlds().get(0);
        }
        out.add(ChatTools.formatTitle(town.getFormattedName()));
        ArrayList<String> sub = new ArrayList<String>();
        if (!town.isAdminDisabledPVP() && (town.isPVP() || town.getHomeblockWorld().isForcePVP())) {
            sub.add(Translation.of("status_title_pvp"));
        }
        if (town.isOpen()) {
            sub.add(Translation.of("status_title_open"));
        }
        if (town.isPublic()) {
            sub.add(Translation.of("status_public"));
        }
        if (town.isNeutral()) {
            sub.add(Translation.of("status_town_title_peaceful"));
        }
        if (town.isConquered()) {
            sub.add(Translation.of("msg_conquered"));
        }
        if (!sub.isEmpty()) {
            out.add(ChatTools.formatSubTitle(StringMgmt.join(sub, " ")));
        }
        if (!town.getBoard().isEmpty()) {
            try {
                out.add(Translation.of("status_town_board", town.getBoard()));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if ((registered = town.getRegistered()) != 0L) {
            out.add(Translation.of("status_founded", registeredFormat.format(town.getRegistered())));
        }
        try {
            out.add(Translation.of("status_town_size_part_1", town.getTownBlocks().size(), TownySettings.getMaxTownBlocks(town)) + (TownySettings.isSellingBonusBlocks(town) ? Translation.of("status_town_size_part_2", town.getPurchasedBlocks(), TownySettings.getMaxPurchasedBlocks(town)) : "") + (town.getBonusBlocks() > 0 ? Translation.of("status_town_size_part_3", town.getBonusBlocks()) : "") + (TownySettings.getNationBonusBlocks(town) > 0 ? Translation.of("status_town_size_part_4", TownySettings.getNationBonusBlocks(town)) : "") + (town.isPublic() ? Translation.of("status_town_size_part_5") + (TownySettings.getTownDisplaysXYZ() ? (town.hasSpawn() ? BukkitTools.convertCoordtoXYZ(town.getSpawn()) : Translation.of("status_no_town")) + "]" : (town.hasHomeBlock() ? town.getHomeBlock().getCoord().toString() : Translation.of("status_no_town")) + "]") : ""));
        }
        catch (TownyException townyException) {
            // empty catch block
        }
        if (TownySettings.isAllowingOutposts()) {
            if (TownySettings.isOutpostsLimitedByLevels()) {
                if (town.hasOutpostSpawn()) {
                    if (!town.hasNation()) {
                        out.add(Translation.of("status_town_outposts", town.getMaxOutpostSpawn(), town.getOutpostLimit()));
                    } else {
                        int nationBonus = 0;
                        try {
                            nationBonus = (Integer)TownySettings.getNationLevel(town.getNation()).get((Object)TownySettings.NationLevel.NATION_BONUS_OUTPOST_LIMIT);
                        }
                        catch (NotRegisteredException notRegisteredException) {
                            // empty catch block
                        }
                        out.add(Translation.of("status_town_outposts", town.getMaxOutpostSpawn(), town.getOutpostLimit()) + (nationBonus > 0 ? Translation.of("status_town_outposts2", nationBonus) : ""));
                    }
                } else {
                    out.add(Translation.of("status_town_outposts3", town.getOutpostLimit()));
                }
            } else if (town.hasOutpostSpawn()) {
                out.add(Translation.of("status_town_outposts4", town.getMaxOutpostSpawn()));
            }
        }
        out.add(Translation.of("status_perm") + town.getPermissions().getColourString().replace("f", "r"));
        out.add(Translation.of("status_perm") + town.getPermissions().getColourString2().replace("f", "r"));
        out.add(Translation.of("explosions2") + (town.isBANG() || world.isForceExpl() ? Translation.of("status_on") : Translation.of("status_off")) + Translation.of("firespread") + (town.isFire() || world.isForceFire() ? Translation.of("status_on") : Translation.of("status_off")) + Translation.of("mobspawns") + (town.hasMobs() || world.isForceTownMobs() ? Translation.of("status_on") : Translation.of("status_off")));
        if (town.isRuined()) {
            out.add(Translation.of("msg_time_remaining_before_full_removal", TownRuinSettings.getTownRuinsMaxDurationHours() - TownRuinUtil.getTimeSinceRuining(town)));
            if (TownRuinSettings.getTownRuinsReclaimEnabled()) {
                if (TownRuinUtil.getTimeSinceRuining(town) < TownRuinSettings.getTownRuinsMinDurationHours()) {
                    out.add(Translation.of("msg_time_until_reclaim_available", TownRuinSettings.getTownRuinsMinDurationHours() - TownRuinUtil.getTimeSinceRuining(town)));
                } else {
                    out.add(Translation.of("msg_reclaim_available"));
                }
            }
        } else {
            if (TownyEconomyHandler.isActive()) {
                String bankString = "";
                bankString = Translation.of(town.isBankrupt() ? "status_bank_bankrupt" : "status_bank", town.getAccount().getHoldingFormattedBalance());
                if (town.isBankrupt()) {
                    if (town.getAccount().getDebtCap() == 0.0) {
                        town.getAccount().setDebtCap(MoneyUtil.getEstimatedValueOfTown(town));
                    }
                    bankString = bankString + " " + Translation.of("status_debtcap", "-" + TownyEconomyHandler.getFormattedBalance(town.getAccount().getDebtCap()));
                }
                if (town.hasUpkeep()) {
                    bankString = bankString + Translation.of("status_bank_town2", BigDecimal.valueOf(TownySettings.getTownUpkeepCost(town)).setScale(2, RoundingMode.HALF_UP).doubleValue());
                }
                if (TownySettings.getUpkeepPenalty() > 0.0 && town.isOverClaimed()) {
                    bankString = bankString + Translation.of("status_bank_town_penalty_upkeep", TownySettings.getTownPenaltyUpkeepCost(town));
                }
                bankString = bankString + Translation.of("status_bank_town3", town.getTaxes()) + (town.isTaxPercentage() ? "%" : "");
                out.add(bankString);
            }
            if (town.hasNation()) {
                try {
                    out.add(Translation.of("status_town_nation", town.getNation().getFormattedName()));
                }
                catch (TownyException bankString) {
                    // empty catch block
                }
            }
            out.add(Translation.of("rank_list_mayor", town.getMayor().getFormattedName()));
            ArrayList<String> ranklist = new ArrayList<String>();
            TownyFormatter.getRanks(town, ranklist);
            out.addAll(ranklist);
            String[] residents = TownyFormatter.getFormattedNames(town.getResidents().toArray(new Resident[0]));
            if (residents.length > 34) {
                String[] entire = residents;
                residents = new String[36];
                System.arraycopy(entire, 0, residents, 0, 35);
                residents[35] = Translation.of("status_town_reslist_overlength");
            }
            out.addAll(ChatTools.listArr(residents, Translation.of("status_town_reslist", town.getNumResidents())));
        }
        out.addAll(TownyFormatter.getExtraFields(town));
        TownStatusScreenEvent event = new TownStatusScreenEvent(town);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.hasAdditionalLines()) {
            out.addAll(event.getAdditionalLines());
        }
        out = TownyFormatter.formatStatusScreens(out);
        return out;
    }

    public static List<String> getStatus(Nation nation) {
        long registered;
        List<String> out = new ArrayList<String>();
        String title = nation.getFormattedName();
        title = title + (nation.isOpen() ? Translation.of("status_title_open") : "");
        out.add(ChatTools.formatTitle(title));
        if (!nation.getBoard().isEmpty()) {
            try {
                out.add(Translation.of("status_town_board", nation.getBoard()));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if ((registered = nation.getRegistered()) != 0L) {
            out.add(Translation.of("status_founded", registeredFormat.format(nation.getRegistered())));
        }
        String line = "";
        if (TownyEconomyHandler.isActive()) {
            line = Translation.of("status_bank", nation.getAccount().getHoldingFormattedBalance());
            if (TownySettings.getNationUpkeepCost(nation) > 0.0) {
                line = line + Translation.of("status_bank_town2", TownySettings.getNationUpkeepCost(nation));
            }
        }
        if (nation.isNeutral()) {
            if (line.length() > 0) {
                line = line + "\u00a78 | ";
            }
            line = line + Translation.of("status_nation_peaceful");
        }
        if (nation.isPublic()) {
            if (line.length() > 0) {
                line = line + "\u00a78 | ";
            }
            try {
                line = line + (nation.isPublic() ? Translation.of("status_town_size_part_5") + (nation.hasSpawn() ? Coord.parseCoord(nation.getSpawn()).toString() : Translation.of("status_no_town")) + "]" : "");
            }
            catch (TownyException townyException) {
                // empty catch block
            }
        }
        if (line.length() > 0) {
            out.add(line);
        }
        if (nation.getNumTowns() > 0 && nation.hasCapital() && nation.getCapital().hasMayor()) {
            out.add(Translation.of("status_nation_king", nation.getCapital().getMayor().getFormattedName()) + Translation.of("status_nation_tax", nation.getTaxes()));
        }
        ArrayList<String> ranklist = new ArrayList<String>();
        List<Town> towns = nation.getTowns();
        ArrayList residents = new ArrayList();
        for (Town town : towns) {
            residents.addAll(town.getResidents());
        }
        List<String> nationranks = TownyPerms.getNationRanks();
        ArrayList<Resident> residentwithrank = new ArrayList<Resident>();
        for (String rank : nationranks) {
            for (Resident r : residents) {
                if (r.getNationRanks() == null || !r.getNationRanks().contains(rank)) continue;
                residentwithrank.add(r);
            }
            ranklist.addAll(TownyFormatter.getFormattedResidents(StringMgmt.capitalize(rank), residentwithrank));
            residentwithrank.clear();
        }
        out.addAll(ranklist);
        String[] towns2 = TownyFormatter.getFormattedNames(nation.getTowns().toArray(new Town[0]));
        if (towns2.length > 10) {
            String[] entire = towns2;
            towns2 = new String[12];
            System.arraycopy(entire, 0, towns2, 0, 11);
            towns2[11] = Translation.of("status_town_reslist_overlength");
        }
        out.addAll(ChatTools.listArr(towns2, Translation.of("status_nation_towns", nation.getNumTowns())));
        String[] allies = TownyFormatter.getFormattedNames(nation.getAllies().toArray(new Nation[0]));
        if (allies.length > 10) {
            String[] entire = allies;
            allies = new String[12];
            System.arraycopy(entire, 0, allies, 0, 11);
            allies[11] = Translation.of("status_town_reslist_overlength");
        }
        out.addAll(ChatTools.listArr(allies, Translation.of("status_nation_allies", nation.getAllies().size())));
        String[] enemies = TownyFormatter.getFormattedNames(nation.getEnemies().toArray(new Nation[0]));
        if (enemies.length > 10) {
            String[] entire = enemies;
            enemies = new String[12];
            System.arraycopy(entire, 0, enemies, 0, 11);
            enemies[11] = Translation.of("status_town_reslist_overlength");
        }
        out.addAll(ChatTools.listArr(enemies, Translation.of("status_nation_enemies", nation.getEnemies().size())));
        out.addAll(TownyFormatter.getExtraFields(nation));
        NationStatusScreenEvent event = new NationStatusScreenEvent(nation);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.hasAdditionalLines()) {
            out.addAll(event.getAdditionalLines());
        }
        out = TownyFormatter.formatStatusScreens(out);
        return out;
    }

    public static List<String> getStatus(TownyWorld world) {
        List<String> out = new ArrayList<String>();
        String title = world.getFormattedName();
        title = title + (world.isPVP() || world.isForcePVP() ? Translation.of("status_title_pvp") : "");
        title = title + (world.isClaimable() ? Translation.of("status_world_claimable") : Translation.of("status_world_noclaims"));
        out.add(ChatTools.formatTitle(title));
        if (!world.isUsingTowny()) {
            out.add(Translation.of("msg_set_use_towny_off"));
        } else {
            out.add(Translation.of("status_world_forcepvp") + (world.isForcePVP() ? Translation.of("status_on") : Translation.of("status_off")) + "\u00a78" + " | " + Translation.of("status_world_friendlyfire") + (world.isFriendlyFireEnabled() ? Translation.of("status_on") : Translation.of("status_off")));
            out.add(Translation.of("status_world_fire") + (world.isFire() ? Translation.of("status_on") : Translation.of("status_off")) + "\u00a78" + " | " + Translation.of("status_world_forcefire") + (world.isForceFire() ? Translation.of("status_forced") : Translation.of("status_adjustable")));
            out.add(Translation.of("explosions2") + ": " + (world.isExpl() ? Translation.of("status_on") : Translation.of("status_off")) + "\u00a78" + " | " + Translation.of("status_world_forceexplosion") + (world.isForceExpl() ? Translation.of("status_forced") : Translation.of("status_adjustable")));
            out.add(Translation.of("status_world_worldmobs") + (world.hasWorldMobs() ? Translation.of("status_on") : Translation.of("status_off")) + "\u00a78" + " | " + Translation.of("status_world_wildernessmobs") + (world.hasWildernessMobs() ? Translation.of("status_on") : Translation.of("status_off")));
            out.add(Translation.of("status_world_forcetownmobs") + (world.isForceTownMobs() ? Translation.of("status_forced") : Translation.of("status_adjustable")));
            out.add("\u00a72" + (world.isWarAllowed() ? Translation.of("msg_set_war_allowed_on") : Translation.of("msg_set_war_allowed_off")));
            out.add(Translation.of("status_world_unclaimrevert") + (world.isUsingPlotManagementRevert() ? Translation.of("status_on_good") : Translation.of("status_off_bad")));
            out.add(Translation.of("status_world_explrevert_entity") + (world.isUsingPlotManagementWildEntityRevert() ? Translation.of("status_on_good") : Translation.of("status_off_bad")) + "\u00a78" + " | " + Translation.of("status_world_explrevert_block") + (world.isUsingPlotManagementWildBlockRevert() ? Translation.of("status_on_good") : Translation.of("status_off_bad")));
            out.add(Translation.of("status_plot_clear_deletion") + (world.isUsingPlotManagementMayorDelete() ? Translation.of("status_on") + "\u00a7a" + " (see /towny plotclearblocks)" : Translation.of("status_off")));
            out.add("\u00a72" + world.getUnclaimedZoneName() + ":");
            out.add("    " + (world.getUnclaimedZoneBuild() != false ? "\u00a7a" : "\u00a7c") + "Build" + "\u00a78" + ", " + (world.getUnclaimedZoneDestroy() != false ? "\u00a7a" : "\u00a7c") + "Destroy" + "\u00a78" + ", " + (world.getUnclaimedZoneSwitch() != false ? "\u00a7a" : "\u00a7c") + "Switch" + "\u00a78" + ", " + (world.getUnclaimedZoneItemUse() != false ? "\u00a7a" : "\u00a7c") + "ItemUse");
            out.add("    " + Translation.of("status_world_ignoredblocks") + "\u00a7a" + " see /towny wildsblocks");
            out.addAll(TownyFormatter.getExtraFields(world));
        }
        out = TownyFormatter.formatStatusScreens(out);
        return out;
    }

    public static List<String> getTaxStatus(Resident resident) {
        ArrayList<String> out = new ArrayList<String>();
        Town town = null;
        boolean taxExempt = TownyPerms.getResidentPerms(resident).containsKey("towny.tax_exempt");
        double plotTax = 0.0;
        double townTax = 0.0;
        out.add(ChatTools.formatTitle(resident.getFormattedName() + (BukkitTools.isOnline(resident.getName()) ? "\u00a7a (Online)" : "")));
        out.add(Translation.of("owner_of_x_plots", resident.getTownBlocks().size()));
        if (resident.hasTown()) {
            try {
                town = resident.getTown();
                if (taxExempt) {
                    out.add(Translation.of("status_res_taxexempt"));
                } else {
                    townTax = town.isTaxPercentage() ? resident.getAccount().getHoldingBalance() * town.getTaxes() / 100.0 : town.getTaxes();
                    out.add(Translation.of("status_res_tax", TownyEconomyHandler.getFormattedBalance(townTax)));
                }
            }
            catch (NotRegisteredException notRegisteredException) {
            }
            catch (EconomyException economyException) {
                // empty catch block
            }
        }
        if (resident.getTownBlocks().size() > 0) {
            for (TownBlock townBlock : new ArrayList<TownBlock>(resident.getTownBlocks())) {
                try {
                    town = townBlock.getTown();
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
                if (town == null || taxExempt && town.hasResident(resident)) continue;
                plotTax += townBlock.getType().getTax(town);
            }
            out.add(Translation.of("status_res_plottax") + TownyEconomyHandler.getFormattedBalance(plotTax));
        }
        out.add(Translation.of("status_res_totaltax") + TownyEconomyHandler.getFormattedBalance(townTax + plotTax));
        return out;
    }

    @Deprecated
    public static String getFormattedName(TownyObject obj) {
        return obj.getFormattedName();
    }

    @Deprecated
    public static String getFormattedResidentName(Resident resident) {
        return resident.getFormattedName();
    }

    @Deprecated
    public static String getFormattedTownName(Town town) {
        return town.getFormattedName();
    }

    @Deprecated
    public static String getFormattedNationName(Nation nation) {
        return nation.getFormattedName();
    }

    @Deprecated
    public static String getFormattedResidentTitleName(Resident resident) {
        return resident.getFormattedTitleName();
    }

    public static String[] getFormattedNames(TownyObject[] objs) {
        ArrayList<String> names = new ArrayList<String>();
        for (TownyObject obj : objs) {
            names.add(obj.getFormattedName() + "\u00a7f");
        }
        return names.toArray(new String[0]);
    }

    public static List<String> getExtraFields(TownyObject to) {
        if (!to.hasMeta()) {
            return new ArrayList<String>();
        }
        String field = "";
        ArrayList<String> extraFields = new ArrayList<String>();
        for (CustomDataField<?> cdf : to.getMetadata()) {
            String newAdd = "";
            if (!cdf.hasLabel()) continue;
            newAdd = "\u00a72" + cdf.getLabel() + ": ";
            newAdd = newAdd + cdf.displayFormattedValue();
            newAdd = newAdd + "  ";
            if ((field + newAdd).length() > 65) {
                extraFields.add(field);
                field = newAdd;
                continue;
            }
            field = field + newAdd;
        }
        if (!field.isEmpty()) {
            extraFields.add(field);
        }
        return extraFields;
    }

    @Deprecated
    public static String getNamePrefix(Resident resident) {
        return resident.getNamePrefix();
    }

    @Deprecated
    public static String getNamePostfix(Resident resident) {
        return resident.getNamePostfix();
    }
}

