/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownySpigotMessaging;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.invites.Invite;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.ResidentList;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.util.StringMgmt;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class TownyMessaging {
    private static final Logger LOGGER = LogManager.getLogger(Towny.class);
    private static final Logger LOGGER_DEBUG = LogManager.getLogger((String)"com.palmergames.bukkit.towny.debug");

    public static void sendErrorMsg(String msg) {
        LOGGER.warn(ChatTools.stripColour("[Towny] Error: " + msg));
    }

    public static void sendErrorMsg(Object sender, String msg) {
        if (sender != null) {
            CommandSender toSend = (CommandSender)sender;
            if (toSend instanceof ConsoleCommandSender) {
                toSend.sendMessage(ChatColor.stripColor((String)msg));
            } else {
                toSend.sendMessage(Translation.of("default_towny_prefix") + ChatColor.RED + msg);
            }
        } else {
            TownyMessaging.sendErrorMsg("Sender cannot be null!");
        }
        TownyMessaging.sendDevMsg(msg);
    }

    public static void sendErrorMsg(Object sender, String[] msg) {
        for (String line : msg) {
            TownyMessaging.sendErrorMsg(sender, line);
        }
    }

    public static void sendMsg(String msg) {
        LOGGER.info("[Towny] " + ChatTools.stripColour(msg));
    }

    public static void sendMsg(CommandSender sender, String msg) {
        if (sender == null) {
            TownyMessaging.sendErrorMsg("Sender cannot be null!");
            return;
        }
        if (sender instanceof Player) {
            Player p = (Player)sender;
            p.sendMessage(Translation.of("default_towny_prefix") + ChatColor.GREEN + msg);
        } else if (sender instanceof ConsoleCommandSender) {
            sender.sendMessage(ChatColor.stripColor((String)msg));
        } else {
            sender.sendMessage(Translation.of("default_towny_prefix") + ChatColor.GREEN + msg);
        }
        TownyMessaging.sendDevMsg(msg);
    }

    public static void sendMsg(Resident resident, String msg) {
        if (BukkitTools.isOnline(resident.getName())) {
            TownyMessaging.sendMsg((CommandSender)resident.getPlayer(), msg);
        }
    }

    public static void sendMsg(Player player, String[] msg) {
        for (String line : msg) {
            TownyMessaging.sendMsg((CommandSender)player, line);
        }
    }

    public static void sendMsg(Player player, List<String> msg) {
        for (String line : msg) {
            TownyMessaging.sendMsg((CommandSender)player, line);
        }
    }

    public static void sendDevMsg(String msg) {
        if (TownySettings.isDevMode()) {
            Player townyDev = BukkitTools.getPlayer(TownySettings.getDevName());
            if (townyDev == null) {
                return;
            }
            townyDev.sendMessage(Translation.of("default_towny_prefix") + " DevMode: " + ChatColor.RED + msg);
        }
    }

    public static void sendDevMsg(String[] msg) {
        for (String line : msg) {
            TownyMessaging.sendDevMsg(line);
        }
    }

    public static void sendDebugMsg(String msg) {
        if (TownySettings.getDebug()) {
            LOGGER_DEBUG.info(ChatTools.stripColour("[Towny] Debug: " + msg));
        }
        TownyMessaging.sendDevMsg(msg);
    }

    public static void sendMessage(Object sender, List<String> lines) {
        TownyMessaging.sendMessage(sender, lines.toArray(new String[0]));
    }

    public static void sendMessage(Object sender, String line) {
        if (sender instanceof Player) {
            ((Player)sender).sendMessage(line);
        } else if (sender instanceof CommandSender) {
            ((CommandSender)sender).sendMessage(Colors.strip(line));
        } else if (sender instanceof Resident) {
            Player p = TownyAPI.getInstance().getPlayer((Resident)sender);
            if (p == null) {
                return;
            }
            p.sendMessage(Colors.strip(line));
        }
    }

    public static void sendMessage(Object sender, String[] lines) {
        for (String line : lines) {
            TownyMessaging.sendMessage(sender, line);
        }
    }

    @Deprecated
    public static void sendTownMessage(Town town, List<String> lines) {
        TownyMessaging.sendTownMessage(town, lines.toArray(new String[0]));
    }

    @Deprecated
    public static void sendNationMessage(Nation nation, List<String> lines) {
        TownyMessaging.sendNationMessage(nation, lines.toArray(new String[0]));
    }

    public static void sendGlobalMessage(List<String> lines) {
        TownyMessaging.sendGlobalMessage(lines.toArray(new String[0]));
    }

    public static void sendGlobalMessage(String[] lines) {
        for (String line : lines) {
            LOGGER.info(ChatTools.stripColour("[Global Msg] " + line));
        }
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null) continue;
            for (String line : lines) {
                player.sendMessage(Translation.of("default_towny_prefix") + line);
            }
        }
    }

    public static void sendGlobalMessage(String line) {
        LOGGER.info(ChatTools.stripColour("[Global Message] " + line));
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null) continue;
            try {
                if (!TownyUniverse.getInstance().getDataSource().getWorld(player.getLocation().getWorld().getName()).isUsingTowny()) continue;
                player.sendMessage(Translation.of("default_towny_prefix") + line);
            }
            catch (NotRegisteredException e) {
                e.printStackTrace();
            }
        }
    }

    public static void sendPlainGlobalMessage(String line) {
        LOGGER.info(ChatTools.stripColour("[Global Message] " + line));
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null) continue;
            try {
                if (!TownyUniverse.getInstance().getDataSource().getWorld(player.getLocation().getWorld().getName()).isUsingTowny()) continue;
                player.sendMessage(line);
            }
            catch (NotRegisteredException e) {
                e.printStackTrace();
            }
        }
    }

    public static void sendResidentMessage(Resident resident, String line) throws TownyException {
        LOGGER.info(ChatTools.stripColour("[Resident Msg] " + resident.getName() + ": " + line));
        Player player = TownyAPI.getInstance().getPlayer(resident);
        if (player == null) {
            throw new TownyException("Player could not be found!");
        }
        player.sendMessage(Translation.of("default_towny_prefix") + line);
    }

    @Deprecated
    public static void sendTownMessage(Town town, String[] lines) {
        for (String line : lines) {
            LOGGER.info(ChatTools.stripColour("[Town Msg] " + StringMgmt.remUnderscore(town.getName()) + ": " + line));
        }
        for (Player player : TownyAPI.getInstance().getOnlinePlayers(town)) {
            for (String line : lines) {
                player.sendMessage(line);
            }
        }
    }

    @Deprecated
    public static void sendTownMessage(Town town, String line) {
        LOGGER.info(ChatTools.stripColour("[Town Msg] " + StringMgmt.remUnderscore(town.getName()) + ": " + line));
        for (Player player : TownyAPI.getInstance().getOnlinePlayers(town)) {
            player.sendMessage(line);
        }
    }

    public static void sendTownMessagePrefixed(Town town, String line) {
        LOGGER.info(ChatTools.stripColour(line));
        for (Player player : TownyAPI.getInstance().getOnlinePlayers(town)) {
            player.sendMessage(Translation.of("default_towny_prefix") + line);
        }
    }

    public static void sendPrefixedTownMessage(Town town, String line) {
        LOGGER.info(ChatTools.stripColour("[Town Msg] " + StringMgmt.remUnderscore(town.getName()) + ": " + line));
        for (Player player : TownyAPI.getInstance().getOnlinePlayers(town)) {
            player.sendMessage(Translation.of("default_town_prefix", StringMgmt.remUnderscore(town.getName())) + line);
        }
    }

    public static void sendPrefixedTownMessage(Town town, String[] lines) {
        for (String line : lines) {
            LOGGER.info(ChatTools.stripColour(line));
        }
        for (Player player : TownyAPI.getInstance().getOnlinePlayers(town)) {
            for (String line : lines) {
                player.sendMessage(Translation.of("default_town_prefix", StringMgmt.remUnderscore(town.getName())) + line);
            }
        }
    }

    public static void sendPrefixedTownMessage(Town town, List<String> lines) {
        TownyMessaging.sendPrefixedTownMessage(town, lines.toArray(new String[0]));
    }

    @Deprecated
    public static void sendNationMessage(Nation nation, String[] lines) {
        for (String line : lines) {
            LOGGER.info(ChatTools.stripColour("[Nation Msg] " + StringMgmt.remUnderscore(nation.getName()) + ": " + line));
        }
        for (Player player : TownyAPI.getInstance().getOnlinePlayers(nation)) {
            for (String line : lines) {
                player.sendMessage(line);
            }
        }
    }

    @Deprecated
    public static void sendNationMessage(Nation nation, String line) {
        LOGGER.info(ChatTools.stripColour("[Nation Msg] " + StringMgmt.remUnderscore(nation.getName()) + ": " + line));
        for (Player player : TownyAPI.getInstance().getOnlinePlayers(nation)) {
            player.sendMessage(line);
        }
    }

    public static void sendPrefixedNationMessage(Nation nation, String line) {
        LOGGER.info(ChatTools.stripColour("[Nation Msg] " + StringMgmt.remUnderscore(nation.getName()) + ": " + line));
        for (Player player : TownyAPI.getInstance().getOnlinePlayers(nation)) {
            player.sendMessage(Translation.of("default_nation_prefix", StringMgmt.remUnderscore(nation.getName())) + line);
        }
    }

    public static void sendPrefixedNationMessage(Nation nation, List<String> lines) {
        TownyMessaging.sendPrefixedNationMessage(nation, lines.toArray(new String[0]));
    }

    public static void sendPrefixedNationMessage(Nation nation, String[] lines) {
        for (String line : lines) {
            LOGGER.info(ChatTools.stripColour("[Nation Msg] " + StringMgmt.remUnderscore(nation.getName()) + ": " + line));
        }
        for (Player player : TownyAPI.getInstance().getOnlinePlayers(nation)) {
            for (String line : lines) {
                player.sendMessage(Translation.of("default_nation_prefix", StringMgmt.remUnderscore(nation.getName())) + line);
            }
        }
    }

    public static void sendNationMessagePrefixed(Nation nation, String line) {
        LOGGER.info(ChatTools.stripColour("[Nation Msg] " + StringMgmt.remUnderscore(nation.getName()) + ": " + line));
        for (Player player : TownyAPI.getInstance().getOnlinePlayers(nation)) {
            player.sendMessage(Translation.of("default_towny_prefix") + line);
        }
    }

    public static void sendNationMessagePrefixed(Nation nation, List<String> lines) {
        for (String line : lines) {
            LOGGER.info(ChatTools.stripColour("[Nation Msg] " + StringMgmt.remUnderscore(nation.getName()) + ": " + line));
        }
        for (Player player : TownyAPI.getInstance().getOnlinePlayers(nation)) {
            for (String line : lines) {
                player.sendMessage(Translation.of("default_towny_prefix") + line);
            }
        }
    }

    public static void sendTownBoard(Player player, Town town) {
        String tbColor1 = Translation.of("townboard_message_colour_1");
        String tbColor2 = Translation.of("townboard_message_colour_2");
        player.sendMessage(tbColor1 + "[" + StringMgmt.remUnderscore(town.getName()) + "] " + tbColor2 + town.getBoard());
    }

    public static void sendNationBoard(Player player, Nation nation) {
        String nbColor1 = Translation.of("nationboard_message_colour_1");
        String nbColor2 = Translation.of("nationboard_message_colour_2");
        player.sendMessage(nbColor1 + "[" + StringMgmt.remUnderscore(nation.getName()) + "] " + nbColor2 + nation.getBoard());
    }

    public static void sendMessageToMode(ResidentList residents, String msg, String modeRequired) {
        for (Resident resident : TownyAPI.getInstance().getOnlineResidents(residents)) {
            if (!resident.hasMode(modeRequired)) continue;
            TownyMessaging.sendMessage((Object)resident, msg);
        }
    }

    public static void sendMessageToMode(Town town, String msg, String modeRequired) {
        for (Resident resident : town.getResidents()) {
            if (!BukkitTools.isOnline(resident.getName())) continue;
            TownyMessaging.sendMessage((Object)resident, msg);
        }
    }

    public static void sendMessageToMode(Nation nation, String msg, String modeRequired) {
        for (Resident resident : nation.getResidents()) {
            if (!BukkitTools.isOnline(resident.getName())) continue;
            TownyMessaging.sendMessage((Object)resident, msg);
        }
    }

    public static void sendTitleMessageToResident(Resident resident, String title, String subtitle) {
        Player player = TownyAPI.getInstance().getPlayer(resident);
        if (player == null) {
            return;
        }
        player.sendTitle(title, subtitle, 10, 70, 10);
    }

    public static void sendTitleMessageToTown(Town town, String title, String subtitle) {
        for (Player player : TownyAPI.getInstance().getOnlinePlayers(town)) {
            player.sendTitle(title, subtitle, 10, 70, 10);
        }
    }

    public static void sendTitleMessageToNation(Nation nation, String title, String subtitle) {
        for (Player player : TownyAPI.getInstance().getOnlinePlayers(nation)) {
            player.sendTitle(title, subtitle, 10, 70, 10);
        }
    }

    public static void sendConfirmationMessage(CommandSender sender, String firstline, String confirmline, String cancelline, String lastline) {
        if (Towny.isSpigot && sender instanceof Player) {
            TownySpigotMessaging.sendSpigotConfirmMessage(sender, firstline, confirmline, cancelline, lastline);
            return;
        }
        if (firstline == null) {
            firstline = Translation.of("confirmation_prefix") + Translation.of("are_you_sure_you_want_to_continue");
        }
        if (confirmline == null) {
            confirmline = ChatColor.GREEN + "          /" + TownySettings.getConfirmCommand();
        }
        if (cancelline == null) {
            cancelline = ChatColor.GREEN + "          /" + TownySettings.getCancelCommand();
        }
        if (lastline != null && lastline.equals("")) {
            String[] message = new String[]{firstline, confirmline, cancelline};
            TownyMessaging.sendMessage((Object)sender, message);
            return;
        }
        if (lastline == null) {
            lastline = Translation.of("this_message_will_expire2");
            String[] message = new String[]{firstline, confirmline, cancelline, lastline};
            TownyMessaging.sendMessage((Object)sender, message);
        }
    }

    public static void sendRequestMessage(CommandSender player, Invite invite) {
        String thirdline;
        String secondline;
        String firstline;
        if (Towny.isSpigot) {
            TownySpigotMessaging.sendSpigotRequestMessage(player, invite);
            return;
        }
        if (invite.getSender() instanceof Town) {
            firstline = Translation.of("invitation_prefix") + Translation.of("you_have_been_invited_to_join2", invite.getSender().getName());
            secondline = ChatColor.GREEN + "          /" + TownySettings.getAcceptCommand() + " " + invite.getSender().getName();
            thirdline = ChatColor.GREEN + "          /" + TownySettings.getDenyCommand() + " " + invite.getSender().getName();
            TownyMessaging.sendConfirmationMessage(player, firstline, secondline, thirdline, "");
        }
        if (invite.getSender() instanceof Nation) {
            if (invite.getReceiver() instanceof Town) {
                firstline = Translation.of("invitation_prefix") + Translation.of("you_have_been_invited_to_join2", invite.getSender().getName());
                secondline = ChatColor.GREEN + "          /t invite accept " + invite.getSender().getName();
                thirdline = ChatColor.GREEN + "          /t invite deny " + invite.getSender().getName();
                TownyMessaging.sendConfirmationMessage(player, firstline, secondline, thirdline, "");
            }
            if (invite.getReceiver() instanceof Nation) {
                firstline = Translation.of("invitation_prefix") + Translation.of("you_have_been_requested_to_ally2", invite.getSender().getName());
                secondline = ChatColor.GREEN + "          /n ally accept " + invite.getSender().getName();
                thirdline = ChatColor.GREEN + "          /n ally deny " + invite.getSender().getName();
                TownyMessaging.sendConfirmationMessage(player, firstline, secondline, thirdline, "");
            }
        }
    }

    @Deprecated
    public static void sendMsg(Object object, String message) {
        TownyMessaging.sendMsg((CommandSender)object, message);
    }
}

