/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.util.StringMgmt;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Player;

public class TownyPlaceholderExpansion
extends PlaceholderExpansion {
    final String nomad = Translation.of("nomad_sing");
    final String res = Translation.of("res_sing");
    final String mayor = Translation.of("mayor_sing");
    final String king = Translation.of("king_sing");
    private final Towny plugin;

    public TownyPlaceholderExpansion(Towny plugin) {
        this.plugin = plugin;
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    public String getAuthor() {
        return this.plugin.getDescription().getAuthors().toString();
    }

    public String getIdentifier() {
        return "townyadvanced";
    }

    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public String onPlaceholderRequest(Player player, String identifier) {
        if (player == null) {
            return "";
        }
        Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
        if (resident == null) {
            return null;
        }
        TownBlock townblock = TownyAPI.getInstance().getTownBlock(player.getLocation());
        String town = "";
        String nation = "";
        String balance = "";
        String tag = "";
        String title = "";
        String amount = "";
        String name = "";
        String rank = "";
        String hex = "";
        Double cost = 0.0;
        switch (identifier) {
            case "town": {
                try {
                    town = String.format(TownySettings.getPAPIFormattingTown(), resident.getTown().getName());
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
                return StringMgmt.remUnderscore(town);
            }
            case "town_formatted": {
                try {
                    town = String.format(TownySettings.getPAPIFormattingTown(), resident.getTown().getFormattedName());
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
                return StringMgmt.remUnderscore(town);
            }
            case "nation": {
                try {
                    nation = String.format(TownySettings.getPAPIFormattingNation(), resident.getTown().getNation().getName());
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
                return StringMgmt.remUnderscore(nation);
            }
            case "nation_formatted": {
                try {
                    nation = String.format(TownySettings.getPAPIFormattingNation(), resident.getTown().getNation().getFormattedName());
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
                return StringMgmt.remUnderscore(nation);
            }
            case "town_balance": {
                try {
                    if (TownyEconomyHandler.isActive()) {
                        balance = TownyEconomyHandler.getFormattedBalance(resident.getTown().getAccount().getCachedBalance());
                    }
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
                return balance;
            }
            case "nation_balance": {
                try {
                    if (TownyEconomyHandler.isActive()) {
                        balance = TownyEconomyHandler.getFormattedBalance(resident.getTown().getNation().getAccount().getCachedBalance());
                    }
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
                return balance;
            }
            case "town_tag": {
                try {
                    tag = String.format(TownySettings.getPAPIFormattingTown(), resident.getTown().getTag());
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
                return tag;
            }
            case "town_tag_override": {
                try {
                    tag = resident.getTown().hasTag() ? String.format(TownySettings.getPAPIFormattingTown(), resident.getTown().getTag()) : StringMgmt.remUnderscore(String.format(TownySettings.getPAPIFormattingTown(), resident.getTown().getName()));
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
                return tag;
            }
            case "nation_tag": {
                try {
                    tag = String.format(TownySettings.getPAPIFormattingNation(), resident.getTown().getNation().getTag());
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
                return tag;
            }
            case "nation_tag_override": {
                try {
                    tag = resident.getTown().getNation().hasTag() ? String.format(TownySettings.getPAPIFormattingNation(), resident.getTown().getNation().getTag()) : StringMgmt.remUnderscore(String.format(TownySettings.getPAPIFormattingNation(), resident.getTown().getNation().getName()));
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
                return tag;
            }
            case "towny_tag": {
                try {
                    if (resident.hasTown()) {
                        if (resident.getTown().hasTag()) {
                            town = resident.getTown().getTag();
                        }
                        if (resident.getTown().hasNation() && resident.getTown().getNation().hasTag()) {
                            nation = resident.getTown().getNation().getTag();
                        }
                    }
                    if (!nation.isEmpty()) {
                        tag = TownySettings.getPAPIFormattingBoth().replace("%t", town).replace("%n", nation);
                    } else if (!town.isEmpty()) {
                        tag = String.format(TownySettings.getPAPIFormattingTown(), town);
                    }
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
                return tag;
            }
            case "towny_formatted": {
                try {
                    if (resident.hasTown()) {
                        town = resident.getTown().getFormattedName();
                        if (resident.getTown().hasNation()) {
                            nation = resident.getTown().getNation().getFormattedName();
                        }
                    }
                    if (!nation.isEmpty()) {
                        tag = TownySettings.getPAPIFormattingBoth().replace("%t", town).replace("%n", nation);
                    } else if (!town.isEmpty()) {
                        tag = String.format(TownySettings.getPAPIFormattingTown(), town);
                    }
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
                return tag;
            }
            case "towny_tag_formatted": {
                try {
                    if (resident.hasTown()) {
                        town = resident.getTown().hasTag() ? resident.getTown().getTag() : resident.getTown().getFormattedName();
                        if (resident.getTown().hasNation()) {
                            nation = resident.getTown().getNation().hasTag() ? resident.getTown().getNation().getTag() : resident.getTown().getNation().getFormattedName();
                        }
                    }
                    if (!nation.isEmpty()) {
                        tag = TownySettings.getPAPIFormattingBoth().replace("%t", town).replace("%n", nation);
                    } else if (!town.isEmpty()) {
                        tag = String.format(TownySettings.getPAPIFormattingTown(), town);
                    }
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
                return tag;
            }
            case "towny_tag_override": {
                try {
                    if (resident.hasTown()) {
                        town = resident.getTown().hasTag() ? resident.getTown().getTag() : StringMgmt.remUnderscore(resident.getTown().getName());
                        if (resident.getTown().hasNation()) {
                            if (resident.getTown().getNation().hasTag()) {
                                nation = resident.getTown().getNation().getTag();
                            } else {
                                nation = resident.getTown().getNation().getName();
                                StringMgmt.remUnderscore(nation);
                            }
                        }
                    }
                    if (!nation.isEmpty()) {
                        tag = TownySettings.getPAPIFormattingBoth().replace("%t", town).replace("%n", nation);
                    } else if (!town.isEmpty()) {
                        tag = String.format(TownySettings.getPAPIFormattingTown(), town);
                    }
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
                return tag;
            }
            case "title": {
                if (resident.hasTitle()) {
                    title = resident.getTitle();
                }
                return title;
            }
            case "surname": {
                if (resident.hasSurname()) {
                    title = resident.getSurname();
                }
                return title;
            }
            case "towny_name_prefix": {
                if (resident.isMayor()) {
                    title = TownySettings.getMayorPrefix(resident);
                }
                if (resident.isKing()) {
                    title = TownySettings.getKingPrefix(resident);
                }
                return title;
            }
            case "towny_name_postfix": {
                if (resident.isMayor()) {
                    title = TownySettings.getMayorPostfix(resident);
                }
                if (resident.isKing()) {
                    title = TownySettings.getKingPostfix(resident);
                }
                return title;
            }
            case "towny_prefix": {
                if (resident.hasTitle()) {
                    title = resident.getTitle() + " ";
                } else {
                    if (resident.isMayor()) {
                        title = TownySettings.getMayorPrefix(resident);
                    }
                    if (resident.isKing()) {
                        title = TownySettings.getKingPrefix(resident);
                    }
                }
                return title;
            }
            case "towny_postfix": {
                if (resident.hasSurname()) {
                    title = " " + resident.getSurname();
                } else {
                    if (resident.isMayor()) {
                        title = TownySettings.getMayorPostfix(resident);
                    }
                    if (resident.isKing()) {
                        title = TownySettings.getKingPostfix(resident);
                    }
                }
                return title;
            }
            case "towny_colour": {
                String colour = "";
                if (!resident.hasTown()) {
                    colour = TownySettings.getPAPIFormattingNomad();
                } else {
                    colour = TownySettings.getPAPIFormattingResident();
                    if (resident.isMayor()) {
                        colour = TownySettings.getPAPIFormattingMayor();
                    }
                    if (resident.isKing()) {
                        colour = TownySettings.getPAPIFormattingKing();
                    }
                }
                return colour;
            }
            case "town_residents_amount": {
                if (resident.hasTown()) {
                    try {
                        amount = String.valueOf(resident.getTown().getNumResidents());
                    }
                    catch (NotRegisteredException notRegisteredException) {
                        // empty catch block
                    }
                }
                return amount;
            }
            case "town_residents_online": {
                if (resident.hasTown()) {
                    try {
                        amount = String.valueOf(TownyAPI.getInstance().getOnlinePlayers(resident.getTown()).size());
                    }
                    catch (NotRegisteredException notRegisteredException) {
                        // empty catch block
                    }
                }
                return amount;
            }
            case "town_townblocks_used": {
                if (resident.hasTown()) {
                    try {
                        amount = String.valueOf(resident.getTown().getTownBlocks().size());
                    }
                    catch (NotRegisteredException notRegisteredException) {
                        // empty catch block
                    }
                }
                return amount;
            }
            case "town_townblocks_bought": {
                if (resident.hasTown()) {
                    try {
                        amount = String.valueOf(resident.getTown().getPurchasedBlocks());
                    }
                    catch (NotRegisteredException notRegisteredException) {
                        // empty catch block
                    }
                }
                return amount;
            }
            case "town_townblocks_bonus": {
                if (resident.hasTown()) {
                    try {
                        amount = String.valueOf(resident.getTown().getBonusBlocks());
                    }
                    catch (NotRegisteredException notRegisteredException) {
                        // empty catch block
                    }
                }
                return amount;
            }
            case "town_townblocks_maximum": {
                if (resident.hasTown()) {
                    try {
                        amount = String.valueOf(TownySettings.getMaxTownBlocks(resident.getTown()));
                    }
                    catch (NotRegisteredException notRegisteredException) {
                        // empty catch block
                    }
                }
                return amount;
            }
            case "town_townblocks_natural_maximum": {
                if (resident.hasTown()) {
                    try {
                        amount = String.valueOf(TownySettings.getMaxTownBlocks(resident.getTown()) - resident.getTown().getBonusBlocks() - resident.getTown().getPurchasedBlocks());
                    }
                    catch (NotRegisteredException notRegisteredException) {
                        // empty catch block
                    }
                }
                return amount;
            }
            case "town_mayor": {
                if (resident.hasTown()) {
                    try {
                        name = resident.getTown().getMayor().getName();
                    }
                    catch (NotRegisteredException notRegisteredException) {
                        // empty catch block
                    }
                }
                return name;
            }
            case "nation_king": {
                if (resident.hasTown()) {
                    try {
                        if (resident.getTown().hasNation()) {
                            name = resident.getTown().getNation().getKing().getName();
                        }
                    }
                    catch (NotRegisteredException notRegisteredException) {
                        // empty catch block
                    }
                }
                return name;
            }
            case "resident_friends_amount": {
                amount = String.valueOf(resident.getFriends().size());
                return amount;
            }
            case "nation_residents_amount": {
                if (resident.hasTown()) {
                    try {
                        if (resident.getTown().hasNation()) {
                            amount = String.valueOf(resident.getTown().getNation().getNumResidents());
                        }
                    }
                    catch (NotRegisteredException notRegisteredException) {
                        // empty catch block
                    }
                }
                return amount;
            }
            case "nation_residents_online": {
                if (resident.hasTown()) {
                    try {
                        if (resident.getTown().hasNation()) {
                            amount = String.valueOf(TownyAPI.getInstance().getOnlinePlayers(resident.getTown().getNation()).size());
                        }
                    }
                    catch (NotRegisteredException notRegisteredException) {
                        // empty catch block
                    }
                }
                return amount;
            }
            case "nation_capital": {
                if (resident.hasTown()) {
                    try {
                        if (resident.getTown().hasNation()) {
                            name = StringMgmt.remUnderscore(resident.getTown().getNation().getCapital().getName());
                        }
                    }
                    catch (NotRegisteredException notRegisteredException) {
                        // empty catch block
                    }
                }
                return name;
            }
            case "daily_town_upkeep": {
                if (resident.hasTown()) {
                    try {
                        cost = TownySettings.getTownUpkeepCost(resident.getTown());
                    }
                    catch (NotRegisteredException notRegisteredException) {
                        // empty catch block
                    }
                }
                return String.valueOf(cost);
            }
            case "daily_nation_upkeep": {
                if (resident.hasTown()) {
                    try {
                        if (resident.getTown().hasNation()) {
                            cost = TownySettings.getNationUpkeepCost(resident.getTown().getNation());
                        }
                    }
                    catch (NotRegisteredException notRegisteredException) {
                        // empty catch block
                    }
                }
                return String.valueOf(cost);
            }
            case "daily_town_tax": {
                boolean percentage = false;
                if (resident.hasTown()) {
                    try {
                        cost = resident.getTown().getTaxes();
                        percentage = resident.getTown().isTaxPercentage();
                    }
                    catch (NotRegisteredException notRegisteredException) {
                        // empty catch block
                    }
                }
                return String.valueOf(cost) + (percentage ? "%" : "");
            }
            case "daily_nation_tax": {
                if (resident.hasTown()) {
                    try {
                        if (resident.getTown().hasNation()) {
                            cost = resident.getTown().getNation().getTaxes();
                        }
                    }
                    catch (NotRegisteredException notRegisteredException) {
                        // empty catch block
                    }
                }
                return String.valueOf(cost);
            }
            case "has_town": {
                return String.valueOf(resident.hasTown());
            }
            case "has_nation": {
                return String.valueOf(resident.hasNation());
            }
            case "nation_tag_town_formatted": {
                try {
                    if (resident.hasTown()) {
                        town = resident.getTown().getFormattedName();
                        if (resident.getTown().hasNation() && resident.getTown().getNation().hasTag()) {
                            nation = resident.getTown().getNation().getTag();
                        }
                    }
                    if (!nation.isEmpty()) {
                        tag = TownySettings.getPAPIFormattingBoth().replace("%t", town).replace("%n", nation);
                    } else if (!town.isEmpty()) {
                        tag = String.format(TownySettings.getPAPIFormattingTown(), town);
                    }
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
                return tag;
            }
            case "nation_tag_town_name": {
                try {
                    if (resident.hasTown()) {
                        town = resident.getTown().getName();
                        if (resident.getTown().hasNation() && resident.getTown().getNation().hasTag()) {
                            nation = resident.getTown().getNation().getTag();
                        }
                    }
                    if (!nation.isEmpty()) {
                        tag = TownySettings.getPAPIFormattingBoth().replace("%t", town).replace("%n", nation);
                    } else if (!town.isEmpty()) {
                        tag = String.format(TownySettings.getPAPIFormattingTown(), town);
                    }
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
                return tag;
            }
            case "nation_map_color_hex": {
                if (resident.hasTown()) {
                    try {
                        if (resident.getTown().hasNation() && !(hex = resident.getTown().getNation().getMapColorHexCode()).isEmpty()) {
                            hex = "#" + hex;
                        }
                    }
                    catch (NotRegisteredException notRegisteredException) {
                        // empty catch block
                    }
                }
                return hex;
            }
            case "town_ranks": {
                if (resident.isMayor()) {
                    rank = Translation.of("mayor_sing");
                } else if (!resident.getTownRanks().isEmpty()) {
                    rank = StringMgmt.capitalize(StringMgmt.join(resident.getTownRanks(), ", "));
                }
                return rank;
            }
            case "nation_ranks": {
                if (resident.isKing()) {
                    rank = Translation.of("king_sing");
                } else if (!resident.getNationRanks().isEmpty()) {
                    rank = StringMgmt.capitalize(StringMgmt.join(resident.getNationRanks(), ", "));
                }
                return rank;
            }
            case "player_status": {
                tag = !resident.hasTown() ? this.nomad : (resident.isKing() ? this.king : (resident.isMayor() ? this.mayor : this.res));
                return tag;
            }
            case "town_prefix": {
                try {
                    return resident.hasTown() ? TownySettings.getTownPrefix(resident.getTown()) : "";
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
            }
            case "town_postfix": {
                try {
                    return resident.hasTown() ? TownySettings.getTownPostfix(resident.getTown()) : "";
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
            }
            case "nation_prefix": {
                try {
                    return resident.hasNation() ? TownySettings.getNationPrefix(resident.getTown().getNation()) : "";
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
            }
            case "nation_postfix": {
                try {
                    return resident.hasNation() ? TownySettings.getNationPostfix(resident.getTown().getNation()) : "";
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
            }
            case "player_jailed": {
                return String.valueOf(resident.isJailed());
            }
            case "player_plot_type": {
                return townblock != null ? townblock.getType().toString() : "";
            }
            case "player_plot_owner": {
                return townblock != null ? String.valueOf(townblock.isOwner(resident)) : "false";
            }
            case "player_location_town_or_wildname": {
                try {
                    return townblock != null ? townblock.getTown().getName() : TownyAPI.getInstance().getDataSource().getWorld(player.getWorld().getName()).getUnclaimedZoneName();
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
            }
            case "player_location_formattedtown_or_wildname": {
                try {
                    return townblock != null ? townblock.getTown().getFormattedName() : TownyAPI.getInstance().getDataSource().getWorld(player.getWorld().getName()).getUnclaimedZoneName();
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
            }
            case "player_location_town_prefix": {
                try {
                    return townblock != null ? townblock.getTown().getPrefix() : "";
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
            }
            case "player_location_town_postfix": {
                try {
                    return townblock != null ? townblock.getTown().getPostfix() : "";
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
            }
            case "player_location_pvp": {
                try {
                    return townblock != null ? (townblock.getPermissions().pvp ? Translation.of("status_title_pvp") : "") : (TownyAPI.getInstance().getDataSource().getWorld(player.getWorld().getName()).isPVP() ? Translation.of("status_title_pvp") : "");
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

