/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.invites.Invite;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.comparators.ComparatorType;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.util.StringMgmt;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TownySpigotMessaging {
    private static HoverCompatibilityWrapper adaptForHover(TextComponent base) {
        return new HoverCompatibilityWrapper(base);
    }

    public static void sendSpigotRequestMessage(CommandSender player, Invite invite) {
        String thirdline;
        String secondline;
        String firstline;
        if (invite.getSender() instanceof Town) {
            firstline = Translation.of("invitation_prefix") + Translation.of("you_have_been_invited_to_join2", invite.getSender().getName());
            secondline = "/" + TownySettings.getAcceptCommand() + " " + invite.getSender().getName();
            thirdline = "/" + TownySettings.getDenyCommand() + " " + invite.getSender().getName();
            TownySpigotMessaging.sendSpigotConfirmMessage(player, firstline, secondline, thirdline, "");
        }
        if (invite.getSender() instanceof Nation) {
            if (invite.getReceiver() instanceof Town) {
                firstline = Translation.of("invitation_prefix") + Translation.of("you_have_been_invited_to_join2", invite.getSender().getName());
                secondline = "/t invite accept " + invite.getSender().getName();
                thirdline = "/t invite deny " + invite.getSender().getName();
                TownySpigotMessaging.sendSpigotConfirmMessage(player, firstline, secondline, thirdline, "");
            }
            if (invite.getReceiver() instanceof Nation) {
                firstline = Translation.of("invitation_prefix") + Translation.of("you_have_been_requested_to_ally2", invite.getSender().getName());
                secondline = "/n ally accept " + invite.getSender().getName();
                thirdline = "/n ally deny " + invite.getSender().getName();
                TownySpigotMessaging.sendSpigotConfirmMessage(player, firstline, secondline, thirdline, "");
            }
        }
    }

    public static void sendSpigotConfirmMessage(CommandSender player, String firstline, String confirmline, String cancelline, String lastline) {
        if (firstline == null) {
            firstline = Translation.of("confirmation_prefix") + Translation.of("are_you_sure_you_want_to_continue");
        }
        if (confirmline == null) {
            confirmline = "/" + TownySettings.getConfirmCommand();
        }
        if (cancelline == null) {
            cancelline = "/" + TownySettings.getCancelCommand();
        }
        lastline = lastline == null ? Translation.of("this_message_will_expire2") : "";
        TextComponent confirmComponent = new TextComponent(ChatColor.GREEN + confirmline.replace('/', '[').concat("]"));
        TownySpigotMessaging.adaptForHover(confirmComponent).setHoverText(Translation.of("msg_confirmation_spigot_hover_accept"));
        confirmComponent.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/towny:" + confirmline.replace("/", "")));
        TextComponent cancelComponent = new TextComponent(ChatColor.GREEN + cancelline.replace('/', '[').concat("]"));
        TownySpigotMessaging.adaptForHover(cancelComponent).setHoverText(Translation.of("msg_confirmation_spigot_hover_cancel"));
        cancelComponent.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/towny:" + cancelline.replace("/", "")));
        player.spigot().sendMessage(new ComponentBuilder(firstline + "\n").append((BaseComponent)confirmComponent).append(ChatColor.WHITE + " - " + Translation.of("msg_confirmation_spigot_click_accept", confirmline.replace('/', '[').replace("[", ""), confirmline) + "\n").append((BaseComponent)cancelComponent).append(ChatColor.WHITE + " - " + Translation.of("msg_confirmation_spigot_click_cancel", cancelline.replace('/', '['), cancelline).replace("[", "") + "\n").append(lastline).create());
    }

    public static void sendSpigotTownList(CommandSender sender, List<Town> towns, ComparatorType compType, int page, int total) {
        int iMax = Math.min(page * 10, towns.size());
        BaseComponent[] townsformatted = page * 10 > towns.size() ? new BaseComponent[towns.size() % 10] : new BaseComponent[10];
        for (int i = (page - 1) * 10; i < iMax; ++i) {
            Town town = towns.get(i);
            TextComponent townName = new TextComponent("\u00a7b" + StringMgmt.remUnderscore(town.getName()));
            String slug = null;
            switch (compType) {
                case BALANCE: {
                    slug = "\u00a7b(" + TownyEconomyHandler.getFormattedBalance(town.getAccount().getCachedBalance()) + ")";
                    break;
                }
                case TOWNBLOCKS: {
                    slug = "\u00a7b(" + town.getTownBlocks().size() + ")";
                    break;
                }
                case RUINED: {
                    slug = "\u00a7b(" + town.getResidents().size() + ") " + (town.isRuined() ? Translation.of("msg_ruined") : "");
                    break;
                }
                case BANKRUPT: {
                    slug = "\u00a7b(" + town.getResidents().size() + ") " + (town.isBankrupt() ? Translation.of("msg_bankrupt") : "");
                    break;
                }
                default: {
                    slug = "\u00a7b(" + town.getResidents().size() + ")";
                }
            }
            townName.addExtra((BaseComponent)new TextComponent("\u00a78 - " + slug));
            if (town.isOpen()) {
                townName.addExtra((BaseComponent)new TextComponent(" \u00a7b" + Translation.of("status_title_open")));
            }
            String spawnCost = "Free";
            if (TownyEconomyHandler.isActive()) {
                spawnCost = ChatColor.RESET + Translation.of("msg_spawn_cost", TownyEconomyHandler.getFormattedBalance(town.getSpawnCost()));
            }
            TownySpigotMessaging.adaptForHover(townName).setHoverText("\u00a76" + Translation.of("msg_click_spawn", town) + "\n" + spawnCost);
            townName.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/towny:town spawn " + town + " -ignore"));
            townsformatted[i % 10] = townName;
        }
        sender.sendMessage(ChatTools.formatTitle(Translation.of("town_plu")));
        sender.sendMessage("\u00a73" + Translation.of("town_name") + (TownySettings.isTownListRandom() ? "" : "\u00a78 - \u00a7b" + Translation.of(compType.getName())));
        for (BaseComponent baseComponent : townsformatted) {
            sender.spigot().sendMessage(baseComponent);
        }
        TextComponent pageFooter = TownySpigotMessaging.getPageNavigationFooter("towny:town", page, compType.getCommandString(), total);
        sender.spigot().sendMessage((BaseComponent)pageFooter);
    }

    public static TextComponent getPageNavigationFooter(String prefix, int page, String arg, int total) {
        TextComponent backButton = new TextComponent("<<<");
        backButton.setColor(net.md_5.bungee.api.ChatColor.GOLD);
        backButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + prefix + " list " + (arg.isEmpty() ? "" : arg + " ") + (page - 1)));
        TownySpigotMessaging.adaptForHover(backButton).setHoverText(Translation.of("msg_hover_previous_page"));
        TextComponent forwardButton = new TextComponent(">>>");
        forwardButton.setColor(net.md_5.bungee.api.ChatColor.GOLD);
        forwardButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + prefix + " list " + (arg.isEmpty() ? "" : arg + " ") + (page + 1)));
        TownySpigotMessaging.adaptForHover(forwardButton).setHoverText(Translation.of("msg_hover_next_page"));
        TextComponent pageText = new TextComponent("   " + Translation.of("LIST_PAGE", page, total) + "   ");
        TextComponent pageFooter = new TextComponent();
        if (page < total && page > 1) {
            pageFooter.addExtra((BaseComponent)backButton);
            pageFooter.addExtra((BaseComponent)pageText);
            pageFooter.addExtra((BaseComponent)forwardButton);
        } else if (page == 1 && page == total) {
            backButton.setClickEvent(null);
            backButton.setHoverEvent(null);
            backButton.setColor(net.md_5.bungee.api.ChatColor.DARK_GRAY);
            forwardButton.setClickEvent(null);
            forwardButton.setHoverEvent(null);
            forwardButton.setColor(net.md_5.bungee.api.ChatColor.DARK_GRAY);
            pageFooter.addExtra((BaseComponent)backButton);
            pageFooter.addExtra((BaseComponent)pageText);
            pageFooter.addExtra((BaseComponent)forwardButton);
        } else if (page == 1) {
            backButton.setClickEvent(null);
            backButton.setHoverEvent(null);
            backButton.setColor(net.md_5.bungee.api.ChatColor.DARK_GRAY);
            pageFooter.addExtra((BaseComponent)backButton);
            pageFooter.addExtra((BaseComponent)pageText);
            pageFooter.addExtra((BaseComponent)forwardButton);
        } else if (page == total) {
            forwardButton.setClickEvent(null);
            forwardButton.setHoverEvent(null);
            forwardButton.setColor(net.md_5.bungee.api.ChatColor.DARK_GRAY);
            pageFooter.addExtra((BaseComponent)backButton);
            pageFooter.addExtra((BaseComponent)pageText);
            pageFooter.addExtra((BaseComponent)forwardButton);
        }
        return pageFooter;
    }

    public static void sendSpigotNationList(CommandSender sender, List<Nation> nations, ComparatorType compType, int page, int total) {
        int iMax = Math.min(page * 10, nations.size());
        BaseComponent[] nationsformatted = page * 10 > nations.size() ? new BaseComponent[nations.size() % 10] : new BaseComponent[10];
        for (int i = (page - 1) * 10; i < iMax; ++i) {
            Nation nation = nations.get(i);
            TextComponent nationName = new TextComponent("\u00a7b" + StringMgmt.remUnderscore(nation.getName()));
            String slug = null;
            switch (compType) {
                case BALANCE: {
                    slug = TownyEconomyHandler.getFormattedBalance(nation.getAccount().getCachedBalance());
                    break;
                }
                case TOWNBLOCKS: {
                    slug = nation.getTownBlocks().size() + "";
                    break;
                }
                case TOWNS: {
                    slug = nation.getTowns().size() + "";
                    break;
                }
                default: {
                    slug = nation.getResidents().size() + "";
                }
            }
            nationName.addExtra((BaseComponent)new TextComponent("\u00a78 - \u00a7b(" + slug + ")"));
            if (nation.isOpen()) {
                nationName.addExtra((BaseComponent)new TextComponent(" \u00a7b" + Translation.of("status_title_open")));
            }
            String spawnCost = "Free";
            if (TownyEconomyHandler.isActive()) {
                spawnCost = ChatColor.RESET + Translation.of("msg_spawn_cost", TownyEconomyHandler.getFormattedBalance(nation.getSpawnCost()));
            }
            TownySpigotMessaging.adaptForHover(nationName).setHoverText("\u00a76" + Translation.of("msg_click_spawn", nation) + "\n" + spawnCost);
            nationName.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/towny:nation spawn " + nation + " -ignore"));
            nationsformatted[i % 10] = nationName;
        }
        sender.sendMessage(ChatTools.formatTitle(Translation.of("nation_plu")));
        sender.sendMessage("\u00a73" + Translation.of("nation_name") + "\u00a78" + " - " + "\u00a7b" + Translation.of(compType.getName()));
        for (BaseComponent baseComponent : nationsformatted) {
            sender.spigot().sendMessage(baseComponent);
        }
        TextComponent pageFooter = TownySpigotMessaging.getPageNavigationFooter("towny:nation", page, compType.getCommandString(), total);
        sender.spigot().sendMessage((BaseComponent)pageFooter);
    }

    public static void sendSpigotOutpostList(Player player, Town town, int page, int total) {
        int outpostsCount = town.getAllOutpostSpawns().size();
        int iMax = Math.min(page * 10, outpostsCount);
        List<Location> outposts = town.getAllOutpostSpawns();
        BaseComponent[] outpostsFormatted = page * 10 > outpostsCount ? new BaseComponent[outpostsCount % 10] : new BaseComponent[10];
        for (int i = (page - 1) * 10; i < iMax; ++i) {
            Location outpost = outposts.get(i);
            TownBlock tb = TownyAPI.getInstance().getTownBlock(outpost);
            if (tb == null) continue;
            String name = !tb.hasPlotObjectGroup() ? tb.getName() : tb.getPlotObjectGroup().getName();
            TextComponent line = new TextComponent(Integer.toString(i + 1));
            line.setColor(net.md_5.bungee.api.ChatColor.GOLD);
            TextComponent dash = new TextComponent(" - ");
            dash.setColor(net.md_5.bungee.api.ChatColor.DARK_GRAY);
            TextComponent outpostName = new TextComponent(name);
            outpostName.setColor(net.md_5.bungee.api.ChatColor.GREEN);
            TextComponent worldName = new TextComponent(outpost.getWorld().getName());
            worldName.setColor(net.md_5.bungee.api.ChatColor.BLUE);
            TextComponent coords = new TextComponent("(" + outpost.getBlockX() + "," + outpost.getBlockZ() + ")");
            coords.setColor(net.md_5.bungee.api.ChatColor.BLUE);
            line.addExtra((BaseComponent)dash);
            if (!name.equalsIgnoreCase("")) {
                line.addExtra((BaseComponent)outpostName);
                line.addExtra((BaseComponent)dash);
            }
            line.addExtra((BaseComponent)worldName);
            line.addExtra((BaseComponent)dash);
            line.addExtra((BaseComponent)coords);
            String spawnCost = "Free";
            if (TownyEconomyHandler.isActive()) {
                spawnCost = ChatColor.RESET + Translation.of("msg_spawn_cost", TownyEconomyHandler.getFormattedBalance(town.getSpawnCost()));
            }
            String hoverText = Translation.of("msg_click_spawn", name.equalsIgnoreCase("") ? "outpost" : name) + "\n" + spawnCost;
            TextComponent hoverComponent = new TextComponent(hoverText);
            hoverComponent.setColor(net.md_5.bungee.api.ChatColor.GOLD);
            TownySpigotMessaging.adaptForHover(line).setHoverText(hoverText);
            line.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/towny:town outpost " + (i + 1)));
            outpostsFormatted[i % 10] = line;
        }
        player.sendMessage(ChatTools.formatTitle(Translation.of("outpost_plu")));
        for (BaseComponent baseComponent : outpostsFormatted) {
            player.spigot().sendMessage(baseComponent);
        }
        TextComponent pageFooter = TownySpigotMessaging.getPageNavigationFooter("towny:town outpost", page, "", total);
        player.spigot().sendMessage((BaseComponent)pageFooter);
    }

    static final class HoverCompatibilityWrapper {
        final TextComponent base;

        public HoverCompatibilityWrapper(TextComponent base) {
            this.base = base;
        }

        public void setHoverText(String hoverText) {
            if (Towny.is116Plus()) {
                try {
                    this.base.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(hoverText)}));
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.base.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(hoverText).create()));
        }
    }
}

