/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.command.BaseCommand;
import com.palmergames.bukkit.towny.command.HelpMenu;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.invites.Invite;
import com.palmergames.bukkit.towny.invites.InviteHandler;
import com.palmergames.bukkit.towny.object.Nameable;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.utils.NameUtil;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.util.StringMgmt;
import java.io.InvalidObjectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class InviteCommand
extends BaseCommand
implements CommandExecutor {
    private static final List<String> inviteTabCompletes = Arrays.asList(TownySettings.getAcceptCommand(), TownySettings.getDenyCommand());
    private static Towny plugin;

    public InviteCommand(Towny instance) {
        plugin = instance;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        switch (args.length) {
            case 1: {
                return NameUtil.filterByStart(inviteTabCompletes, args[0]);
            }
            case 2: {
                switch (args[0].toLowerCase()) {
                    case "accept": 
                    case "deny": {
                        Resident res;
                        if (!(sender instanceof Player) || (res = TownyUniverse.getInstance().getResident(((Player)sender).getUniqueId())) == null) return Collections.emptyList();
                        return NameUtil.filterByStart(res.getReceivedInvites().stream().map(Invite::getSender).map(Nameable::getName).collect(Collectors.toList()), args[1]);
                    }
                }
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            if (plugin.isError()) {
                sender.sendMessage("\u00a7c[Towny Error] Locked in Safe mode!");
                return false;
            }
            Player player = (Player)sender;
            if (command.getName().equalsIgnoreCase("invite")) {
                this.parseInviteCommand(player, args);
            }
        } else {
            HelpMenu.INVITE_HELP.send(sender);
        }
        return true;
    }

    private void parseInviteCommand(Player player, String[] split) {
        if (split.length == 0 || split[0].equalsIgnoreCase("help") || split[0].equalsIgnoreCase("?")) {
            HelpMenu.INVITE_HELP.send((CommandSender)player);
        } else if (split[0].equalsIgnoreCase("list")) {
            InviteCommand.parseInviteList(player, split);
        } else if (split[0].equalsIgnoreCase(TownySettings.getAcceptCommand())) {
            InviteCommand.parseAccept(player, StringMgmt.remFirstArg(split));
        } else if (split[0].equalsIgnoreCase(TownySettings.getDenyCommand())) {
            InviteCommand.parseDeny(player, StringMgmt.remFirstArg(split));
        }
    }

    private static void parseInviteList(Player player, String[] split) {
        Optional<Resident> resOpt = TownyUniverse.getInstance().getResidentOpt(player.getUniqueId());
        if (!resOpt.isPresent()) {
            TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_not_registered"));
            return;
        }
        Resident resident = resOpt.get();
        String received = Translation.of("player_received_invites").replace("%a", Integer.toString(resident.getReceivedInvites().size())).replace("%m", Integer.toString(InviteHandler.getReceivedInvitesMaxAmount(resident)));
        try {
            int page;
            if (resident.getReceivedInvites().size() > 0) {
                page = 1;
                if (split != null && split.length >= 2) {
                    try {
                        page = Integer.parseInt(split[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            } else {
                throw new TownyException(Translation.of("msg_err_player_no_invites"));
            }
            InviteCommand.sendInviteList(player, (List<Invite>)resident.getReceivedInvites(), page, false);
            player.sendMessage(received);
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
        }
    }

    public static void parseDeny(Player player, String[] args) {
        Town town;
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        Optional<Resident> resOpt = townyUniverse.getResidentOpt(player.getUniqueId());
        if (!resOpt.isPresent()) {
            TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_not_registered"));
            return;
        }
        Resident resident = resOpt.get();
        Collection invites = resident.getReceivedInvites();
        if (invites.size() == 0) {
            TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_player_no_invites"));
            return;
        }
        if (args.length >= 1) {
            town = townyUniverse.getTown(args[0]);
            if (town == null) {
                TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_invalid_name"));
                return;
            }
        } else if (invites.size() == 1) {
            town = (Town)((Invite)invites.get(0)).getSender();
        } else {
            TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_player_has_multiple_invites"));
            InviteCommand.parseInviteList(player, null);
            return;
        }
        Invite toDecline = null;
        for (Invite invite : InviteHandler.getActiveInvites()) {
            if (!invite.getSender().equals(town) || !invite.getReceiver().equals(resident)) continue;
            toDecline = invite;
            break;
        }
        if (toDecline != null) {
            try {
                InviteHandler.declineInvite(toDecline, false);
            }
            catch (InvalidObjectException e) {
                e.printStackTrace();
            }
        } else {
            TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_specify_name"));
        }
    }

    public static void parseAccept(Player player, String[] args) {
        Town town;
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        Optional<Resident> resOpt = townyUniverse.getResidentOpt(player.getUniqueId());
        if (!resOpt.isPresent()) {
            TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_not_registered"));
            return;
        }
        Resident resident = resOpt.get();
        Collection invites = resident.getReceivedInvites();
        if (invites.size() == 0) {
            TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_player_no_invites"));
            return;
        }
        if (args.length >= 1) {
            town = townyUniverse.getTown(args[0]);
            if (town == null) {
                TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_invalid_name"));
                return;
            }
        } else if (invites.size() == 1) {
            town = (Town)((Invite)invites.get(0)).getSender();
        } else {
            TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_player_has_multiple_invites"));
            InviteCommand.parseInviteList(player, null);
            return;
        }
        Invite toAccept = null;
        for (Invite invite : InviteHandler.getActiveInvites()) {
            if (!invite.getSender().equals(town) || !invite.getReceiver().equals(resident)) continue;
            toAccept = invite;
            break;
        }
        if (toAccept != null) {
            try {
                if (TownySettings.getMaxResidentsPerTown() > 0 && town.getResidents().size() >= TownySettings.getMaxResidentsPerTown()) {
                    TownyMessaging.sendMessage((Object)player, Translation.of("msg_err_max_residents_per_town_reached", TownySettings.getMaxResidentsPerTown()));
                    return;
                }
                InviteHandler.acceptInvite(toAccept);
            }
            catch (TownyException | InvalidObjectException e) {
                e.printStackTrace();
            }
        } else {
            TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_specify_name"));
        }
    }

    public static void sendInviteList(Player player, List<Invite> list, int page, boolean fromSender) {
        if (page < 0) {
            TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_negative"));
            return;
        }
        if (page == 0) {
            TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_error_must_be_int"));
            return;
        }
        int total = (int)Math.ceil((double)list.size() / 10.0);
        if (page > total) {
            return;
        }
        ArrayList<String> invitesFormatted = new ArrayList<String>();
        int iMax = page * 10;
        if (page * 10 > list.size()) {
            iMax = list.size();
        }
        String object = null;
        for (int i = (page - 1) * 10; i < iMax; ++i) {
            Invite invite = list.get(i);
            String name = invite.getDirectSender().getName();
            String output = null;
            if (fromSender) {
                output = "\u00a73" + invite.getReceiver().getName() + "\u00a78" + " - " + "\u00a72" + name;
                if (invite.getSender() instanceof Town) {
                    object = Translation.of("player_sing");
                }
                if (invite.getSender() instanceof Nation) {
                    if (invite.getReceiver() instanceof Town) {
                        object = Translation.of("town_sing");
                    }
                    if (invite.getReceiver() instanceof Nation) {
                        object = Translation.of("nation_sing");
                    }
                }
            } else {
                output = "\u00a73" + invite.getSender().getName() + "\u00a78" + " - " + "\u00a72" + name;
                if (invite.getReceiver() instanceof Resident) {
                    object = Translation.of("town_sing");
                }
                if (invite.getReceiver() instanceof Town || invite.getReceiver() instanceof Nation) {
                    object = Translation.of("nation_sing");
                }
            }
            invitesFormatted.add(output);
        }
        player.sendMessage(ChatTools.formatList(Translation.of("invite_plu"), "\u00a73" + object + "\u00a78" + " - " + "\u00a7b" + Translation.of("invite_sent_by"), invitesFormatted, Translation.of("LIST_PAGE", page, total)));
    }
}

