/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownySpigotMessaging;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.command.BaseCommand;
import com.palmergames.bukkit.towny.command.HelpMenu;
import com.palmergames.bukkit.towny.command.InviteCommand;
import com.palmergames.bukkit.towny.confirmations.Confirmation;
import com.palmergames.bukkit.towny.db.TownyDataSource;
import com.palmergames.bukkit.towny.event.NationAcceptAllyRequestEvent;
import com.palmergames.bukkit.towny.event.NationAddEnemyEvent;
import com.palmergames.bukkit.towny.event.NationDenyAllyRequestEvent;
import com.palmergames.bukkit.towny.event.NationInviteTownEvent;
import com.palmergames.bukkit.towny.event.NationPreAddEnemyEvent;
import com.palmergames.bukkit.towny.event.NationPreAddTownEvent;
import com.palmergames.bukkit.towny.event.NationPreRemoveEnemyEvent;
import com.palmergames.bukkit.towny.event.NationPreRenameEvent;
import com.palmergames.bukkit.towny.event.NationRemoveAllyEvent;
import com.palmergames.bukkit.towny.event.NationRemoveEnemyEvent;
import com.palmergames.bukkit.towny.event.NationRequestAllyNationEvent;
import com.palmergames.bukkit.towny.event.NewNationEvent;
import com.palmergames.bukkit.towny.event.nation.NationMergeEvent;
import com.palmergames.bukkit.towny.event.nation.NationPreMergeEvent;
import com.palmergames.bukkit.towny.event.nation.NationPreTownKickEvent;
import com.palmergames.bukkit.towny.event.nation.NationPreTownLeaveEvent;
import com.palmergames.bukkit.towny.event.nation.NationRankAddEvent;
import com.palmergames.bukkit.towny.event.nation.NationRankRemoveEvent;
import com.palmergames.bukkit.towny.event.nation.NationTownLeaveEvent;
import com.palmergames.bukkit.towny.event.nation.PreNewNationEvent;
import com.palmergames.bukkit.towny.event.nation.toggle.NationToggleNeutralEvent;
import com.palmergames.bukkit.towny.event.nation.toggle.NationToggleOpenEvent;
import com.palmergames.bukkit.towny.event.nation.toggle.NationTogglePublicEvent;
import com.palmergames.bukkit.towny.event.nation.toggle.NationToggleUnknownEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.InvalidNameException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.invites.Invite;
import com.palmergames.bukkit.towny.invites.InviteHandler;
import com.palmergames.bukkit.towny.invites.exceptions.TooManyInvitesException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Government;
import com.palmergames.bukkit.towny.object.Nameable;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.SpawnType;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.comparators.ComparatorType;
import com.palmergames.bukkit.towny.object.inviteobjects.NationAllyNationInvite;
import com.palmergames.bukkit.towny.object.inviteobjects.TownJoinNationInvite;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.permissions.TownyPermissionSource;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.utils.MapUtil;
import com.palmergames.bukkit.towny.utils.MoneyUtil;
import com.palmergames.bukkit.towny.utils.NameUtil;
import com.palmergames.bukkit.towny.utils.ResidentUtil;
import com.palmergames.bukkit.towny.utils.SpawnUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.NameValidation;
import com.palmergames.util.StringMgmt;
import java.io.InvalidObjectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class NationCommand
extends BaseCommand
implements CommandExecutor {
    private static Towny plugin;
    private static final List<String> nationTabCompletes;
    private static final List<String> nationSetTabCompletes;
    private static final List<String> nationListTabCompletes;
    static final List<String> nationToggleTabCompletes;
    private static final List<String> nationEnemyTabCompletes;
    private static final List<String> nationAllyTabCompletes;
    private static final List<String> nationKingTabCompletes;
    private static final List<String> nationConsoleTabCompletes;

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        block96: {
            block95: {
                if (!(sender instanceof Player)) break block95;
                Player player = (Player)sender;
                switch (args[0].toLowerCase()) {
                    case "toggle": {
                        if (args.length == 2) {
                            return NameUtil.filterByStart(nationToggleTabCompletes, args[1]);
                        }
                        if (args.length == 3) {
                            return NameUtil.filterByStart(BaseCommand.setOnOffCompletes, args[2]);
                        }
                        break block96;
                    }
                    case "king": {
                        if (args.length == 2) {
                            return NameUtil.filterByStart(nationKingTabCompletes, args[1]);
                        }
                        break block96;
                    }
                    case "townlist": 
                    case "allylist": 
                    case "enemylist": 
                    case "online": 
                    case "join": 
                    case "delete": 
                    case "merge": {
                        if (args.length == 2) {
                            return NationCommand.getTownyStartingWith(args[1], "n");
                        }
                        break block96;
                    }
                    case "spawn": {
                        if (args.length == 2) {
                            List<String> nationOrIgnore = NationCommand.getTownyStartingWith(args[1], "n");
                            nationOrIgnore.add("-ignore");
                            return NameUtil.filterByStart(nationOrIgnore, args[1]);
                        }
                        if (args.length == 3) {
                            List<String> ignore = Collections.singletonList("-ignore");
                            return ignore;
                        }
                    }
                    case "add": {
                        return NationCommand.getTownyStartingWith(args[args.length - 1], "t");
                    }
                    case "kick": {
                        try {
                            Object res = TownyUniverse.getInstance().getResident(player.getUniqueId());
                            if (res != null) {
                                return NameUtil.filterByStart(NameUtil.getNames(((Resident)res).getTown().getNation().getTowns()), args[args.length - 1]);
                            }
                        }
                        catch (TownyException res) {
                            // empty catch block
                        }
                    }
                    case "ally": {
                        if (args.length == 2) {
                            return NameUtil.filterByStart(nationAllyTabCompletes, args[1]);
                        }
                        if (args.length > 2) {
                            switch (args[1].toLowerCase()) {
                                case "add": {
                                    if (args[args.length - 1].startsWith("-")) {
                                        try {
                                            return NameUtil.filterByStart(NationCommand.getResidentOrThrow(player.getUniqueId()).getTown().getNation().getSentAllyInvites().stream().map(Invite::getReceiver).map(Nameable::getName).collect(Collectors.toList()), args[args.length - 1].substring(1)).stream().map(e -> "-" + e).collect(Collectors.toList());
                                        }
                                        catch (TownyException townyException) {
                                        }
                                    } else {
                                        return NationCommand.getTownyStartingWith(args[args.length - 1], "n");
                                    }
                                }
                                case "remove": {
                                    try {
                                        return NameUtil.filterByStart(NameUtil.getNames(NationCommand.getResidentOrThrow(player.getUniqueId()).getTown().getNation().getAllies()), args[args.length - 1]);
                                    }
                                    catch (TownyException townyException) {
                                        // empty catch block
                                    }
                                }
                                case "accept": 
                                case "deny": {
                                    try {
                                        return NameUtil.filterByStart(NationCommand.getResidentOrThrow(player.getUniqueId()).getTown().getNation().getReceivedInvites().stream().map(Invite::getSender).map(Nameable::getName).collect(Collectors.toList()), args[args.length - 1]);
                                    }
                                    catch (TownyException townyException) {
                                        // empty catch block
                                    }
                                }
                            }
                            break;
                        }
                        break block96;
                    }
                    case "rank": {
                        if (args.length == 2) {
                            return NameUtil.filterByStart(nationEnemyTabCompletes, args[1]);
                        }
                        if (args.length > 2) {
                            switch (args[1].toLowerCase()) {
                                case "add": 
                                case "remove": {
                                    if (args.length == 3) {
                                        try {
                                            return NameUtil.filterByStart(NameUtil.getNames(NationCommand.getResidentOrThrow(player.getUniqueId()).getTown().getNation().getResidents()), args[2]);
                                        }
                                        catch (NotRegisteredException e2) {
                                            return Collections.emptyList();
                                        }
                                    }
                                    if (args.length != 4) break;
                                    return NameUtil.filterByStart(TownyPerms.getNationRanks(), args[3]);
                                }
                            }
                            break;
                        }
                        break block96;
                    }
                    case "enemy": {
                        if (args.length == 2) {
                            return NameUtil.filterByStart(nationEnemyTabCompletes, args[1]);
                        }
                        if (args.length == 3) {
                            switch (args[1].toLowerCase()) {
                                case "add": {
                                    return NationCommand.getTownyStartingWith(args[2], "n");
                                }
                                case "remove": {
                                    try {
                                        return NameUtil.filterByStart(NameUtil.getNames(NationCommand.getResidentOrThrow(player.getUniqueId()).getTown().getNation().getEnemies()), args[2]);
                                    }
                                    catch (TownyException townyException) {
                                        // empty catch block
                                    }
                                }
                            }
                            break;
                        }
                        break block96;
                    }
                    case "set": {
                        try {
                            return NationCommand.nationSetTabComplete(NationCommand.getResidentOrThrow(player.getUniqueId()).getTown().getNation(), args);
                        }
                        catch (NotRegisteredException e3) {
                            return Collections.emptyList();
                        }
                    }
                    case "list": {
                        switch (args.length) {
                            case 2: {
                                return Collections.singletonList("by");
                            }
                            case 3: {
                                return NameUtil.filterByStart(nationListTabCompletes, args[2]);
                            }
                        }
                    }
                    default: {
                        if (args.length == 1) {
                            List<String> nationNames = NameUtil.filterByStart(nationTabCompletes, args[0]);
                            if (nationNames.size() > 0) {
                                return nationNames;
                            }
                            return NationCommand.getTownyStartingWith(args[0], "n");
                        }
                        break block96;
                    }
                }
                break block96;
            }
            if (args.length == 1) {
                return NationCommand.filterByStartOrGetTownyStartingWith(nationConsoleTabCompletes, args[0], "n");
            }
        }
        return Collections.emptyList();
    }

    static List<String> nationSetTabComplete(Nation nation, String[] args) {
        if (args.length == 2) {
            return NameUtil.filterByStart(nationSetTabCompletes, args[1]);
        }
        if (args.length == 3) {
            switch (args[1].toLowerCase()) {
                case "king": 
                case "title": 
                case "surname": {
                    return NameUtil.filterByStart(NameUtil.getNames(nation.getResidents()), args[2]);
                }
                case "capital": {
                    return NameUtil.filterByStart(NameUtil.getNames(nation.getTowns()), args[2]);
                }
                case "tag": {
                    if (args.length != 3) break;
                    return NameUtil.filterByStart(Collections.singletonList("clear"), args[2]);
                }
            }
        }
        return Collections.emptyList();
    }

    public NationCommand(Towny instance) {
        plugin = instance;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (sender instanceof Player) {
            if (plugin.isError()) {
                sender.sendMessage("\u00a7c[Towny Error] Locked in Safe mode!");
                return false;
            }
            Player player = (Player)sender;
            if (args == null) {
                HelpMenu.NATION_HELP.send((CommandSender)player);
                this.parseNationCommand(player, args);
            } else {
                this.parseNationCommand(player, args);
            }
        } else {
            this.parseNationCommandForConsole(sender, args);
        }
        return true;
    }

    private static Nation getNationOrThrow(String nationName) throws NotRegisteredException {
        Nation nation = TownyUniverse.getInstance().getNation(nationName);
        if (nation == null) {
            throw new NotRegisteredException(Translation.of("msg_err_not_registered_1", nationName));
        }
        return nation;
    }

    private void parseNationCommandForConsole(CommandSender sender, String[] split) {
        if (split.length == 0 || split[0].equalsIgnoreCase("?") || split[0].equalsIgnoreCase("help")) {
            HelpMenu.NATION_HELP_CONSOLE.send(sender);
        } else if (split[0].equalsIgnoreCase("list")) {
            try {
                this.listNations(sender, split);
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg((Object)sender, e.getMessage());
            }
        } else {
            Nation nation = TownyUniverse.getInstance().getNation(split[0]);
            if (nation != null) {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> TownyMessaging.sendMessage((Object)sender, TownyFormatter.getStatus(nation)));
            } else {
                TownyMessaging.sendErrorMsg((Object)sender, Translation.of("msg_err_not_registered_1", split[0]));
            }
        }
    }

    public void parseNationCommand(Player player, String[] split) {
        block73: {
            TownyPermissionSource permSource = TownyUniverse.getInstance().getPermissionSource();
            try {
                if (split.length == 0) {
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)Towny.getPlugin(), () -> {
                        Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
                        if (resident == null || !resident.hasNation()) {
                            TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_dont_belong_nation"));
                            return;
                        }
                        try {
                            Town town = resident.getTown();
                            Nation nation = town.getNation();
                            TownyMessaging.sendMessage((Object)player, TownyFormatter.getStatus(nation));
                        }
                        catch (NotRegisteredException notRegisteredException) {
                            // empty catch block
                        }
                    });
                    break block73;
                }
                if (split[0].equalsIgnoreCase("?")) {
                    HelpMenu.NATION_HELP.send((CommandSender)player);
                    break block73;
                }
                if (split[0].equalsIgnoreCase("list")) {
                    if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_LIST.getNode())) {
                        throw new TownyException(Translation.of("msg_err_command_disable"));
                    }
                    this.listNations((CommandSender)player, split);
                    break block73;
                }
                if (split[0].equalsIgnoreCase("townlist")) {
                    if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_TOWNLIST.getNode())) {
                        throw new TownyException(Translation.of("msg_err_command_disable"));
                    }
                    Nation nation = null;
                    try {
                        nation = split.length == 1 ? NationCommand.getResidentOrThrow(player.getUniqueId()).getTown().getNation() : NationCommand.getNationOrThrow(split[1]);
                    }
                    catch (NotRegisteredException e) {
                        TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_specify_name"));
                        return;
                    }
                    TownyMessaging.sendMessage((Object)player, ChatTools.formatTitle(nation.getFormattedName()));
                    TownyMessaging.sendMessage((Object)player, ChatTools.listArr(TownyFormatter.getFormattedNames(nation.getTowns().toArray(new Town[0])), Translation.of("status_nation_towns", nation.getTowns().size())));
                    break block73;
                }
                if (split[0].equalsIgnoreCase("allylist")) {
                    if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_ALLYLIST.getNode())) {
                        throw new TownyException(Translation.of("msg_err_command_disable"));
                    }
                    Nation nation = null;
                    try {
                        nation = split.length == 1 ? NationCommand.getResidentOrThrow(player.getUniqueId()).getTown().getNation() : NationCommand.getNationOrThrow(split[1]);
                    }
                    catch (NotRegisteredException e) {
                        TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_specify_name"));
                        return;
                    }
                    if (nation.getAllies().isEmpty()) {
                        TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_error_nation_has_no_allies"));
                    } else {
                        TownyMessaging.sendMessage((Object)player, ChatTools.formatTitle(nation.getFormattedName()));
                        TownyMessaging.sendMessage((Object)player, ChatTools.listArr(TownyFormatter.getFormattedNames(nation.getAllies().toArray(new Nation[0])), Translation.of("status_nation_allies", nation.getAllies().size())));
                    }
                    break block73;
                }
                if (split[0].equalsIgnoreCase("enemylist")) {
                    if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_ENEMYLIST.getNode())) {
                        throw new TownyException(Translation.of("msg_err_command_disable"));
                    }
                    Nation nation = null;
                    try {
                        nation = split.length == 1 ? NationCommand.getResidentOrThrow(player.getUniqueId()).getTown().getNation() : NationCommand.getNationOrThrow(split[1]);
                    }
                    catch (NotRegisteredException e) {
                        TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_specify_name"));
                        return;
                    }
                    if (nation.getEnemies().isEmpty()) {
                        TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_error_nation_has_no_enemies"));
                    } else {
                        TownyMessaging.sendMessage((Object)player, ChatTools.formatTitle(nation.getFormattedName()));
                        TownyMessaging.sendMessage((Object)player, ChatTools.listArr(TownyFormatter.getFormattedNames(nation.getEnemies().toArray(new Nation[0])), Translation.of("status_nation_enemies", nation.getEnemies().size())));
                    }
                    break block73;
                }
                if (split[0].equalsIgnoreCase("new")) {
                    Resident resident = NationCommand.getResidentOrThrow(player.getUniqueId());
                    if (TownySettings.getNumResidentsCreateNation() > 0 && resident.getTown().getNumResidents() < TownySettings.getNumResidentsCreateNation()) {
                        TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_not_enough_residents_new_nation"));
                        return;
                    }
                    if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_NEW.getNode())) {
                        throw new TownyException(Translation.of("msg_err_command_disable"));
                    }
                    if (split.length == 1) {
                        TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_specify_nation_name"));
                    } else if (split.length >= 2) {
                        if (!resident.isMayor() && !resident.getTown().hasResidentWithRank(resident, "assistant")) {
                            throw new TownyException(Translation.of("msg_peasant_right"));
                        }
                        boolean noCharge = TownySettings.getNewNationPrice() == 0.0 || !TownyEconomyHandler.isActive();
                        CharSequence[] newSplit = StringMgmt.remFirstArg(split);
                        String nationName = String.join((CharSequence)"_", newSplit);
                        NationCommand.newNation(player, nationName, resident.getTown(), noCharge);
                    }
                    break block73;
                }
                if (split[0].equalsIgnoreCase("join")) {
                    if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_JOIN.getNode())) {
                        throw new TownyException(Translation.of("msg_err_command_disable"));
                    }
                    this.parseNationJoin(player, StringMgmt.remFirstArg(split));
                    break block73;
                }
                if (split[0].equalsIgnoreCase("merge")) {
                    if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_MERGE.getNode())) {
                        throw new TownyException(Translation.of("msg_err_command_disable"));
                    }
                    if (split.length == 1) {
                        TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_specify_nation_name"));
                    } else if (split.length == 2) {
                        Resident resident = NationCommand.getResidentOrThrow(player.getUniqueId());
                        if (!resident.isKing()) {
                            throw new TownyException(Translation.of("msg_err_merging_for_kings_only"));
                        }
                        this.mergeNation(player, split[1]);
                    }
                    break block73;
                }
                if (split[0].equalsIgnoreCase("withdraw")) {
                    if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_WITHDRAW.getNode())) {
                        throw new TownyException(Translation.of("msg_err_command_disable"));
                    }
                    NationCommand.nationTransaction(player, split, true);
                    break block73;
                }
                if (split[0].equalsIgnoreCase("leave")) {
                    if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_LEAVE.getNode())) {
                        throw new TownyException(Translation.of("msg_err_command_disable"));
                    }
                    this.nationLeave(player);
                    break block73;
                }
                if (split[0].equalsIgnoreCase("spawn")) {
                    String[] newSplit = StringMgmt.remFirstArg(split);
                    boolean ignoreWarning = false;
                    if (split.length > 1 && split[1].equals("-ignore") || split.length > 2 && split[2].equals("-ignore")) {
                        ignoreWarning = true;
                    }
                    NationCommand.nationSpawn(player, newSplit, ignoreWarning);
                    break block73;
                }
                if (split[0].equalsIgnoreCase("deposit")) {
                    if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_DEPOSIT.getNode())) {
                        throw new TownyException(Translation.of("msg_err_command_disable"));
                    }
                    NationCommand.nationTransaction(player, split, false);
                    break block73;
                }
                Object[] newSplit = StringMgmt.remFirstArg(split);
                if (split[0].equalsIgnoreCase("rank")) {
                    this.nationRank(player, (String[])newSplit);
                    break block73;
                }
                if (split[0].equalsIgnoreCase("king")) {
                    if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_KING.getNode())) {
                        throw new TownyException(Translation.of("msg_err_command_disable"));
                    }
                    this.nationKing(player, (String[])newSplit);
                    break block73;
                }
                if (split[0].equalsIgnoreCase("add")) {
                    if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_INVITE_ADD.getNode())) {
                        throw new TownyException(Translation.of("msg_err_command_disable"));
                    }
                    this.nationAdd(player, (String[])newSplit);
                    break block73;
                }
                if (split[0].equalsIgnoreCase("invite") || split[0].equalsIgnoreCase("invites")) {
                    this.parseInviteCommand(player, (String[])newSplit);
                    break block73;
                }
                if (split[0].equalsIgnoreCase("kick")) {
                    if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_KICK.getNode())) {
                        throw new TownyException(Translation.of("msg_err_command_disable"));
                    }
                    this.nationKick(player, (String[])newSplit);
                    break block73;
                }
                if (split[0].equalsIgnoreCase("set")) {
                    NationCommand.nationSet(player, (String[])newSplit, false, null);
                    break block73;
                }
                if (split[0].equalsIgnoreCase("toggle")) {
                    NationCommand.nationToggle((CommandSender)player, (String[])newSplit, false, null);
                    break block73;
                }
                if (split[0].equalsIgnoreCase("ally")) {
                    this.nationAlly(player, (String[])newSplit);
                    break block73;
                }
                if (split[0].equalsIgnoreCase("enemy")) {
                    if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_ENEMY.getNode())) {
                        throw new TownyException(Translation.of("msg_err_command_disable"));
                    }
                    this.nationEnemy(player, (String[])newSplit);
                    break block73;
                }
                if (split[0].equalsIgnoreCase("delete")) {
                    if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_DELETE.getNode())) {
                        throw new TownyException(Translation.of("msg_err_command_disable"));
                    }
                    this.nationDelete(player, (String[])newSplit);
                    break block73;
                }
                if (split[0].equalsIgnoreCase("online")) {
                    if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_ONLINE.getNode())) {
                        throw new TownyException(Translation.of("msg_err_command_disable"));
                    }
                    this.parseNationOnlineCommand(player, (String[])newSplit);
                    break block73;
                }
                if (split[0].equalsIgnoreCase("say")) {
                    if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_SAY.getNode())) {
                        throw new TownyException(Translation.of("msg_err_command_disable"));
                    }
                    Nation nation = NationCommand.getResidentOrThrow(player.getUniqueId()).getTown().getNation();
                    String message = StringMgmt.join(newSplit);
                    TownyMessaging.sendPrefixedNationMessage(nation, message);
                    break block73;
                }
                if (split[0].equalsIgnoreCase("bankhistory")) {
                    if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_BANKHISTORY.getNode())) {
                        throw new TownyException(Translation.of("msg_err_command_disable"));
                    }
                    int pages = 10;
                    if (newSplit.length > 0) {
                        try {
                            pages = Integer.parseInt((String)newSplit[0]);
                        }
                        catch (NumberFormatException e) {
                            TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_error_must_be_int"));
                            return;
                        }
                    }
                    TownyUniverse.getInstance().getResident(player.getUniqueId()).getTown().getNation().generateBankHistoryBook(player, pages);
                    break block73;
                }
                Nation nation = TownyUniverse.getInstance().getNation(split[0]);
                if (nation == null) {
                    TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_not_registered_1", split[0]));
                    return;
                }
                try {
                    Resident resident = NationCommand.getResidentOrThrow(player.getUniqueId());
                    if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_OTHERNATION.getNode()) && (resident.hasTown() && resident.getTown().hasNation() && resident.getTown().getNation() != nation || !resident.hasTown())) {
                        throw new TownyException(Translation.of("msg_err_command_disable"));
                    }
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)Towny.getPlugin(), () -> TownyMessaging.sendMessage((Object)player, TownyFormatter.getStatus(nation)));
                }
                catch (NotRegisteredException ex) {
                    TownyMessaging.sendErrorMsg((Object)player, ex.getMessage());
                }
            }
            catch (Exception x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            }
        }
    }

    private void parseNationJoin(Player player, String[] args) throws TownyException {
        try {
            if (args.length < 1) {
                throw new TownyException(String.format("Usage: /nation join [nation]", new Object[0]));
            }
            String nationName = args[0];
            Resident resident = NationCommand.getResidentOrThrow(player.getUniqueId());
            Town town = resident.getTown();
            Nation nation = NationCommand.getNationOrThrow(nationName);
            if (town.hasNation()) {
                throw new TownyException(Translation.of("msg_err_already_in_a_nation"));
            }
            if (!nation.isOpen()) {
                throw new TownyException(Translation.of("msg_err_nation_not_open", nation.getFormattedName()));
            }
            if (TownySettings.getNumResidentsJoinNation() > 0 && town.getNumResidents() < TownySettings.getNumResidentsJoinNation()) {
                throw new TownyException(Translation.of("msg_err_not_enough_residents_join_nation", town.getName()));
            }
            if (TownySettings.getMaxTownsPerNation() > 0 && nation.getTowns().size() >= TownySettings.getMaxTownsPerNation()) {
                throw new TownyException(Translation.of("msg_err_nation_over_town_limit", TownySettings.getMaxTownsPerNation()));
            }
            if (TownySettings.getNationRequiresProximity() > 0.0) {
                Coord capitalCoord = nation.getCapital().getHomeBlock().getCoord();
                Coord townCoord = town.getHomeBlock().getCoord();
                if (!nation.getCapital().getHomeBlock().getWorld().getName().equals(town.getHomeBlock().getWorld().getName())) {
                    throw new TownyException(Translation.of("msg_err_nation_homeblock_in_another_world"));
                }
                double distance = Math.sqrt(Math.pow((double)capitalCoord.getX() - (double)townCoord.getX(), 2.0) + Math.pow((double)capitalCoord.getZ() - (double)townCoord.getZ(), 2.0));
                if (distance > TownySettings.getNationRequiresProximity()) {
                    throw new TownyException(Translation.of("msg_err_town_not_close_enough_to_nation", town.getName()));
                }
            }
            NationPreAddTownEvent preEvent = new NationPreAddTownEvent(nation, town);
            Bukkit.getPluginManager().callEvent((Event)preEvent);
            if (preEvent.isCancelled()) {
                TownyMessaging.sendErrorMsg((Object)player, preEvent.getCancelMessage());
                return;
            }
            ArrayList<Town> towns = new ArrayList<Town>();
            towns.add(town);
            NationCommand.nationAdd(nation, towns);
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
        }
    }

    private void parseInviteCommand(Player player, String[] newSplit) throws TownyException {
        TownyPermissionSource permSource = TownyUniverse.getInstance().getPermissionSource();
        Resident resident = NationCommand.getResidentOrThrow(player.getUniqueId());
        String sent = Translation.of("nation_sent_invites").replace("%a", Integer.toString(resident.getTown().getNation().getSentInvites().size())).replace("%m", Integer.toString(InviteHandler.getSentInvitesMaxAmount(resident.getTown().getNation())));
        if (newSplit.length == 0) {
            if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_INVITE_SEE_HOME.getNode())) {
                throw new TownyException(Translation.of("msg_err_command_disable"));
            }
            HelpMenu.NATION_INVITE.send((CommandSender)player);
            TownyMessaging.sendMessage((Object)player, sent);
            return;
        }
        if (newSplit.length >= 1) {
            if (newSplit[0].equalsIgnoreCase("help") || newSplit[0].equalsIgnoreCase("?")) {
                HelpMenu.NATION_INVITE.send((CommandSender)player);
                return;
            }
            if (newSplit[0].equalsIgnoreCase("sent")) {
                if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_INVITE_LIST_SENT.getNode())) {
                    throw new TownyException(Translation.of("msg_err_command_disable"));
                }
                Collection sentinvites = resident.getTown().getNation().getSentInvites();
                int page = 1;
                if (newSplit.length >= 2) {
                    try {
                        page = Integer.parseInt(newSplit[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                InviteCommand.sendInviteList(player, (List<Invite>)sentinvites, page, true);
                player.sendMessage(sent);
                return;
            }
            if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_INVITE_ADD.getNode())) {
                throw new TownyException(Translation.of("msg_err_command_disable"));
            }
            this.nationAdd(player, newSplit);
        }
    }

    private void parseNationOnlineCommand(Player player, String[] split) throws TownyException {
        if (split.length > 0) {
            Nation nation = NationCommand.getNationOrThrow(split[0]);
            List<Resident> onlineResidents = ResidentUtil.getOnlineResidentsViewable(player, nation);
            if (onlineResidents.size() > 0) {
                TownyMessaging.sendMessage((Object)player, TownyFormatter.getFormattedOnlineResidents(Translation.of("msg_nation_online"), nation, player));
            } else {
                TownyMessaging.sendMessage((Object)player, "\u00a7f0 " + Translation.of("res_list") + " " + Translation.of("msg_nation_online") + ": " + nation);
            }
        } else {
            Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
            if (resident == null || !resident.hasNation()) {
                TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_dont_belong_nation"));
                return;
            }
            try {
                Town town = resident.getTown();
                Nation nation = town.getNation();
                TownyMessaging.sendMessage((Object)player, TownyFormatter.getFormattedOnlineResidents(Translation.of("msg_nation_online"), nation, player));
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void nationRank(Player player, String[] split) throws TownyException {
        Resident target;
        if (split.length == 0) {
            player.sendMessage(ChatTools.formatTitle("/nation rank"));
            player.sendMessage(ChatTools.formatCommand("", "/nation rank", "add/remove [resident] rank", ""));
            return;
        }
        Town town = null;
        Town targetTown = null;
        if (split.length < 3) {
            TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation rank add/remove [resident] [rank]");
            return;
        }
        try {
            Resident resident = NationCommand.getResidentOrThrow(player.getUniqueId());
            target = NationCommand.getResidentOrThrow(split[1]);
            town = resident.getTown();
            targetTown = target.getTown();
            if (town.getNation() != targetTown.getNation()) {
                throw new TownyException("This resident is not a member of your Nation!");
            }
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            return;
        }
        String rank = TownyPerms.matchNationRank(split[2]);
        if (rank == null) {
            TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_unknown_rank_available_ranks", split[2], StringMgmt.join(TownyPerms.getNationRanks(), ", ")));
            return;
        }
        if (!TownyUniverse.getInstance().getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_RANK.getNode(rank.toLowerCase()))) {
            TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_no_permission_to_give_rank"));
            return;
        }
        if (split[0].equalsIgnoreCase("add")) {
            NationRankAddEvent nationRankAddEvent = new NationRankAddEvent(town.getNation(), rank, target);
            BukkitTools.getPluginManager().callEvent((Event)nationRankAddEvent);
            if (nationRankAddEvent.isCancelled()) {
                TownyMessaging.sendErrorMsg((Object)player, nationRankAddEvent.getCancelMessage());
                return;
            }
            try {
                if (!target.addNationRank(rank)) {
                    TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_resident_not_part_of_any_town"));
                    return;
                }
                if (BukkitTools.isOnline(target.getName())) {
                    TownyMessaging.sendMsg(target, Translation.of("msg_you_have_been_given_rank", "Nation", rank));
                    plugin.deleteCache(TownyAPI.getInstance().getPlayer(target));
                }
                TownyMessaging.sendMsg((CommandSender)player, Translation.of("msg_you_have_given_rank", "Nation", rank, target.getName()));
            }
            catch (AlreadyRegisteredException e) {
                TownyMessaging.sendMsg((CommandSender)player, Translation.of("msg_resident_already_has_rank", target.getName(), "Nation"));
                return;
            }
        }
        if (!split[0].equalsIgnoreCase("remove")) {
            TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_invalid_property", split[0]));
            return;
        }
        NationRankRemoveEvent nationRankRemoveEvent = new NationRankRemoveEvent(town.getNation(), rank, target);
        BukkitTools.getPluginManager().callEvent((Event)nationRankRemoveEvent);
        if (nationRankRemoveEvent.isCancelled()) {
            TownyMessaging.sendErrorMsg((Object)player, nationRankRemoveEvent.getCancelMessage());
            return;
        }
        try {
            if (target.removeNationRank(rank)) {
                if (BukkitTools.isOnline(target.getName())) {
                    TownyMessaging.sendMsg(target, Translation.of("msg_you_have_had_rank_taken", "Nation", rank));
                    plugin.deleteCache(TownyAPI.getInstance().getPlayer(target));
                }
                TownyMessaging.sendMsg((CommandSender)player, Translation.of("msg_you_have_taken_rank_from", "Nation", rank, target.getName()));
            }
        }
        catch (NotRegisteredException e) {
            TownyMessaging.sendMsg((CommandSender)player, String.format("msg_resident_doesnt_have_rank", target.getName(), "Nation"));
            return;
        }
        target.save();
    }

    public void listNations(CommandSender sender, String[] split) throws TownyException {
        TownyPermissionSource permSource = TownyUniverse.getInstance().getPermissionSource();
        boolean console = true;
        Player player = null;
        if (split.length == 2 && split[1].equals("?")) {
            sender.sendMessage(ChatTools.formatTitle("/nation list"));
            sender.sendMessage(ChatTools.formatCommand("", "/nation list", "{page #}", ""));
            sender.sendMessage(ChatTools.formatCommand("", "/nation list", "{page #} by residents", ""));
            sender.sendMessage(ChatTools.formatCommand("", "/nation list", "{page #} by towns", ""));
            sender.sendMessage(ChatTools.formatCommand("", "/nation list", "{page #} by open", ""));
            sender.sendMessage(ChatTools.formatCommand("", "/nation list", "{page #} by balance", ""));
            sender.sendMessage(ChatTools.formatCommand("", "/nation list", "{page #} by name", ""));
            sender.sendMessage(ChatTools.formatCommand("", "/nation list", "{page #} by townblocks", ""));
            sender.sendMessage(ChatTools.formatCommand("", "/nation list", "{page #} by online", ""));
            return;
        }
        if (sender instanceof Player) {
            console = false;
            player = (Player)sender;
        }
        if (split.length < 2 && !console && !permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_LIST_RESIDENTS.getNode())) {
            throw new TownyException(Translation.of("msg_err_command_disable"));
        }
        ArrayList<Nation> nationsToSort = new ArrayList<Nation>(TownyUniverse.getInstance().getNations());
        int page = 1;
        boolean pageSet = false;
        boolean comparatorSet = false;
        ComparatorType type = ComparatorType.RESIDENTS;
        int total = (int)Math.ceil((double)nationsToSort.size() / 10.0);
        for (int i = 1; i < split.length; ++i) {
            if (split[i].equalsIgnoreCase("by")) {
                if (comparatorSet) {
                    TownyMessaging.sendErrorMsg((Object)sender, Translation.of("msg_error_multiple_comparators_nation"));
                    return;
                }
                if (++i < split.length) {
                    comparatorSet = true;
                    if (split[i].equalsIgnoreCase("resident")) {
                        split[i] = "residents";
                    }
                    if (!console && !permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_LIST.getNode(split[i]))) {
                        throw new TownyException(Translation.of("msg_err_command_disable"));
                    }
                    if (!nationListTabCompletes.contains(split[i].toLowerCase())) {
                        throw new TownyException(Translation.of("msg_error_invalid_comparator_nation"));
                    }
                } else {
                    TownyMessaging.sendErrorMsg((Object)sender, Translation.of("msg_error_missing_comparator"));
                    return;
                }
                type = ComparatorType.valueOf(split[i].toUpperCase());
                comparatorSet = true;
                continue;
            }
            if (pageSet) {
                TownyMessaging.sendErrorMsg((Object)sender, Translation.of("msg_error_too_many_pages"));
                return;
            }
            try {
                page = Integer.parseInt(split[i]);
                if (page < 0) {
                    TownyMessaging.sendErrorMsg((Object)sender, Translation.of("msg_err_negative"));
                    return;
                }
                if (page == 0) {
                    TownyMessaging.sendErrorMsg((Object)sender, Translation.of("msg_error_must_be_int"));
                    return;
                }
                pageSet = true;
                continue;
            }
            catch (NumberFormatException e) {
                TownyMessaging.sendErrorMsg((Object)sender, Translation.of("msg_error_must_be_int"));
                return;
            }
        }
        if (page > total) {
            TownyMessaging.sendErrorMsg((Object)sender, Translation.of("LIST_ERR_NOT_ENOUGH_PAGES", total));
            return;
        }
        ArrayList<Nation> nations = nationsToSort;
        Comparator<? extends Government> comparator = type.getComparator();
        ComparatorType finalType = type;
        int pageNumber = page;
        try {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                nations.sort(comparator);
                this.sendList(sender, nations, finalType, pageNumber, total);
            });
        }
        catch (RuntimeException e) {
            TownyMessaging.sendErrorMsg((Object)sender, Translation.of("msg_error_comparator_failed"));
        }
    }

    public void sendList(CommandSender sender, List<Nation> nations, ComparatorType type, int page, int total) {
        if (Towny.isSpigot && sender instanceof Player) {
            TownySpigotMessaging.sendSpigotNationList(sender, nations, type, page, total);
            return;
        }
        int iMax = Math.min(page * 10, nations.size());
        ArrayList<String> nationsordered = new ArrayList<String>(10);
        for (int i = (page - 1) * 10; i < iMax; ++i) {
            Nation nation = nations.get(i);
            String slug = null;
            switch (type) {
                case BALANCE: {
                    slug = TownyEconomyHandler.getFormattedBalance(nation.getAccount().getCachedBalance());
                    break;
                }
                case ONLINE: {
                    slug = TownyAPI.getInstance().getOnlinePlayersInNation(nation).size() + "";
                    break;
                }
                case TOWNS: {
                    slug = nation.getTowns().size() + "";
                    break;
                }
                default: {
                    slug = nation.getResidents().size() + "";
                }
            }
            String output = "\u00a76" + StringMgmt.remUnderscore(nation.getName()) + "\u00a78" + " - " + "\u00a7b" + "(" + slug + ")";
            nationsordered.add(output);
        }
        sender.sendMessage(ChatTools.formatList(Translation.of("nation_plu"), "\u00a76" + Translation.of("nation_name") + "\u00a78" + " - " + "\u00a7b" + Translation.of(type.getName()), nationsordered, Translation.of("LIST_PAGE", page, total)));
    }

    public static void newNation(Player player, String name, Town capitalTown, boolean noCharge) {
        try {
            String filteredName;
            if (capitalTown.hasNation()) {
                throw new TownyException(Translation.of("msg_err_already_nation"));
            }
            try {
                filteredName = NameValidation.checkAndFilterName(name);
            }
            catch (InvalidNameException e) {
                filteredName = null;
            }
            if (filteredName == null || TownyUniverse.getInstance().hasNation(filteredName)) {
                throw new TownyException(Translation.of("msg_err_invalid_name", name));
            }
            PreNewNationEvent preEvent = new PreNewNationEvent(capitalTown, name);
            Bukkit.getPluginManager().callEvent((Event)preEvent);
            if (preEvent.isCancelled()) {
                TownyMessaging.sendErrorMsg((Object)player, preEvent.getCancelMessage());
                return;
            }
            if (!noCharge && TownyEconomyHandler.isActive()) {
                if (!capitalTown.getAccount().canPayFromHoldings(TownySettings.getNewNationPrice())) {
                    throw new TownyException(Translation.of("msg_no_funds_new_nation2", TownySettings.getNewNationPrice()));
                }
                Confirmation.runOnAccept(() -> {
                    try {
                        if (!capitalTown.getAccount().withdraw(TownySettings.getNewNationPrice(), "New Nation Cost")) {
                            TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_no_funds_new_nation2", TownySettings.getNewNationPrice()));
                            return;
                        }
                    }
                    catch (EconomyException economyException) {
                        // empty catch block
                    }
                    try {
                        NationCommand.newNation(name, capitalTown);
                    }
                    catch (AlreadyRegisteredException | NotRegisteredException e) {
                        TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                    }
                    TownyMessaging.sendGlobalMessage(Translation.of("msg_new_nation", player.getName(), StringMgmt.remUnderscore(name)));
                }).setTitle(Translation.of("msg_confirm_purchase", TownyEconomyHandler.getFormattedBalance(TownySettings.getNewNationPrice()))).sendTo((CommandSender)player);
            } else {
                NationCommand.newNation(name, capitalTown);
                TownyMessaging.sendGlobalMessage(Translation.of("msg_new_nation", player.getName(), StringMgmt.remUnderscore(name)));
            }
        }
        catch (EconomyException | TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
        }
    }

    public static Nation newNation(String name, Town town) throws AlreadyRegisteredException, NotRegisteredException {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        UUID nationUUID = UUID.randomUUID();
        townyUniverse.getDataSource().newNation(name, nationUUID);
        Nation nation = townyUniverse.getNation(nationUUID);
        if (nation == null) {
            TownyMessaging.sendErrorMsg(String.format("Error fetching new nation with name %s; it was not properly registered!", name));
            throw new NotRegisteredException(Translation.of("msg_err_not_registered_1", name));
        }
        nation.setRegistered(System.currentTimeMillis());
        nation.setMapColorHexCode(MapUtil.generateRandomNationColourAsHexCode());
        town.setNation(nation);
        nation.setCapital(town);
        if (TownyEconomyHandler.isActive()) {
            try {
                nation.getAccount().setBalance(0.0, "New Nation Account");
            }
            catch (EconomyException e) {
                e.printStackTrace();
            }
        }
        town.save();
        nation.save();
        BukkitTools.getPluginManager().callEvent((Event)new NewNationEvent(nation));
        return nation;
    }

    public void mergeNation(Player player, String name) throws TownyException {
        Nation remainingNation;
        Nation nation = TownyUniverse.getInstance().getNation(name);
        try {
            remainingNation = NationCommand.getResidentOrThrow(player.getUniqueId()).getTown().getNation();
        }
        catch (NotRegisteredException e) {
            throw new TownyException(Translation.of("msg_err_invalid_name", name));
        }
        if (nation == null || remainingNation.getName().equalsIgnoreCase(name)) {
            throw new TownyException(Translation.of("msg_err_invalid_name", name));
        }
        Resident king = nation.getKing();
        if (!BukkitTools.isOnline(king.getName())) {
            throw new TownyException(Translation.of("msg_err_king_of_that_nation_is_not_online", name, king.getName()));
        }
        TownyMessaging.sendMessage((Object)BukkitTools.getPlayer(king.getName()), Translation.of("msg_would_you_merge_your_nation_into_other_nation", nation, remainingNation, remainingNation));
        if (TownySettings.getNationRequiresProximity() > 0.0) {
            List<Town> towns = nation.getTowns();
            towns.addAll(remainingNation.getTowns());
            List<Town> removedTowns = remainingNation.recheckTownDistanceDryRun(towns, remainingNation.getCapital());
            if (!removedTowns.isEmpty()) {
                TownyMessaging.sendMessage((Object)nation.getKing(), Translation.of("msg_warn_the_following_towns_will_be_removed_from_your_nation", StringMgmt.join(removedTowns, ", ")));
                TownyMessaging.sendMessage((Object)remainingNation.getKing(), Translation.of("msg_warn_the_following_towns_will_be_removed_from_your_nation", StringMgmt.join(removedTowns, ", ")));
            }
        }
        Confirmation.runOnAccept(() -> {
            NationPreMergeEvent preEvent = new NationPreMergeEvent(nation, remainingNation);
            Bukkit.getPluginManager().callEvent((Event)preEvent);
            if (preEvent.isCancelled()) {
                TownyMessaging.sendErrorMsg((Object)nation, preEvent.getCancelMessage());
                return;
            }
            try {
                BukkitTools.getPluginManager().callEvent((Event)new NationMergeEvent(nation, remainingNation));
                TownyUniverse.getInstance().getDataSource().mergeNation(nation, remainingNation);
                TownyMessaging.sendGlobalMessage(Translation.of("nation1_has_merged_with_nation2", nation, remainingNation));
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
            }
        }).sendTo((CommandSender)BukkitTools.getPlayerExact(king.getName()));
    }

    public void nationLeave(Player player) {
        Town town = null;
        try {
            Resident resident = NationCommand.getResidentOrThrow(player.getUniqueId());
            town = resident.getTown();
            NationPreTownLeaveEvent event = new NationPreTownLeaveEvent(town.getNation(), town);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                throw new TownyException(event.getCancelMessage());
            }
            Town finalTown = town;
            Nation nation = town.getNation();
            Confirmation.runOnAccept(() -> {
                Bukkit.getPluginManager().callEvent((Event)new NationTownLeaveEvent(nation, finalTown));
                finalTown.removeNation();
                plugin.resetCache();
                TownyMessaging.sendPrefixedNationMessage(nation, Translation.of("msg_nation_town_left", StringMgmt.remUnderscore(finalTown.getName())));
                TownyMessaging.sendPrefixedTownMessage(finalTown, Translation.of("msg_town_left_nation", StringMgmt.remUnderscore(nation.getName())));
            }).sendTo((CommandSender)player);
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            return;
        }
    }

    public void nationDelete(Player player, String[] split) {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (split.length == 0) {
            try {
                Resident resident = NationCommand.getResidentOrThrow(player.getUniqueId());
                Nation nation = resident.getTown().getNation();
                Confirmation.runOnAccept(() -> {
                    TownyUniverse.getInstance().getDataSource().removeNation(nation);
                    TownyMessaging.sendGlobalMessage(Translation.of("MSG_DEL_NATION", nation.getName()));
                }).sendTo((CommandSender)player);
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            }
        } else {
            try {
                if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_NATION_DELETE.getNode())) {
                    throw new TownyException(Translation.of("msg_err_admin_only_delete_nation"));
                }
                Nation nation = NationCommand.getNationOrThrow(split[0]);
                townyUniverse.getDataSource().removeNation(nation);
                TownyMessaging.sendGlobalMessage(Translation.of("MSG_DEL_NATION", nation.getName()));
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            }
        }
    }

    public void nationKing(Player player, String[] split) {
        if (split.length == 0 || split[0].equalsIgnoreCase("?")) {
            HelpMenu.KING_HELP.send((CommandSender)player);
        }
    }

    public void nationAdd(Player player, String[] names) throws TownyException {
        Nation nation;
        TownyDataSource dataSource = TownyUniverse.getInstance().getDataSource();
        if (names.length < 1) {
            TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation add [names]");
            return;
        }
        try {
            Resident resident = NationCommand.getResidentOrThrow(player.getUniqueId());
            nation = resident.getTown().getNation();
            if (TownySettings.getMaxTownsPerNation() > 0 && nation.getTowns().size() >= TownySettings.getMaxTownsPerNation()) {
                TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_nation_over_town_limit", TownySettings.getMaxTownsPerNation()));
                return;
            }
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            return;
        }
        ArrayList<String> townlist = new ArrayList<String>(Arrays.asList(names));
        ArrayList<String> newtownlist = new ArrayList<String>();
        ArrayList<String> removeinvites = new ArrayList<String>();
        for (String townname : townlist) {
            if (townname.startsWith("-")) {
                removeinvites.add(townname.substring(1));
                continue;
            }
            if (!nation.hasTown(townname)) {
                newtownlist.add(townname);
                continue;
            }
            removeinvites.add(townname);
        }
        names = newtownlist.toArray(new String[0]);
        String[] namestoremove = removeinvites.toArray(new String[0]);
        if (namestoremove.length >= 1) {
            NationCommand.nationRevokeInviteTown(player, nation, dataSource.getTowns(namestoremove));
        }
        if (names.length >= 1) {
            NationCommand.nationAdd(player, nation, dataSource.getTowns(names));
        }
    }

    private static void nationRevokeInviteTown(Object sender, Nation nation, List<Town> towns) {
        block2: for (Town town : towns) {
            if (!InviteHandler.inviteIsActive(nation, town)) continue;
            for (Invite invite : town.getReceivedInvites()) {
                if (!invite.getSender().equals(nation)) continue;
                try {
                    InviteHandler.declineInvite(invite, true);
                    TownyMessaging.sendMessage(sender, Translation.of("nation_revoke_invite_successful"));
                    continue block2;
                }
                catch (InvalidObjectException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void nationAdd(Player player, Nation nation, List<Town> invited) throws TownyException {
        StringBuilder msg;
        ArrayList<Town> remove = new ArrayList<Town>();
        for (Town town : invited) {
            try {
                if (TownySettings.getNumResidentsJoinNation() > 0 && town.getNumResidents() < TownySettings.getNumResidentsJoinNation()) {
                    remove.add(town);
                    TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_not_enough_residents_join_nation", town.getName()));
                    continue;
                }
                if (TownySettings.getNationRequiresProximity() > 0.0) {
                    Coord capitalCoord = nation.getCapital().getHomeBlock().getCoord();
                    Coord townCoord = town.getHomeBlock().getCoord();
                    if (!nation.getCapital().getHomeBlock().getWorld().getName().equals(town.getHomeBlock().getWorld().getName())) {
                        remove.add(town);
                        TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_nation_homeblock_in_another_world"));
                        continue;
                    }
                    double distance = Math.sqrt(Math.pow((double)capitalCoord.getX() - (double)townCoord.getX(), 2.0) + Math.pow((double)capitalCoord.getZ() - (double)townCoord.getZ(), 2.0));
                    if (distance > TownySettings.getNationRequiresProximity()) {
                        TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_town_not_close_enough_to_nation", town.getName()));
                        remove.add(town);
                        continue;
                    }
                }
                NationPreAddTownEvent preEvent = new NationPreAddTownEvent(nation, town);
                Bukkit.getPluginManager().callEvent((Event)preEvent);
                if (preEvent.isCancelled()) {
                    TownyMessaging.sendErrorMsg((Object)player, preEvent.getCancelMessage());
                    return;
                }
                NationCommand.nationInviteTown(player, nation, town);
            }
            catch (AlreadyRegisteredException e) {
                remove.add(town);
            }
        }
        for (Town town : remove) {
            invited.remove(town);
        }
        if (invited.size() > 0) {
            msg = new StringBuilder();
            for (Town town : invited) {
                msg.append(town.getName()).append(", ");
            }
        } else {
            throw new TownyException(Translation.of("msg_invalid_name"));
        }
        msg = new StringBuilder(msg.substring(0, msg.length() - 2));
        msg = new StringBuilder(Translation.of("msg_invited_join_nation", player.getName(), msg.toString()));
        TownyMessaging.sendPrefixedNationMessage(nation, msg.toString());
    }

    private static void nationInviteTown(Player player, Nation nation, Town town) throws TownyException {
        TownJoinNationInvite invite = new TownJoinNationInvite((CommandSender)player, town, nation);
        try {
            if (!InviteHandler.inviteIsActive(invite)) {
                town.newReceivedInvite(invite);
                nation.newSentInvite(invite);
                InviteHandler.addInvite(invite);
                Player mayor = TownyAPI.getInstance().getPlayer(town.getMayor());
                if (mayor != null) {
                    TownyMessaging.sendRequestMessage((CommandSender)mayor, invite);
                }
            } else {
                throw new TownyException(Translation.of("msg_err_town_already_invited", town.getName()));
            }
            Bukkit.getPluginManager().callEvent((Event)new NationInviteTownEvent(invite));
        }
        catch (TooManyInvitesException e) {
            town.deleteReceivedInvite(invite);
            nation.deleteSentInvite(invite);
            throw new TownyException(e.getMessage());
        }
    }

    public static void nationAdd(Nation nation, List<Town> towns) throws AlreadyRegisteredException {
        for (Town town : towns) {
            if (town.hasNation()) continue;
            town.setNation(nation);
            town.save();
            TownyMessaging.sendNationMessagePrefixed(nation, Translation.of("msg_join_nation", town.getName()));
        }
        plugin.resetCache();
        nation.save();
    }

    public void nationKick(Player player, String[] names) {
        Nation nation;
        if (names.length < 1) {
            TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation kick [names]");
            return;
        }
        try {
            if (TownyAPI.getInstance().isWarTime()) {
                throw new TownyException(Translation.of("msg_war_cannot_do"));
            }
            Resident resident = NationCommand.getResidentOrThrow(player.getUniqueId());
            nation = resident.getTown().getNation();
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            return;
        }
        NationCommand.nationKick((CommandSender)player, nation, TownyUniverse.getInstance().getDataSource().getTowns(names));
    }

    public static void nationKick(CommandSender sender, Nation nation, List<Town> kicking) {
        ArrayList<Town> remove = new ArrayList<Town>();
        for (Town town : kicking) {
            if (town.isCapital() || !nation.hasTown(town)) {
                remove.add(town);
                continue;
            }
            NationPreTownKickEvent event = new NationPreTownKickEvent(nation, town);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                TownyMessaging.sendErrorMsg((Object)sender, event.getCancelMessage());
                remove.add(town);
                continue;
            }
            town.removeNation();
            TownyMessaging.sendPrefixedTownMessage(town, Translation.of("msg_nation_kicked_by", sender.getName()));
        }
        for (Town town : remove) {
            kicking.remove(town);
        }
        if (kicking.size() > 0) {
            TownyMessaging.sendPrefixedNationMessage(nation, Translation.of("msg_nation_kicked", sender.getName(), StringMgmt.join(kicking, ", ")));
            plugin.resetCache();
        } else {
            TownyMessaging.sendErrorMsg((Object)sender, Translation.of("msg_invalid_name"));
        }
    }

    private void nationAlly(Player player, String[] split) throws TownyException {
        Nation nation;
        Resident resident;
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        TownyPermissionSource permSource = townyUniverse.getPermissionSource();
        if (split.length <= 0) {
            HelpMenu.ALLIES_STRING.send((CommandSender)player);
            return;
        }
        try {
            resident = NationCommand.getResidentOrThrow(player.getUniqueId());
            nation = resident.getTown().getNation();
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            return;
        }
        ArrayList<Nation> list = new ArrayList<Nation>();
        ArrayList<Nation> remlist = new ArrayList<Nation>();
        String[] names = StringMgmt.remFirstArg(split);
        if (split[0].equalsIgnoreCase("add")) {
            if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_ALLY_ADD.getNode())) {
                throw new TownyException(Translation.of("msg_err_command_disable"));
            }
            for (String name : names) {
                Nation ally = townyUniverse.getNation(name);
                if (ally != null) {
                    if (nation.equals(ally)) {
                        TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_own_nation_disallow"));
                        continue;
                    }
                    if (nation.isAlliedWith(ally)) {
                        TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_already_ally", ally));
                        continue;
                    }
                    list.add(ally);
                    continue;
                }
                if (name.startsWith("-") && TownySettings.isDisallowOneWayAlliance()) {
                    ally = townyUniverse.getNation(name.substring(1));
                    if (ally != null) {
                        if (nation.equals(ally)) {
                            TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_own_nation_disallow"));
                            continue;
                        }
                        remlist.add(ally);
                        continue;
                    }
                    TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_invalid_name", name));
                    continue;
                }
                TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_invalid_name", name));
            }
            if (!list.isEmpty()) {
                if (TownySettings.isDisallowOneWayAlliance()) {
                    this.nationAlly(resident, nation, list, true);
                } else {
                    this.nationlegacyAlly(resident, nation, list, true);
                }
            }
            if (!remlist.isEmpty()) {
                this.nationRemoveAllyRequest(player, nation, remlist);
            }
            return;
        }
        if (split[0].equalsIgnoreCase("remove")) {
            if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_ALLY_REMOVE.getNode())) {
                throw new TownyException(Translation.of("msg_err_command_disable"));
            }
            for (String name : names) {
                Nation ally = townyUniverse.getNation(name);
                if (ally == null) continue;
                if (nation.equals(ally)) {
                    TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_own_nation_disallow"));
                    return;
                }
                list.add(ally);
            }
            if (!list.isEmpty()) {
                if (TownySettings.isDisallowOneWayAlliance()) {
                    this.nationAlly(resident, nation, list, false);
                } else {
                    this.nationlegacyAlly(resident, nation, list, false);
                }
            }
            return;
        }
        if (!TownySettings.isDisallowOneWayAlliance()) {
            HelpMenu.ALLIES_STRING.send((CommandSender)player);
            return;
        }
        if (TownySettings.isDisallowOneWayAlliance()) {
            Nation sendernation;
            Collection invites;
            String received = Translation.of("nation_received_requests").replace("%a", Integer.toString(resident.getTown().getNation().getReceivedInvites().size())).replace("%m", Integer.toString(InviteHandler.getReceivedInvitesMaxAmount(resident.getTown().getNation())));
            String sent = Translation.of("nation_sent_ally_requests").replace("%a", Integer.toString(resident.getTown().getNation().getSentAllyInvites().size())).replace("%m", Integer.toString(InviteHandler.getSentAllyRequestsMaxAmount(resident.getTown().getNation())));
            if (split[0].equalsIgnoreCase("sent")) {
                if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_ALLY_LIST_SENT.getNode())) {
                    throw new TownyException(Translation.of("msg_err_command_disable"));
                }
                List<Invite> sentinvites = resident.getTown().getNation().getSentAllyInvites();
                int page = 1;
                if (split.length >= 2) {
                    try {
                        page = Integer.parseInt(split[2]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                InviteCommand.sendInviteList(player, sentinvites, page, true);
                player.sendMessage(sent);
                return;
            }
            if (split[0].equalsIgnoreCase("received")) {
                if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_ALLY_LIST_RECEIVED.getNode())) {
                    throw new TownyException(Translation.of("msg_err_command_disable"));
                }
                Collection receivedinvites = resident.getTown().getNation().getReceivedInvites();
                int page = 1;
                if (split.length >= 2) {
                    try {
                        page = Integer.parseInt(split[2]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                InviteCommand.sendInviteList(player, (List<Invite>)receivedinvites, page, false);
                player.sendMessage(received);
                return;
            }
            if (split[0].equalsIgnoreCase("accept")) {
                if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_ALLY_ACCEPT.getNode())) {
                    throw new TownyException(Translation.of("msg_err_command_disable"));
                }
                invites = nation.getReceivedInvites();
                if (invites.size() == 0) {
                    TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_nation_no_requests"));
                    return;
                }
                if (split.length >= 2) {
                    sendernation = townyUniverse.getNation(split[1]);
                    if (sendernation == null) {
                        TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_invalid_name"));
                        return;
                    }
                } else {
                    TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_nation_specify_invite"));
                    InviteCommand.sendInviteList(player, (List<Invite>)invites, 1, false);
                    return;
                }
                Invite toAccept = null;
                for (Invite invite : InviteHandler.getActiveInvites()) {
                    if (!invite.getSender().equals(sendernation) || !invite.getReceiver().equals(nation)) continue;
                    toAccept = invite;
                    break;
                }
                if (toAccept != null) {
                    try {
                        NationAcceptAllyRequestEvent acceptAllyRequestEvent = new NationAcceptAllyRequestEvent((Nation)toAccept.getSender(), (Nation)toAccept.getReceiver());
                        Bukkit.getPluginManager().callEvent((Event)acceptAllyRequestEvent);
                        if (acceptAllyRequestEvent.isCancelled()) {
                            toAccept.getReceiver().deleteReceivedInvite(toAccept);
                            toAccept.getSender().deleteSentInvite(toAccept);
                            TownyMessaging.sendErrorMsg((Object)player, acceptAllyRequestEvent.getCancelMessage());
                            return;
                        }
                        InviteHandler.acceptInvite(toAccept);
                        return;
                    }
                    catch (InvalidObjectException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (split[0].equalsIgnoreCase("deny")) {
                if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_ALLY_DENY.getNode())) {
                    throw new TownyException(Translation.of("msg_err_command_disable"));
                }
                invites = nation.getReceivedInvites();
                if (invites.size() == 0) {
                    TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_nation_no_requests"));
                    return;
                }
                if (split.length >= 2) {
                    sendernation = townyUniverse.getNation(split[1]);
                    if (sendernation == null) {
                        TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_invalid_name"));
                        return;
                    }
                } else {
                    TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_nation_specify_invite"));
                    InviteCommand.sendInviteList(player, (List<Invite>)invites, 1, false);
                    return;
                }
                Invite toDecline = null;
                for (Invite invite : InviteHandler.getActiveInvites()) {
                    if (!invite.getSender().equals(sendernation) || !invite.getReceiver().equals(nation)) continue;
                    toDecline = invite;
                    break;
                }
                if (toDecline != null) {
                    try {
                        NationDenyAllyRequestEvent denyAllyRequestEvent = new NationDenyAllyRequestEvent(nation, sendernation);
                        Bukkit.getPluginManager().callEvent((Event)denyAllyRequestEvent);
                        if (denyAllyRequestEvent.isCancelled()) {
                            sendernation.deleteSentAllyInvite(toDecline);
                            nation.deleteReceivedInvite(toDecline);
                            TownyMessaging.sendErrorMsg((Object)player, denyAllyRequestEvent.getCancelMessage());
                            return;
                        }
                        InviteHandler.declineInvite(toDecline, false);
                        TownyMessaging.sendMessage((Object)player, Translation.of("successful_deny_request"));
                    }
                    catch (InvalidObjectException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                HelpMenu.ALLIES_STRING.send((CommandSender)player);
                return;
            }
        }
    }

    private void nationRemoveAllyRequest(Object sender, Nation nation, ArrayList<Nation> remlist) {
        block2: for (Nation invited : remlist) {
            if (!InviteHandler.inviteIsActive(nation, invited)) continue;
            for (Invite invite : invited.getReceivedInvites()) {
                if (!invite.getSender().equals(nation)) continue;
                try {
                    InviteHandler.declineInvite(invite, true);
                    TownyMessaging.sendMessage(sender, Translation.of("town_revoke_invite_successful"));
                    continue block2;
                }
                catch (InvalidObjectException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void nationCreateAllyRequest(CommandSender sender, Nation nation, Nation receiver) throws TownyException {
        NationAllyNationInvite invite = new NationAllyNationInvite(sender, receiver, nation);
        try {
            if (!InviteHandler.inviteIsActive(invite)) {
                receiver.newReceivedInvite(invite);
                nation.newSentAllyInvite(invite);
                InviteHandler.addInvite(invite);
                Player mayor = TownyAPI.getInstance().getPlayer(receiver.getCapital().getMayor());
                if (mayor != null) {
                    TownyMessaging.sendRequestMessage((CommandSender)mayor, invite);
                }
            } else {
                throw new TownyException(Translation.of("msg_err_player_already_invited", receiver.getName()));
            }
            Bukkit.getPluginManager().callEvent((Event)new NationRequestAllyNationEvent(invite));
        }
        catch (TooManyInvitesException e) {
            receiver.deleteReceivedInvite(invite);
            nation.deleteSentAllyInvite(invite);
            throw new TownyException(e.getMessage());
        }
    }

    public void nationlegacyAlly(Resident resident, Nation nation, List<Nation> allies, boolean add) {
        Player player = BukkitTools.getPlayer(resident.getName());
        ArrayList<Nation> remove = new ArrayList<Nation>();
        for (Nation targetNation : allies) {
            try {
                if (add && !nation.getAllies().contains(targetNation)) {
                    if (!targetNation.hasEnemy(nation)) {
                        try {
                            nation.addAlly(targetNation);
                        }
                        catch (AlreadyRegisteredException e) {
                            e.printStackTrace();
                        }
                        TownyMessaging.sendPrefixedNationMessage(nation, Translation.of("msg_allied_nations", resident.getName(), targetNation.getName()));
                        TownyMessaging.sendPrefixedNationMessage(targetNation, Translation.of("msg_added_ally", nation.getName()));
                        continue;
                    }
                    remove.add(targetNation);
                    TownyMessaging.sendPrefixedNationMessage(nation, Translation.of("msg_unable_ally_enemy", targetNation.getName()));
                    continue;
                }
                if (!nation.getAllies().contains(targetNation)) continue;
                nation.removeAlly(targetNation);
                TownyMessaging.sendPrefixedNationMessage(targetNation, Translation.of("msg_removed_ally", nation.getName()));
                TownyMessaging.sendMessage((Object)player, Translation.of("msg_ally_removed_successfully"));
                if (!targetNation.hasAlly(nation)) continue;
                this.nationlegacyAlly(resident, targetNation, Arrays.asList(nation), false);
            }
            catch (NotRegisteredException e) {
                remove.add(targetNation);
            }
        }
        for (Nation newAlly : remove) {
            allies.remove(newAlly);
        }
        if (allies.size() > 0) {
            TownyUniverse.getInstance().getDataSource().saveNations();
            plugin.resetCache();
        } else {
            TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_invalid_name"));
        }
    }

    public void nationAlly(Resident resident, Nation nation, List<Nation> allies, boolean add) throws TownyException {
        Player player = BukkitTools.getPlayer(resident.getName());
        ArrayList<Nation> remove = new ArrayList<Nation>();
        for (Nation targetNation : allies) {
            if (add) {
                if (targetNation.hasEnemy(nation)) continue;
                if (!targetNation.getCapital().getMayor().isNPC()) {
                    for (Nation newAlly : allies) {
                        this.nationCreateAllyRequest((CommandSender)player, nation, targetNation);
                        TownyMessaging.sendPrefixedNationMessage(nation, Translation.of("msg_ally_req_sent", newAlly.getName()));
                    }
                    continue;
                }
                if (TownyUniverse.getInstance().getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN.getNode())) {
                    try {
                        targetNation.addAlly(nation);
                        nation.addAlly(targetNation);
                    }
                    catch (AlreadyRegisteredException e) {
                        e.printStackTrace();
                    }
                    TownyMessaging.sendPrefixedNationMessage(nation, Translation.of("msg_allied_nations", resident.getName(), targetNation.getName()));
                    TownyMessaging.sendPrefixedNationMessage(targetNation, Translation.of("msg_added_ally", nation.getName()));
                    continue;
                }
                TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_unable_ally_npc", nation.getName()));
                continue;
            }
            if (!nation.getAllies().contains(targetNation)) continue;
            try {
                NationRemoveAllyEvent removeAllyEvent = new NationRemoveAllyEvent(nation, targetNation);
                Bukkit.getPluginManager().callEvent((Event)removeAllyEvent);
                if (removeAllyEvent.isCancelled()) {
                    TownyMessaging.sendErrorMsg((Object)player, removeAllyEvent.getCancelMessage());
                    return;
                }
                nation.removeAlly(targetNation);
                TownyMessaging.sendPrefixedNationMessage(targetNation, Translation.of("msg_removed_ally", nation.getName()));
                TownyMessaging.sendMessage((Object)player, Translation.of("msg_ally_removed_successfully"));
            }
            catch (NotRegisteredException e) {
                remove.add(targetNation);
            }
            if (!targetNation.hasAlly(nation)) continue;
            try {
                targetNation.removeAlly(nation);
            }
            catch (NotRegisteredException notRegisteredException) {
            }
        }
        for (Nation newAlly : remove) {
            allies.remove(newAlly);
        }
        if (allies.size() > 0) {
            TownyUniverse.getInstance().getDataSource().saveNations();
            plugin.resetCache();
        } else {
            TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_invalid_name"));
        }
    }

    public void nationEnemy(Player player, String[] split) throws TownyException {
        Nation nation;
        Resident resident;
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (split.length < 2) {
            TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation enemy [add/remove] [name]");
            return;
        }
        try {
            resident = NationCommand.getResidentOrThrow(player.getUniqueId());
            nation = resident.getTown().getNation();
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            return;
        }
        ArrayList<Nation> list = new ArrayList<Nation>();
        String test = split[0];
        String[] newSplit = StringMgmt.remFirstArg(split);
        if ((test.equalsIgnoreCase("remove") || test.equalsIgnoreCase("add")) && newSplit.length > 0) {
            for (String name : newSplit) {
                Nation enemy = townyUniverse.getNation(name);
                if (enemy == null) {
                    throw new TownyException(Translation.of("msg_err_no_nation_with_that_name", name));
                }
                if (nation.equals(enemy)) {
                    TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_own_nation_disallow"));
                    continue;
                }
                list.add(enemy);
            }
            if (!list.isEmpty()) {
                this.nationEnemy(resident, nation, list, test.equalsIgnoreCase("add"));
            }
        } else {
            TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_invalid_property", "[add/remove]"));
        }
    }

    public void nationEnemy(Resident resident, Nation nation, List<Nation> enemies, boolean add) {
        ArrayList<Nation> remove = new ArrayList<Nation>();
        for (Nation targetNation : enemies) {
            try {
                if (add && !nation.getEnemies().contains(targetNation)) {
                    NationPreAddEnemyEvent npaee = new NationPreAddEnemyEvent(nation, targetNation);
                    Bukkit.getPluginManager().callEvent((Event)npaee);
                    if (!npaee.isCancelled()) {
                        nation.addEnemy(targetNation);
                        NationAddEnemyEvent naee = new NationAddEnemyEvent(nation, targetNation);
                        Bukkit.getPluginManager().callEvent((Event)naee);
                        TownyMessaging.sendPrefixedNationMessage(targetNation, Translation.of("msg_added_enemy", nation.getName()));
                        if (!targetNation.hasAlly(nation)) continue;
                        this.nationlegacyAlly(resident, targetNation, Arrays.asList(nation), false);
                        continue;
                    }
                    TownyMessaging.sendMsg((CommandSender)TownyAPI.getInstance().getPlayer(resident), npaee.getCancelMessage());
                    remove.add(targetNation);
                    continue;
                }
                if (!nation.getEnemies().contains(targetNation)) continue;
                NationPreRemoveEnemyEvent npree = new NationPreRemoveEnemyEvent(nation, targetNation);
                Bukkit.getPluginManager().callEvent((Event)npree);
                if (!npree.isCancelled()) {
                    nation.removeEnemy(targetNation);
                    NationRemoveEnemyEvent nree = new NationRemoveEnemyEvent(nation, targetNation);
                    Bukkit.getPluginManager().callEvent((Event)nree);
                    TownyMessaging.sendPrefixedNationMessage(targetNation, Translation.of("msg_removed_enemy", nation.getName()));
                    continue;
                }
                TownyMessaging.sendMsg((CommandSender)TownyAPI.getInstance().getPlayer(resident), npree.getCancelMessage());
                remove.add(targetNation);
            }
            catch (AlreadyRegisteredException | NotRegisteredException e) {
                remove.add(targetNation);
            }
        }
        for (Nation newEnemy : remove) {
            enemies.remove(newEnemy);
        }
        if (enemies.size() > 0) {
            String msg = "";
            for (Nation newEnemy : enemies) {
                msg = msg + newEnemy.getName() + ", ";
            }
            msg = msg.substring(0, msg.length() - 2);
            msg = add ? Translation.of("msg_enemy_nations", resident.getName(), msg) : Translation.of("msg_enemy_to_neutral", resident.getName(), msg);
            TownyMessaging.sendPrefixedNationMessage(nation, msg);
            TownyUniverse.getInstance().getDataSource().saveNations();
            plugin.resetCache();
        } else {
            TownyMessaging.sendErrorMsg((Object)resident, Translation.of("msg_invalid_name"));
        }
    }

    public static void nationSet(Player player, String[] split, boolean admin, Nation nation) throws TownyException, InvalidNameException, EconomyException {
        TownyPermissionSource permSource = TownyUniverse.getInstance().getPermissionSource();
        if (split.length == 0) {
            player.sendMessage(ChatTools.formatTitle("/nation set"));
            player.sendMessage(ChatTools.formatCommand("", "/nation set", "king " + Translation.of("res_2"), ""));
            player.sendMessage(ChatTools.formatCommand("", "/nation set", "capital [town]", ""));
            player.sendMessage(ChatTools.formatCommand("", "/nation set", "taxes [$]", ""));
            player.sendMessage(ChatTools.formatCommand("", "/nation set", "name [name]", ""));
            player.sendMessage(ChatTools.formatCommand("", "/nation set", "title/surname [resident] [text]", ""));
            player.sendMessage(ChatTools.formatCommand("", "/nation set", "tag [upto 4 letters] or clear", ""));
            player.sendMessage(ChatTools.formatCommand("", "/nation set", "board [message ... ]", ""));
            player.sendMessage(ChatTools.formatCommand("", "/nation set", "spawn", ""));
            player.sendMessage(ChatTools.formatCommand("", "/nation set", "spawncost [$]", ""));
            player.sendMessage(ChatTools.formatCommand("", "/nation set", "mapcolor [color]", ""));
        } else {
            block93: {
                Resident resident;
                try {
                    if (!admin) {
                        resident = NationCommand.getResidentOrThrow(player.getUniqueId());
                        nation = resident.getTown().getNation();
                    } else {
                        resident = nation.getKing();
                    }
                }
                catch (TownyException x) {
                    TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
                    return;
                }
                if (split[0].equalsIgnoreCase("king")) {
                    if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_SET_KING.getNode())) {
                        throw new TownyException(Translation.of("msg_err_command_disable"));
                    }
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation set king Dumbo");
                    } else {
                        try {
                            Resident newKing = NationCommand.getResidentOrThrow(split[1]);
                            String oldKingsName = nation.getCapital().getMayor().getName();
                            if (TownySettings.getNumResidentsCreateNation() > 0 && newKing.getTown().getNumResidents() < TownySettings.getNumResidentsCreateNation()) {
                                TownyMessaging.sendMessage((Object)player, Translation.of("msg_not_enough_residents_capital", newKing.getTown().getName()));
                                return;
                            }
                            nation.setKing(newKing);
                            plugin.deleteCache(oldKingsName);
                            plugin.deleteCache(newKing.getName());
                            TownyMessaging.sendPrefixedNationMessage(nation, Translation.of("msg_new_king", newKing.getName(), nation.getName()));
                        }
                        catch (TownyException e) {
                            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                        }
                    }
                } else if (split[0].equalsIgnoreCase("capital")) {
                    try {
                        Town newCapital = TownyUniverse.getInstance().getTown(split[1]);
                        if (newCapital == null) {
                            TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_not_registered_1", split[1]));
                            return;
                        }
                        if (TownySettings.getNumResidentsCreateNation() > 0 && newCapital.getNumResidents() < TownySettings.getNumResidentsCreateNation()) {
                            TownyMessaging.sendMessage((Object)player, Translation.of("msg_not_enough_residents_capital", newCapital.getName()));
                            return;
                        }
                        if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_SET_CAPITOL.getNode())) {
                            throw new TownyException(Translation.of("msg_err_command_disable"));
                        }
                        if (split.length < 2) {
                            TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation set capital {town name}");
                            break block93;
                        }
                        if (TownySettings.getNationRequiresProximity() > 0.0) {
                            List<Town> removedTowns = nation.recheckTownDistanceDryRun(nation.getTowns(), newCapital);
                            if (!removedTowns.isEmpty()) {
                                String title = Translation.of("msg_warn_the_following_towns_will_be_removed_from_your_nation", StringMgmt.join(removedTowns, ", "));
                                Nation finalNation = nation;
                                Confirmation.runOnAccept(() -> {
                                    try {
                                        finalNation.setCapital(newCapital);
                                        finalNation.recheckTownDistance();
                                        plugin.resetCache();
                                        TownyMessaging.sendPrefixedNationMessage(finalNation, Translation.of("msg_new_king", newCapital.getMayor().getName(), finalNation.getName()));
                                    }
                                    catch (TownyException e) {
                                        TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                                    }
                                }).setTitle(title).sendTo((CommandSender)player);
                            } else {
                                nation.setCapital(newCapital);
                                plugin.resetCache();
                                TownyMessaging.sendPrefixedNationMessage(nation, Translation.of("msg_new_king", newCapital.getMayor().getName(), nation.getName()));
                                nation.save();
                            }
                            break block93;
                        }
                        nation.setCapital(newCapital);
                        plugin.resetCache();
                        TownyMessaging.sendPrefixedNationMessage(nation, Translation.of("msg_new_king", newCapital.getMayor().getName(), nation.getName()));
                        nation.save();
                    }
                    catch (TownyException e) {
                        TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                    }
                } else if (split[0].equalsIgnoreCase("spawn")) {
                    if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_SET_SPAWN.getNode())) {
                        throw new TownyException(Translation.of("msg_err_command_disable"));
                    }
                    try {
                        nation.setSpawn(player.getLocation());
                        TownyMessaging.sendMsg((CommandSender)player, Translation.of("msg_set_nation_spawn"));
                    }
                    catch (TownyException e) {
                        TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                    }
                } else if (split[0].equalsIgnoreCase("taxes")) {
                    if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_SET_TAXES.getNode())) {
                        throw new TownyException(Translation.of("msg_err_command_disable"));
                    }
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation set taxes 70");
                    } else {
                        int amount = Integer.parseInt(split[1].trim());
                        if (amount < 0) {
                            TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_negative_money"));
                            return;
                        }
                        try {
                            nation.setTaxes(amount);
                            TownyMessaging.sendPrefixedNationMessage(nation, Translation.of("msg_town_set_nation_tax", player.getName(), split[1]));
                        }
                        catch (NumberFormatException e) {
                            TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_error_must_be_int"));
                        }
                    }
                } else if (split[0].equalsIgnoreCase("spawncost")) {
                    if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_SET_SPAWNCOST.getNode())) {
                        throw new TownyException(Translation.of("msg_err_command_disable"));
                    }
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation set spawncost 70");
                    } else {
                        try {
                            double amount = Double.parseDouble(split[1]);
                            if (amount < 0.0) {
                                TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_negative_money"));
                                return;
                            }
                            if (TownySettings.getSpawnTravelCost() < amount) {
                                TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_cannot_set_spawn_cost_more_than", TownySettings.getSpawnTravelCost()));
                                return;
                            }
                            nation.setSpawnCost(amount);
                            TownyMessaging.sendPrefixedNationMessage(nation, Translation.of("msg_spawn_cost_set_to", player.getName(), Translation.of("nation_sing"), split[1]));
                        }
                        catch (NumberFormatException e) {
                            TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_error_must_be_num"));
                            return;
                        }
                    }
                } else if (split[0].equalsIgnoreCase("name")) {
                    if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_SET_NAME.getNode())) {
                        throw new TownyException(Translation.of("msg_err_command_disable"));
                    }
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation set name Plutoria");
                    } else {
                        if (NameValidation.isBlacklistName(split[1])) {
                            throw new TownyException(Translation.of("msg_invalid_name"));
                        }
                        if (TownyEconomyHandler.isActive() && TownySettings.getNationRenameCost() > 0.0) {
                            if (!nation.getAccount().canPayFromHoldings(TownySettings.getNationRenameCost())) {
                                throw new EconomyException(Translation.of("msg_err_no_money", TownyEconomyHandler.getFormattedBalance(TownySettings.getNationRenameCost())));
                            }
                            Nation finalNation = nation;
                            String name = split[1];
                            Confirmation.runOnAccept(() -> {
                                try {
                                    finalNation.getAccount().withdraw(TownySettings.getNationRenameCost(), String.format("Nation renamed to: %s", name));
                                }
                                catch (EconomyException economyException) {
                                    // empty catch block
                                }
                                NationCommand.nationRename(player, finalNation, name);
                            }).setTitle(Translation.of("msg_confirm_purchase", TownyEconomyHandler.getFormattedBalance(TownySettings.getNationRenameCost()))).sendTo((CommandSender)player);
                        } else {
                            NationCommand.nationRename(player, nation, split[1]);
                        }
                    }
                } else if (split[0].equalsIgnoreCase("tag")) {
                    if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_SET_TAG.getNode())) {
                        throw new TownyException(Translation.of("msg_err_command_disable"));
                    }
                    if (split.length < 2) {
                        throw new TownyException("Eg: /nation set tag PLT");
                    }
                    if (split[1].equalsIgnoreCase("clear")) {
                        nation.setTag(" ");
                        TownyMessaging.sendPrefixedNationMessage(nation, Translation.of("msg_reset_nation_tag", player.getName()));
                    } else {
                        nation.setTag(NameValidation.checkAndFilterName(split[1]));
                        TownyMessaging.sendPrefixedNationMessage(nation, Translation.of("msg_set_nation_tag", player.getName(), nation.getTag()));
                    }
                } else if (split[0].equalsIgnoreCase("title")) {
                    if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_SET_TITLE.getNode())) {
                        throw new TownyException(Translation.of("msg_err_command_disable"));
                    }
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation set title bilbo Jester ");
                    } else {
                        resident = NationCommand.getResidentOrThrow(split[1]);
                    }
                    if (!CombatUtil.isSameNation(NationCommand.getResidentOrThrow(player.getUniqueId()), resident)) {
                        TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_not_same_nation", resident.getName()));
                        return;
                    }
                    String title = StringMgmt.join(NameValidation.checkAndFilterArray(StringMgmt.remArgs(split, 2)));
                    if (title.length() > TownySettings.getMaxTitleLength()) {
                        TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_input_too_long"));
                        return;
                    }
                    resident.setTitle(title);
                    resident.save();
                    if (resident.hasTitle()) {
                        TownyMessaging.sendPrefixedNationMessage(nation, Translation.of("msg_set_title", resident.getName(), resident.getTitle()));
                    } else {
                        TownyMessaging.sendPrefixedNationMessage(nation, Translation.of("msg_clear_title_surname", "Title", resident.getName()));
                    }
                } else if (split[0].equalsIgnoreCase("surname")) {
                    if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_SET_SURNAME.getNode())) {
                        throw new TownyException(Translation.of("msg_err_command_disable"));
                    }
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation set surname bilbo the dwarf ");
                    } else {
                        resident = NationCommand.getResidentOrThrow(split[1]);
                    }
                    if (!CombatUtil.isSameNation(NationCommand.getResidentOrThrow(player.getUniqueId()), resident)) {
                        TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_not_same_nation", resident.getName()));
                        return;
                    }
                    String surname = StringMgmt.join(NameValidation.checkAndFilterArray(StringMgmt.remArgs(split, 2)));
                    if (surname.length() > TownySettings.getMaxTitleLength()) {
                        TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_input_too_long"));
                        return;
                    }
                    resident.setSurname(surname);
                    resident.save();
                    if (resident.hasSurname()) {
                        TownyMessaging.sendPrefixedNationMessage(nation, Translation.of("msg_set_surname", resident.getName(), resident.getSurname()));
                    } else {
                        TownyMessaging.sendPrefixedNationMessage(nation, Translation.of("msg_clear_title_surname", "Surname", resident.getName()));
                    }
                } else if (split[0].equalsIgnoreCase("board")) {
                    if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_SET_BOARD.getNode())) {
                        throw new TownyException(Translation.of("msg_err_command_disable"));
                    }
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation set board " + Translation.of("town_help_9"));
                        return;
                    }
                    String line = StringMgmt.join(StringMgmt.remFirstArg(split), " ");
                    if (!line.equals("none")) {
                        if (!NameValidation.isValidString(line)) {
                            TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_invalid_string_nationboard_not_set"));
                            return;
                        }
                        if (line.length() > 159) {
                            line = line.substring(0, 159);
                        }
                    } else {
                        line = "";
                    }
                    nation.setBoard(line);
                    TownyMessaging.sendNationBoard(player, nation);
                } else if (split[0].equalsIgnoreCase("mapcolor")) {
                    if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_SET_MAPCOLOR.getNode())) {
                        throw new TownyException(Translation.of("msg_err_command_disable"));
                    }
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation set mapcolor brown.");
                        return;
                    }
                    String line = StringMgmt.join(StringMgmt.remFirstArg(split), " ");
                    if (!TownySettings.getNationColorsMap().containsKey(line.toLowerCase())) {
                        String allowedColorsListAsString = TownySettings.getNationColorsMap().keySet().toString();
                        TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_invalid_nation_map_color", allowedColorsListAsString));
                        return;
                    }
                    nation.setMapColorHexCode(TownySettings.getNationColorsMap().get(line.toLowerCase()));
                    TownyMessaging.sendPrefixedNationMessage(nation, Translation.of("msg_nation_map_color_changed", line.toLowerCase()));
                } else {
                    TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_invalid_property", split[0]));
                    return;
                }
            }
            nation.save();
        }
    }

    public static void nationToggle(CommandSender sender, String[] split, boolean admin, Nation nation) throws TownyException {
        if (split.length == 0 || split[0].equalsIgnoreCase("?") || split[0].equalsIgnoreCase("help")) {
            HelpMenu.NATION_TOGGLE_HELP.send(sender);
        } else {
            try {
                if (!admin) {
                    Resident resident = NationCommand.getResidentOrThrow(((Player)sender).getUniqueId());
                    nation = resident.getTown().getNation();
                } else {
                    Resident resident = nation.getKing();
                }
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg((Object)sender, x.getMessage());
                return;
            }
            if (!admin && !TownyUniverse.getInstance().getPermissionSource().testPermission((Player)sender, PermissionNodes.TOWNY_COMMAND_NATION_TOGGLE.getNode(split[0].toLowerCase()))) {
                throw new TownyException(Translation.of("msg_err_command_disable"));
            }
            Optional<Object> choice = Optional.empty();
            if (split.length == 2) {
                choice = BaseCommand.parseToggleChoice(split[1]);
            }
            if (split[0].equalsIgnoreCase("peaceful") || split[0].equalsIgnoreCase("neutral")) {
                boolean value = choice.orElse(!nation.isNeutral());
                double cost = TownySettings.getNationNeutralityCost();
                if (nation.isNeutral() && value) {
                    throw new TownyException(Translation.of("msg_nation_already_peaceful"));
                }
                if (!nation.isNeutral() && !value) {
                    throw new TownyException(Translation.of("msg_nation_already_not_peaceful"));
                }
                try {
                    if (value && TownyEconomyHandler.isActive() && !nation.getAccount().canPayFromHoldings(cost)) {
                        throw new TownyException(Translation.of("msg_nation_cant_peaceful"));
                    }
                }
                catch (EconomyException economyException) {
                    // empty catch block
                }
                NationToggleNeutralEvent preEvent = new NationToggleNeutralEvent(sender, nation, admin, value);
                Bukkit.getPluginManager().callEvent((Event)preEvent);
                if (preEvent.isCancelled()) {
                    throw new TownyException(preEvent.getCancelMessage());
                }
                try {
                    if (value && TownyEconomyHandler.isActive() && cost > 0.0) {
                        nation.getAccount().withdraw(cost, "Peaceful Nation Cost");
                    }
                }
                catch (EconomyException economyException) {
                    // empty catch block
                }
                nation.setNeutral(value);
                if (value && TownyEconomyHandler.isActive() && cost > 0.0) {
                    TownyMessaging.sendMsg(sender, Translation.of("msg_you_paid", TownyEconomyHandler.getFormattedBalance(cost)));
                }
                TownyMessaging.sendPrefixedNationMessage(nation, Translation.of("msg_nation_peaceful") + (nation.isNeutral() ? "\u00a72" : "\u00a74 not") + " peaceful.");
            } else if (split[0].equalsIgnoreCase("public")) {
                NationTogglePublicEvent preEvent = new NationTogglePublicEvent(sender, nation, admin, (Boolean)choice.orElse(!nation.isPublic()));
                Bukkit.getPluginManager().callEvent((Event)preEvent);
                if (preEvent.isCancelled()) {
                    throw new TownyException(preEvent.getCancelMessage());
                }
                nation.setPublic(preEvent.getFutureState());
                TownyMessaging.sendPrefixedNationMessage(nation, Translation.of("msg_nation_changed_public", nation.isPublic() ? Translation.of("enabled") : Translation.of("disabled")));
            } else if (split[0].equalsIgnoreCase("open")) {
                NationToggleOpenEvent preEvent = new NationToggleOpenEvent(sender, nation, admin, (Boolean)choice.orElse(!nation.isOpen()));
                Bukkit.getPluginManager().callEvent((Event)preEvent);
                if (preEvent.isCancelled()) {
                    throw new TownyException(preEvent.getCancelMessage());
                }
                nation.setOpen(preEvent.getFutureState());
                TownyMessaging.sendPrefixedNationMessage(nation, Translation.of("msg_nation_changed_open", nation.isOpen() ? Translation.of("enabled") : Translation.of("disabled")));
            } else {
                NationToggleUnknownEvent event = new NationToggleUnknownEvent(sender, nation, admin, split);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    TownyMessaging.sendErrorMsg((Object)sender, event.getCancelMessage());
                    return;
                }
            }
            nation.save();
        }
    }

    public static void nationRename(Player player, Nation nation, String newName) {
        NationPreRenameEvent event = new NationPreRenameEvent(nation, newName);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_rename_cancelled"));
            return;
        }
        try {
            TownyUniverse.getInstance().getDataSource().renameNation(nation, newName);
            TownyMessaging.sendPrefixedNationMessage(nation, Translation.of("msg_nation_set_name", player.getName(), nation.getName()));
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
        }
    }

    public static void nationSpawn(Player player, String[] split, boolean ignoreWarning) throws TownyException {
        try {
            String notAffordMSG;
            Nation nation;
            Resident resident = NationCommand.getResidentOrThrow(player.getUniqueId());
            if (split.length == 0) {
                if (!resident.hasTown()) {
                    TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_dont_belong_nation"));
                    return;
                }
                if (!resident.getTown().hasNation()) {
                    TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_dont_belong_nation"));
                    return;
                }
                nation = resident.getTown().getNation();
                notAffordMSG = Translation.of("msg_err_cant_afford_tp");
            } else {
                nation = NationCommand.getNationOrThrow(split[0]);
                notAffordMSG = Translation.of("msg_err_cant_afford_tp_nation", nation.getName());
            }
            SpawnUtil.sendToTownySpawn(player, split, nation, notAffordMSG, false, ignoreWarning, SpawnType.NATION);
        }
        catch (NotRegisteredException e) {
            throw new TownyException(Translation.of("msg_err_not_registered_1", split[0]));
        }
    }

    private static void nationTransaction(Player player, String[] args, boolean withdraw) {
        block13: {
            try {
                int amount;
                Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
                if (resident == null || !resident.hasNation()) {
                    throw new TownyException(Translation.of("msg_err_dont_belong_nation"));
                }
                if (args.length < 2 || args.length > 3) {
                    throw new TownyException(Translation.of("msg_must_specify_amnt", "/nation" + (withdraw ? " withdraw" : " deposit")));
                }
                try {
                    amount = Integer.parseInt(args[1].trim());
                }
                catch (NumberFormatException ex) {
                    throw new TownyException(Translation.of("msg_error_must_be_int"));
                }
                if (args.length == 2) {
                    if (withdraw) {
                        MoneyUtil.nationWithdraw(player, resident, resident.getTown().getNation(), amount);
                    } else {
                        MoneyUtil.nationDeposit(player, resident, resident.getTown().getNation(), amount);
                    }
                    return;
                }
                if (withdraw) {
                    throw new TownyException(Translation.of("msg_must_specify_amnt", "/nation withdraw"));
                }
                if (args.length != 3) break block13;
                if (!TownyUniverse.getInstance().getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_NATION_DEPOSIT_OTHER.getNode())) {
                    throw new TownyException(Translation.of("msg_err_command_disable"));
                }
                Town town = TownyUniverse.getInstance().getTown(args[2]);
                if (town != null) {
                    if (!resident.getTown().getNation().hasTown(town)) {
                        throw new TownyException(Translation.of("msg_err_not_same_nation", town.getName()));
                    }
                    MoneyUtil.townDeposit(player, resident, town, resident.getTown().getNation(), amount);
                    break block13;
                }
                throw new NotRegisteredException();
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
            }
        }
    }

    static {
        nationTabCompletes = Arrays.asList("list", "online", "leave", "withdraw", "deposit", "new", "rank", "add", "kick", "delete", "enemy", "rank", "say", "set", "toggle", "join", "merge", "townlist", "allylist", "enemylist", "ally", "spawn", "king", "bankhistory");
        nationSetTabCompletes = Arrays.asList("king", "capital", "board", "taxes", "name", "spawn", "spawncost", "title", "surname", "tag", "mapcolor");
        nationListTabCompletes = Arrays.asList("residents", "balance", "name", "online", "open", "public", "townblocks", "towns");
        nationToggleTabCompletes = Arrays.asList("neutral", "peaceful", "public", "open");
        nationEnemyTabCompletes = Arrays.asList("add", "remove");
        nationAllyTabCompletes = Arrays.asList("add", "remove", "sent", "received", "accept", "deny");
        nationKingTabCompletes = Collections.singletonList("?");
        nationConsoleTabCompletes = Arrays.asList("?", "help", "list");
    }
}

