/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import com.google.common.collect.Iterables;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.command.BaseCommand;
import com.palmergames.bukkit.towny.command.HelpMenu;
import com.palmergames.bukkit.towny.confirmations.Confirmation;
import com.palmergames.bukkit.towny.event.PlotClearEvent;
import com.palmergames.bukkit.towny.event.PlotPreChangeTypeEvent;
import com.palmergames.bukkit.towny.event.PlotPreClearEvent;
import com.palmergames.bukkit.towny.event.TownBlockSettingsChangedEvent;
import com.palmergames.bukkit.towny.event.plot.PlotNotForSaleEvent;
import com.palmergames.bukkit.towny.event.plot.PlotSetForSaleEvent;
import com.palmergames.bukkit.towny.event.plot.toggle.PlotToggleExplosionEvent;
import com.palmergames.bukkit.towny.event.plot.toggle.PlotToggleFireEvent;
import com.palmergames.bukkit.towny.event.plot.toggle.PlotToggleMobsEvent;
import com.palmergames.bukkit.towny.event.plot.toggle.PlotTogglePvpEvent;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.PlotGroup;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyPermissionChange;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.permissions.TownyPermissionSource;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.tasks.CooldownTimerTask;
import com.palmergames.bukkit.towny.tasks.PlotClaim;
import com.palmergames.bukkit.towny.utils.AreaSelectionUtil;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.utils.NameUtil;
import com.palmergames.bukkit.towny.utils.OutpostUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.NameValidation;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class PlotCommand
extends BaseCommand
implements CommandExecutor {
    private static Towny plugin;
    private static final List<String> plotTabCompletes;
    private static final List<String> plotGroupTabCompletes;
    private static final List<String> plotSetTabCompletes;
    private static final List<String> plotRectCircleCompletes;
    private static final List<String> plotToggleTabCompletes;

    public PlotCommand(Towny instance) {
        plugin = instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (sender instanceof Player) {
            if (plugin.isError()) {
                sender.sendMessage("\u00a7c[Towny Error] Locked in Safe mode!");
                return false;
            }
            Player player = (Player)sender;
            try {
                if (!TownyUniverse.getInstance().getDataSource().getWorld(player.getWorld().getName()).isUsingTowny()) {
                    TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_set_use_towny_off"));
                    return false;
                }
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
            if (args == null) {
                HelpMenu.PLOT_HELP.send((CommandSender)player);
                return true;
            }
            try {
                return this.parsePlotCommand(player, args);
            }
            catch (TownyException x) {
                x.getMessage();
                return true;
            }
        }
        HelpMenu.PLOT_HELP.send(sender);
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (sender instanceof Player) {
            switch (args[0].toLowerCase()) {
                case "set": {
                    if (args.length == 2) {
                        return NameUtil.filterByStart(plotSetTabCompletes, args[1]);
                    }
                    if (args.length <= 2 || !args[1].equalsIgnoreCase("perm")) break;
                    return PlotCommand.permTabComplete(StringMgmt.remArgs(args, 2));
                }
                case "toggle": {
                    if (args.length == 2) {
                        return NameUtil.filterByStart(plotToggleTabCompletes, args[1]);
                    }
                    if (args.length != 3) break;
                    return NameUtil.filterByStart(BaseCommand.setOnOffCompletes, args[2]);
                }
                case "claim": 
                case "unclaim": 
                case "notforsale": 
                case "nfs": {
                    if (args.length != 2) break;
                    return NameUtil.filterByStart(plotRectCircleCompletes, args[1]);
                }
                case "forsale": 
                case "fs": {
                    switch (args.length) {
                        case 2: {
                            return NameUtil.filterByStart(Collections.singletonList("within"), args[1]);
                        }
                        case 3: {
                            return NameUtil.filterByStart(plotRectCircleCompletes, args[2]);
                        }
                    }
                    break;
                }
                case "group": {
                    if (args.length == 2) {
                        return NameUtil.filterByStart(plotGroupTabCompletes, args[1]);
                    }
                    if (args.length <= 2) break;
                    return PlotCommand.permTabComplete(StringMgmt.remFirstArg(args));
                }
                case "perm": {
                    if (args.length != 2) break;
                    return NameUtil.filterByStart(Collections.singletonList("hud"), args[1]);
                }
                default: {
                    if (args.length != 1) break;
                    return NameUtil.filterByStart(plotTabCompletes, args[0]);
                }
            }
        }
        return Collections.emptyList();
    }

    public boolean parsePlotCommand(Player player, String[] split) throws TownyException {
        block112: {
            TownyPermissionSource permSource = TownyUniverse.getInstance().getPermissionSource();
            if (split.length == 0 || split[0].equalsIgnoreCase("?")) {
                HelpMenu.PLOT_HELP.send((CommandSender)player);
            } else {
                Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
                if (resident == null) {
                    TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_not_registered"));
                    return true;
                }
                String world = player.getWorld().getName();
                try {
                    if (!TownyAPI.getInstance().isWilderness(player.getLocation()) && TownyAPI.getInstance().getTownBlock(player.getLocation()).getTown().isRuined()) {
                        throw new TownyException(Translation.of("msg_err_cannot_use_command_because_town_ruined"));
                    }
                    if (split[0].equalsIgnoreCase("claim")) {
                        if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_CLAIM.getNode())) {
                            throw new TownyException(Translation.of("msg_err_command_disable"));
                        }
                        if (TownyAPI.getInstance().isWarTime()) {
                            throw new TownyException(Translation.of("msg_war_cannot_do"));
                        }
                        List<WorldCoord> selection = AreaSelectionUtil.selectWorldCoordArea(resident, new WorldCoord(world, Coord.parseCoord((Entity)player)), StringMgmt.remFirstArg(split));
                        selection = AreaSelectionUtil.filterPlotsForSale(selection);
                        if ((selection = AreaSelectionUtil.filterUnownedBlocks(resident, selection)).size() > 0) {
                            if (selection.size() > TownySettings.getMaxResidentPlots(resident)) {
                                throw new TownyException(Translation.of("msg_max_plot_own", TownySettings.getMaxResidentPlots(resident)));
                            }
                            double cost = 0.0;
                            for (WorldCoord worldCoord : new ArrayList<WorldCoord>(selection)) {
                                try {
                                    TownBlock townBlock = worldCoord.getTownBlock();
                                    double d = townBlock.getPlotPrice();
                                    if (townBlock.hasPlotObjectGroup()) {
                                        PlotGroup group = townBlock.getPlotObjectGroup();
                                        if (TownyEconomyHandler.isActive() && !resident.getAccount().canPayFromHoldings(group.getPrice())) {
                                            throw new TownyException(Translation.of("msg_no_funds_claim_plot_group", group.getTownBlocks().size(), TownyEconomyHandler.getFormattedBalance(group.getPrice())));
                                        }
                                        Confirmation.runOnAccept(() -> {
                                            ArrayList<WorldCoord> coords = new ArrayList<WorldCoord>();
                                            group.getTownBlocks().forEach(tb -> coords.add(tb.getWorldCoord()));
                                            new PlotClaim(Towny.getPlugin(), player, resident, coords, true, false, true).start();
                                        }).setTitle(Translation.of("msg_plot_group_claim_confirmation", group.getTownBlocks().size()) + " " + TownyEconomyHandler.getFormattedBalance(group.getPrice()) + ". " + Translation.of("are_you_sure_you_want_to_continue")).sendTo((CommandSender)player);
                                        return true;
                                    }
                                    if (d > -1.0) {
                                        cost += townBlock.getPlotPrice();
                                        continue;
                                    }
                                    if (townBlock.getTown().isMayor(resident)) continue;
                                    selection.remove(worldCoord);
                                }
                                catch (NotRegisteredException e) {
                                    selection.remove(worldCoord);
                                }
                            }
                            int maxPlots = TownySettings.getMaxResidentPlots(resident);
                            int extraPlots = TownySettings.getMaxResidentExtraPlots(resident);
                            if (maxPlots != -1) {
                                maxPlots += extraPlots;
                            }
                            if (maxPlots >= 0 && resident.getTownBlocks().size() + selection.size() > maxPlots) {
                                throw new TownyException(Translation.of("msg_max_plot_own", maxPlots));
                            }
                            if (TownyEconomyHandler.isActive() && !resident.getAccount().canPayFromHoldings(cost)) {
                                throw new TownyException(Translation.of("msg_no_funds_claim_plot", TownyEconomyHandler.getFormattedBalance(cost)));
                            }
                            if (cost != 0.0) {
                                String title = Translation.of("msg_confirm_purchase", TownyEconomyHandler.getFormattedBalance(cost));
                                List<WorldCoord> list = selection;
                                Confirmation.runOnAccept(() -> new PlotClaim(plugin, player, resident, finalSelection, true, false, false).start()).setTitle(title).sendTo((CommandSender)player);
                            } else {
                                new PlotClaim(plugin, player, resident, selection, true, false, false).start();
                            }
                        } else {
                            player.sendMessage(Translation.of("msg_err_empty_area_selection"));
                        }
                        break block112;
                    }
                    if (split[0].equalsIgnoreCase("evict")) {
                        if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_EVICT.getNode())) {
                            throw new TownyException(Translation.of("msg_err_command_disable"));
                        }
                        if (TownyAPI.getInstance().isWarTime()) {
                            throw new TownyException(Translation.of("msg_war_cannot_do"));
                        }
                        if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_ASMAYOR.getNode())) {
                            throw new TownyException(Translation.of("msg_err_command_disable"));
                        }
                        TownBlock townBlock = new WorldCoord(world, Coord.parseCoord((Entity)player)).getTownBlock();
                        Town town = townBlock.getTown();
                        if (townBlock.getResident() == null) {
                            TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_no_one_to_evict"));
                        } else {
                            Resident owner = townBlock.getResident();
                            if (!town.equals(resident.getTown())) {
                                TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_not_part_town"));
                                return false;
                            }
                            if (townBlock.hasPlotObjectGroup()) {
                                for (TownBlock tb2 : townBlock.getPlotObjectGroup().getTownBlocks()) {
                                    owner = tb2.getResident();
                                    tb2.setResident(null);
                                    tb2.setPlotPrice(-1.0);
                                    tb2.setType(townBlock.getType());
                                    owner.save();
                                    tb2.save();
                                }
                                player.sendMessage(Translation.of("msg_plot_evict_group", townBlock.getPlotObjectGroup().getName()));
                                return true;
                            }
                            townBlock.setResident(null);
                            townBlock.setPlotPrice(-1.0);
                            townBlock.setType(townBlock.getType());
                            owner.save();
                            townBlock.save();
                            player.sendMessage(Translation.of("msg_plot_evict"));
                        }
                        break block112;
                    }
                    if (split[0].equalsIgnoreCase("unclaim")) {
                        if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_UNCLAIM.getNode())) {
                            throw new TownyException(Translation.of("msg_err_command_disable"));
                        }
                        if (TownyAPI.getInstance().isWarTime()) {
                            throw new TownyException(Translation.of("msg_war_cannot_do"));
                        }
                        if (split.length == 2 && split[1].equalsIgnoreCase("all")) {
                            new PlotClaim(plugin, player, resident, null, false, false, false).start();
                        } else {
                            List<WorldCoord> selection = AreaSelectionUtil.selectWorldCoordArea(resident, new WorldCoord(world, Coord.parseCoord((Entity)player)), StringMgmt.remFirstArg(split));
                            if ((selection = AreaSelectionUtil.filterOwnedBlocks(resident, selection)).size() > 0) {
                                Iterator<WorldCoord> town = selection.iterator();
                                if (town.hasNext()) {
                                    WorldCoord coord = town.next();
                                    TownBlock block = coord.getTownBlock();
                                    if (!block.hasPlotObjectGroup()) {
                                        new PlotClaim(plugin, player, resident, selection, false, false, false).start();
                                        return true;
                                    }
                                    ArrayList groupSelection = new ArrayList();
                                    block.getPlotObjectGroup().getTownBlocks().forEach(tb -> groupSelection.add(tb.getWorldCoord()));
                                    Confirmation.runOnAccept(() -> new PlotClaim(Towny.getPlugin(), player, resident, groupSelection, false, false, false).start()).setTitle(Translation.of("msg_plot_group_unclaim_confirmation", block.getPlotObjectGroup().getTownBlocks().size()) + " " + Translation.of("are_you_sure_you_want_to_continue")).sendTo((CommandSender)player);
                                    return true;
                                }
                            } else {
                                player.sendMessage(Translation.of("msg_err_empty_area_selection"));
                            }
                        }
                        break block112;
                    }
                    if (split[0].equalsIgnoreCase("notforsale") || split[0].equalsIgnoreCase("nfs")) {
                        if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_NOTFORSALE.getNode())) {
                            throw new TownyException(Translation.of("msg_err_command_disable"));
                        }
                        WorldCoord pos = new WorldCoord(world, Coord.parseCoord((Entity)player));
                        List<WorldCoord> selection = AreaSelectionUtil.selectWorldCoordArea(resident, new WorldCoord(world, Coord.parseCoord((Entity)player)), StringMgmt.remFirstArg(split));
                        selection = AreaSelectionUtil.filterPlotsForSale(selection);
                        if (permSource.testPermission(player, PermissionNodes.TOWNY_ADMIN.getNode())) {
                            for (WorldCoord worldCoord : selection) {
                                if (worldCoord.getTownBlock().hasPlotObjectGroup()) {
                                    TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_plot_belongs_to_group_plot_nfs", worldCoord));
                                    return false;
                                }
                                this.setPlotForSale(resident, worldCoord, -1.0);
                            }
                            return true;
                        }
                        if (permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_ASMAYOR.getNode()) && resident.hasTown() && resident.getTown() == pos.getTownBlock().getTown()) {
                            selection = AreaSelectionUtil.filterOwnedBlocks(resident.getTown(), selection);
                            selection = AreaSelectionUtil.filterOutResidentBlocks(resident, selection);
                        } else {
                            selection = AreaSelectionUtil.filterOwnedBlocks(resident, selection);
                        }
                        if (selection.isEmpty()) {
                            throw new TownyException(Translation.of("msg_err_empty_area_selection"));
                        }
                        for (WorldCoord worldCoord : selection) {
                            if (worldCoord.getTownBlock().hasPlotObjectGroup()) {
                                TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_plot_belongs_to_group_plot_nfs", worldCoord));
                                continue;
                            }
                            this.setPlotForSale(resident, worldCoord, -1.0);
                        }
                        break block112;
                    }
                    if (split[0].equalsIgnoreCase("forsale") || split[0].equalsIgnoreCase("fs")) {
                        if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_FORSALE.getNode())) {
                            throw new TownyException(Translation.of("msg_err_command_disable"));
                        }
                        WorldCoord pos = new WorldCoord(world, Coord.parseCoord((Entity)player));
                        double plotPrice = pos.getTownBlock().getTown().getPlotTypePrice(pos.getTownBlock().getType());
                        if (split.length > 1) {
                            List<Object> selection;
                            int areaSelectPivot = AreaSelectionUtil.getAreaSelectPivot(split);
                            if (areaSelectPivot >= 0) {
                                selection = AreaSelectionUtil.selectWorldCoordArea(resident, new WorldCoord(world, Coord.parseCoord((Entity)player)), StringMgmt.subArray(split, areaSelectPivot + 1, split.length));
                                if (permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_ASMAYOR.getNode()) && resident.hasTown() && resident.getTown() == pos.getTownBlock().getTown()) {
                                    selection = AreaSelectionUtil.filterOwnedBlocks(resident.getTown(), selection);
                                    selection = AreaSelectionUtil.filterOutResidentBlocks(resident, selection);
                                } else {
                                    selection = AreaSelectionUtil.filterOwnedBlocks(resident, selection);
                                }
                                if (selection.isEmpty()) {
                                    throw new TownyException(Translation.of("msg_err_empty_area_selection"));
                                }
                            } else {
                                selection = new ArrayList<WorldCoord>();
                                selection.add(pos);
                            }
                            if (areaSelectPivot != 1) {
                                try {
                                    plotPrice = Double.parseDouble(split[1]);
                                    if (plotPrice < 0.0) {
                                        TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_negative_money"));
                                        return true;
                                    }
                                }
                                catch (NumberFormatException e) {
                                    TownyMessaging.sendMessage((Object)resident, Translation.of("msg_error_must_be_num"));
                                    return true;
                                }
                            }
                            for (WorldCoord worldCoord : selection) {
                                TownBlock townBlock = worldCoord.getTownBlock();
                                if (townBlock.hasPlotObjectGroup()) {
                                    TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_plot_belongs_to_group_plot_fs2", worldCoord));
                                    continue;
                                }
                                this.setPlotForSale(resident, worldCoord, plotPrice);
                            }
                            break block112;
                        }
                        if (pos.getTownBlock().hasPlotObjectGroup()) {
                            TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_plot_belongs_to_group_plot_fs2", pos));
                            return false;
                        }
                        this.setPlotForSale(resident, pos, plotPrice);
                        break block112;
                    }
                    if (split[0].equalsIgnoreCase("perm") || split[0].equalsIgnoreCase("info")) {
                        if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_PERM.getNode())) {
                            throw new TownyException(Translation.of("msg_err_command_disable"));
                        }
                        if (split.length > 1 && split[1].equalsIgnoreCase("hud")) {
                            if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_PERM_HUD.getNode())) {
                                throw new TownyException(Translation.of("msg_err_command_disable"));
                            }
                            plugin.getHUDManager().togglePermHUD(player);
                        } else if (TownyAPI.getInstance().isWilderness(player.getLocation())) {
                            TownyMessaging.sendMessage((Object)player, TownyFormatter.getStatus(TownyUniverse.getInstance().getDataSource().getWorld(player.getLocation().getWorld().getName())));
                        } else {
                            TownBlock townBlock = new WorldCoord(world, Coord.parseCoord((Entity)player)).getTownBlock();
                            TownyMessaging.sendMessage((Object)player, TownyFormatter.getStatus(townBlock));
                        }
                        break block112;
                    }
                    if (split[0].equalsIgnoreCase("toggle")) {
                        TownBlock townBlock = new WorldCoord(world, Coord.parseCoord((Entity)player)).getTownBlock();
                        this.plotTestOwner(resident, townBlock);
                        if (townBlock.hasPlotObjectGroup()) {
                            TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_plot_belongs_to_group_toggle"));
                            return false;
                        }
                        this.plotToggle(player, new WorldCoord(world, Coord.parseCoord((Entity)player)).getTownBlock(), StringMgmt.remFirstArg(split));
                        break block112;
                    }
                    if (split[0].equalsIgnoreCase("set")) {
                        if ((split = StringMgmt.remFirstArg(split)).length == 0 || split[0].equalsIgnoreCase("?")) {
                            player.sendMessage(ChatTools.formatTitle("/... set"));
                            player.sendMessage(ChatTools.formatCommand("", "set", "[plottype]", "Ex: Inn, Wilds, Farm, Embassy etc"));
                            player.sendMessage(ChatTools.formatCommand("", "set", "outpost", "Costs " + TownyEconomyHandler.getFormattedBalance(TownySettings.getOutpostCost())));
                            player.sendMessage(ChatTools.formatCommand("", "set", "reset", "Removes a plot type"));
                            player.sendMessage(ChatTools.formatCommand("", "set", "[name]", "Names a plot"));
                            player.sendMessage(ChatTools.formatCommand("Level", "[resident/ally/outsider]", "", ""));
                            player.sendMessage(ChatTools.formatCommand("Type", "[build/destroy/switch/itemuse]", "", ""));
                            player.sendMessage(ChatTools.formatCommand("", "set perm", "[on/off]", "Toggle all permissions"));
                            player.sendMessage(ChatTools.formatCommand("", "set perm", "[level/type] [on/off]", ""));
                            player.sendMessage(ChatTools.formatCommand("", "set perm", "[level] [type] [on/off]", ""));
                            player.sendMessage(ChatTools.formatCommand("", "set perm", "reset", ""));
                            player.sendMessage(ChatTools.formatCommand("Eg", "/plot set perm", "ally off", ""));
                            player.sendMessage(ChatTools.formatCommand("Eg", "/plot set perm", "friend build on", ""));
                            player.sendMessage(Translation.of("plot_perms", "'friend'", "'resident'"));
                            player.sendMessage(Translation.of("plot_perms_1"));
                            break block112;
                        }
                        if (split.length > 0) {
                            if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_SET.getNode(split[0].toLowerCase()))) {
                                throw new TownyException(Translation.of("msg_err_command_disable"));
                            }
                            TownBlock townBlock = new WorldCoord(world, Coord.parseCoord((Entity)player)).getTownBlock();
                            if (townBlock.hasPlotObjectGroup()) {
                                TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_plot_belongs_to_group_set"));
                                return false;
                            }
                            if (split[0].equalsIgnoreCase("perm")) {
                                TownBlockOwner owner = this.plotTestOwner(resident, townBlock);
                                PlotCommand.setTownBlockPermissions(player, owner, townBlock, StringMgmt.remFirstArg(split));
                                return true;
                            }
                            if (split[0].equalsIgnoreCase("name")) {
                                this.plotTestOwner(resident, townBlock);
                                if (split.length == 1) {
                                    townBlock.setName("");
                                    TownyMessaging.sendMsg((CommandSender)player, Translation.of("msg_plot_name_removed"));
                                    townBlock.save();
                                    return true;
                                }
                                if (!NameValidation.isBlacklistName(split[1])) {
                                    townBlock.setName(StringMgmt.join(StringMgmt.remFirstArg(split), ""));
                                    townBlock.save();
                                    TownyMessaging.sendMsg((CommandSender)player, Translation.of("msg_plot_name_set_to", townBlock.getName()));
                                } else {
                                    TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_invalid_name"));
                                }
                                return true;
                            }
                            if (split[0].equalsIgnoreCase("outpost") && TownySettings.isAllowingOutposts()) {
                                if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWN_CLAIM_OUTPOST.getNode())) {
                                    throw new TownyException(Translation.of("msg_err_command_disable"));
                                }
                                this.plotTestOwner(resident, townBlock);
                                Town town = townBlock.getTown();
                                TownyWorld townyWorld = townBlock.getWorld();
                                boolean isAdmin = permSource.isTownyAdmin(player);
                                Coord key = Coord.parseCoord(plugin.getCache(player).getLastLocation());
                                if (OutpostUtil.OutpostTests(town, resident, townyWorld, key, isAdmin, true)) {
                                    if (TownyEconomyHandler.isActive() && !town.getAccount().canPayFromHoldings(TownySettings.getOutpostCost())) {
                                        throw new TownyException(Translation.of("msg_err_cannot_afford_to_set_outpost"));
                                    }
                                    Confirmation.runOnAccept(() -> {
                                        townBlock.setOutpost(true);
                                        try {
                                            town.addOutpostSpawn(player.getLocation());
                                        }
                                        catch (TownyException e) {
                                            TownyMessaging.sendErrorMsg(e.getMessage());
                                            return;
                                        }
                                        if (TownyEconomyHandler.isActive() && TownySettings.getOutpostCost() > 0.0) {
                                            try {
                                                town.getAccount().withdraw(TownySettings.getOutpostCost(), "Plot Set Outpost");
                                            }
                                            catch (EconomyException economyException) {
                                                // empty catch block
                                            }
                                        }
                                        town.save();
                                        townBlock.save();
                                        TownyMessaging.sendMessage((Object)player, Translation.of("msg_plot_set_cost", TownyEconomyHandler.getFormattedBalance(TownySettings.getOutpostCost()), Translation.of("outpost")));
                                    }).setTitle(Translation.of("msg_confirm_purchase", TownyEconomyHandler.getFormattedBalance(TownySettings.getOutpostCost()))).sendTo((CommandSender)player);
                                }
                                return true;
                            }
                            try {
                                TownBlockType townBlockType;
                                String plotTypeName = split[0];
                                if (plotTypeName.equalsIgnoreCase("reset")) {
                                    plotTypeName = "default";
                                }
                                if ((townBlockType = TownBlockType.lookup(plotTypeName)) == null) {
                                    throw new TownyException(Translation.of("msg_err_not_block_type"));
                                }
                                try {
                                    this.plotTestOwner(resident, townBlock);
                                }
                                catch (TownyException e) {
                                    TownyMessaging.sendErrorMsg((Object)resident, e.getMessage());
                                    return false;
                                }
                                PlotPreChangeTypeEvent preEvent = new PlotPreChangeTypeEvent(townBlockType, townBlock, resident);
                                BukkitTools.getPluginManager().callEvent((Event)preEvent);
                                if (preEvent.isCancelled()) {
                                    player.sendMessage(preEvent.getCancelMessage());
                                    return false;
                                }
                                double cost = townBlockType.getCost();
                                if (cost > 0.0 && TownyEconomyHandler.isActive() && !resident.getAccount().canPayFromHoldings(cost)) {
                                    throw new EconomyException(Translation.of("msg_err_cannot_afford_plot_set_type_cost", new Object[]{townBlockType, TownyEconomyHandler.getFormattedBalance(cost)}));
                                }
                                if (cost > 0.0 && TownyEconomyHandler.isActive()) {
                                    Confirmation.runOnAccept(() -> {
                                        try {
                                            resident.getAccount().withdraw(cost, String.format("Plot set to %s", new Object[]{townBlockType}));
                                        }
                                        catch (EconomyException economyException) {
                                            // empty catch block
                                        }
                                        TownyMessaging.sendMessage((Object)resident, Translation.of("msg_plot_set_cost", new Object[]{TownyEconomyHandler.getFormattedBalance(cost), townBlockType}));
                                        try {
                                            townBlock.setType(townBlockType, resident);
                                        }
                                        catch (TownyException e) {
                                            TownyMessaging.sendErrorMsg((Object)resident, e.getMessage());
                                        }
                                        TownyMessaging.sendMsg((CommandSender)player, Translation.of("msg_plot_set_type", new Object[]{townBlockType}));
                                    }).setTitle(Translation.of("msg_confirm_purchase", TownyEconomyHandler.getFormattedBalance(cost))).sendTo((CommandSender)BukkitTools.getPlayerExact(resident.getName()));
                                    break block112;
                                }
                                townBlock.setType(townBlockType, resident);
                                TownyMessaging.sendMsg((CommandSender)player, Translation.of("msg_plot_set_type", plotTypeName));
                            }
                            catch (NotRegisteredException nre) {
                                TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_not_part_town"));
                            }
                            catch (TownyException te) {
                                TownyMessaging.sendErrorMsg((Object)player, te.getMessage());
                            }
                            break block112;
                        }
                        player.sendMessage(ChatTools.formatCommand("", "/plot set", "name", ""));
                        player.sendMessage(ChatTools.formatCommand("", "/plot set", "reset", ""));
                        player.sendMessage(ChatTools.formatCommand("", "/plot set", "shop|embassy|arena|wilds|spleef|inn|jail|farm|bank", ""));
                        player.sendMessage(ChatTools.formatCommand("", "/plot set perm", "?", ""));
                        break block112;
                    }
                    if (split[0].equalsIgnoreCase("clear")) {
                        if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_CLEAR.getNode())) {
                            throw new TownyException(Translation.of("msg_err_command_disable"));
                        }
                        TownBlock townBlock = new WorldCoord(world, Coord.parseCoord((Entity)player)).getTownBlock();
                        if (townBlock != null) {
                            if (!townBlock.getWorld().isUsingPlotManagementMayorDelete()) {
                                throw new TownyException(Translation.of("msg_err_plot_clear_disabled_in_this_world"));
                            }
                            if (townBlock.hasResident()) {
                                if (!townBlock.isOwner(resident)) {
                                    player.sendMessage(Translation.of("msg_area_not_own"));
                                    return true;
                                }
                            } else if (!townBlock.getTown().equals(resident.getTown())) {
                                player.sendMessage(Translation.of("msg_area_not_own"));
                                return true;
                            }
                            PlotPreClearEvent preEvent = new PlotPreClearEvent(townBlock);
                            BukkitTools.getPluginManager().callEvent((Event)preEvent);
                            if (preEvent.isCancelled()) {
                                player.sendMessage(preEvent.getCancelMessage());
                                return false;
                            }
                            for (String material : TownyUniverse.getInstance().getDataSource().getWorld(world).getPlotManagementMayorDelete()) {
                                if (Material.matchMaterial((String)material) != null) {
                                    TownyRegenAPI.deleteTownBlockMaterial(townBlock, Material.getMaterial((String)material));
                                    player.sendMessage(Translation.of("msg_clear_plot_material", material));
                                    continue;
                                }
                                throw new TownyException(Translation.of("msg_err_invalid_property", material));
                            }
                            BukkitTools.getPluginManager().callEvent((Event)new PlotClearEvent(townBlock));
                        } else {
                            player.sendMessage(Translation.of("msg_err_empty_area_selection"));
                        }
                        break block112;
                    }
                    if (split[0].equalsIgnoreCase("group")) {
                        return this.handlePlotGroupCommand(StringMgmt.remFirstArg(split), player);
                    }
                    throw new TownyException(Translation.of("msg_err_invalid_property", split[0]));
                }
                catch (EconomyException | TownyException x) {
                    TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
                }
            }
        }
        return true;
    }

    public static TownyPermissionChange setTownBlockPermissions(Player player, TownBlockOwner townBlockOwner, TownBlock townBlock, String[] split) {
        TownyPermissionChange permChange = null;
        if (split.length == 0 || split[0].equalsIgnoreCase("?")) {
            player.sendMessage(ChatTools.formatTitle("/... set perm"));
            if (townBlockOwner instanceof Town) {
                player.sendMessage(ChatTools.formatCommand("Level", "[resident/nation/ally/outsider]", "", ""));
            }
            if (townBlockOwner instanceof Resident) {
                player.sendMessage(ChatTools.formatCommand("Level", "[friend/town/ally/outsider]", "", ""));
            }
            player.sendMessage(ChatTools.formatCommand("Type", "[build/destroy/switch/itemuse]", "", ""));
            player.sendMessage(ChatTools.formatCommand("", "set perm", "[on/off]", "Toggle all permissions"));
            player.sendMessage(ChatTools.formatCommand("", "set perm", "[level/type] [on/off]", ""));
            player.sendMessage(ChatTools.formatCommand("", "set perm", "[level] [type] [on/off]", ""));
            player.sendMessage(ChatTools.formatCommand("", "set perm", "reset", ""));
            player.sendMessage(ChatTools.formatCommand("Eg", "/plot set perm", "friend build on", ""));
            return null;
        }
        TownyPermission perm = townBlock.getPermissions();
        if (split.length == 1) {
            if (split[0].equalsIgnoreCase("reset")) {
                permChange = new TownyPermissionChange(TownyPermissionChange.Action.RESET, false, townBlock);
                perm.change(permChange);
                townBlock.save();
                TownyMessaging.sendMsg((CommandSender)player, Translation.of("msg_set_perms_reset_single"));
                plugin.resetCache();
                return permChange;
            }
            try {
                boolean b = StringMgmt.parseOnOff(split[0]);
                permChange = new TownyPermissionChange(TownyPermissionChange.Action.ALL_PERMS, b, new Object[0]);
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_plot_set_perm_syntax_error"));
                return null;
            }
        }
        if (split.length == 2) {
            boolean b;
            try {
                b = StringMgmt.parseOnOff(split[1]);
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_plot_set_perm_syntax_error"));
                return null;
            }
            if (split[0].equalsIgnoreCase("friend")) {
                split[0] = "resident";
            } else if (split[0].equalsIgnoreCase("town")) {
                split[0] = "nation";
            } else if (split[0].equalsIgnoreCase("itemuse")) {
                split[0] = "item_use";
            }
            try {
                TownyPermission.PermLevel permLevel = TownyPermission.PermLevel.valueOf(split[0].toUpperCase());
                permChange = new TownyPermissionChange(TownyPermissionChange.Action.PERM_LEVEL, b, new Object[]{permLevel});
            }
            catch (IllegalArgumentException permLevelException) {
                try {
                    TownyPermission.ActionType actionType = TownyPermission.ActionType.valueOf(split[0].toUpperCase());
                    permChange = new TownyPermissionChange(TownyPermissionChange.Action.ACTION_TYPE, b, new Object[]{actionType});
                }
                catch (IllegalArgumentException actionTypeException) {
                    TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_plot_set_perm_syntax_error"));
                    return null;
                }
            }
        } else if (split.length == 3) {
            TownyPermission.ActionType actionType;
            TownyPermission.PermLevel permLevel;
            if (split[0].equalsIgnoreCase("friend")) {
                split[0] = "resident";
            } else if (split[0].equalsIgnoreCase("town")) {
                split[0] = "nation";
            }
            if (split[1].equalsIgnoreCase("itemuse")) {
                split[1] = "item_use";
            }
            try {
                permLevel = TownyPermission.PermLevel.valueOf(split[0].toUpperCase());
                actionType = TownyPermission.ActionType.valueOf(split[1].toUpperCase());
            }
            catch (IllegalArgumentException ignore) {
                TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_plot_set_perm_syntax_error"));
                return null;
            }
            try {
                boolean b = StringMgmt.parseOnOff(split[2]);
                permChange = new TownyPermissionChange(TownyPermissionChange.Action.SINGLE_PERM, b, new Object[]{permLevel, actionType});
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_plot_set_perm_syntax_error"));
                return null;
            }
        }
        if (permChange != null) {
            perm.change(permChange);
        }
        townBlock.setChanged(true);
        townBlock.save();
        if (!townBlock.hasPlotObjectGroup()) {
            TownyMessaging.sendMsg((CommandSender)player, Translation.of("msg_set_perms"));
            TownyMessaging.sendMessage((Object)player, "\u00a72 Perm: " + (townBlockOwner instanceof Resident ? perm.getColourString().replace("n", "t") : perm.getColourString().replace("f", "r")));
            TownyMessaging.sendMessage((Object)player, "\u00a72 Perm: " + (townBlockOwner instanceof Resident ? perm.getColourString2().replace("n", "t") : perm.getColourString2().replace("f", "r")));
            TownyMessaging.sendMessage((Object)player, "\u00a72PvP: " + (perm.pvp ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Explosions: " + (perm.explosion ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Firespread: " + (perm.fire ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Mob Spawns: " + (perm.mobs ? "\u00a74ON" : "\u00a7aOFF"));
        }
        TownBlockSettingsChangedEvent event = new TownBlockSettingsChangedEvent(townBlock);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        plugin.resetCache();
        return permChange;
    }

    public void setPlotForSale(Resident resident, WorldCoord worldCoord, double forSale) throws TownyException {
        try {
            TownBlock townBlock = worldCoord.getTownBlock();
            this.plotTestOwner(resident, townBlock);
            if (forSale > TownySettings.getMaxPlotPrice()) {
                townBlock.setPlotPrice(TownySettings.getMaxPlotPrice());
            } else {
                townBlock.setPlotPrice(forSale);
            }
            if (forSale != -1.0) {
                TownyMessaging.sendPrefixedTownMessage(townBlock.getTown(), Translation.of("MSG_PLOT_FOR_SALE", resident.getName(), worldCoord.toString()));
                if (!resident.hasTown() || resident.hasTown() && townBlock.getTown() != resident.getTown()) {
                    TownyMessaging.sendMsg(resident, Translation.of("MSG_PLOT_FOR_SALE", resident.getName(), worldCoord.toString()));
                }
                Bukkit.getPluginManager().callEvent((Event)new PlotSetForSaleEvent(resident, forSale, townBlock));
            } else {
                TownyMessaging.sendMsg(resident, Translation.of("msg_plot_set_to_nfs"));
                Bukkit.getPluginManager().callEvent((Event)new PlotNotForSaleEvent(resident, townBlock));
            }
            townBlock.save();
        }
        catch (NotRegisteredException e) {
            throw new TownyException(Translation.of("msg_err_not_part_town"));
        }
    }

    public void plotToggle(Player player, TownBlock townBlock, String[] split) {
        TownyPermissionSource permSource = TownyUniverse.getInstance().getPermissionSource();
        if (split.length == 0 || split[0].equalsIgnoreCase("?")) {
            player.sendMessage(ChatTools.formatTitle("/plot toggle"));
            player.sendMessage(ChatTools.formatCommand("", "/plot toggle", "pvp", ""));
            player.sendMessage(ChatTools.formatCommand("", "/plot toggle", "explosion", ""));
            player.sendMessage(ChatTools.formatCommand("", "/plot toggle", "fire", ""));
            player.sendMessage(ChatTools.formatCommand("", "/plot toggle", "mobs", ""));
        } else {
            try {
                if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_TOGGLE.getNode(split[0].toLowerCase()))) {
                    throw new TownyException(Translation.of("msg_err_command_disable"));
                }
                Optional<Object> choice = Optional.empty();
                if (split.length == 2) {
                    choice = BaseCommand.parseToggleChoice(split[1]);
                }
                if (split[0].equalsIgnoreCase("pvp")) {
                    this.toggleTest(player, townBlock, StringMgmt.join(split, " "));
                    if (TownySettings.getPVPCoolDownTime() > 0 && !permSource.testPermission(player, PermissionNodes.TOWNY_ADMIN.getNode())) {
                        if (CooldownTimerTask.hasCooldown(townBlock.getTown().getName(), CooldownTimerTask.CooldownType.PVP)) {
                            throw new TownyException(Translation.of("msg_err_cannot_toggle_pvp_x_seconds_remaining", CooldownTimerTask.getCooldownRemaining(townBlock.getTown().getName(), CooldownTimerTask.CooldownType.PVP)));
                        }
                        if (CooldownTimerTask.hasCooldown(townBlock.getWorldCoord().toString(), CooldownTimerTask.CooldownType.PVP)) {
                            throw new TownyException(Translation.of("msg_err_cannot_toggle_pvp_x_seconds_remaining", CooldownTimerTask.getCooldownRemaining(townBlock.getWorldCoord().toString(), CooldownTimerTask.CooldownType.PVP)));
                        }
                    }
                    if (townBlock.getTown().isAdminDisabledPVP() && !townBlock.getPermissions().pvp) {
                        throw new TownyException(Translation.of("msg_err_admin_controlled_pvp_prevents_you_from_changing_pvp", "adminDisabledPVP", "on"));
                    }
                    if (townBlock.getTown().isAdminEnabledPVP() && townBlock.getPermissions().pvp) {
                        throw new TownyException(Translation.of("msg_err_admin_controlled_pvp_prevents_you_from_changing_pvp", "adminEnabledPVP", "off"));
                    }
                    PlotTogglePvpEvent plotTogglePvpEvent = new PlotTogglePvpEvent(townBlock.getTown(), player, (Boolean)choice.orElse(!townBlock.getPermissions().pvp));
                    Bukkit.getPluginManager().callEvent((Event)plotTogglePvpEvent);
                    if (plotTogglePvpEvent.isCancelled()) {
                        throw new TownyException(plotTogglePvpEvent.getCancellationMsg());
                    }
                    townBlock.getPermissions().pvp = (Boolean)choice.orElse(!townBlock.getPermissions().pvp);
                    if (TownySettings.getPVPCoolDownTime() > 0 && !permSource.testPermission(player, PermissionNodes.TOWNY_ADMIN.getNode())) {
                        CooldownTimerTask.addCooldownTimer(townBlock.getWorldCoord().toString(), CooldownTimerTask.CooldownType.PVP);
                    }
                    TownyMessaging.sendMessage((Object)player, Translation.of("msg_changed_pvp", "Plot", townBlock.getPermissions().pvp ? Translation.of("enabled") : Translation.of("disabled")));
                } else if (split[0].equalsIgnoreCase("explosion")) {
                    this.toggleTest(player, townBlock, StringMgmt.join(split, " "));
                    PlotToggleExplosionEvent plotToggleExplosionEvent = new PlotToggleExplosionEvent(townBlock.getTown(), player, choice.orElse(!townBlock.getPermissions().explosion));
                    Bukkit.getPluginManager().callEvent((Event)plotToggleExplosionEvent);
                    if (plotToggleExplosionEvent.isCancelled()) {
                        throw new TownyException(plotToggleExplosionEvent.getCancellationMsg());
                    }
                    townBlock.getPermissions().explosion = (Boolean)choice.orElse(!townBlock.getPermissions().explosion);
                    TownyMessaging.sendMessage((Object)player, Translation.of("msg_changed_expl", "the Plot", townBlock.getPermissions().explosion ? Translation.of("enabled") : Translation.of("disabled")));
                } else if (split[0].equalsIgnoreCase("fire")) {
                    this.toggleTest(player, townBlock, StringMgmt.join(split, " "));
                    PlotToggleFireEvent plotToggleFireEvent = new PlotToggleFireEvent(townBlock.getTown(), player, (Boolean)choice.orElse(!townBlock.getPermissions().fire));
                    Bukkit.getPluginManager().callEvent((Event)plotToggleFireEvent);
                    if (plotToggleFireEvent.isCancelled()) {
                        throw new TownyException(plotToggleFireEvent.getCancellationMsg());
                    }
                    townBlock.getPermissions().fire = (Boolean)choice.orElse(!townBlock.getPermissions().fire);
                    TownyMessaging.sendMessage((Object)player, Translation.of("msg_changed_fire", "the Plot", townBlock.getPermissions().fire ? Translation.of("enabled") : Translation.of("disabled")));
                } else if (split[0].equalsIgnoreCase("mobs")) {
                    this.toggleTest(player, townBlock, StringMgmt.join(split, " "));
                    PlotToggleMobsEvent plotToggleMobsEvent = new PlotToggleMobsEvent(townBlock.getTown(), player, (Boolean)choice.orElse(!townBlock.getPermissions().mobs));
                    Bukkit.getPluginManager().callEvent((Event)plotToggleMobsEvent);
                    if (plotToggleMobsEvent.isCancelled()) {
                        throw new TownyException(plotToggleMobsEvent.getCancellationMsg());
                    }
                    townBlock.getPermissions().mobs = (Boolean)choice.orElse(!townBlock.getPermissions().mobs);
                    TownyMessaging.sendMessage((Object)player, Translation.of("msg_changed_mobs", "the Plot", townBlock.getPermissions().mobs ? Translation.of("enabled") : Translation.of("disabled")));
                } else {
                    TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_invalid_property", "plot"));
                    return;
                }
                townBlock.setChanged(true);
                TownBlockSettingsChangedEvent event = new TownBlockSettingsChangedEvent(townBlock);
                Bukkit.getServer().getPluginManager().callEvent((Event)event);
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
            }
            townBlock.save();
        }
    }

    public void plotGroupToggle(Player player, PlotGroup plotGroup, String[] split) {
        TownyPermissionSource permSource = TownyUniverse.getInstance().getPermissionSource();
        if (split.length == 0 || split[0].equalsIgnoreCase("?")) {
            player.sendMessage(ChatTools.formatTitle("/plot group toggle"));
            player.sendMessage(ChatTools.formatCommand("", "/plot group toggle", "pvp", ""));
            player.sendMessage(ChatTools.formatCommand("", "/plot group toggle", "explosion", ""));
            player.sendMessage(ChatTools.formatCommand("", "/plot group toggle", "fire", ""));
            player.sendMessage(ChatTools.formatCommand("", "/plot group toggle", "mobs", ""));
        } else {
            try {
                String endingMessage = "";
                Optional<Object> choice = Optional.empty();
                if (split.length == 2) {
                    choice = BaseCommand.parseToggleChoice(split[1]);
                }
                for (TownBlock groupBlock : plotGroup.getTownBlocks()) {
                    if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_TOGGLE.getNode(split[0].toLowerCase()))) {
                        throw new TownyException(Translation.of("msg_err_command_disable"));
                    }
                    if (split[0].equalsIgnoreCase("pvp")) {
                        this.toggleTest(player, groupBlock, StringMgmt.join(split, " "));
                        if (TownySettings.getPVPCoolDownTime() > 0) {
                            if (CooldownTimerTask.hasCooldown(groupBlock.getTown().getName(), CooldownTimerTask.CooldownType.PVP)) {
                                throw new TownyException(Translation.of("msg_err_cannot_toggle_pvp_x_seconds_remaining", CooldownTimerTask.getCooldownRemaining(groupBlock.getTown().getName(), CooldownTimerTask.CooldownType.PVP)));
                            }
                            if (CooldownTimerTask.hasCooldown(groupBlock.getWorldCoord().toString(), CooldownTimerTask.CooldownType.PVP)) {
                                throw new TownyException(Translation.of("msg_err_cannot_toggle_pvp_x_seconds_remaining", CooldownTimerTask.getCooldownRemaining(groupBlock.getWorldCoord().toString(), CooldownTimerTask.CooldownType.PVP)));
                            }
                        }
                        groupBlock.getPermissions().pvp = choice.orElse(!groupBlock.getPermissions().pvp);
                        if (TownySettings.getPVPCoolDownTime() > 0) {
                            CooldownTimerTask.addCooldownTimer(groupBlock.getWorldCoord().toString(), CooldownTimerTask.CooldownType.PVP);
                        }
                        endingMessage = Translation.of("msg_changed_pvp", "Plot Group", groupBlock.getPermissions().pvp ? Translation.of("enabled") : Translation.of("disabled"));
                    } else if (split[0].equalsIgnoreCase("explosion")) {
                        this.toggleTest(player, groupBlock, StringMgmt.join(split, " "));
                        groupBlock.getPermissions().explosion = (Boolean)choice.orElse(!groupBlock.getPermissions().explosion);
                        endingMessage = Translation.of("msg_changed_expl", "the Plot Group", groupBlock.getPermissions().explosion ? Translation.of("enabled") : Translation.of("disabled"));
                    } else if (split[0].equalsIgnoreCase("fire")) {
                        this.toggleTest(player, groupBlock, StringMgmt.join(split, " "));
                        groupBlock.getPermissions().fire = (Boolean)choice.orElse(!groupBlock.getPermissions().fire);
                        endingMessage = Translation.of("msg_changed_fire", "the Plot Group", groupBlock.getPermissions().fire ? Translation.of("enabled") : Translation.of("disabled"));
                    } else if (split[0].equalsIgnoreCase("mobs")) {
                        this.toggleTest(player, groupBlock, StringMgmt.join(split, " "));
                        groupBlock.getPermissions().mobs = (Boolean)choice.orElse(!groupBlock.getPermissions().mobs);
                        endingMessage = Translation.of("msg_changed_mobs", "the Plot Group", groupBlock.getPermissions().mobs ? Translation.of("enabled") : Translation.of("disabled"));
                    } else {
                        TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_invalid_property", "plot"));
                        return;
                    }
                    groupBlock.setChanged(true);
                    TownBlockSettingsChangedEvent event = new TownBlockSettingsChangedEvent(groupBlock);
                    Bukkit.getServer().getPluginManager().callEvent((Event)event);
                    groupBlock.save();
                }
                TownyMessaging.sendMessage((Object)player, endingMessage);
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
            }
        }
    }

    private void toggleTest(Player player, TownBlock townBlock, String split) throws TownyException {
        if ((split = split.toLowerCase()).contains("mobs") && townBlock.getWorld().isForceTownMobs()) {
            throw new TownyException(Translation.of("msg_world_mobs"));
        }
        if (split.contains("fire") && townBlock.getWorld().isForceFire()) {
            throw new TownyException(Translation.of("msg_world_fire"));
        }
        if (split.contains("explosion") && townBlock.getWorld().isForceExpl()) {
            throw new TownyException(Translation.of("msg_world_expl"));
        }
        if (split.contains("pvp") && townBlock.getWorld().isForcePVP()) {
            throw new TownyException(Translation.of("msg_world_pvp"));
        }
        if ((split.contains("pvp") || split.trim().equalsIgnoreCase("off")) && townBlock.getType().equals((Object)TownBlockType.ARENA)) {
            throw new TownyException(Translation.of("msg_plot_pvp"));
        }
    }

    public TownBlockOwner plotTestOwner(Resident resident, TownBlock townBlock) throws TownyException {
        boolean isSameTown;
        Player player = BukkitTools.getPlayer(resident.getName());
        boolean isAdmin = TownyUniverse.getInstance().getPermissionSource().isTownyAdmin(player);
        if (townBlock.hasResident()) {
            boolean isSameTown2;
            Resident owner = townBlock.getResident();
            boolean bl = isSameTown2 = resident.hasTown() && resident.getTown() == owner.getTown() && townBlock.getTown() == resident.getTown();
            if (resident == owner || isSameTown2 && player.hasPermission(PermissionNodes.TOWNY_COMMAND_PLOT_ASMAYOR.getNode()) || townBlock.getTown() == resident.getTown() && player.hasPermission(PermissionNodes.TOWNY_COMMAND_PLOT_ASMAYOR.getNode()) || isAdmin) {
                return owner;
            }
            throw new TownyException(Translation.of("msg_area_not_own"));
        }
        Town owner = townBlock.getTown();
        boolean bl = isSameTown = resident.hasTown() && resident.getTown() == owner;
        if (isSameTown && !BukkitTools.getPlayer(resident.getName()).hasPermission(PermissionNodes.TOWNY_COMMAND_PLOT_ASMAYOR.getNode())) {
            throw new TownyException(Translation.of("msg_not_mayor_ass"));
        }
        if (!isSameTown && !isAdmin) {
            throw new TownyException(Translation.of("msg_err_not_part_town"));
        }
        return owner;
    }

    private boolean handlePlotGroupCommand(String[] split, Player player) throws TownyException {
        block51: {
            TownyPermissionSource permSource = TownyUniverse.getInstance().getPermissionSource();
            Resident resident = PlotCommand.getResidentOrThrow(player.getUniqueId());
            String world = player.getWorld().getName();
            TownBlock townBlock = new WorldCoord(world, Coord.parseCoord((Entity)player)).getTownBlock();
            Town town = townBlock.getTown();
            this.plotTestOwner(resident, townBlock);
            if (split.length <= 0 || split[0].equalsIgnoreCase("?")) {
                player.sendMessage(ChatTools.formatTitle("/plot group"));
                player.sendMessage(ChatTools.formatCommand("/plot group", "add | new | create", "[name]", "Ex: /plot group new ExpensivePlots"));
                player.sendMessage(ChatTools.formatCommand("/plot group", "remove", "", "Removes a plot from the specified group."));
                player.sendMessage(ChatTools.formatCommand("/plot group", "rename", "[newName]", "Renames the group you are standing in."));
                player.sendMessage(ChatTools.formatCommand("/plot group", "set", "...", "Ex: /plot group set perm resident on."));
                player.sendMessage(ChatTools.formatCommand("/plot group", "toggle", "...", "Ex: /plot group toggle [pvp|fire|mobs]"));
                player.sendMessage(ChatTools.formatCommand("/plot group", "forsale | fs", "[price]", "Ex: /plot group forsale 50"));
                player.sendMessage(ChatTools.formatCommand("/plot group", "notforsale | nfs", "", "Ex: /plot group notforsale"));
                if (townBlock.hasPlotObjectGroup()) {
                    TownyMessaging.sendMsg((CommandSender)player, Translation.of("status_plot_group_name_and_size", townBlock.getPlotObjectGroup().getName(), townBlock.getPlotObjectGroup().getTownBlocks().size()));
                }
                return true;
            }
            if (split[0].equalsIgnoreCase("add") || split[0].equalsIgnoreCase("new") || split[0].equalsIgnoreCase("create")) {
                if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_GROUP_ADD.getNode())) {
                    throw new TownyException(Translation.of("msg_err_command_disable"));
                }
                PlotGroup newGroup = null;
                if (townBlock.hasPlotObjectGroup()) {
                    TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_plot_already_belongs_to_a_group", townBlock.getPlotObjectGroup().getName()));
                    return false;
                }
                if (split.length == 2) {
                    String plotGroupName;
                    UUID plotGroupID = TownyUniverse.getInstance().generatePlotGroupID();
                    newGroup = new PlotGroup(plotGroupID, plotGroupName = split[1], town);
                    if (town.hasPlotGroupName(newGroup.getName())) {
                        newGroup = town.getPlotObjectGroupFromName(newGroup.getName());
                    }
                    townBlock.setPlotObjectGroup(newGroup);
                    if (!(townBlock.getPlotPrice() < 0.0)) {
                        newGroup.addPlotPrice(townBlock.getPlotPrice());
                    }
                } else {
                    TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_plot_group_name_required"));
                    return false;
                }
                town.addPlotGroup(newGroup);
                TownyUniverse.getInstance().getDataSource().savePlotGroupList();
                newGroup.save();
                townBlock.save();
                town.save();
                TownyMessaging.sendMsg((CommandSender)player, Translation.of("msg_plot_was_put_into_group_x", townBlock.getX(), townBlock.getZ(), newGroup.getName()));
            } else if (split[0].equalsIgnoreCase("remove")) {
                if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_GROUP_REMOVE.getNode())) {
                    throw new TownyException(Translation.of("msg_err_command_disable"));
                }
                if (!townBlock.hasPlotObjectGroup()) {
                    TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_plot_not_associated_with_a_group"));
                    return false;
                }
                String name = townBlock.getPlotObjectGroup().getName();
                townBlock.getPlotObjectGroup().removeTownBlock(townBlock);
                townBlock.removePlotObjectGroup();
                townBlock.save();
                TownyMessaging.sendMsg((CommandSender)player, Translation.of("msg_plot_was_removed_from_group_x", townBlock.getX(), townBlock.getZ(), name));
            } else if (split[0].equalsIgnoreCase("rename")) {
                if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_GROUP_RENAME.getNode())) {
                    throw new TownyException(Translation.of("msg_err_command_disable"));
                }
                if (!townBlock.hasPlotObjectGroup()) {
                    TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_plot_not_associated_with_a_group"));
                    return false;
                }
                if (split.length == 1) {
                    TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_plot_group_name_required"));
                    return false;
                }
                String newName = split[1];
                String oldName = townBlock.getPlotObjectGroup().getName();
                TownyUniverse.getInstance().getDataSource().renameGroup(townBlock.getPlotObjectGroup(), newName);
                TownyMessaging.sendMsg((CommandSender)player, Translation.of("msg_plot_renamed_from_x_to_y", oldName, newName));
            } else if (split[0].equalsIgnoreCase("forsale") || split[0].equalsIgnoreCase("fs")) {
                if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_GROUP_FORSALE.getNode())) {
                    throw new TownyException(Translation.of("msg_err_command_disable"));
                }
                PlotGroup group = townBlock.getPlotObjectGroup();
                if (group == null) {
                    TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_plot_not_associated_with_a_group"));
                    return false;
                }
                if (split.length < 2) {
                    TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_plot_group_specify_price"));
                    return false;
                }
                int price = Integer.parseInt(split[1]);
                group.setPrice(price);
                group.save();
                TownyUniverse.getInstance().getDataSource().savePlotGroupList();
                TownyMessaging.sendPrefixedTownMessage(town, Translation.of("msg_player_put_group_up_for_sale", player.getName(), group.getName(), TownyEconomyHandler.getFormattedBalance(group.getPrice())));
            } else if (split[0].equalsIgnoreCase("notforsale") || split[0].equalsIgnoreCase("nfs")) {
                if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_GROUP_NOTFORSALE.getNode())) {
                    throw new TownyException(Translation.of("msg_err_command_disable"));
                }
                PlotGroup group = townBlock.getPlotObjectGroup();
                if (group == null) {
                    TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_plot_not_associated_with_a_group"));
                    return false;
                }
                group.setPrice(-1.0);
                group.save();
                TownyUniverse.getInstance().getDataSource().savePlotGroupList();
                TownyMessaging.sendPrefixedTownMessage(town, Translation.of("msg_player_made_group_not_for_sale", player.getName(), group.getName()));
            } else {
                if (split[0].equalsIgnoreCase("toggle")) {
                    if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_GROUP_TOGGLE.getNode())) {
                        throw new TownyException(Translation.of("msg_err_command_disable"));
                    }
                    if (townBlock.getPlotObjectGroup() == null) {
                        TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_plot_not_associated_with_a_group"));
                        return false;
                    }
                    PlotGroup plotGroup = townBlock.getPlotObjectGroup();
                    String title = Translation.of("msg_plot_group_toggle_confirmation", townBlock.getPlotObjectGroup().getTownBlocks().size()) + " " + Translation.of("are_you_sure_you_want_to_continue");
                    Confirmation.runOnAccept(() -> new PlotCommand(Towny.getPlugin()).plotGroupToggle(player, plotGroup, StringMgmt.remArgs(split, 1))).setTitle(title).sendTo((CommandSender)player);
                    return true;
                }
                if (split[0].equalsIgnoreCase("set")) {
                    TownBlockType type;
                    if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_PLOT_GROUP_SET.getNode())) {
                        throw new TownyException(Translation.of("msg_err_command_disable"));
                    }
                    if (townBlock.getPlotObjectGroup() == null) {
                        TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_plot_not_associated_with_a_group"));
                        return false;
                    }
                    TownBlockOwner townBlockOwner = this.plotTestOwner(resident, townBlock);
                    if (split.length < 2) {
                        player.sendMessage(ChatTools.formatTitle("/plot group set"));
                        if (townBlockOwner instanceof Town) {
                            player.sendMessage(ChatTools.formatCommand("Level", "[resident/nation/ally/outsider]", "", ""));
                        }
                        if (townBlockOwner instanceof Resident) {
                            player.sendMessage(ChatTools.formatCommand("Level", "[friend/town/ally/outsider]", "", ""));
                        }
                        player.sendMessage(ChatTools.formatCommand("Type", "[build/destroy/switch/itemuse]", "", ""));
                        player.sendMessage(ChatTools.formatCommand("/plot group set", "perm", "[on/off]", "Toggle all permissions"));
                        player.sendMessage(ChatTools.formatCommand("/plot group set", "perm", "[level/type] [on/off]", ""));
                        player.sendMessage(ChatTools.formatCommand("/plot group set", "perm", "[level] [type] [on/off]", ""));
                        player.sendMessage(ChatTools.formatCommand("/plot group set", "perm", "reset", ""));
                        player.sendMessage(ChatTools.formatCommand("Eg", "/plot group set perm", "friend build on", ""));
                        player.sendMessage(ChatTools.formatCommand("/plot group set", "[townblocktype]", "", "Farm, Wilds, Bank, Embassy, etc."));
                        return false;
                    }
                    if (split[1].equalsIgnoreCase("perm")) {
                        PlotGroup plotGroup = townBlock.getPlotObjectGroup();
                        Runnable permHandler = () -> {
                            Iterator<TownBlock> townBlockIterator = plotGroup.getTownBlocks().iterator();
                            if (!townBlockIterator.hasNext()) {
                                return;
                            }
                            TownBlock tb = townBlockIterator.next();
                            TownyPermissionChange permChange = PlotCommand.setTownBlockPermissions(player, townBlockOwner, tb, StringMgmt.remArgs(split, 2));
                            if (permChange != null) {
                                while (townBlockIterator.hasNext()) {
                                    tb = townBlockIterator.next();
                                    tb.getPermissions().change(permChange);
                                    tb.setChanged(true);
                                    tb.save();
                                    TownBlockSettingsChangedEvent event = new TownBlockSettingsChangedEvent(tb);
                                    Bukkit.getServer().getPluginManager().callEvent((Event)event);
                                }
                                plugin.resetCache();
                                TownyPermission perm = ((TownBlock)Iterables.getFirst(plotGroup.getTownBlocks(), null)).getPermissions();
                                TownyMessaging.sendMsg((CommandSender)player, Translation.of("msg_set_perms"));
                                TownyMessaging.sendMessage((Object)player, "\u00a72 Perm: " + (townBlockOwner instanceof Resident ? perm.getColourString().replace("n", "t") : perm.getColourString().replace("f", "r")));
                                TownyMessaging.sendMessage((Object)player, "\u00a72 Perm: " + (townBlockOwner instanceof Resident ? perm.getColourString2().replace("n", "t") : perm.getColourString2().replace("f", "r")));
                                TownyMessaging.sendMessage((Object)player, "\u00a72PvP: " + (!CombatUtil.preventPvP(townBlock.getWorld(), townBlock) ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Explosions: " + (perm.explosion ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Firespread: " + (perm.fire ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Mob Spawns: " + (perm.mobs ? "\u00a74ON" : "\u00a7aOFF"));
                            }
                        };
                        String title = Translation.of("msg_plot_group_set_perm_confirmation", townBlock.getPlotObjectGroup().getTownBlocks().size()) + " " + Translation.of("are_you_sure_you_want_to_continue");
                        Confirmation.runOnAccept(permHandler).setTitle(title).sendTo((CommandSender)player);
                        return true;
                    }
                    String plotTypeName = split[1];
                    if (plotTypeName.equalsIgnoreCase("jail")) {
                        throw new TownyException(Translation.of(Translation.of("msg_err_cannot_set_group_to_jail")));
                    }
                    if (plotTypeName.equalsIgnoreCase("reset")) {
                        plotTypeName = "default";
                    }
                    if ((type = TownBlockType.lookup(plotTypeName)) == null) {
                        throw new TownyException(Translation.of("msg_err_not_block_type"));
                    }
                    for (TownBlock tb : townBlock.getPlotObjectGroup().getTownBlocks()) {
                        try {
                            this.plotTestOwner(resident, townBlock);
                        }
                        catch (TownyException e) {
                            TownyMessaging.sendErrorMsg((Object)resident, e.getMessage());
                            return false;
                        }
                        PlotPreChangeTypeEvent preEvent = new PlotPreChangeTypeEvent(type, tb, resident);
                        BukkitTools.getPluginManager().callEvent((Event)preEvent);
                        if (!preEvent.isCancelled()) continue;
                        player.sendMessage(preEvent.getCancelMessage());
                        return false;
                    }
                    int amount = townBlock.getPlotObjectGroup().getTownBlocks().size();
                    double cost = type.getCost() * (double)amount;
                    try {
                        if (cost > 0.0 && TownyEconomyHandler.isActive() && !resident.getAccount().canPayFromHoldings(cost)) {
                            throw new EconomyException(Translation.of("msg_err_cannot_afford_plot_set_type_cost", new Object[]{type, TownyEconomyHandler.getFormattedBalance(cost)}));
                        }
                        if (cost > 0.0 && TownyEconomyHandler.isActive()) {
                            Confirmation.runOnAccept(() -> {
                                try {
                                    resident.getAccount().withdraw(cost, String.format("Plot (" + amount + ") set to %s", new Object[]{type}));
                                }
                                catch (EconomyException economyException) {
                                    // empty catch block
                                }
                                TownyMessaging.sendMessage((Object)resident, Translation.of("msg_plot_set_cost", new Object[]{TownyEconomyHandler.getFormattedBalance(cost), type}));
                                for (TownBlock tb : townBlock.getPlotObjectGroup().getTownBlocks()) {
                                    try {
                                        tb.setType(type, resident);
                                    }
                                    catch (TownyException townyException) {}
                                }
                                TownyMessaging.sendMsg((CommandSender)player, Translation.of("msg_set_group_type_to_x", new Object[]{type}));
                            }).setTitle(Translation.of("msg_confirm_purchase", TownyEconomyHandler.getFormattedBalance(cost))).sendTo((CommandSender)BukkitTools.getPlayerExact(resident.getName()));
                            break block51;
                        }
                        for (TownBlock tb : townBlock.getPlotObjectGroup().getTownBlocks()) {
                            tb.setType(type, resident);
                        }
                        TownyMessaging.sendMsg((CommandSender)player, Translation.of("msg_set_group_type_to_x", plotTypeName));
                    }
                    catch (EconomyException e) {
                        TownyMessaging.sendErrorMsg((Object)resident, e.getMessage());
                    }
                } else {
                    player.sendMessage(ChatTools.formatTitle("/plot group"));
                    player.sendMessage(ChatTools.formatCommand("/plot group", "add | new | create", "[name]", "Ex: /plot group new ExpensivePlots"));
                    player.sendMessage(ChatTools.formatCommand("/plot group", "remove", "", "Removes a plot from the specified group."));
                    player.sendMessage(ChatTools.formatCommand("/plot group", "rename", "[newName]", "Renames the group you are standing in."));
                    player.sendMessage(ChatTools.formatCommand("/plot group", "set", "...", "Ex: /plot group set perm resident on."));
                    player.sendMessage(ChatTools.formatCommand("/plot group", "toggle", "...", "Ex: /plot group toggle [pvp|fire|mobs]"));
                    player.sendMessage(ChatTools.formatCommand("/plot group", "forsale | fs", "[price]", "Ex: /plot group forsale 50"));
                    player.sendMessage(ChatTools.formatCommand("/plot group", "notforsale | nfs", "", "Ex: /plot group notforsale"));
                    if (townBlock.hasPlotObjectGroup()) {
                        TownyMessaging.sendMsg((CommandSender)player, Translation.of("status_plot_group_name_and_size", townBlock.getPlotObjectGroup().getName(), townBlock.getPlotObjectGroup().getTownBlocks().size()));
                    }
                    return true;
                }
            }
        }
        return false;
    }

    static {
        plotTabCompletes = Arrays.asList("claim", "unclaim", "forsale", "fs", "notforsale", "nfs", "evict", "perm", "set", "toggle", "clear", "group");
        plotGroupTabCompletes = Arrays.asList("add", "remove", "set", "toggle", "fs", "notforsale", "forsale", "perm", "rename");
        plotSetTabCompletes = Arrays.asList("reset", "shop", "embassy", "arena", "wilds", "inn", "jail", "farm", "bank", "outpost", "name", "perm");
        plotRectCircleCompletes = Arrays.asList("rect", "circle");
        plotToggleTabCompletes = Arrays.asList("fire", "pvp", "explosion", "mobs");
    }
}

