/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyLogger;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyTimerHandler;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.command.BaseCommand;
import com.palmergames.bukkit.towny.command.HelpMenu;
import com.palmergames.bukkit.towny.command.NationCommand;
import com.palmergames.bukkit.towny.command.ResidentCommand;
import com.palmergames.bukkit.towny.command.TownCommand;
import com.palmergames.bukkit.towny.confirmations.Confirmation;
import com.palmergames.bukkit.towny.db.TownyFlatFileSource;
import com.palmergames.bukkit.towny.event.NationPreRenameEvent;
import com.palmergames.bukkit.towny.event.TownPreRenameEvent;
import com.palmergames.bukkit.towny.event.TownyLoadedDatabaseEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.InvalidMetadataTypeException;
import com.palmergames.bukkit.towny.exceptions.InvalidNameException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.SpawnType;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.metadata.CustomDataField;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.tasks.BackupTask;
import com.palmergames.bukkit.towny.tasks.PlotClaim;
import com.palmergames.bukkit.towny.tasks.ResidentPurge;
import com.palmergames.bukkit.towny.tasks.TownClaim;
import com.palmergames.bukkit.towny.utils.AreaSelectionUtil;
import com.palmergames.bukkit.towny.utils.NameUtil;
import com.palmergames.bukkit.towny.utils.ResidentUtil;
import com.palmergames.bukkit.towny.utils.SpawnUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.NameValidation;
import com.palmergames.util.MemMgmt;
import com.palmergames.util.StringMgmt;
import com.palmergames.util.TimeTools;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;

public class TownyAdminCommand
extends BaseCommand
implements CommandExecutor {
    private static Towny plugin;
    private static final List<String> ta_panel;
    private static final List<String> adminTabCompletes;
    private static final List<String> adminTownTabCompletes;
    private static final List<String> adminNationTabCompletes;
    private static final List<String> adminToggleTabCompletes;
    private static final List<String> adminPlotTabCompletes;
    private static final List<String> adminMetaTabCompletes;
    private static final List<String> adminDatabaseTabCompletes;
    private static final List<String> adminResidentTabCompletes;
    private static final List<String> adminResidentFriendTabCompletes;
    private static final List<String> adminSetCompletes;
    private boolean isConsole;
    private Player player;
    private CommandSender sender;

    public TownyAdminCommand(Towny instance) {
        plugin = instance;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        this.sender = sender;
        if (sender instanceof Player) {
            this.player = (Player)sender;
            this.isConsole = false;
        } else {
            this.isConsole = true;
            this.player = null;
        }
        try {
            return this.parseTownyAdminCommand(args);
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg((Object)sender, e.getMessage());
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        switch (args[0].toLowerCase()) {
            case "reload": {
                if (args.length > 1) {
                    return NameUtil.filterByStart(Arrays.asList("database", "db", "config", "perms", "permissions", "language", "lang", "townyperms", "all"), args[1]);
                }
            }
            case "set": {
                if (args.length <= 1) return Collections.emptyList();
                switch (args[1].toLowerCase()) {
                    case "mayor": {
                        switch (args.length) {
                            case 3: {
                                return TownyAdminCommand.getTownyStartingWith(args[2], "t");
                            }
                            case 4: {
                                return TownyAdminCommand.filterByStartOrGetTownyStartingWith(Collections.singletonList("npc"), args[3], "+r");
                            }
                        }
                    }
                    case "capital": 
                    case "plot": {
                        if (args.length == 3) {
                            return TownyAdminCommand.getTownyStartingWith(args[2], "t");
                        }
                    }
                    case "title": 
                    case "surname": {
                        if (args.length != 3) break;
                        return TownyAdminCommand.getTownyStartingWith(args[2], "r");
                    }
                }
                if (args.length != 2) return Collections.emptyList();
                return NameUtil.filterByStart(adminSetCompletes, args[1]);
            }
            case "plot": {
                if (args.length == 2) {
                    return NameUtil.filterByStart(adminPlotTabCompletes, args[1]);
                }
                if (args.length <= 2) return Collections.emptyList();
                switch (args[1].toLowerCase()) {
                    case "claim": {
                        return TownyAdminCommand.getTownyStartingWith(args[2], "r");
                    }
                    case "meta": {
                        if (args.length != 3) return Collections.emptyList();
                        return NameUtil.filterByStart(adminMetaTabCompletes, args[2]);
                    }
                }
                return Collections.emptyList();
            }
            case "givebonus": {
                if (args.length != 2) return Collections.emptyList();
                return TownyAdminCommand.getTownyStartingWith(args[1], "rt");
            }
            case "toggle": {
                if (args.length == 2) {
                    return NameUtil.filterByStart(adminToggleTabCompletes, args[1]);
                }
                if (args.length >= 3 && args[1].equalsIgnoreCase("npc")) {
                    if (args.length == 3) {
                        return TownyAdminCommand.getTownyStartingWith(args[2], "r");
                    }
                    if (args.length != 4) return Collections.emptyList();
                    return NameUtil.filterByStart(BaseCommand.setOnOffCompletes, args[3]);
                }
                if (args.length != 3) return Collections.emptyList();
                return NameUtil.filterByStart(BaseCommand.setOnOffCompletes, args[2]);
            }
            case "tpplot": {
                if (args.length != 2) return Collections.emptyList();
                return NameUtil.filterByStart(TownyUniverse.getInstance().getDataSource().getWorlds().stream().map(TownyObject::getName).collect(Collectors.toList()), args[1]);
            }
            case "checkperm": 
            case "delete": {
                if (args.length != 2) return Collections.emptyList();
                return TownyAdminCommand.getTownyStartingWith(args[1], "r");
            }
            case "database": {
                if (args.length != 2) return Collections.emptyList();
                return NameUtil.filterByStart(adminDatabaseTabCompletes, args[1]);
            }
            case "resident": {
                switch (args.length) {
                    case 2: {
                        return TownyAdminCommand.getTownyStartingWith(args[1], "r");
                    }
                    case 3: {
                        return NameUtil.filterByStart(adminResidentTabCompletes, args[2]);
                    }
                    case 4: {
                        if (!args[2].equalsIgnoreCase("friend")) return Collections.emptyList();
                        return NameUtil.filterByStart(adminResidentFriendTabCompletes, args[3]);
                    }
                }
                return Collections.emptyList();
            }
            case "town": {
                if (args.length == 2) {
                    return TownyAdminCommand.filterByStartOrGetTownyStartingWith(Collections.singletonList("new"), args[1], "+t");
                }
                if (args.length > 2 && !args[1].equalsIgnoreCase("new")) {
                    switch (args[2].toLowerCase()) {
                        case "add": {
                            if (args.length == 4) {
                                return null;
                            }
                        }
                        case "kick": {
                            if (args.length == 4) {
                                return TownyAdminCommand.getResidentsOfTownStartingWith(args[1], args[3]);
                            }
                        }
                        case "rank": {
                            switch (args.length) {
                                case 4: {
                                    return NameUtil.filterByStart(TownCommand.townAddRemoveTabCompletes, args[3]);
                                }
                                case 5: {
                                    return TownyAdminCommand.getResidentsOfTownStartingWith(args[1], args[4]);
                                }
                                case 6: {
                                    switch (args[3].toLowerCase()) {
                                        case "add": {
                                            return NameUtil.filterByStart(TownyPerms.getTownRanks(), args[5]);
                                        }
                                        case "remove": {
                                            Resident res = TownyUniverse.getInstance().getResident(args[4]);
                                            if (res == null) return Collections.emptyList();
                                            return NameUtil.filterByStart(res.getTownRanks(), args[5]);
                                        }
                                    }
                                    return Collections.emptyList();
                                }
                            }
                            return Collections.emptyList();
                        }
                        case "set": {
                            Town town = TownyUniverse.getInstance().getTown(args[1]);
                            if (town == null) return Collections.emptyList();
                            return TownCommand.townSetTabComplete(town, StringMgmt.remArgs(args, 2));
                        }
                        case "toggle": {
                            if (args.length == 4) {
                                return NameUtil.filterByStart(TownCommand.townToggleTabCompletes, args[3]);
                            }
                            if (args.length == 5 && !args[3].equalsIgnoreCase("jail")) {
                                return NameUtil.filterByStart(BaseCommand.setOnOffCompletes, args[4]);
                            }
                        }
                        case "outlaw": {
                            switch (args.length) {
                                case 4: {
                                    return NameUtil.filterByStart(TownCommand.townAddRemoveTabCompletes, args[3]);
                                }
                                case 5: {
                                    switch (args[3].toLowerCase()) {
                                        case "add": {
                                            return TownyAdminCommand.getTownyStartingWith(args[4], "r");
                                        }
                                        case "remove": {
                                            Town town = TownyUniverse.getInstance().getTown(args[1]);
                                            if (town == null) break;
                                            return NameUtil.filterByStart(NameUtil.getNames(town.getOutlaws()), args[4]);
                                        }
                                    }
                                    break;
                                }
                            }
                        }
                        case "invite": {
                            if (args.length == 4) {
                                return TownyAdminCommand.getTownyStartingWith(args[3], "r");
                            }
                        }
                        case "meta": {
                            if (args.length != 4) return Collections.emptyList();
                            return NameUtil.filterByStart(adminMetaTabCompletes, args[3]);
                        }
                    }
                    if (args.length != 3) return Collections.emptyList();
                    return NameUtil.filterByStart(adminTownTabCompletes, args[2]);
                }
                if (args.length != 4) return Collections.emptyList();
                if (!args[1].equalsIgnoreCase("new")) return Collections.emptyList();
                return TownyAdminCommand.getTownyStartingWith(args[3], "r");
            }
            case "nation": {
                if (args.length == 2) {
                    return TownyAdminCommand.filterByStartOrGetTownyStartingWith(Collections.singletonList("new"), args[1], "+n");
                }
                if (args.length > 2 && !args[1].equalsIgnoreCase("new")) {
                    switch (args[2].toLowerCase()) {
                        case "add": {
                            if (args.length == 4) {
                                return TownyAdminCommand.getTownyStartingWith(args[3], "t");
                            }
                        }
                        case "toggle": {
                            if (args.length == 4) {
                                return NameUtil.filterByStart(NationCommand.nationToggleTabCompletes, args[3]);
                            }
                            if (args.length == 5) {
                                return NameUtil.filterByStart(BaseCommand.setOnOffCompletes, args[4]);
                            }
                        }
                        case "set": {
                            Nation nation = TownyUniverse.getInstance().getNation(args[1]);
                            if (nation == null) return Collections.emptyList();
                            return NationCommand.nationSetTabComplete(nation, StringMgmt.remArgs(args, 2));
                        }
                        case "merge": {
                            if (args.length != 4) break;
                            return TownyAdminCommand.getTownyStartingWith(args[3], "n");
                        }
                    }
                    if (args.length != 3) return Collections.emptyList();
                    return NameUtil.filterByStart(adminNationTabCompletes, args[2]);
                }
                if (args.length != 4) return Collections.emptyList();
                if (!args[1].equalsIgnoreCase("new")) return Collections.emptyList();
                return TownyAdminCommand.getTownyStartingWith(args[3], "t");
            }
            case "unclaim": {
                if (args.length != 2) break;
                return NameUtil.filterByStart(TownCommand.townUnclaimTabCompletes, args[1]);
            }
        }
        if (args.length != 1) return Collections.emptyList();
        return NameUtil.filterByStart(adminTabCompletes, args[0]);
    }

    private CommandSender getSender() {
        return this.sender;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean parseTownyAdminCommand(String[] split) throws TownyException {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (this.getSender() == this.player && !townyUniverse.getPermissionSource().testPermission(this.player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_SCREEN.getNode())) {
            throw new TownyException(Translation.of("msg_err_command_disable"));
        }
        if (split.length == 0) {
            this.buildTAPanel();
            Iterator<String> iterator = ta_panel.iterator();
            while (iterator.hasNext()) {
                String line = iterator.next();
                this.sender.sendMessage(line);
            }
            return true;
        }
        if (split[0].equalsIgnoreCase("?") || split[0].equalsIgnoreCase("help")) {
            HelpMenu.TA_HELP.send(this.sender);
            return true;
        }
        if (split[0].equalsIgnoreCase("set")) {
            this.adminSet(StringMgmt.remFirstArg(split));
            return true;
        }
        if (split[0].equalsIgnoreCase("resident")) {
            this.parseAdminResidentCommand(StringMgmt.remFirstArg(split));
            return true;
        }
        if (split[0].equalsIgnoreCase("town")) {
            this.parseAdminTownCommand(StringMgmt.remFirstArg(split));
            return true;
        }
        if (split[0].equalsIgnoreCase("nation")) {
            this.parseAdminNationCommand(StringMgmt.remFirstArg(split));
            return true;
        }
        if (split[0].equalsIgnoreCase("toggle")) {
            this.parseToggleCommand(StringMgmt.remFirstArg(split));
            return true;
        }
        if (split[0].equalsIgnoreCase("plot")) {
            this.parseAdminPlotCommand(StringMgmt.remFirstArg(split));
            return true;
        }
        if (!this.isConsole && !townyUniverse.getPermissionSource().testPermission(this.player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN.getNode(split[0].toLowerCase()))) {
            throw new TownyException(Translation.of("msg_err_command_disable"));
        }
        if (split[0].equalsIgnoreCase("givebonus") || split[0].equalsIgnoreCase("giveplots")) {
            this.giveBonus(StringMgmt.remFirstArg(split));
            return true;
        }
        if (split[0].equalsIgnoreCase("reload")) {
            if (split.length != 2) {
                this.showReloadHelp();
                return false;
            }
            switch (split[1]) {
                case "db": 
                case "database": {
                    this.reloadDatabase();
                    return true;
                }
                case "config": {
                    this.reloadConfig(false);
                    return true;
                }
                case "perms": 
                case "townyperms": 
                case "permissions": {
                    this.reloadPerms();
                    return true;
                }
                case "language": 
                case "lang": {
                    this.reloadLangs();
                    return true;
                }
                case "all": {
                    this.reloadConfig(false);
                    this.reloadLangs();
                    this.reloadPerms();
                    this.reloadDatabase();
                    return true;
                }
            }
            this.showReloadHelp();
            return true;
        }
        if (split[0].equalsIgnoreCase("reset")) {
            this.reloadConfig(true);
            return true;
        }
        if (split[0].equalsIgnoreCase("backup")) {
            CompletableFuture.runAsync(new BackupTask()).thenRun(() -> TownyMessaging.sendMsg(this.getSender(), Translation.of("mag_backup_success")));
            return true;
        }
        if (split[0].equalsIgnoreCase("database")) {
            this.parseAdminDatabaseCommand(StringMgmt.remFirstArg(split));
            return true;
        }
        if (split[0].equalsIgnoreCase("mysqldump")) {
            if (!TownySettings.getSaveDatabase().equalsIgnoreCase("mysql")) throw new TownyException(Translation.of("msg_err_mysql_not_being_used"));
            if (!TownySettings.getLoadDatabase().equalsIgnoreCase("mysql")) throw new TownyException(Translation.of("msg_err_mysql_not_being_used"));
            TownyFlatFileSource dataSource = new TownyFlatFileSource(plugin, townyUniverse);
            dataSource.saveAll();
            TownyMessaging.sendMsg(this.getSender(), Translation.of("msg_mysql_dump_success"));
            return true;
        }
        if (split[0].equalsIgnoreCase("newday")) {
            TownyTimerHandler.newDay();
            return true;
        }
        if (split[0].equalsIgnoreCase("newhour")) {
            TownyTimerHandler.newHour();
            TownyMessaging.sendMsg(this.getSender(), Translation.of("msg_newhour_success"));
            return true;
        }
        if (split[0].equalsIgnoreCase("purge")) {
            this.purge(StringMgmt.remFirstArg(split));
            return true;
        }
        if (split[0].equalsIgnoreCase("delete")) {
            String[] newSplit = StringMgmt.remFirstArg(split);
            this.residentDelete(this.player, newSplit);
            return true;
        }
        if (split[0].equalsIgnoreCase("unclaim")) {
            this.parseAdminUnclaimCommand(StringMgmt.remFirstArg(split));
            return true;
        }
        if (split[0].equalsIgnoreCase("checkperm")) {
            this.parseAdminCheckPermCommand(StringMgmt.remFirstArg(split));
            return true;
        }
        if (split[0].equalsIgnoreCase("tpplot")) {
            this.parseAdminTpPlotCommand(StringMgmt.remFirstArg(split));
            return true;
        }
        if (!split[0].equalsIgnoreCase("depositall")) {
            TownyMessaging.sendErrorMsg((Object)this.getSender(), Translation.of("msg_err_invalid_sub"));
            return false;
        }
        if (!TownyEconomyHandler.isActive()) {
            throw new TownyException(Translation.of("msg_err_no_economy"));
        }
        this.parseAdminDepositAllCommand(StringMgmt.remFirstArg(split));
        return true;
    }

    private void parseAdminDatabaseCommand(String[] split) {
        if (split.length == 0 || split.length > 2 || split[0].equalsIgnoreCase("?")) {
            this.sender.sendMessage(ChatTools.formatTitle("/townyadmin database"));
            this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin database", "save", ""));
            this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin database", "load", ""));
            return;
        }
        if (split[0].equalsIgnoreCase("save")) {
            if (TownyUniverse.getInstance().getDataSource().saveAll()) {
                TownyMessaging.sendMsg(this.getSender(), Translation.of("msg_save_success"));
            }
        } else if (split[0].equalsIgnoreCase("load")) {
            TownyUniverse.getInstance().clearAllObjects();
            if (TownyUniverse.getInstance().getDataSource().loadAll()) {
                TownyMessaging.sendMsg(this.getSender(), Translation.of("msg_load_success"));
                Bukkit.getPluginManager().callEvent((Event)new TownyLoadedDatabaseEvent());
            }
        }
    }

    private void parseAdminPlotCommand(String[] split) throws TownyException {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (this.isConsole) {
            this.sender.sendMessage("[Towny] InputError: This command was designed for use in game only.");
            return;
        }
        if (split.length == 0 || split.length < 1 || split[0].equalsIgnoreCase("?")) {
            this.sender.sendMessage(ChatTools.formatTitle("/townyadmin plot"));
            this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin plot claim", "[player]", ""));
            this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin plot meta", "", ""));
            this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin plot meta", "set [key] [value]", ""));
            this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin plot meta", "[add|remove] [key]", ""));
            return;
        }
        if (split[0].equalsIgnoreCase("meta")) {
            TownyAdminCommand.handlePlotMetaCommand(this.player, split);
            return;
        }
        if (split[0].equalsIgnoreCase("claim")) {
            if (!townyUniverse.getPermissionSource().testPermission(this.player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_PLOT_CLAIM.getNode())) {
                throw new TownyException(Translation.of("msg_err_command_disable"));
            }
            if (split.length == 1) {
                TownyMessaging.sendErrorMsg((Object)this.sender, Translation.of("msg_error_ta_plot_claim"));
                return;
            }
            Optional<Resident> resOpt = townyUniverse.getResidentOpt(split[1]);
            if (!resOpt.isPresent()) {
                TownyMessaging.sendErrorMsg((Object)this.sender, Translation.of("msg_error_no_player_with_that_name", split[1]));
                return;
            }
            Player player = BukkitTools.getPlayer(this.sender.getName());
            String world = player.getWorld().getName();
            ArrayList<WorldCoord> selection = new ArrayList<WorldCoord>();
            selection.add(new WorldCoord(world, Coord.parseCoord((Entity)player)));
            new PlotClaim(plugin, player, resOpt.get(), selection, true, true, false).start();
        }
    }

    private void parseAdminCheckPermCommand(String[] split) throws TownyException {
        if (split.length != 2) {
            throw new TownyException(Translation.of("msg_err_invalid_input", "Eg: /ta checkperm {name} {node}"));
        }
        Player player = BukkitTools.getPlayer(split[0]);
        if (player == null) {
            throw new TownyException("Player couldn't be found");
        }
        String node = split[1];
        if (player.hasPermission(node)) {
            TownyMessaging.sendMessage((Object)this.sender, "Permission true");
        } else {
            TownyMessaging.sendErrorMsg((Object)this.sender, "Permission false");
        }
    }

    private void parseAdminTpPlotCommand(String[] split) throws TownyException {
        if (split.length != 3) {
            throw new TownyException(Translation.of("msg_err_invalid_input", "Eg: /ta tpplot world x z"));
        }
        Player player = (Player)this.sender;
        double y = 1.0;
        if (Bukkit.getServer().getWorld(split[0]) == null) {
            throw new TownyException(Translation.of("msg_err_invalid_input", "Eg: /ta tpplot world x z"));
        }
        World world = Bukkit.getServer().getWorld(split[0]);
        double x = Double.parseDouble(split[1]) * (double)TownySettings.getTownBlockSize();
        double z = Double.parseDouble(split[2]) * (double)TownySettings.getTownBlockSize();
        y = Bukkit.getWorld((String)world.getName()).getHighestBlockYAt(new Location(world, x, y, z));
        Location loc = new Location(world, x, y, z);
        player.teleport(loc, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    private void giveBonus(String[] split) throws TownyException {
        int extraBlocks;
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        boolean isTown = false;
        if (split.length != 2) {
            throw new TownyException(Translation.of("msg_err_invalid_input", "Eg: givebonus [town/player] [n]"));
        }
        Town town = townyUniverse.getTown(split[0]);
        if (town != null) {
            isTown = true;
        } else {
            Resident target = TownyAdminCommand.getResidentOrThrow(split[0]);
            if (!target.hasTown()) {
                throw new TownyException(Translation.of("msg_err_resident_doesnt_belong_to_any_town"));
            }
            try {
                town = target.getTown();
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        try {
            extraBlocks = Integer.parseInt(split[1].trim());
        }
        catch (NumberFormatException ex) {
            throw new TownyException(Translation.of("msg_error_must_be_int"));
        }
        town.setBonusBlocks(town.getBonusBlocks() + extraBlocks);
        TownyMessaging.sendMsg(this.getSender(), Translation.of("msg_give_total", town.getName(), split[1], town.getBonusBlocks()));
        if (!this.isConsole || isTown) {
            TownyMessaging.sendTownMessagePrefixed(town, "You have been given " + extraBlocks + " bonus townblocks.");
        }
        if (this.isConsole && !isTown) {
            TownyMessaging.sendMessage((Object)town, "You have been given " + extraBlocks + " bonus townblocks.");
            TownyMessaging.sendMessage((Object)town, "If you have paid any real-life money for these townblocks please understand: the creators of Towny do not condone this transaction, the server you play on breaks the Minecraft EULA and, worse, is selling a part of Towny which the developers did not intend to be sold.");
            TownyMessaging.sendMessage((Object)town, "If you did pay real money you should consider playing on a Towny server that respects the wishes of the Towny Team.");
        }
        town.save();
    }

    private void buildTAPanel() {
        ta_panel.clear();
        Runtime run = Runtime.getRuntime();
        ta_panel.add(ChatTools.formatTitle(Translation.of("ta_panel_1")));
        ta_panel.add("\u00a73[\u00a7bTowny\u00a73] \u00a72" + Translation.of("ta_panel_2") + "\u00a7a" + TownyAPI.getInstance().isWarTime() + "\u00a78" + " | " + "\u00a72" + Translation.of("ta_panel_3") + (TownyTimerHandler.isHealthRegenRunning() ? "\u00a7aOn" : "\u00a7cOff") + "\u00a78" + " | " + "\u00a72" + Translation.of("ta_panel_5") + (TownyTimerHandler.isDailyTimerRunning() ? "\u00a7aOn" : "\u00a7cOff"));
        ta_panel.add("\u00a73[\u00a7b" + Translation.of("ta_panel_8") + "\u00a73" + "] " + "\u00a72" + Translation.of("ta_panel_9") + "\u00a7a" + MemMgmt.getMemSize(run.totalMemory()) + "\u00a78" + " | " + "\u00a72" + Translation.of("ta_panel_10") + "\u00a7a" + Thread.getAllStackTraces().keySet().size() + "\u00a78" + " | " + "\u00a72" + Translation.of("ta_panel_11") + "\u00a7a" + TownyFormatter.getTime());
        ta_panel.add("\u00a7e" + MemMgmt.getMemoryBar(50, run));
    }

    public void parseAdminUnclaimCommand(String[] split) {
        if (split.length == 1 && split[0].equalsIgnoreCase("?")) {
            HelpMenu.TA_UNCLAIM.send(this.getSender());
        } else {
            if (this.isConsole) {
                this.sender.sendMessage("[Towny] InputError: This command was designed for use in game only.");
                return;
            }
            try {
                if (TownyAPI.getInstance().isWarTime()) {
                    throw new TownyException(Translation.of("msg_war_cannot_do"));
                }
                List<WorldCoord> selection = AreaSelectionUtil.selectWorldCoordArea(null, new WorldCoord(this.player.getWorld().getName(), Coord.parseCoord((Entity)this.player)), split);
                selection = AreaSelectionUtil.filterOutWildernessBlocks(selection);
                new TownClaim(plugin, this.player, null, selection, false, false, true).start();
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg((Object)this.player, x.getMessage());
                return;
            }
        }
    }

    public void parseAdminResidentCommand(String[] split) throws TownyException {
        block15: {
            TownyUniverse townyUniverse = TownyUniverse.getInstance();
            if (split.length == 0 || split[0].equalsIgnoreCase("?")) {
                this.sender.sendMessage(ChatTools.formatTitle("/townyadmin resident"));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin resident", "[resident]", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin resident", "[resident] rename [newname]", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin resident", "[resident] friend... [add|remove] [resident]", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin resident", "[resident] friend... |list|clear]", ""));
                return;
            }
            try {
                Resident resident = TownyAdminCommand.getResidentOrThrow(split[0]);
                if (split.length == 1) {
                    TownyMessaging.sendMessage((Object)this.getSender(), TownyFormatter.getStatus(resident, this.player));
                    return;
                }
                if (!townyUniverse.getPermissionSource().testPermission(this.player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_RESIDENT.getNode(split[1].toLowerCase()))) {
                    throw new TownyException(Translation.of("msg_err_command_disable"));
                }
                if (split[1].equalsIgnoreCase("rename")) {
                    if (!NameValidation.isBlacklistName(split[2])) {
                        townyUniverse.getDataSource().renamePlayer(resident, split[2]);
                    } else {
                        TownyMessaging.sendErrorMsg((Object)this.getSender(), Translation.of("msg_invalid_name"));
                    }
                    break block15;
                }
                if (split[1].equalsIgnoreCase("friend")) {
                    if (split.length == 2) {
                        this.sender.sendMessage(ChatTools.formatTitle("/townyadmin resident {resident} friend"));
                        this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin resident", "[resident] friend... [add|remove] [resident]", ""));
                        this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin resident", "[resident] friend... |list|clear]", ""));
                        return;
                    }
                    if (this.isConsole) {
                        throw new TownyException("/ta resident {resident} friend cannot be run from console.");
                    }
                    ResidentCommand.residentFriend(BukkitTools.getPlayer(this.sender.getName()), StringMgmt.remArgs(split, 2), true, resident);
                    break block15;
                }
                if (!split[1].equalsIgnoreCase("unjail")) break block15;
                Player jailedPlayer = TownyAPI.getInstance().getPlayer(resident);
                if (this.player == null) {
                    throw new TownyException(String.format("%s is not online", resident.getName()));
                }
                if (resident.isJailed()) {
                    resident.setJailed(false);
                    String jailTownName = resident.getJailTown();
                    int index = resident.getJailSpawn();
                    Town jailTown = townyUniverse.getTown(jailTownName);
                    if (jailTown == null) {
                        throw new TownyException(String.format("Invalid jail town of '%s'", jailTownName));
                    }
                    Location loc = Bukkit.getWorld((String)jailTown.getHomeblockWorld().getName()).getSpawnLocation();
                    jailedPlayer.sendMessage(Translation.of("msg_town_spawn_warmup", TownySettings.getTeleportWarmupTime()));
                    TownyAPI.getInstance().jailTeleport(jailedPlayer, loc);
                    resident.removeJailSpawn();
                    resident.setJailTown("");
                    TownyMessaging.sendMsg((CommandSender)this.player, "You have been freed from jail.");
                    TownyMessaging.sendPrefixedTownMessage(jailTown, jailedPlayer.getName() + " has been freed from jail number " + index);
                    break block15;
                }
                throw new TownyException(Translation.of("msg_player_not_jailed_in_your_town"));
            }
            catch (NotRegisteredException e) {
                TownyMessaging.sendErrorMsg((Object)this.getSender(), e.getMessage());
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg((Object)this.getSender(), e.getMessage());
            }
        }
    }

    public void parseAdminTownCommand(String[] split) throws TownyException {
        block50: {
            TownyUniverse townyUniverse = TownyUniverse.getInstance();
            if (split.length == 0 || split[0].equalsIgnoreCase("?")) {
                this.sender.sendMessage(ChatTools.formatTitle("/townyadmin town"));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin town", "new [name] [mayor]", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin town", "[town]", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin town", "[town] add/kick [] .. []", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin town", "[town] rename [newname]", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin town", "[town] delete", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin town", "[town] spawn", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin town", "[town] outpost #", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin town", "[town] rank", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin town", "[town] set", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin town", "[town] toggle", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin town", "[town] meta", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin town", "[town] deposit [amount]", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin town", "[town] withdraw [amount]", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin town", "[town] bankhistory", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin town", "[town] outlaw [add|remove] [name]", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin town", "[town] leavenation", ""));
                return;
            }
            try {
                if (split[0].equalsIgnoreCase("new")) {
                    if (split.length != 3) {
                        throw new TownyException(Translation.of("msg_err_not_enough_variables") + "/ta town new [name] [mayor]");
                    }
                    if (!townyUniverse.getPermissionSource().testPermission(this.player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_TOWN_NEW.getNode())) {
                        throw new TownyException(Translation.of("msg_err_command_disable"));
                    }
                    Optional<Resident> resOpt = TownyUniverse.getInstance().getResidentOpt(split[2]);
                    if (!resOpt.isPresent()) {
                        TownyMessaging.sendErrorMsg((Object)this.getSender(), Translation.of("msg_err_not_registered_1", split[2]));
                        return;
                    }
                    TownCommand.newTown(this.player, split[1], resOpt.get(), true);
                    return;
                }
                Town town = townyUniverse.getTown(split[0]);
                if (town == null) {
                    TownyMessaging.sendErrorMsg((Object)this.getSender(), Translation.of("msg_err_not_registered_1", split[0]));
                    return;
                }
                if (split.length == 1) {
                    TownyMessaging.sendMessage((Object)this.getSender(), TownyFormatter.getStatus(town));
                    return;
                }
                if (!townyUniverse.getPermissionSource().testPermission(this.player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_TOWN.getNode(split[1].toLowerCase()))) {
                    throw new TownyException(Translation.of("msg_err_command_disable"));
                }
                if (split[1].equalsIgnoreCase("invite")) {
                    TownCommand.townAdd(this.getSender(), town, StringMgmt.remArgs(split, 2));
                    break block50;
                }
                if (split[1].equalsIgnoreCase("add")) {
                    Resident resident = townyUniverse.getResident(split[2]);
                    if (resident == null) {
                        TownyMessaging.sendMessage((Object)this.sender, Translation.of("msg_error_no_player_with_that_name", split[2]));
                        return;
                    }
                    TownCommand.townAddResident(town, resident);
                    TownyMessaging.sendPrefixedTownMessage(town, Translation.of("msg_join_town", resident.getName()));
                    TownyMessaging.sendMessage((Object)this.sender, Translation.of("msg_join_town", resident.getName()));
                    break block50;
                }
                if (split[1].equalsIgnoreCase("kick")) {
                    TownCommand.townKickResidents(this.getSender(), town.getMayor(), town, ResidentUtil.getValidatedResidents(this.getSender(), StringMgmt.remArgs(split, 2)));
                    break block50;
                }
                if (split[1].equalsIgnoreCase("delete")) {
                    Confirmation.runOnAccept(() -> {
                        TownyMessaging.sendMessage((Object)this.sender, Translation.of("town_deleted_by_admin", town.getName()));
                        TownyUniverse.getInstance().getDataSource().removeTown(town);
                    }).sendTo(this.sender);
                    break block50;
                }
                if (split[1].equalsIgnoreCase("rename")) {
                    TownPreRenameEvent event = new TownPreRenameEvent(town, split[2]);
                    Bukkit.getServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        TownyMessaging.sendErrorMsg((Object)this.sender, Translation.of("msg_err_rename_cancelled"));
                        return;
                    }
                    if (!NameValidation.isBlacklistName(split[2])) {
                        townyUniverse.getDataSource().renameTown(town, split[2]);
                        TownyMessaging.sendPrefixedTownMessage(town, Translation.of("msg_town_set_name", this.getSender() instanceof Player ? this.player.getName() : "CONSOLE", town.getName()));
                        TownyMessaging.sendMsg(this.getSender(), Translation.of("msg_town_set_name", this.getSender() instanceof Player ? this.player.getName() : "CONSOLE", town.getName()));
                    } else {
                        TownyMessaging.sendErrorMsg((Object)this.getSender(), Translation.of("msg_invalid_name"));
                    }
                    break block50;
                }
                if (split[1].equalsIgnoreCase("spawn")) {
                    SpawnUtil.sendToTownySpawn(this.player, StringMgmt.remArgs(split, 2), town, "", false, false, SpawnType.TOWN);
                    break block50;
                }
                if (split[1].equalsIgnoreCase("outpost")) {
                    SpawnUtil.sendToTownySpawn(this.player, StringMgmt.remArgs(split, 2), town, "", true, false, SpawnType.TOWN);
                    break block50;
                }
                if (split[1].equalsIgnoreCase("rank")) {
                    this.parseAdminTownRankCommand(this.player, town, StringMgmt.remArgs(split, 2));
                    break block50;
                }
                if (split[1].equalsIgnoreCase("toggle")) {
                    if (split.length == 2 || split[2].equalsIgnoreCase("?")) {
                        this.sender.sendMessage(ChatTools.formatTitle("/ta town {townname} toggle"));
                        this.sender.sendMessage(ChatTools.formatCommand("", "/ta town {townname} toggle", "pvp", ""));
                        this.sender.sendMessage(ChatTools.formatCommand("", "/ta town {townname} toggle", "forcepvp", ""));
                        this.sender.sendMessage(ChatTools.formatCommand("", "/ta town {townname} toggle", "public", ""));
                        this.sender.sendMessage(ChatTools.formatCommand("", "/ta town {townname} toggle", "explosion", ""));
                        this.sender.sendMessage(ChatTools.formatCommand("", "/ta town {townname} toggle", "fire", ""));
                        this.sender.sendMessage(ChatTools.formatCommand("", "/ta town {townname} toggle", "mobs", ""));
                        this.sender.sendMessage(ChatTools.formatCommand("", "/ta town {townname} toggle", "taxpercent", ""));
                        this.sender.sendMessage(ChatTools.formatCommand("", "/ta town {townname} toggle", "open", ""));
                        this.sender.sendMessage(ChatTools.formatCommand("", "/ta town {townname} toggle", "jail [number] [resident]", ""));
                        this.sender.sendMessage(ChatTools.formatCommand("", "/ta town {townname} toggle", "forcepvp", ""));
                        return;
                    }
                    Optional<Object> choice = Optional.empty();
                    if (split.length == 4) {
                        choice = BaseCommand.parseToggleChoice(split[3]);
                    }
                    if (split[2].equalsIgnoreCase("forcepvp")) {
                        town.setAdminEnabledPVP(choice.orElse(!town.isAdminEnabledPVP()));
                        town.save();
                        TownyMessaging.sendMessage((Object)this.sender, Translation.of("msg_town_forcepvp_setting_set_to", town.getName(), town.isAdminEnabledPVP()));
                    } else {
                        TownCommand.townToggle(this.sender, StringMgmt.remArgs(split, 2), true, town);
                    }
                    break block50;
                }
                if (split[1].equalsIgnoreCase("set")) {
                    TownCommand.townSet(this.player, StringMgmt.remArgs(split, 2), true, town);
                    break block50;
                }
                if (split[1].equalsIgnoreCase("meta")) {
                    TownyAdminCommand.handleTownMetaCommand(this.player, town, split);
                    break block50;
                }
                if (split[1].equalsIgnoreCase("bankhistory")) {
                    int pages = 10;
                    if (split.length > 2) {
                        try {
                            pages = Integer.parseInt(split[2]);
                        }
                        catch (NumberFormatException e) {
                            TownyMessaging.sendErrorMsg((Object)this.player, Translation.of("msg_error_must_be_int"));
                            return;
                        }
                    }
                    town.generateBankHistoryBook(this.player, pages);
                    break block50;
                }
                if (split[1].equalsIgnoreCase("deposit")) {
                    int amount;
                    if (!TownyEconomyHandler.isActive()) {
                        throw new TownyException(Translation.of("msg_err_no_economy"));
                    }
                    if (split.length != 3) {
                        throw new TownyException(Translation.of("msg_err_invalid_input", "deposit [amount]"));
                    }
                    try {
                        amount = Integer.parseInt(split[2]);
                    }
                    catch (NumberFormatException ex) {
                        TownyMessaging.sendErrorMsg((Object)this.player, Translation.of("msg_error_must_be_int"));
                        return;
                    }
                    if (town.getAccount().deposit(amount, "Admin Deposit")) {
                        String depositMessage = Translation.of("msg_xx_deposited_xx", this.isConsole ? "Console" : this.player.getName(), amount, Translation.of("town_sing"));
                        TownyMessaging.sendMessage((Object)this.sender, depositMessage);
                        TownyMessaging.sendPrefixedTownMessage(town, depositMessage);
                    } else {
                        TownyMessaging.sendErrorMsg((Object)this.sender, Translation.of("msg_unable_to_deposit_x", amount));
                    }
                    break block50;
                }
                if (split[1].equalsIgnoreCase("withdraw")) {
                    int amount;
                    if (!TownyEconomyHandler.isActive()) {
                        throw new TownyException(Translation.of("msg_err_no_economy"));
                    }
                    if (split.length != 3) {
                        throw new TownyException(Translation.of("msg_err_invalid_input", "withdraw [amount]"));
                    }
                    try {
                        amount = Integer.parseInt(split[2]);
                    }
                    catch (NumberFormatException ex) {
                        TownyMessaging.sendErrorMsg((Object)this.player, Translation.of("msg_error_must_be_int"));
                        return;
                    }
                    if (town.getAccount().withdraw(amount, "Admin Withdraw")) {
                        String withdrawMessage = Translation.of("msg_xx_withdrew_xx", this.isConsole ? "Console" : this.player.getName(), amount, Translation.of("town_sing"));
                        TownyMessaging.sendMessage((Object)this.sender, withdrawMessage);
                        TownyMessaging.sendPrefixedTownMessage(town, withdrawMessage);
                    } else {
                        TownyMessaging.sendErrorMsg((Object)this.sender, Translation.of("msg_unable_to_withdraw_x", amount));
                    }
                    break block50;
                }
                if (split[1].equalsIgnoreCase("outlaw")) {
                    TownCommand.parseTownOutlawCommand(this.sender, StringMgmt.remArgs(split, 2), true, town);
                    break block50;
                }
                if (split[1].equalsIgnoreCase("leavenation")) {
                    Nation nation = null;
                    if (!town.hasNation()) {
                        throw new TownyException(Translation.of("That town does not belong to a nation."));
                    }
                    nation = town.getNation();
                    town.removeNation();
                    plugin.resetCache();
                    TownyMessaging.sendPrefixedNationMessage(nation, Translation.of("msg_nation_town_left", StringMgmt.remUnderscore(town.getName())));
                    TownyMessaging.sendPrefixedTownMessage(town, Translation.of("msg_town_left_nation", StringMgmt.remUnderscore(nation.getName())));
                    break block50;
                }
                this.sender.sendMessage(ChatTools.formatTitle("/townyadmin town"));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin town", "new [name] [mayor]", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin town", "[town]", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin town", "[town] add/kick [] .. []", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin town", "[town] rename [newname]", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin town", "[town] delete", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin town", "[town] spawn", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin town", "[town] outpost #", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin town", "[town] rank", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin town", "[town] set", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin town", "[town] toggle", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin town", "[town] meta", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin town", "[town] deposit [amount]", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin town", "[town] withdraw [amount]", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin town", "[town] bankhistory", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin town", "[town] outlaw [add|remove] [name]", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin town", "[town] leavenation", ""));
                return;
            }
            catch (EconomyException | TownyException e) {
                TownyMessaging.sendErrorMsg((Object)this.getSender(), e.getMessage());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseAdminTownRankCommand(Player player, Town town, String[] split) throws TownyException {
        if (split.length < 3) {
            throw new TownyException("Eg: /townyadmin town [townname] rank add/remove [resident] [rank]");
        }
        Resident target = TownyAdminCommand.getResidentOrThrow(split[1]);
        if (!target.hasTown()) {
            throw new TownyException(Translation.of("msg_resident_not_your_town"));
        }
        if (target.getTown() != town) {
            throw new TownyException(Translation.of("msg_err_townadmintownrank_wrong_town"));
        }
        String rank = TownyPerms.matchTownRank(split[2]);
        if (rank == null) {
            throw new TownyException(Translation.of("msg_unknown_rank_available_ranks", split[2], StringMgmt.join(TownyPerms.getTownRanks(), ", ")));
        }
        if (split[0].equalsIgnoreCase("add")) {
            try {
                if (!target.addTownRank(rank)) {
                    TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_resident_not_your_town"));
                    return;
                }
                TownyMessaging.sendMsg(target, Translation.of("msg_you_have_been_given_rank", "Town", rank));
                TownyMessaging.sendMsg((CommandSender)player, Translation.of("msg_you_have_given_rank", "Town", rank, target.getName()));
            }
            catch (AlreadyRegisteredException e) {
                TownyMessaging.sendMsg((CommandSender)player, Translation.of("msg_resident_already_has_rank", target.getName(), "Town"));
                return;
            }
        }
        if (!split[0].equalsIgnoreCase("remove")) {
            TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_invalid_property", split[0]));
            return;
        }
        try {
            if (target.removeTownRank(rank)) {
                TownyMessaging.sendMsg(target, Translation.of("msg_you_have_had_rank_taken", "Town", rank));
                TownyMessaging.sendMsg((CommandSender)player, Translation.of("msg_you_have_taken_rank_from", "Town", rank, target.getName()));
            }
        }
        catch (NotRegisteredException e) {
            TownyMessaging.sendMsg((CommandSender)player, Translation.of("msg_resident_doesnt_have_rank", target.getName(), "Town"));
            return;
        }
        target.save();
    }

    public void parseAdminNationCommand(String[] split) throws TownyException {
        block37: {
            TownyUniverse townyUniverse = TownyUniverse.getInstance();
            if (split.length == 0 || split[0].equalsIgnoreCase("?")) {
                this.sender.sendMessage(ChatTools.formatTitle("/townyadmin nation"));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin nation", "new", "[name] [capital]"));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin nation", "[nation]", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin nation", "[nation] add [] .. []", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin nation", "[nation] kick [] .. []", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin nation", "[nation] rename [newname]", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin nation", "[nation] delete", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin nation", "[nation] recheck", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin nation", "[nation] toggle", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin nation", "[nation] set", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin nation", "[nation] deposit [amount]", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin nation", "[nation] withdraw [amount]", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin nation", "[nation] bankhistory", ""));
                this.sender.sendMessage(ChatTools.formatCommand(Translation.of("admin_sing"), "/townyadmin nation", "[oldnation] merge [newnation]", ""));
                return;
            }
            try {
                int amount;
                if (split[0].equalsIgnoreCase("new")) {
                    if (split.length != 3) {
                        throw new TownyException(Translation.of("msg_err_not_enough_variables") + "/ta town new [name] [mayor]");
                    }
                    if (!townyUniverse.getPermissionSource().testPermission(this.player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_NATION_NEW.getNode())) {
                        throw new TownyException(Translation.of("msg_err_command_disable"));
                    }
                    Town capitalTown = townyUniverse.getTown(split[2]);
                    if (capitalTown == null) {
                        throw new TownyException(Translation.of("msg_err_invalid_name", split[2]));
                    }
                    NationCommand.newNation(this.player, split[1], capitalTown, true);
                    return;
                }
                Nation nation = townyUniverse.getNation(split[0]);
                if (nation == null) {
                    throw new NotRegisteredException(Translation.of("msg_err_no_nation_with_that_name", split[0]));
                }
                if (split.length == 1) {
                    TownyMessaging.sendMessage((Object)this.getSender(), TownyFormatter.getStatus(nation));
                    return;
                }
                if (!townyUniverse.getPermissionSource().testPermission(this.player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_NATION.getNode(split[1].toLowerCase()))) {
                    throw new TownyException(Translation.of("msg_err_command_disable"));
                }
                if (split[1].equalsIgnoreCase("add")) {
                    NationCommand.nationAdd(nation, townyUniverse.getDataSource().getTowns(StringMgmt.remArgs(split, 2)));
                    break block37;
                }
                if (split[1].equalsIgnoreCase("kick")) {
                    NationCommand.nationKick(this.sender, nation, townyUniverse.getDataSource().getTowns(StringMgmt.remArgs(split, 2)));
                    break block37;
                }
                if (split[1].equalsIgnoreCase("delete")) {
                    if (!this.isConsole) {
                        TownyMessaging.sendMessage((Object)this.sender, Translation.of("nation_deleted_by_admin", nation.getName()));
                        TownyMessaging.sendGlobalMessage(Translation.of("msg_del_nation", nation.getName()));
                        townyUniverse.getDataSource().removeNation(nation);
                    } else {
                        Confirmation.runOnAccept(() -> {
                            TownyUniverse.getInstance().getDataSource().removeNation(nation);
                            TownyMessaging.sendGlobalMessage(Translation.of("MSG_DEL_NATION", nation.getName()));
                        }).sendTo(this.sender);
                    }
                    break block37;
                }
                if (split[1].equalsIgnoreCase("recheck")) {
                    nation.recheckTownDistance();
                    TownyMessaging.sendMessage((Object)this.sender, Translation.of("nation_rechecked_by_admin", nation.getName()));
                    break block37;
                }
                if (split[1].equalsIgnoreCase("rename")) {
                    NationPreRenameEvent event = new NationPreRenameEvent(nation, split[2]);
                    Bukkit.getServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        TownyMessaging.sendErrorMsg((Object)this.sender, Translation.of("msg_err_rename_cancelled"));
                        return;
                    }
                    if (!NameValidation.isBlacklistName(split[2])) {
                        townyUniverse.getDataSource().renameNation(nation, split[2]);
                        TownyMessaging.sendPrefixedNationMessage(nation, Translation.of("msg_nation_set_name", this.getSender() instanceof Player ? this.player.getName() : "CONSOLE", nation.getName()));
                    } else {
                        TownyMessaging.sendErrorMsg((Object)this.getSender(), Translation.of("msg_invalid_name"));
                    }
                    break block37;
                }
                if (split[1].equalsIgnoreCase("merge")) {
                    Nation remainingNation = townyUniverse.getNation(split[2]);
                    if (remainingNation == null || remainingNation.equals(nation)) {
                        throw new TownyException(Translation.of("msg_err_invalid_name", split[2]));
                    }
                    townyUniverse.getDataSource().mergeNation(nation, remainingNation);
                    TownyMessaging.sendGlobalMessage(Translation.of("nation1_has_merged_with_nation2", nation, remainingNation));
                    break block37;
                }
                if (split[1].equalsIgnoreCase("set")) {
                    NationCommand.nationSet(this.player, StringMgmt.remArgs(split, 2), true, nation);
                    break block37;
                }
                if (split[1].equalsIgnoreCase("toggle")) {
                    NationCommand.nationToggle(this.sender, StringMgmt.remArgs(split, 2), true, nation);
                    break block37;
                }
                if (split[1].equalsIgnoreCase("bankhistory")) {
                    int pages = 10;
                    if (split.length > 2) {
                        try {
                            pages = Integer.parseInt(split[2]);
                        }
                        catch (NumberFormatException e) {
                            TownyMessaging.sendErrorMsg((Object)this.player, Translation.of("msg_error_must_be_int"));
                            return;
                        }
                    }
                    nation.generateBankHistoryBook(this.player, pages);
                    break block37;
                }
                if (split[1].equalsIgnoreCase("deposit")) {
                    int amount2;
                    if (!TownyEconomyHandler.isActive()) {
                        throw new TownyException(Translation.of("msg_err_no_economy"));
                    }
                    if (split.length != 3) {
                        throw new TownyException(Translation.of("msg_err_invalid_input", "deposit [amount]"));
                    }
                    try {
                        amount2 = Integer.parseInt(split[2]);
                    }
                    catch (NumberFormatException ex) {
                        TownyMessaging.sendErrorMsg((Object)this.player, Translation.of("msg_error_must_be_int"));
                        return;
                    }
                    nation.getAccount().deposit(amount2, "Admin Deposit");
                    String depositMessage = Translation.of("msg_xx_deposited_xx", this.isConsole ? "Console" : this.player.getName(), amount2, Translation.of("nation_sing"));
                    TownyMessaging.sendMessage((Object)this.sender, depositMessage);
                    TownyMessaging.sendPrefixedNationMessage(nation, depositMessage);
                    break block37;
                }
                if (!split[1].equalsIgnoreCase("withdraw")) break block37;
                if (!TownyEconomyHandler.isActive()) {
                    throw new TownyException(Translation.of("msg_err_no_economy"));
                }
                if (split.length != 3) {
                    throw new TownyException(Translation.of("msg_err_invalid_input", "withdraw [amount]"));
                }
                try {
                    amount = Integer.parseInt(split[2]);
                }
                catch (NumberFormatException ex) {
                    TownyMessaging.sendErrorMsg((Object)this.player, Translation.of("msg_error_must_be_int"));
                    return;
                }
                nation.getAccount().withdraw(amount, "Admin Withdraw");
                String withdrawMessage = Translation.of("msg_xx_withdrew_xx", this.isConsole ? "Console" : this.player.getName(), amount, Translation.of("nation_sing"));
                TownyMessaging.sendMessage((Object)this.sender, withdrawMessage);
                TownyMessaging.sendPrefixedNationMessage(nation, withdrawMessage);
            }
            catch (AlreadyRegisteredException | EconomyException | InvalidNameException | NotRegisteredException e) {
                TownyMessaging.sendErrorMsg((Object)this.getSender(), e.getMessage());
            }
        }
    }

    public void adminSet(String[] split) throws TownyException {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (!townyUniverse.getPermissionSource().testPermission(this.player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_SET.getNode())) {
            throw new TownyException(Translation.of("msg_err_command_disable"));
        }
        if (split.length == 0) {
            this.sender.sendMessage(ChatTools.formatTitle("/townyadmin set"));
            this.sender.sendMessage(ChatTools.formatCommand("", "/townyadmin set", "mayor [town] " + Translation.of("town_help_2"), ""));
            this.sender.sendMessage(ChatTools.formatCommand("", "/townyadmin set", "mayor [town] npc", ""));
            this.sender.sendMessage(ChatTools.formatCommand("", "/townyadmin set", "capital [town]", ""));
            this.sender.sendMessage(ChatTools.formatCommand("", "/townyadmin set", "title [resident] [title]", ""));
            this.sender.sendMessage(ChatTools.formatCommand("", "/townyadmin set", "surname [resident] [surname]", ""));
            this.sender.sendMessage(ChatTools.formatCommand("", "/townyadmin set", "plot [town]", ""));
            return;
        }
        if (split[0].equalsIgnoreCase("mayor")) {
            if (!townyUniverse.getPermissionSource().testPermission(this.player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_SET_MAYOR.getNode(split[0].toLowerCase()))) {
                throw new TownyException(Translation.of("msg_err_command_disable"));
            }
            if (split.length < 3) {
                this.sender.sendMessage(ChatTools.formatTitle("/townyadmin set mayor"));
                this.sender.sendMessage(ChatTools.formatCommand("Eg", "/townyadmin set mayor", "[town] " + Translation.of("town_help_2"), ""));
                this.sender.sendMessage(ChatTools.formatCommand("Eg", "/townyadmin set mayor", "[town] npc", ""));
            } else {
                try {
                    Resident newMayor;
                    Town town = townyUniverse.getTown(split[1]);
                    if (town == null) {
                        TownyMessaging.sendErrorMsg((Object)this.getSender(), Translation.of("msg_err_not_registered_1", split[1]));
                        return;
                    }
                    if (split[2].equalsIgnoreCase("npc")) {
                        String name = this.nextNpcName();
                        UUID npcUUID = UUID.randomUUID();
                        townyUniverse.getDataSource().newResident(name, npcUUID);
                        newMayor = townyUniverse.getResident(npcUUID);
                        newMayor.setRegistered(System.currentTimeMillis());
                        newMayor.setLastOnline(0L);
                        newMayor.setNPC(true);
                        newMayor.save();
                        town.setHasUpkeep(false);
                    } else {
                        newMayor = TownyAdminCommand.getResidentOrThrow(split[2]);
                    }
                    if (!town.hasResident(newMayor)) {
                        TownCommand.townAddResident(town, newMayor);
                    }
                    Resident oldMayor = town.getMayor();
                    town.setMayor(newMayor);
                    if (oldMayor.isNPC()) {
                        oldMayor.removeTown();
                        townyUniverse.getDataSource().removeResident(oldMayor);
                        town.setHasUpkeep(true);
                    }
                    town.save();
                    TownyMessaging.sendPrefixedTownMessage(town, Translation.of("msg_new_mayor", newMayor.getName()));
                }
                catch (TownyException e) {
                    TownyMessaging.sendErrorMsg((Object)this.getSender(), e.getMessage());
                }
            }
        } else if (split[0].equalsIgnoreCase("capital")) {
            if (!townyUniverse.getPermissionSource().testPermission(this.player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_SET_CAPITAL.getNode(split[0].toLowerCase()))) {
                throw new TownyException(Translation.of("msg_err_command_disable"));
            }
            if (split.length < 2) {
                this.sender.sendMessage(ChatTools.formatTitle("/townyadmin set capital"));
                this.sender.sendMessage(ChatTools.formatCommand("Eg", "/ta set capital", "[town name]", "[nation name]"));
            } else {
                Town newCapital = townyUniverse.getTown(split[1]);
                if (newCapital == null) {
                    TownyMessaging.sendErrorMsg((Object)this.player, Translation.of("msg_err_not_registered_1", split[1]));
                    return;
                }
                try {
                    Nation nation = newCapital.getNation();
                    NationCommand.nationSet(this.player, split, true, nation);
                }
                catch (Exception e) {
                    TownyMessaging.sendErrorMsg((Object)this.player, e.getMessage());
                }
            }
        } else if (split[0].equalsIgnoreCase("title")) {
            if (!townyUniverse.getPermissionSource().testPermission(this.player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_SET_TITLE.getNode(split[0].toLowerCase()))) {
                throw new TownyException(Translation.of("msg_err_command_disable"));
            }
            Resident resident = null;
            if (split.length < 2) {
                TownyMessaging.sendErrorMsg((Object)this.player, "Eg: /townyadmin set title bilbo Jester");
            } else {
                resident = TownyAdminCommand.getResidentOrThrow(split[1]);
            }
            split = StringMgmt.remArgs(split, 2);
            if (StringMgmt.join(split).length() > TownySettings.getMaxTitleLength()) {
                TownyMessaging.sendErrorMsg((Object)this.player, Translation.of("msg_err_input_too_long"));
                return;
            }
            String title = StringMgmt.join(NameValidation.checkAndFilterArray(split));
            resident.setTitle(title + " ");
            resident.save();
            if (resident.hasTitle()) {
                TownyMessaging.sendMessage((Object)this.sender, Translation.of("msg_set_title", resident.getName(), resident.getTitle()));
                TownyMessaging.sendMessage((Object)resident, Translation.of("msg_set_title", resident.getName(), resident.getTitle()));
            } else {
                TownyMessaging.sendMessage((Object)this.sender, Translation.of("msg_clear_title_surname", "Title", resident.getName()));
                TownyMessaging.sendMessage((Object)resident, Translation.of("msg_clear_title_surname", "Title", resident.getName()));
            }
        } else if (split[0].equalsIgnoreCase("surname")) {
            if (!townyUniverse.getPermissionSource().testPermission(this.player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_SET_SURNAME.getNode(split[0].toLowerCase()))) {
                throw new TownyException(Translation.of("msg_err_command_disable"));
            }
            Resident resident = null;
            if (split.length < 2) {
                TownyMessaging.sendErrorMsg((Object)this.player, "Eg: /townyadmin set surname bilbo Jester");
            } else {
                resident = TownyAdminCommand.getResidentOrThrow(split[1]);
            }
            split = StringMgmt.remArgs(split, 2);
            if (StringMgmt.join(split).length() > TownySettings.getMaxTitleLength()) {
                TownyMessaging.sendErrorMsg((Object)this.player, Translation.of("msg_err_input_too_long"));
                return;
            }
            String surname = StringMgmt.join(NameValidation.checkAndFilterArray(split));
            resident.setSurname(surname + " ");
            resident.save();
            if (resident.hasSurname()) {
                TownyMessaging.sendMessage((Object)this.sender, Translation.of("msg_set_surname", resident.getName(), resident.getSurname()));
                TownyMessaging.sendMessage((Object)resident, Translation.of("msg_set_surname", resident.getName(), resident.getSurname()));
            } else {
                TownyMessaging.sendMessage((Object)this.sender, Translation.of("msg_clear_title_surname", "Surname", resident.getName()));
                TownyMessaging.sendMessage((Object)resident, Translation.of("msg_clear_title_surname", "Surname", resident.getName()));
            }
        } else if (split[0].equalsIgnoreCase("plot")) {
            if (!townyUniverse.getPermissionSource().testPermission(this.player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_SET_PLOT.getNode(split[0].toLowerCase()))) {
                throw new TownyException(Translation.of("msg_err_command_disable"));
            }
            TownBlock tb = TownyAPI.getInstance().getTownBlock(this.player.getLocation());
            if (split.length < 2) {
                this.sender.sendMessage(ChatTools.formatTitle("/townyadmin set plot"));
                this.sender.sendMessage(ChatTools.formatCommand("Eg", "/ta set plot", "[town name]", Translation.of("msg_admin_set_plot_help_1")));
                this.sender.sendMessage(ChatTools.formatCommand("Eg", "/ta set plot", "[town name] {rect|circle} {radius}", Translation.of("msg_admin_set_plot_help_2")));
                this.sender.sendMessage(ChatTools.formatCommand("Eg", "/ta set plot", "[town name] {rect|circle} auto", Translation.of("msg_admin_set_plot_help_2")));
                return;
            }
            if (tb != null) {
                Town newTown = townyUniverse.getTown(split[1]);
                if (newTown != null) {
                    tb.setResident(null);
                    tb.setTown(newTown);
                    tb.setType(TownBlockType.RESIDENTIAL);
                    tb.setName("");
                    TownyMessaging.sendMessage((Object)this.player, Translation.of("changed_plot_town", newTown.getName()));
                } else {
                    TownyMessaging.sendErrorMsg((Object)this.player, Translation.of("msg_err_not_registered_1", split[1]));
                }
            } else {
                List<WorldCoord> selection;
                Town town = townyUniverse.getTown(split[1]);
                if (town == null) {
                    TownyMessaging.sendErrorMsg((Object)this.player, Translation.of("msg_err_not_registered_1", split[1]));
                    return;
                }
                TownyWorld world = townyUniverse.getDataSource().getWorld(this.player.getWorld().getName());
                Coord key = Coord.parseCoord(plugin.getCache(this.player).getLastLocation());
                if (split.length == 2) {
                    selection = AreaSelectionUtil.selectWorldCoordArea(town, new WorldCoord(world.getName(), key), new String[0]);
                } else {
                    String[] newSplit = StringMgmt.remFirstArg(split);
                    newSplit = StringMgmt.remFirstArg(newSplit);
                    selection = AreaSelectionUtil.selectWorldCoordArea(town, new WorldCoord(world.getName(), key), newSplit);
                }
                TownyMessaging.sendDebugMsg("Admin Initiated townClaim: Pre-Filter Selection [" + selection.size() + "] " + Arrays.toString(selection.toArray(new WorldCoord[0])));
                selection = AreaSelectionUtil.filterOutTownOwnedBlocks(selection);
                TownyMessaging.sendDebugMsg("Admin Initiated townClaim: Post-Filter Selection [" + selection.size() + "] " + Arrays.toString(selection.toArray(new WorldCoord[0])));
                new TownClaim(plugin, this.player, town, selection, false, true, false).start();
            }
        } else {
            TownyMessaging.sendErrorMsg((Object)this.getSender(), Translation.of("msg_err_invalid_property", "administrative"));
        }
    }

    public String nextNpcName() throws TownyException {
        int i = 0;
        do {
            String name = TownySettings.getNPCPrefix() + ++i;
            if (TownyUniverse.getInstance().hasResident(name)) continue;
            return name;
        } while (i <= 100000);
        throw new TownyException(Translation.of("msg_err_too_many_npc"));
    }

    public void reloadLangs() {
        String rootFolder = TownyUniverse.getInstance().getRootFolder();
        try {
            Translation.loadLanguage(rootFolder + File.separator + "settings", "english.yml");
        }
        catch (IOException e) {
            TownyMessaging.sendErrorMsg((Object)this.sender, Translation.of("msg_reload_error"));
            e.printStackTrace();
            return;
        }
        TownyMessaging.sendMsg(this.sender, Translation.of("msg_reloaded_lang"));
    }

    public void reloadPerms() {
        String rootFolder = TownyUniverse.getInstance().getRootFolder();
        try {
            TownyPerms.loadPerms(rootFolder + File.separator + "settings", "townyperms.yml");
        }
        catch (TownyException e) {
            plugin.setError(true);
            TownyMessaging.sendErrorMsg((Object)this.sender, "Error Loading townyperms.yml!");
            return;
        }
        if (plugin.isError()) {
            plugin.setError(false);
        }
        TownyPerms.updateOnlinePerms();
        TownyMessaging.sendMsg(this.sender, Translation.of("msg_reloaded_perms"));
    }

    public void reloadConfig(boolean reset) {
        if (reset) {
            TownyUniverse.getInstance().getDataSource().deleteFile(plugin.getConfigPath());
            TownyMessaging.sendMsg(this.sender, Translation.of("msg_reset_config"));
        }
        try {
            String rootFolder = TownyUniverse.getInstance().getRootFolder();
            TownySettings.loadConfig(rootFolder + File.separator + "settings" + File.separator + "config.yml", plugin.getVersion());
            TownySettings.loadTownLevelConfig();
            TownySettings.loadNationLevelConfig();
            Translation.loadLanguage(rootFolder + File.separator + "settings", "english.yml");
        }
        catch (IOException e) {
            TownyMessaging.sendErrorMsg((Object)this.sender, Translation.of("msg_reload_error"));
            e.printStackTrace();
            return;
        }
        TownyMessaging.sendMsg(this.sender, Translation.of("msg_reloaded_config"));
    }

    public void reloadDatabase() {
        TownyUniverse.getInstance().getDataSource().finishTasks();
        if (plugin.load()) {
            TownyPerms.registerPermissionNodes();
            TownyPerms.updateOnlinePerms();
        }
        TownyMessaging.sendMsg(this.sender, Translation.of("msg_reloaded_db"));
    }

    public void purge(String[] split) {
        if (split.length == 0) {
            this.sender.sendMessage(ChatTools.formatTitle("/townyadmin purge"));
            this.sender.sendMessage(ChatTools.formatCommand("", "/townyadmin purge", "[number of days] {townless}", ""));
            this.sender.sendMessage(ChatTools.formatCommand("", "", "Removes offline residents not seen for this duration.", ""));
            this.sender.sendMessage(ChatTools.formatCommand("", "", "Optional {townless} flag limits purge to only people that have no town.", ""));
            return;
        }
        String days = "";
        if (split.length == 2 && split[1].equalsIgnoreCase("townless")) {
            days = days + "townless";
        }
        try {
            days = days + String.valueOf(split[0]);
        }
        catch (NumberFormatException e) {
            TownyMessaging.sendErrorMsg((Object)this.getSender(), Translation.of("msg_error_must_be_int"));
            return;
        }
        if (!this.isConsole) {
            if (!TownyUniverse.getInstance().getPermissionSource().testPermission(this.player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_PURGE.getNode())) {
                try {
                    throw new TownyException(Translation.of("msg_err_admin_only"));
                }
                catch (TownyException e) {
                    TownyMessaging.sendErrorMsg((Object)this.player, e.getMessage());
                }
            }
            String finalDays = days;
            Runnable purgeHandler = () -> {
                int numDays;
                Player player = (Player)this.sender;
                if (player == null) {
                    try {
                        throw new TownyException("Player could not be found!");
                    }
                    catch (TownyException e) {
                        e.printStackTrace();
                    }
                }
                boolean townless = false;
                if (finalDays.startsWith("townless")) {
                    townless = true;
                    numDays = Integer.parseInt(finalDays.substring(8));
                } else {
                    numDays = Integer.parseInt(finalDays);
                }
                new ResidentPurge(plugin, (CommandSender)player, TimeTools.getMillis(numDays + "d"), townless).start();
            };
            if (this.sender != null) {
                Confirmation.runOnAccept(purgeHandler).sendTo(this.sender);
            }
        } else {
            String finalDays = days;
            Confirmation.runOnAccept(() -> {
                int numDays;
                boolean townless = false;
                if (finalDays.startsWith("townless")) {
                    townless = true;
                    numDays = Integer.parseInt(finalDays.substring(8));
                } else {
                    numDays = Integer.parseInt(finalDays);
                }
                new ResidentPurge(plugin, null, TimeTools.getMillis(numDays + "d"), townless).start();
            }).sendTo(this.sender);
        }
    }

    public void residentDelete(Player player, String[] split) {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (split.length == 0) {
            TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_invalid_name"));
        } else {
            try {
                if (!townyUniverse.getPermissionSource().isTownyAdmin(player)) {
                    throw new TownyException(Translation.of("msg_err_admin_only_delete"));
                }
                for (String name : split) {
                    Resident resident = townyUniverse.getResident(name);
                    if (resident != null) {
                        if (!resident.isNPC() && !BukkitTools.isOnline(resident.getName())) {
                            townyUniverse.getDataSource().removeResident(resident);
                            TownyMessaging.sendGlobalMessage(Translation.of("MSG_DEL_RESIDENT", resident.getName()));
                            continue;
                        }
                        TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_online_or_npc", name));
                        continue;
                    }
                    TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_invalid_name", name));
                }
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            }
        }
    }

    public void parseToggleCommand(String[] split) throws TownyException {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        Optional<Object> choice = Optional.empty();
        if (split.length == 2) {
            choice = BaseCommand.parseToggleChoice(split[1]);
        } else if (split.length == 3 && split[1].equalsIgnoreCase("npc")) {
            choice = BaseCommand.parseToggleChoice(split[2]);
        }
        if (split.length == 0) {
            this.player.sendMessage(ChatTools.formatTitle("/townyadmin toggle"));
            this.player.sendMessage(ChatTools.formatCommand("", "/townyadmin toggle", "war", ""));
            this.player.sendMessage(ChatTools.formatCommand("", "/townyadmin toggle", "peaceful", ""));
            this.player.sendMessage(ChatTools.formatCommand("", "/townyadmin toggle", "devmode", ""));
            this.player.sendMessage(ChatTools.formatCommand("", "/townyadmin toggle", "debug", ""));
            this.player.sendMessage(ChatTools.formatCommand("", "/townyadmin toggle", "townwithdraw/nationwithdraw", ""));
            this.player.sendMessage(ChatTools.formatCommand("", "/townyadmin toggle npc", "[resident]", ""));
            return;
        }
        if (!townyUniverse.getPermissionSource().testPermission(this.player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_TOGGLE.getNode(split[0].toLowerCase()))) {
            throw new TownyException(Translation.of("msg_err_command_disable"));
        }
        if (split[0].equalsIgnoreCase("war")) {
            if (!choice.orElse(TownyAPI.getInstance().isWarTime()).booleanValue()) {
                townyUniverse.startWarEvent();
                TownyMessaging.sendMsg(this.getSender(), Translation.of("msg_war_started"));
            } else {
                townyUniverse.endWarEvent();
                TownyMessaging.sendMsg(this.getSender(), Translation.of("msg_war_ended"));
            }
        } else if (split[0].equalsIgnoreCase("peaceful") || split[0].equalsIgnoreCase("neutral")) {
            try {
                TownySettings.setDeclaringNeutral((Boolean)choice.orElse(!TownySettings.isDeclaringNeutral()));
                TownyMessaging.sendMsg(this.getSender(), Translation.of("msg_nation_allow_peaceful", TownySettings.isDeclaringNeutral() ? Translation.of("enabled") : Translation.of("disabled")));
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg((Object)this.getSender(), Translation.of("msg_err_invalid_choice"));
            }
        } else if (split[0].equalsIgnoreCase("devmode")) {
            try {
                TownySettings.setDevMode((Boolean)choice.orElse(!TownySettings.isDevMode()));
                TownyMessaging.sendMsg(this.getSender(), "Dev Mode " + (TownySettings.isDevMode() ? "\u00a72" + Translation.of("enabled") : "\u00a74" + Translation.of("disabled")));
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg((Object)this.getSender(), Translation.of("msg_err_invalid_choice"));
            }
        } else if (split[0].equalsIgnoreCase("debug")) {
            try {
                TownySettings.setDebug((Boolean)choice.orElse(!TownySettings.getDebug()));
                TownyLogger.getInstance().refreshDebugLogger();
                TownyMessaging.sendMsg(this.getSender(), "Debug Mode " + (TownySettings.getDebug() ? "\u00a72" + Translation.of("enabled") : "\u00a74" + Translation.of("disabled")));
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg((Object)this.getSender(), Translation.of("msg_err_invalid_choice"));
            }
        } else if (split[0].equalsIgnoreCase("townwithdraw")) {
            try {
                TownySettings.SetTownBankAllowWithdrawls((Boolean)choice.orElse(!TownySettings.getTownBankAllowWithdrawls()));
                TownyMessaging.sendMsg(this.getSender(), "Town Withdrawls " + (TownySettings.getTownBankAllowWithdrawls() ? "\u00a72" + Translation.of("enabled") : "\u00a74" + Translation.of("disabled")));
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg((Object)this.getSender(), Translation.of("msg_err_invalid_choice"));
            }
        } else if (split[0].equalsIgnoreCase("nationwithdraw")) {
            try {
                TownySettings.SetNationBankAllowWithdrawls((Boolean)choice.orElse(!TownySettings.getNationBankAllowWithdrawls()));
                TownyMessaging.sendMsg(this.getSender(), "Nation Withdrawls " + (TownySettings.getNationBankAllowWithdrawls() ? "\u00a72" + Translation.of("enabled") : "\u00a74" + Translation.of("disabled")));
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg((Object)this.getSender(), Translation.of("msg_err_invalid_choice"));
            }
        } else if (split[0].equalsIgnoreCase("npc")) {
            if (split.length != 2) {
                throw new TownyException(Translation.of("msg_err_invalid_input", "Eg: toggle npc [resident]"));
            }
            Resident resident = townyUniverse.getResident(split[1]);
            if (resident == null) {
                throw new TownyException(Translation.of("msg_err_not_registered_1", split[1]));
            }
            resident.setNPC(!resident.isNPC());
            resident.save();
            TownyMessaging.sendMessage((Object)this.sender, Translation.of("msg_npc_flag", resident.isNPC(), resident.getName()));
        } else {
            TownyMessaging.sendErrorMsg((Object)this.getSender(), Translation.of("msg_err_invalid_choice"));
        }
    }

    public static void handleTownMetaCommand(Player player, Town town, String[] split) throws TownyException {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_TOWN_META.getNode())) {
            throw new TownyException(Translation.of("msg_err_command_disable"));
        }
        if (split.length == 2) {
            if (town.hasMeta()) {
                player.sendMessage(ChatTools.formatTitle("Custom Meta Data"));
                for (CustomDataField<?> field : town.getMetadata()) {
                    player.sendMessage(field.getKey() + " = " + field.getValue());
                }
            } else {
                TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_this_town_doesnt_have_any_associated_metadata"));
            }
            return;
        }
        if (split.length < 4) {
            player.sendMessage(ChatTools.formatTitle("/townyadmin town {townname} meta"));
            player.sendMessage(ChatTools.formatCommand("", "meta", "set", "The key of a registered data field"));
            player.sendMessage(ChatTools.formatCommand("", "meta", "add", "Add a key of a registered data field"));
            player.sendMessage(ChatTools.formatCommand("", "meta", "remove", "Remove a key from the town"));
            return;
        }
        String mdKey = split[3];
        if (split[2].equalsIgnoreCase("set")) {
            String val;
            String string = val = split.length == 5 ? split[4] : null;
            if (town.hasMeta() && town.hasMeta(mdKey)) {
                CustomDataField<?> cdf = town.getMetadata(mdKey);
                try {
                    if (val == null) {
                        throw new InvalidMetadataTypeException(cdf.getType());
                    }
                    cdf.isValidType(val);
                }
                catch (InvalidMetadataTypeException e) {
                    TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                    return;
                }
                cdf.setValueFromString(val);
                TownyMessaging.sendMsg((CommandSender)player, Translation.of("msg_key_x_was_successfully_updated_to_x", mdKey, cdf.getValue()));
                town.save();
            } else {
                TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_key_x_is_not_part_of_this_town", mdKey));
            }
        } else if (split[2].equalsIgnoreCase("add")) {
            if (!townyUniverse.getRegisteredMetadataMap().containsKey(mdKey)) {
                TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_the_metadata_for_key_is_not_registered", mdKey));
                return;
            }
            CustomDataField<?> md = townyUniverse.getRegisteredMetadataMap().get(mdKey);
            if (town.hasMeta() && town.hasMeta(md.getKey())) {
                TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_key_x_already_exists", mdKey));
                return;
            }
            TownyMessaging.sendMsg((CommandSender)player, Translation.of("msg_custom_data_was_successfully_added_to_town"));
            town.addMetaData((CustomDataField<?>)md.clone());
        } else if (split[2].equalsIgnoreCase("remove")) {
            if (town.hasMeta() && town.hasMeta(mdKey)) {
                CustomDataField<?> cdf = town.getMetadata(mdKey);
                town.removeMetaData(cdf);
                TownyMessaging.sendMsg((CommandSender)player, Translation.of("msg_data_successfully_deleted"));
                return;
            }
            TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_key_cannot_be_deleted"));
        }
    }

    public static boolean handlePlotMetaCommand(Player player, String[] split) throws TownyException {
        String world = player.getWorld().getName();
        TownBlock townBlock = null;
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        try {
            townBlock = new WorldCoord(world, Coord.parseCoord((Entity)player)).getTownBlock();
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
            return false;
        }
        if (!townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWNYADMIN_PLOT_META.getNode())) {
            throw new TownyException(Translation.of("msg_err_command_disable"));
        }
        if (split.length == 1) {
            if (townBlock.hasMeta()) {
                player.sendMessage(ChatTools.formatTitle("Custom Meta Data"));
                for (CustomDataField<?> field : townBlock.getMetadata()) {
                    player.sendMessage(field.getKey() + " = " + field.getValue());
                }
            } else {
                TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_this_plot_doesnt_have_any_associated_metadata"));
            }
            return true;
        }
        if (split.length < 3) {
            player.sendMessage(ChatTools.formatTitle("/townyadmin plot meta"));
            player.sendMessage(ChatTools.formatCommand("", "meta", "set", "The key of a registered data field"));
            player.sendMessage(ChatTools.formatCommand("", "meta", "add", "Add a key of a registered data field"));
            player.sendMessage(ChatTools.formatCommand("", "meta", "remove", "Remove a key from the town"));
            return false;
        }
        String mdKey = split[2];
        if (split[1].equalsIgnoreCase("set")) {
            String val;
            String string = val = split.length == 4 ? split[3] : null;
            if (townBlock.hasMeta() && townBlock.hasMeta(mdKey)) {
                CustomDataField<?> cdf = townBlock.getMetadata(mdKey);
                try {
                    if (val == null) {
                        throw new InvalidMetadataTypeException(cdf.getType());
                    }
                    cdf.isValidType(val);
                }
                catch (InvalidMetadataTypeException e) {
                    TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                    return false;
                }
                cdf.setValueFromString(val);
                TownyMessaging.sendMsg((CommandSender)player, Translation.of("msg_key_x_was_successfully_updated_to_x", mdKey, cdf.getValue()));
                townBlock.save();
                return true;
            }
            TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_key_x_is_not_part_of_this_plot", mdKey));
            return false;
        }
        if (split[1].equalsIgnoreCase("add")) {
            if (!townyUniverse.getRegisteredMetadataMap().containsKey(mdKey)) {
                TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_the_metadata_for_key_is_not_registered", mdKey));
                return false;
            }
            CustomDataField<?> md = townyUniverse.getRegisteredMetadataMap().get(mdKey);
            if (townBlock.hasMeta() && townBlock.hasMeta(md.getKey())) {
                TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_key_x_already_exists", mdKey));
                return false;
            }
            TownyMessaging.sendMsg((CommandSender)player, Translation.of("msg_custom_data_was_successfully_added_to_townblock"));
            townBlock.addMetaData((CustomDataField<?>)md.clone());
        } else if (split[1].equalsIgnoreCase("remove")) {
            if (townBlock.hasMeta() && townBlock.hasMeta(mdKey)) {
                CustomDataField<?> cdf = townBlock.getMetadata(mdKey);
                townBlock.removeMetaData(cdf);
                TownyMessaging.sendMsg((CommandSender)player, Translation.of("msg_data_successfully_deleted"));
                return true;
            }
            TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_key_cannot_be_deleted"));
            return false;
        }
        return true;
    }

    private void showReloadHelp() {
        this.sender.sendMessage(ChatTools.formatTitle("/ta reload"));
        this.sender.sendMessage(ChatTools.formatCommand("", "/ta reload", "database", "Reloads database"));
        this.sender.sendMessage(ChatTools.formatCommand("", "/ta reload", "config", "Reloads config"));
        this.sender.sendMessage(ChatTools.formatCommand("", "/ta reload", "lang", "Reloads language file."));
        this.sender.sendMessage(ChatTools.formatCommand("", "/ta reload", "perms", "Reloads Towny permissions."));
        this.sender.sendMessage(ChatTools.formatCommand("", "/ta reload", "all", "Reloads all components of towny."));
    }

    private void parseAdminDepositAllCommand(String[] split) {
        if (split.length == 0) {
            this.showDepositAllHelp();
        } else if (split.length > 1) {
            this.showDepositAllHelp();
        } else if (split.length == 1) {
            String reason = "townyadmin depositall";
            double amount = 0.0;
            try {
                amount = Double.parseDouble(split[0]);
            }
            catch (NumberFormatException e) {
                TownyMessaging.sendErrorMsg((Object)this.sender, Translation.of("msg_error_must_be_num"));
                return;
            }
            for (Nation nation : TownyUniverse.getInstance().getNations()) {
                try {
                    nation.getAccount().deposit(amount, reason);
                }
                catch (EconomyException economyException) {}
            }
            for (Town town : TownyUniverse.getInstance().getTowns()) {
                try {
                    town.getAccount().deposit(amount, reason);
                }
                catch (EconomyException economyException) {}
            }
            TownyMessaging.sendMsg(this.sender, Translation.of("msg_ta_deposit_all_success", TownyEconomyHandler.getFormattedBalance(amount)));
        }
    }

    private void showDepositAllHelp() {
        this.sender.sendMessage(ChatTools.formatTitle("/townyadmin depositall"));
        this.sender.sendMessage(ChatTools.formatCommand("", "/townyadmin depositall", "[amount]", ""));
    }

    static {
        ta_panel = new ArrayList<String>();
        adminTabCompletes = Arrays.asList("delete", "plot", "resident", "town", "nation", "reset", "toggle", "set", "givebonus", "reload", "backup", "checkperm", "newday", "newhour", "unclaim", "purge", "mysqldump", "tpplot", "database", "depositall");
        adminTownTabCompletes = Arrays.asList("new", "add", "remove", "kick", "rename", "spawn", "tpplot", "outpost", "delete", "rank", "toggle", "set", "meta", "deposit", "withdraw", "bankhistory", "outlaw", "leavenation", "invite");
        adminNationTabCompletes = Arrays.asList("add", "kick", "rename", "delete", "toggle", "set", "meta", "deposit", "withdraw", "bankhistory");
        adminToggleTabCompletes = Arrays.asList("war", "neutral", "npc", "debug", "devmode", "townwithdraw", "nationwithdraw");
        adminPlotTabCompletes = Arrays.asList("claim", "meta");
        adminMetaTabCompletes = Arrays.asList("set", "add", "remove");
        adminDatabaseTabCompletes = Arrays.asList("save", "load");
        adminResidentTabCompletes = Arrays.asList("rename", "friend", "unjail");
        adminResidentFriendTabCompletes = Arrays.asList("add", "remove", "list", "clear");
        adminSetCompletes = Arrays.asList("mayor", "capital", "title", "surname", "plot");
    }
}

