/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.command.BaseCommand;
import com.palmergames.bukkit.towny.command.HelpMenu;
import com.palmergames.bukkit.towny.event.TownBlockSettingsChangedEvent;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.permissions.TownyPermissionSource;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.utils.NameUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class TownyWorldCommand
extends BaseCommand
implements CommandExecutor {
    private static Towny plugin;
    private static TownyWorld Globalworld;
    private static final List<String> townyWorldTabCompletes;
    private static final List<String> townyWorldToggleTabCompletes;
    private static List<String> townySetTabCompletes;
    private boolean isConsole = false;

    public TownyWorldCommand(Towny instance) {
        plugin = instance;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (sender instanceof Player) {
            if (plugin.isError()) {
                sender.sendMessage("\u00a7c[Towny Error] Locked in Safe mode!");
                return false;
            }
            this.parseWorldCommand(sender, args);
        } else {
            this.isConsole = true;
            this.parseWorldFromConsole(sender, args);
        }
        Globalworld = null;
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        switch (args[0].toLowerCase()) {
            case "toggle": {
                if (args.length == 2) {
                    return NameUtil.filterByStart(townyWorldToggleTabCompletes, args[1]);
                }
                if (args.length != 3) break;
                return NameUtil.filterByStart(BaseCommand.setOnOffCompletes, args[2]);
            }
            case "set": {
                if (args.length != 2) break;
                return NameUtil.filterByStart(townySetTabCompletes, args[1]);
            }
            default: {
                if (args.length != 1) break;
                return TownyWorldCommand.filterByStartOrGetTownyStartingWith(townyWorldTabCompletes, args[0], "+w");
            }
        }
        return Collections.emptyList();
    }

    private void parseWorldFromConsole(CommandSender sender, String[] split) {
        Player player = null;
        if (split.length == 0 || split[0].equalsIgnoreCase("?") || split[0].equalsIgnoreCase("help")) {
            HelpMenu.TOWNYWORLD_HELP_CONSOLE.send(sender);
            return;
        }
        if (split[0].equalsIgnoreCase("list")) {
            this.listWorlds(player, sender);
            return;
        }
        if (split[0].equalsIgnoreCase("set")) {
            HelpMenu.TOWNYWORLD_SET_CONSOLE.send(sender);
        } else if (split[0].equalsIgnoreCase("regen") || split[0].equalsIgnoreCase("undo") || split[0].equalsIgnoreCase("toggle")) {
            HelpMenu.TOWNYWORLD_HELP_CONSOLE.send(sender);
        } else {
            try {
                Globalworld = TownyUniverse.getInstance().getDataSource().getWorld(split[0].toLowerCase());
            }
            catch (NotRegisteredException e) {
                TownyMessaging.sendErrorMsg((Object)sender, Translation.of("msg_area_not_recog"));
                return;
            }
            split = StringMgmt.remFirstArg(split);
            this.parseWorldCommand(sender, split);
        }
    }

    public void parseWorldCommand(CommandSender sender, String[] split) {
        TownyPermissionSource permSource = TownyUniverse.getInstance().getPermissionSource();
        Player player = null;
        if (sender instanceof Player) {
            player = (Player)sender;
            try {
                if (Globalworld == null) {
                    Globalworld = TownyUniverse.getInstance().getDataSource().getWorld(player.getWorld().getName());
                }
            }
            catch (NotRegisteredException e) {
                TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_area_not_recog"));
                return;
            }
        }
        if (split.length == 0) {
            if (player == null) {
                for (String line : TownyFormatter.getStatus(Globalworld)) {
                    sender.sendMessage(Colors.strip(line));
                }
            } else {
                TownyMessaging.sendMessage((Object)player, TownyFormatter.getStatus(Globalworld));
            }
            return;
        }
        try {
            if (split[0].equalsIgnoreCase("?")) {
                HelpMenu.TOWNYWORLD_HELP.send(sender);
            } else if (split[0].equalsIgnoreCase("list")) {
                if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_LIST.getNode())) {
                    throw new TownyException(Translation.of("msg_err_command_disable"));
                }
                this.listWorlds(player, sender);
            } else if (split[0].equalsIgnoreCase("set")) {
                if (!permSource.testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_SET.getNode())) {
                    throw new TownyException(Translation.of("msg_err_command_disable"));
                }
                this.worldSet(player, sender, StringMgmt.remFirstArg(split));
            } else if (split[0].equalsIgnoreCase("toggle")) {
                this.worldToggle(player, sender, StringMgmt.remFirstArg(split));
            } else if (split[0].equalsIgnoreCase("regen")) {
                TownyMessaging.sendErrorMsg((Object)player, "This command has been removed for 1.13 compatibility, look for its return in the future.");
            }
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
        }
    }

    public void listWorlds(Player player, CommandSender sender) {
        if (player == null) {
            sender.sendMessage(ChatTools.formatTitle(Translation.of("world_plu")));
        } else {
            player.sendMessage(ChatTools.formatTitle(Translation.of("world_plu")));
        }
        ArrayList<String> formatedList = new ArrayList<String>();
        HashMap<String, Integer> playersPerWorld = BukkitTools.getPlayersPerWorld();
        for (TownyWorld world : TownyUniverse.getInstance().getDataSource().getWorlds()) {
            int numPlayers = playersPerWorld.getOrDefault(world.getName(), 0);
            formatedList.add("\u00a7b" + world.getName() + "\u00a73" + " [" + numPlayers + "]" + "\u00a7f");
        }
        if (player == null) {
            for (String line : ChatTools.list(formatedList)) {
                sender.sendMessage(line);
            }
        } else {
            for (String line : ChatTools.list(formatedList)) {
                player.sendMessage(line);
            }
        }
    }

    public void worldToggle(Player player, CommandSender sender, String[] split) throws TownyException {
        if (split.length == 0) {
            if (!this.isConsole) {
                player.sendMessage(ChatTools.formatTitle("/TownyWorld toggle"));
                player.sendMessage(ChatTools.formatCommand("", "/TownyWorld toggle", "claimable", ""));
                player.sendMessage(ChatTools.formatCommand("", "/TownyWorld toggle", "usingtowny", ""));
                sender.sendMessage(ChatTools.formatCommand("", "/TownyWorld toggle", "warallowed", ""));
                player.sendMessage(ChatTools.formatCommand("", "/TownyWorld toggle", "pvp/forcepvp", ""));
                player.sendMessage(ChatTools.formatCommand("", "/TownyWorld toggle", "friendlyfire", ""));
                player.sendMessage(ChatTools.formatCommand("", "/TownyWorld toggle", "explosion/forceexplosion", ""));
                player.sendMessage(ChatTools.formatCommand("", "/TownyWorld toggle", "fire/forcefire", ""));
                player.sendMessage(ChatTools.formatCommand("", "/TownyWorld toggle", "townmobs/wildernessmobs/worldmobs", ""));
                player.sendMessage(ChatTools.formatCommand("", "/TownyWorld toggle", "revertunclaim", ""));
                player.sendMessage(ChatTools.formatCommand("", "/TownyWorld toggle", "revertentityexpl/revertblockexpl", ""));
                player.sendMessage(ChatTools.formatCommand("", "/TownyWorld toggle", "plotcleardelete", ""));
            } else {
                sender.sendMessage(ChatTools.formatTitle("/TownyWorld toggle"));
                sender.sendMessage(ChatTools.formatCommand("", "/TownyWorld {world} toggle", "claimable", ""));
                sender.sendMessage(ChatTools.formatCommand("", "/TownyWorld {world} toggle", "usingtowny", ""));
                sender.sendMessage(ChatTools.formatCommand("", "/TownyWorld {world} toggle", "warallowed", ""));
                sender.sendMessage(ChatTools.formatCommand("", "/TownyWorld {world} toggle", "pvp/forcepvp", ""));
                sender.sendMessage(ChatTools.formatCommand("", "/TownyWorld {world} toggle", "friendlyfire", ""));
                sender.sendMessage(ChatTools.formatCommand("", "/TownyWorld {world} toggle", "explosion/forceexplosion", ""));
                sender.sendMessage(ChatTools.formatCommand("", "/TownyWorld {world} toggle", "fire/forcefire", ""));
                sender.sendMessage(ChatTools.formatCommand("", "/TownyWorld {world} toggle", "townmobs/worldmobs", ""));
                sender.sendMessage(ChatTools.formatCommand("", "/TownyWorld {world} toggle", "revertunclaim", ""));
                sender.sendMessage(ChatTools.formatCommand("", "/TownyWorld {world} toggle", "revertentityexpl/revertblockexpl", ""));
                sender.sendMessage(ChatTools.formatCommand("", "/TownyWorld {world} toggle", "plotcleardelete", ""));
            }
        } else {
            if (!TownyUniverse.getInstance().getPermissionSource().testPermission(player, PermissionNodes.TOWNY_COMMAND_TOWNYWORLD_TOGGLE.getNode(split[0].toLowerCase()))) {
                throw new TownyException(Translation.of("msg_err_command_disable"));
            }
            Optional<Object> choice = Optional.empty();
            if (split.length == 2) {
                choice = BaseCommand.parseToggleChoice(split[1]);
            }
            if (split[0].equalsIgnoreCase("claimable")) {
                Globalworld.setClaimable(choice.orElse(!Globalworld.isClaimable()));
                String msg = Translation.of("msg_set_claim", Globalworld.getName(), Globalworld.isClaimable() ? Translation.of("enabled") : Translation.of("disabled"));
                if (player != null) {
                    TownyMessaging.sendMsg((CommandSender)player, msg);
                } else {
                    TownyMessaging.sendMsg(msg);
                }
            } else if (split[0].equalsIgnoreCase("usingtowny")) {
                Globalworld.setUsingTowny((Boolean)choice.orElse(!Globalworld.isUsingTowny()));
                plugin.resetCache();
                String msg = String.format(Globalworld.isUsingTowny() ? Translation.of("msg_set_use_towny_on") : Translation.of("msg_set_use_towny_off"), new Object[0]);
                if (player != null) {
                    TownyMessaging.sendMsg((CommandSender)player, msg);
                } else {
                    TownyMessaging.sendMsg(msg);
                }
            } else if (split[0].equalsIgnoreCase("warallowed")) {
                Globalworld.setWarAllowed((Boolean)choice.orElse(!Globalworld.isWarAllowed()));
                plugin.resetCache();
                String msg = String.format(Globalworld.isWarAllowed() ? Translation.of("msg_set_war_allowed_on") : Translation.of("msg_set_war_allowed_off"), new Object[0]);
                if (player != null) {
                    TownyMessaging.sendMsg((CommandSender)player, msg);
                } else {
                    TownyMessaging.sendMsg(msg);
                }
            } else if (split[0].equalsIgnoreCase("pvp")) {
                Globalworld.setPVP((Boolean)choice.orElse(!Globalworld.isPVP()));
                String msg = Translation.of("msg_changed_world_setting", "Global PVP", Globalworld.getName(), Globalworld.isPVP() ? Translation.of("enabled") : Translation.of("disabled"));
                if (player != null) {
                    TownyMessaging.sendMsg((CommandSender)player, msg);
                } else {
                    TownyMessaging.sendMsg(msg);
                }
            } else if (split[0].equalsIgnoreCase("forcepvp")) {
                Globalworld.setForcePVP((Boolean)choice.orElse(!Globalworld.isForcePVP()));
                String msg = Translation.of("msg_changed_world_setting", "Force town PVP", Globalworld.getName(), Globalworld.isForcePVP() ? Translation.of("forced") : Translation.of("adjustable"));
                if (player != null) {
                    TownyMessaging.sendMsg((CommandSender)player, msg);
                } else {
                    TownyMessaging.sendMsg(msg);
                }
            } else if (split[0].equalsIgnoreCase("friendlyfire")) {
                Globalworld.setFriendlyFire((Boolean)choice.orElse(!Globalworld.isFriendlyFireEnabled()));
                String msg = Translation.of("msg_changed_world_setting", "Friendly Fire", Globalworld.getName(), Globalworld.isFriendlyFireEnabled() ? Translation.of("enabled") : Translation.of("disabled"));
                if (player != null) {
                    TownyMessaging.sendMsg((CommandSender)player, msg);
                } else {
                    TownyMessaging.sendMsg(msg);
                }
            } else if (split[0].equalsIgnoreCase("explosion")) {
                Globalworld.setExpl((Boolean)choice.orElse(!Globalworld.isExpl()));
                String msg = Translation.of("msg_changed_world_setting", "Explosions", Globalworld.getName(), Globalworld.isExpl() ? Translation.of("enabled") : Translation.of("disabled"));
                if (player != null) {
                    TownyMessaging.sendMsg((CommandSender)player, msg);
                } else {
                    TownyMessaging.sendMsg(msg);
                }
            } else if (split[0].equalsIgnoreCase("forceexplosion")) {
                Globalworld.setForceExpl((Boolean)choice.orElse(!Globalworld.isForceExpl()));
                String msg = Translation.of("msg_changed_world_setting", "Force town Explosions", Globalworld.getName(), Globalworld.isForceExpl() ? Translation.of("forced") : Translation.of("adjustable"));
                if (player != null) {
                    TownyMessaging.sendMsg((CommandSender)player, msg);
                } else {
                    TownyMessaging.sendMsg(msg);
                }
            } else if (split[0].equalsIgnoreCase("fire")) {
                Globalworld.setFire((Boolean)choice.orElse(!Globalworld.isFire()));
                String msg = Translation.of("msg_changed_world_setting", "Fire Spread", Globalworld.getName(), Globalworld.isFire() ? Translation.of("enabled") : Translation.of("disabled"));
                if (player != null) {
                    TownyMessaging.sendMsg((CommandSender)player, msg);
                } else {
                    TownyMessaging.sendMsg(msg);
                }
            } else if (split[0].equalsIgnoreCase("forcefire")) {
                Globalworld.setForceFire((Boolean)choice.orElse(!Globalworld.isForceFire()));
                String msg = Translation.of("msg_changed_world_setting", "Force town Fire Spread", Globalworld.getName(), Globalworld.isForceFire() ? Translation.of("forced") : Translation.of("adjustable"));
                if (player != null) {
                    TownyMessaging.sendMsg((CommandSender)player, msg);
                } else {
                    TownyMessaging.sendMsg(msg);
                }
            } else if (split[0].equalsIgnoreCase("townmobs")) {
                Globalworld.setForceTownMobs((Boolean)choice.orElse(!Globalworld.isForceTownMobs()));
                String msg = Translation.of("msg_changed_world_setting", "Town Mob spawns", Globalworld.getName(), Globalworld.isForceTownMobs() ? Translation.of("forced") : Translation.of("adjustable"));
                if (player != null) {
                    TownyMessaging.sendMsg((CommandSender)player, msg);
                } else {
                    TownyMessaging.sendMsg(msg);
                }
            } else if (split[0].equalsIgnoreCase("worldmobs")) {
                Globalworld.setWorldMobs((Boolean)choice.orElse(!Globalworld.hasWorldMobs()));
                String msg = Translation.of("msg_changed_world_setting", "World Mob spawns", Globalworld.getName(), Globalworld.hasWorldMobs() ? Translation.of("enabled") : Translation.of("disabled"));
                if (player != null) {
                    TownyMessaging.sendMsg((CommandSender)player, msg);
                } else {
                    TownyMessaging.sendMsg(msg);
                }
            } else if (split[0].equalsIgnoreCase("wildernessmobs")) {
                Globalworld.setWildernessMobs((Boolean)choice.orElse(!Globalworld.hasWildernessMobs()));
                String msg = Translation.of("msg_changed_world_setting", "Wilderness Mob spawns", Globalworld.getName(), Globalworld.hasWildernessMobs() ? Translation.of("enabled") : Translation.of("disabled"));
                if (player != null) {
                    TownyMessaging.sendMsg((CommandSender)player, msg);
                } else {
                    TownyMessaging.sendMsg(msg);
                }
            } else if (split[0].equalsIgnoreCase("revertunclaim")) {
                Globalworld.setUsingPlotManagementRevert((Boolean)choice.orElse(!Globalworld.isUsingPlotManagementRevert()));
                if (!Globalworld.isUsingPlotManagementRevert()) {
                    TownyRegenAPI.removeWorldCoords(Globalworld);
                    TownyRegenAPI.removePlotChunksForWorld(Globalworld, true);
                }
                String msg = Translation.of("msg_changed_world_setting", "Unclaim Revert", Globalworld.getName(), Globalworld.isUsingPlotManagementRevert() ? Translation.of("enabled") : Translation.of("disabled"));
                if (player != null) {
                    TownyMessaging.sendMsg((CommandSender)player, msg);
                } else {
                    TownyMessaging.sendMsg(msg);
                }
            } else if (split[0].equalsIgnoreCase("revertentityexpl")) {
                Globalworld.setUsingPlotManagementWildEntityRevert((Boolean)choice.orElse(!Globalworld.isUsingPlotManagementWildEntityRevert()));
                String msg = Translation.of("msg_changed_world_setting", "Wilderness Entity Explosion Revert", Globalworld.getName(), Globalworld.isUsingPlotManagementWildEntityRevert() ? Translation.of("enabled") : Translation.of("disabled"));
                if (player != null) {
                    TownyMessaging.sendMsg((CommandSender)player, msg);
                } else {
                    TownyMessaging.sendMsg(msg);
                }
            } else if (split[0].equalsIgnoreCase("revertblockexpl")) {
                Globalworld.setUsingPlotManagementWildBlockRevert((Boolean)choice.orElse(!Globalworld.isUsingPlotManagementWildBlockRevert()));
                String msg = Translation.of("msg_changed_world_setting", "Wilderness Block Explosion Revert", Globalworld.getName(), Globalworld.isUsingPlotManagementWildBlockRevert() ? Translation.of("enabled") : Translation.of("disabled"));
                if (player != null) {
                    TownyMessaging.sendMsg((CommandSender)player, msg);
                } else {
                    TownyMessaging.sendMsg(msg);
                }
            } else if (split[0].equalsIgnoreCase("plotcleardelete")) {
                Globalworld.setUsingPlotManagementMayorDelete((Boolean)choice.orElse(!Globalworld.isUsingPlotManagementWildBlockRevert()));
                String msg = Translation.of("msg_changed_world_setting", "Plot Clear Delete", Globalworld.getName(), Globalworld.isUsingPlotManagementMayorDelete() ? Translation.of("enabled") : Translation.of("disabled"));
                if (player != null) {
                    TownyMessaging.sendMsg((CommandSender)player, msg);
                } else {
                    TownyMessaging.sendMsg(msg);
                }
            } else {
                String msg = Translation.of("msg_err_invalid_property", "'" + split[0] + "'");
                if (player != null) {
                    TownyMessaging.sendErrorMsg((Object)player, msg);
                } else {
                    TownyMessaging.sendErrorMsg(msg);
                }
                return;
            }
            Globalworld.save();
            TownBlockSettingsChangedEvent event = new TownBlockSettingsChangedEvent(Globalworld);
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
        }
    }

    public void worldSet(Player player, CommandSender sender, String[] split) {
        if (split.length == 0) {
            HelpMenu.TOWNYWORLD_SET.send(sender);
        } else {
            block43: {
                if (split[0].equalsIgnoreCase("usedefault")) {
                    Globalworld.setUsingDefault();
                    plugin.resetCache();
                    if (player != null) {
                        TownyMessaging.sendMsg((CommandSender)player, Translation.of("msg_usedefault", Globalworld.getName()));
                    } else {
                        sender.sendMessage(Translation.of("msg_usedefault", Globalworld.getName()));
                    }
                } else if (split[0].equalsIgnoreCase("wildperm")) {
                    if (split.length < 2) {
                        Globalworld.setUsingDefault();
                        if (player != null) {
                            TownyMessaging.sendMsg((CommandSender)player, Translation.of("msg_usedefault", Globalworld.getName()));
                        } else {
                            sender.sendMessage(Translation.of("msg_usedefault", Globalworld.getName()));
                        }
                    } else {
                        try {
                            List<String> perms = Arrays.asList(StringMgmt.remFirstArg(split));
                            Globalworld.setUnclaimedZoneBuild(perms.contains("build"));
                            Globalworld.setUnclaimedZoneDestroy(perms.contains("destroy"));
                            Globalworld.setUnclaimedZoneSwitch(perms.contains("switch"));
                            Globalworld.setUnclaimedZoneItemUse(perms.contains("itemuse"));
                            plugin.resetCache();
                            if (player != null) {
                                TownyMessaging.sendMsg((CommandSender)player, Translation.of("msg_set_wild_perms", Globalworld.getName(), perms.toString()));
                                break block43;
                            }
                            sender.sendMessage(Translation.of("msg_set_wild_perms", Globalworld.getName(), perms.toString()));
                        }
                        catch (Exception e) {
                            if (player != null) {
                                TownyMessaging.sendErrorMsg((Object)player, "Eg: /townyworld set wildperm build destroy");
                                break block43;
                            }
                            sender.sendMessage("Eg: /townyworld set wildperm build destroy <world>");
                        }
                    }
                } else if (split[0].equalsIgnoreCase("wildignore")) {
                    if (split.length < 2) {
                        if (player != null) {
                            TownyMessaging.sendErrorMsg((Object)player, "Eg: /townyworld set wildignore SAPLING,GOLD_ORE,IRON_ORE");
                        } else {
                            sender.sendMessage("Eg: /townyworld set wildignore SAPLING,GOLD_ORE,IRON_ORE <world>");
                        }
                    } else {
                        try {
                            ArrayList<String> mats = new ArrayList<String>();
                            for (String s : StringMgmt.remFirstArg(split)) {
                                mats.add(Material.matchMaterial((String)s.trim().toUpperCase()).name());
                            }
                            Globalworld.setUnclaimedZoneIgnore(mats);
                            plugin.resetCache();
                            if (player != null) {
                                TownyMessaging.sendMsg((CommandSender)player, Translation.of("msg_set_wild_ignore", Globalworld.getName(), Globalworld.getUnclaimedZoneIgnoreMaterials()));
                                break block43;
                            }
                            sender.sendMessage(Translation.of("msg_set_wild_ignore", Globalworld.getName(), Globalworld.getUnclaimedZoneIgnoreMaterials()));
                        }
                        catch (Exception e) {
                            TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_invalid_input", " on/off."));
                        }
                    }
                } else if (split[0].equalsIgnoreCase("wildregen")) {
                    if (split.length < 2) {
                        if (player != null) {
                            TownyMessaging.sendErrorMsg((Object)player, "Eg: /townyworld set wildregen Creeper,EnderCrystal,EnderDragon,Fireball,SmallFireball,LargeFireball,TNTPrimed,ExplosiveMinecart");
                        } else {
                            sender.sendMessage("Eg: /townyworld set wildregen Creeper,EnderCrystal,EnderDragon,Fireball,SmallFireball,LargeFireball,TNTPrimed,ExplosiveMinecart <world>");
                        }
                    } else {
                        ArrayList<String> entities = new ArrayList<String>(Arrays.asList(StringMgmt.remFirstArg(split)));
                        Globalworld.setPlotManagementWildRevertEntities(entities);
                        if (player != null) {
                            TownyMessaging.sendMsg((CommandSender)player, Translation.of("msg_set_wild_regen", Globalworld.getName(), Globalworld.getPlotManagementWildRevertEntities()));
                        } else {
                            sender.sendMessage(Translation.of("msg_set_wild_regen", Globalworld.getName(), Globalworld.getPlotManagementWildRevertEntities()));
                        }
                    }
                } else if (split[0].equalsIgnoreCase("wildname")) {
                    if (split.length < 2) {
                        if (player != null) {
                            TownyMessaging.sendErrorMsg((Object)player, "Eg: /townyworld set wildname Wildy");
                        }
                    } else {
                        try {
                            Globalworld.setUnclaimedZoneName(split[1]);
                            if (player != null) {
                                TownyMessaging.sendMsg((CommandSender)player, Translation.of("msg_set_wild_name", Globalworld.getName(), split[1]));
                                break block43;
                            }
                            sender.sendMessage(Translation.of("msg_set_wild_name", Globalworld.getName(), split[1]));
                        }
                        catch (Exception e) {
                            TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_invalid_input", " on/off."));
                        }
                    }
                } else {
                    if (player != null) {
                        TownyMessaging.sendErrorMsg((Object)player, Translation.of("msg_err_invalid_property", "world"));
                    }
                    return;
                }
            }
            Globalworld.save();
        }
    }

    static {
        townyWorldTabCompletes = Arrays.asList("list", "toggle", "set", "regen", "undo");
        townyWorldToggleTabCompletes = Arrays.asList("claimable", "usingtowny", "pvp", "forcepvp", "explosion", "forceexplosion", "friendlyfire", "fire", "forcefire", "townmobs", "worldmobs", "wildernessmobs", "revertunclaim", "revertentityexpl", "revertblockexpl", "warallowed", "plotcleardelete");
        townySetTabCompletes = Arrays.asList("usedefault", "wildperm", "wildignore", "wildregen", "wildname");
    }
}

