/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.db;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.db.FlatFileSaveTask;
import com.palmergames.bukkit.towny.db.TownyDatabaseHandler;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.EmptyNationException;
import com.palmergames.bukkit.towny.exceptions.InvalidNameException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.PlotGroup;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.metadata.CustomDataField;
import com.palmergames.bukkit.towny.tasks.DeleteFileTask;
import com.palmergames.bukkit.towny.utils.MapUtil;
import com.palmergames.util.FileMgmt;
import com.palmergames.util.StringMgmt;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.StringJoiner;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;

public final class TownyFlatFileSource
extends TownyDatabaseHandler {
    private final String newLine = System.getProperty("line.separator");

    public TownyFlatFileSource(Towny plugin, TownyUniverse universe) {
        super(plugin, universe);
        if (!FileMgmt.checkOrCreateFolders(this.rootFolderPath, this.dataFolderPath, this.dataFolderPath + File.separator + "residents", this.dataFolderPath + File.separator + "residents" + File.separator + "deleted", this.dataFolderPath + File.separator + "towns", this.dataFolderPath + File.separator + "towns" + File.separator + "deleted", this.dataFolderPath + File.separator + "nations", this.dataFolderPath + File.separator + "nations" + File.separator + "deleted", this.dataFolderPath + File.separator + "worlds", this.dataFolderPath + File.separator + "worlds" + File.separator + "deleted", this.dataFolderPath + File.separator + "townblocks", this.dataFolderPath + File.separator + "plotgroups") || !FileMgmt.checkOrCreateFiles(this.dataFolderPath + File.separator + "worlds.txt", this.dataFolderPath + File.separator + "plotgroups.txt")) {
            TownyMessaging.sendErrorMsg("Could not create flatfile default files and folders.");
        }
    }

    public String getResidentFilename(Resident resident) {
        return this.dataFolderPath + File.separator + "residents" + File.separator + resident.getName() + ".txt";
    }

    public String getTownFilename(Town town) {
        return this.dataFolderPath + File.separator + "towns" + File.separator + town.getName() + ".txt";
    }

    public String getNationFilename(Nation nation) {
        return this.dataFolderPath + File.separator + "nations" + File.separator + nation.getName() + ".txt";
    }

    public String getWorldFilename(TownyWorld world) {
        return this.dataFolderPath + File.separator + "worlds" + File.separator + world.getName() + ".txt";
    }

    public String getTownBlockFilename(TownBlock townBlock) {
        return this.dataFolderPath + File.separator + "townblocks" + File.separator + townBlock.getWorld().getName() + File.separator + townBlock.getX() + "_" + townBlock.getZ() + "_" + TownySettings.getTownBlockSize() + ".data";
    }

    public String getPlotGroupFilename(PlotGroup group) {
        return this.dataFolderPath + File.separator + "plotgroups" + File.separator + group.getID() + ".data";
    }

    @Override
    public boolean loadTownBlockList() {
        TownyMessaging.sendDebugMsg("Loading TownBlock List");
        File townblocksFolder = new File(this.dataFolderPath + File.separator + "townblocks");
        File[] worldFolders = townblocksFolder.listFiles(File::isDirectory);
        TownyMessaging.sendDebugMsg("Folders found " + worldFolders.length);
        boolean mismatched = false;
        int mismatchedCount = 0;
        try {
            for (File worldfolder : worldFolders) {
                TownyWorld world;
                String worldName = worldfolder.getName();
                try {
                    world = this.getWorld(worldName);
                }
                catch (NotRegisteredException e) {
                    this.newWorld(worldName);
                    world = this.getWorld(worldName);
                }
                File worldFolder = new File(this.dataFolderPath + File.separator + "townblocks" + File.separator + worldName);
                File[] townBlockFiles = worldFolder.listFiles(file -> file.getName().endsWith(".data"));
                int total = 0;
                for (File townBlockFile : townBlockFiles) {
                    String[] coords = townBlockFile.getName().split("_");
                    String[] size = coords[2].split("\\.");
                    if (Integer.parseInt(size[0]) != TownySettings.getTownBlockSize()) {
                        mismatched = true;
                        ++mismatchedCount;
                        continue;
                    }
                    int x = Integer.parseInt(coords[0]);
                    int z = Integer.parseInt(coords[1]);
                    TownBlock townBlock = new TownBlock(x, z, world);
                    TownyUniverse.getInstance().addTownBlock(townBlock);
                    ++total;
                }
                TownyMessaging.sendDebugMsg("World: " + worldName + " loaded " + total + " townblocks.");
            }
            if (mismatched) {
                TownyMessaging.sendDebugMsg(String.format("%s townblocks were found with a town_block_size that does not match your config, they were not loaded into memory.", mismatchedCount));
            }
            return true;
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadPlotGroupList() {
        TownyMessaging.sendDebugMsg("Loading Group List");
        String line = null;
        try (BufferedReader fin = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.dataFolderPath + File.separator + "plotgroups.txt"), StandardCharsets.UTF_8));){
            while ((line = fin.readLine()) != null) {
                Town town;
                String groupName;
                UUID groupID;
                if (line.equals("")) continue;
                String[] tokens = line.split(",");
                String townName = null;
                if (tokens.length == 4) {
                    townName = tokens[1];
                    groupID = UUID.fromString(tokens[2]);
                    groupName = tokens[3];
                } else {
                    townName = tokens[0];
                    groupID = UUID.fromString(tokens[1]);
                    groupName = tokens[2];
                }
                if ((town = this.universe.getTown(townName)) == null) continue;
                this.universe.newGroup(town, groupName, groupID);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("Error Loading Group List at " + line + ", in towny\\data\\groups.txt");
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean loadResidentList() {
        TownyMessaging.sendDebugMsg("Loading Resident List");
        List<String> residents = this.receiveListFromLegacyFile("residents.txt");
        File[] residentFiles = this.receiveObjectFiles("residents");
        assert (residentFiles != null);
        for (File resident : residentFiles) {
            String name = resident.getName().replace(".txt", "");
            if (residents.size() > 0 && !residents.contains(name)) {
                TownyMessaging.sendDebugMsg("Removing " + resident.getName() + " because they are not found in the residents.txt.");
                this.deleteFile(resident.getAbsolutePath());
                continue;
            }
            try {
                this.newResident(name);
            }
            catch (NotRegisteredException e) {
                e.printStackTrace();
                return false;
            }
            catch (AlreadyRegisteredException alreadyRegisteredException) {
                // empty catch block
            }
        }
        if (residents.size() > 0) {
            this.deleteFile(this.dataFolderPath + File.separator + "residents.txt");
        }
        return true;
    }

    @Override
    public boolean loadTownList() {
        TownyMessaging.sendDebugMsg("Loading Town List");
        List<String> towns = this.receiveListFromLegacyFile("towns.txt");
        File[] townFiles = this.receiveObjectFiles("towns");
        assert (townFiles != null);
        for (File town : townFiles) {
            String name = town.getName().replace(".txt", "");
            if (towns.size() > 0 && !towns.contains(name)) {
                TownyMessaging.sendDebugMsg("Removing " + town.getName() + " because they are not found in the towns.txt.");
                this.deleteFile(town.getAbsolutePath());
                continue;
            }
            try {
                TownyUniverse.getInstance().newTownInternal(name);
            }
            catch (AlreadyRegisteredException alreadyRegisteredException) {
            }
            catch (InvalidNameException e) {
                e.printStackTrace();
                return false;
            }
        }
        if (towns.size() > 0) {
            this.deleteFile(this.dataFolderPath + File.separator + "towns.txt");
        }
        return true;
    }

    @Override
    public boolean loadNationList() {
        TownyMessaging.sendDebugMsg("Loading Nation List");
        List<String> nations = this.receiveListFromLegacyFile("nations.txt");
        File[] nationFiles = this.receiveObjectFiles("nations");
        assert (nationFiles != null);
        for (File nation : nationFiles) {
            String name = nation.getName().replace(".txt", "");
            if (nations.size() > 0 && !nations.contains(name)) {
                TownyMessaging.sendDebugMsg("Removing " + nation.getName() + " because they are not found in the nations.txt.");
                this.deleteFile(nation.getAbsolutePath());
                continue;
            }
            try {
                this.newNation(name);
            }
            catch (AlreadyRegisteredException alreadyRegisteredException) {
            }
            catch (NotRegisteredException e) {
                e.printStackTrace();
                return false;
            }
        }
        if (nations.size() > 0) {
            this.deleteFile(this.dataFolderPath + File.separator + "nations.txt");
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadWorldList() {
        if (this.plugin != null) {
            TownyMessaging.sendDebugMsg("Loading Server World List");
            for (World world : this.plugin.getServer().getWorlds()) {
                try {
                    this.newWorld(world.getName());
                }
                catch (AlreadyRegisteredException alreadyRegisteredException) {}
            }
        }
        TownyMessaging.sendDebugMsg("Loading World List");
        String line = null;
        try (BufferedReader fin = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.dataFolderPath + File.separator + "worlds.txt"), StandardCharsets.UTF_8));){
            while ((line = fin.readLine()) != null) {
                if (line.equals("")) continue;
                this.newWorld(line);
            }
            boolean bl = true;
            return bl;
        }
        catch (AlreadyRegisteredException e) {
            return true;
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("Error Loading World List at " + line + ", in towny\\data\\worlds.txt");
            e.printStackTrace();
            return false;
        }
    }

    private List<String> receiveListFromLegacyFile(String listFile) {
        ArrayList<String> list = new ArrayList<String>();
        try (BufferedReader fin = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.dataFolderPath + File.separator + listFile), StandardCharsets.UTF_8));){
            String line;
            while ((line = fin.readLine()) != null && !line.equals("")) {
                list.add(line);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    private File[] receiveObjectFiles(String folder) {
        File[] files = new File(this.dataFolderPath + File.separator + folder).listFiles(file -> file.getName().toLowerCase().endsWith(".txt"));
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadResident(Resident resident) {
        boolean save = true;
        String line = null;
        String path = this.getResidentFilename(resident);
        File fileResident = new File(path);
        if (fileResident.exists() && fileResident.isFile()) {
            block39: {
                TownyMessaging.sendDebugMsg("Loading Resident: " + resident.getName());
                try {
                    HashMap<String, String> keys = FileMgmt.loadFileIntoHashMap(fileResident);
                    resident.setLastOnline(Long.parseLong(keys.get("lastOnline")));
                    line = keys.get("uuid");
                    if (line != null) {
                        UUID uuid = UUID.fromString(line);
                        if (TownyUniverse.getInstance().hasResident(uuid)) {
                            Resident olderRes = TownyUniverse.getInstance().getResident(uuid);
                            if (resident.getLastOnline() > olderRes.getLastOnline()) {
                                TownyMessaging.sendDebugMsg("Deleting : " + olderRes.getName() + " which is a dupe of " + resident.getName());
                                try {
                                    TownyUniverse.getInstance().unregisterResident(olderRes);
                                }
                                catch (NotRegisteredException notRegisteredException) {
                                    // empty catch block
                                }
                                if (olderRes.hasTown()) {
                                    try {
                                        olderRes.getTown().removeResident(olderRes);
                                    }
                                    catch (NotRegisteredException notRegisteredException) {
                                        // empty catch block
                                    }
                                }
                                this.deleteResident(olderRes);
                            } else {
                                TownyMessaging.sendDebugMsg("Deleting resident : " + resident.getName() + " which is a dupe of " + olderRes.getName());
                                try {
                                    TownyUniverse.getInstance().unregisterResident(resident);
                                }
                                catch (NotRegisteredException notRegisteredException) {
                                    // empty catch block
                                }
                                this.deleteResident(resident);
                                save = false;
                                boolean bl = true;
                                return bl;
                            }
                        }
                        resident.setUUID(uuid);
                        this.universe.registerResidentUUID(resident);
                    }
                    if ((line = keys.get("registered")) != null) {
                        resident.setRegistered(Long.parseLong(line));
                    } else {
                        resident.setRegistered(resident.getLastOnline());
                    }
                    line = keys.get("isNPC");
                    if (line != null) {
                        resident.setNPC(Boolean.parseBoolean(line));
                    }
                    if ((line = keys.get("isJailed")) != null) {
                        resident.setJailed(Boolean.parseBoolean(line));
                    }
                    if ((line = keys.get("JailSpawn")) != null) {
                        resident.setJailSpawn(Integer.valueOf(line));
                    }
                    if ((line = keys.get("JailDays")) != null) {
                        resident.setJailDays(Integer.valueOf(line));
                    }
                    if ((line = keys.get("JailTown")) != null) {
                        resident.setJailTown(line);
                    }
                    if ((line = keys.get("friends")) != null) {
                        List<Resident> friends = this.getResidents(line.split(","));
                        for (Resident friend : friends) {
                            resident.addFriend(friend);
                        }
                    }
                    if ((line = keys.get("protectionStatus")) != null) {
                        resident.setPermissions(line);
                    }
                    if ((line = keys.get("metadata")) != null && !line.isEmpty()) {
                        resident.setMetadata(line.trim());
                    }
                    if ((line = keys.get("town")) == null) break block39;
                    Town town = this.universe.getTown(line);
                    if (town == null) {
                        TownyMessaging.sendErrorMsg("Loading Error: " + resident.getName() + " tried to load the town " + line + " which is invalid, removing town from the resident.");
                        break block39;
                    }
                    resident.setTown(town);
                    line = keys.get("title");
                    if (line != null) {
                        resident.setTitle(line);
                    }
                    if ((line = keys.get("surname")) != null) {
                        resident.setSurname(line);
                    }
                    try {
                        line = keys.get("town-ranks");
                        if (line != null) {
                            resident.setTownRanks(Arrays.asList(line.split(",")));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        line = keys.get("nation-ranks");
                        if (line != null) {
                            resident.setNationRanks(Arrays.asList(line.split(",")));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                catch (Exception e) {
                    TownyMessaging.sendErrorMsg("Loading Error: Exception while reading resident file " + resident.getName() + " at line: " + line + ", in towny\\data\\residents\\" + resident.getName() + ".txt");
                    e.printStackTrace();
                    boolean bl = false;
                    return bl;
                }
                finally {
                    if (save) {
                        this.saveResident(resident);
                    }
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadTown(Town town) {
        String line = null;
        String path = this.getTownFilename(town);
        File fileTown = new File(path);
        if (fileTown.exists() && fileTown.isFile()) {
            TownyMessaging.sendDebugMsg("Loading Town: " + town.getName());
            try {
                Nation nation;
                Location loc;
                double z;
                double y;
                double x;
                TownyWorld world;
                String[] tokens;
                HashMap<String, String> keys = FileMgmt.loadFileIntoHashMap(fileTown);
                line = keys.get("mayor");
                if (line != null) {
                    try {
                        Resident res = this.universe.getResident(line);
                        if (res == null) {
                            throw new TownyException();
                        }
                        town.forceSetMayor(res);
                    }
                    catch (TownyException e1) {
                        if (town.getResidents().size() == 0) {
                            this.deleteTown(town);
                        } else {
                            town.findNewMayor();
                        }
                        boolean bl = true;
                        this.saveTown(town);
                        return bl;
                    }
                }
                if ((line = keys.get("outlaws")) != null) {
                    for (String token : tokens = line.split(",")) {
                        if (token.isEmpty()) continue;
                        TownyMessaging.sendDebugMsg("Town Fetching Outlaw: " + token);
                        Resident outlaw = this.universe.getResident(token);
                        if (outlaw != null) {
                            try {
                                town.addOutlaw(outlaw);
                            }
                            catch (AlreadyRegisteredException ex) {
                                TownyMessaging.sendErrorMsg("Loading Error: Exception while reading an outlaw of town file " + town.getName() + ".txt. The outlaw " + token + " is duplicated! Skipping adding duplicate...");
                            }
                            continue;
                        }
                        TownyMessaging.sendErrorMsg("Loading Error: Exception while reading an outlaw of town file " + town.getName() + ".txt. The outlaw " + token + " does not exist, removing from list...");
                    }
                }
                line = "townBoard";
                town.setBoard(keys.get("townBoard"));
                line = keys.get("tag");
                if (line != null) {
                    try {
                        town.setTag(line);
                    }
                    catch (TownyException e) {
                        town.setTag("");
                    }
                }
                if ((line = keys.get("protectionStatus")) != null) {
                    town.setPermissions(line);
                }
                if ((line = keys.get("bonusBlocks")) != null) {
                    try {
                        town.setBonusBlocks(Integer.parseInt(line));
                    }
                    catch (Exception e) {
                        town.setBonusBlocks(0);
                    }
                }
                if ((line = keys.get("purchasedBlocks")) != null) {
                    try {
                        town.setPurchasedBlocks(Integer.parseInt(line));
                    }
                    catch (Exception e) {
                        town.setPurchasedBlocks(0);
                    }
                }
                if ((line = keys.get("plotPrice")) != null) {
                    try {
                        town.setPlotPrice(Double.parseDouble(line));
                    }
                    catch (Exception e) {
                        town.setPlotPrice(0.0);
                    }
                }
                if ((line = keys.get("hasUpkeep")) != null) {
                    try {
                        town.setHasUpkeep(Boolean.parseBoolean(line));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("taxpercent")) != null) {
                    try {
                        town.setTaxPercentage(Boolean.parseBoolean(line));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("taxes")) != null) {
                    try {
                        town.setTaxes(Double.parseDouble(line));
                    }
                    catch (Exception e) {
                        town.setTaxes(0.0);
                    }
                }
                if ((line = keys.get("plotTax")) != null) {
                    try {
                        town.setPlotTax(Double.parseDouble(line));
                    }
                    catch (Exception e) {
                        town.setPlotTax(0.0);
                    }
                }
                if ((line = keys.get("commercialPlotPrice")) != null) {
                    try {
                        town.setCommercialPlotPrice(Double.parseDouble(line));
                    }
                    catch (Exception e) {
                        town.setCommercialPlotPrice(0.0);
                    }
                }
                if ((line = keys.get("commercialPlotTax")) != null) {
                    try {
                        town.setCommercialPlotTax(Double.parseDouble(line));
                    }
                    catch (Exception e) {
                        town.setCommercialPlotTax(0.0);
                    }
                }
                if ((line = keys.get("embassyPlotPrice")) != null) {
                    try {
                        town.setEmbassyPlotPrice(Double.parseDouble(line));
                    }
                    catch (Exception e) {
                        town.setEmbassyPlotPrice(0.0);
                    }
                }
                if ((line = keys.get("embassyPlotTax")) != null) {
                    try {
                        town.setEmbassyPlotTax(Double.parseDouble(line));
                    }
                    catch (Exception e) {
                        town.setEmbassyPlotTax(0.0);
                    }
                }
                if ((line = keys.get("spawnCost")) != null) {
                    try {
                        town.setSpawnCost(Double.parseDouble(line));
                    }
                    catch (Exception e) {
                        town.setSpawnCost(TownySettings.getSpawnTravelCost());
                    }
                }
                if ((line = keys.get("adminDisabledPvP")) != null) {
                    try {
                        town.setAdminDisabledPVP(Boolean.parseBoolean(line));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("adminEnabledPvP")) != null) {
                    try {
                        town.setAdminEnabledPVP(Boolean.parseBoolean(line));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("open")) != null) {
                    try {
                        town.setOpen(Boolean.parseBoolean(line));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("public")) != null) {
                    try {
                        town.setPublic(Boolean.parseBoolean(line));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("conquered")) != null) {
                    try {
                        town.setConquered(Boolean.parseBoolean(line));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("conqueredDays")) != null) {
                    town.setConqueredDays(Integer.valueOf(line));
                }
                if ((line = keys.get("homeBlock")) != null && (tokens = line.split(",")).length == 3) {
                    try {
                        world = this.getWorld(tokens[0]);
                        try {
                            int x2 = Integer.parseInt(tokens[1]);
                            int z2 = Integer.parseInt(tokens[2]);
                            TownBlock homeBlock = TownyUniverse.getInstance().getTownBlock(new WorldCoord(world.getName(), x2, z2));
                            town.forceSetHomeBlock(homeBlock);
                        }
                        catch (NumberFormatException e) {
                            TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " homeBlock tried to load invalid location.");
                        }
                        catch (NotRegisteredException e) {
                            TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " homeBlock tried to load invalid TownBlock.");
                        }
                        catch (TownyException e) {
                            TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " does not have a home block.");
                        }
                    }
                    catch (NotRegisteredException e) {
                        TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " homeBlock tried to load invalid world.");
                    }
                }
                if ((line = keys.get("spawn")) != null && (tokens = line.split(",")).length >= 4) {
                    try {
                        world = this.plugin.getServerWorld(tokens[0]);
                        double x3 = Double.parseDouble(tokens[1]);
                        double y2 = Double.parseDouble(tokens[2]);
                        double z3 = Double.parseDouble(tokens[3]);
                        Location loc2 = new Location((World)world, x3, y2, z3);
                        if (tokens.length == 6) {
                            loc2.setPitch(Float.parseFloat(tokens[4]));
                            loc2.setYaw(Float.parseFloat(tokens[5]));
                        }
                        town.forceSetSpawn(loc2);
                    }
                    catch (NotRegisteredException | NullPointerException | NumberFormatException world2) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("outpostspawns")) != null) {
                    String[] outposts;
                    for (String spawn : outposts = line.split(";")) {
                        tokens = spawn.split(",");
                        if (tokens.length < 4) continue;
                        try {
                            World world3 = this.plugin.getServerWorld(tokens[0]);
                            x = Double.parseDouble(tokens[1]);
                            y = Double.parseDouble(tokens[2]);
                            z = Double.parseDouble(tokens[3]);
                            loc = new Location(world3, x, y, z);
                            if (tokens.length == 6) {
                                loc.setPitch(Float.parseFloat(tokens[4]));
                                loc.setYaw(Float.parseFloat(tokens[5]));
                            }
                            town.forceAddOutpostSpawn(loc);
                        }
                        catch (NotRegisteredException | NullPointerException | NumberFormatException world3) {
                            // empty catch block
                        }
                    }
                }
                if ((line = keys.get("jailspawns")) != null) {
                    String[] jails;
                    for (String spawn : jails = line.split(";")) {
                        tokens = spawn.split(",");
                        if (tokens.length < 4) continue;
                        try {
                            World world4 = this.plugin.getServerWorld(tokens[0]);
                            x = Double.parseDouble(tokens[1]);
                            y = Double.parseDouble(tokens[2]);
                            z = Double.parseDouble(tokens[3]);
                            loc = new Location(world4, x, y, z);
                            if (tokens.length == 6) {
                                loc.setPitch(Float.parseFloat(tokens[4]));
                                loc.setYaw(Float.parseFloat(tokens[5]));
                            }
                            town.forceAddJailSpawn(loc);
                        }
                        catch (NotRegisteredException | NullPointerException | NumberFormatException exception) {
                            // empty catch block
                        }
                    }
                }
                if ((line = keys.get("uuid")) != null) {
                    UUID townUUID = null;
                    try {
                        townUUID = UUID.fromString(line);
                    }
                    catch (IllegalArgumentException ee) {
                        townUUID = UUID.randomUUID();
                    }
                    town.setUUID(townUUID);
                    TownyUniverse.getInstance().registerTownUUID(town);
                }
                if ((line = keys.get("registered")) != null) {
                    try {
                        town.setRegistered(Long.valueOf(line));
                    }
                    catch (Exception ee) {
                        town.setRegistered(0L);
                    }
                }
                if ((line = keys.get("metadata")) != null && !line.isEmpty()) {
                    town.setMetadata(line.trim());
                }
                if ((line = keys.get("nation")) != null && !line.isEmpty() && (nation = this.universe.getNation(line)) != null) {
                    town.setNation(nation);
                }
                if ((line = keys.get("ruined")) != null) {
                    try {
                        town.setRuined(Boolean.parseBoolean(line));
                    }
                    catch (Exception e) {
                        town.setRuined(false);
                    }
                }
                if ((line = keys.get("ruinedTime")) != null) {
                    try {
                        town.setRuinedTime(Long.valueOf(line));
                    }
                    catch (Exception ee) {
                        town.setRuinedTime(0L);
                    }
                }
                if ((line = keys.get("neutral")) != null) {
                    town.setNeutral(Boolean.parseBoolean(line));
                }
                if ((line = keys.get("debtBalance")) != null) {
                    try {
                        town.setDebtBalance(Double.parseDouble(line));
                    }
                    catch (Exception e) {
                        town.setDebtBalance(0.0);
                    }
                }
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg("Loading Error: Exception while reading town file " + town.getName() + " at line: " + line + ", in towny\\data\\towns\\" + town.getName() + ".txt");
                e.printStackTrace();
                boolean bl = false;
                return bl;
            }
            finally {
                this.saveTown(town);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadNation(Nation nation) {
        String line = "";
        String path = this.getNationFilename(nation);
        File fileNation = new File(path);
        if (fileNation.exists() && fileNation.isFile()) {
            TownyMessaging.sendDebugMsg("Loading Nation: " + nation.getName());
            try {
                String[] tokens;
                HashMap<String, String> keys = FileMgmt.loadFileIntoHashMap(fileNation);
                line = keys.get("capital");
                if (line != null) {
                    Town town = this.universe.getTown(line);
                    if (town != null) {
                        try {
                            nation.forceSetCapital(town);
                        }
                        catch (EmptyNationException e1) {
                            System.out.println("The nation " + nation.getName() + " could not load a capital city and is being disbanded.");
                            this.removeNation(nation);
                            boolean bl = true;
                            this.saveNation(nation);
                            return bl;
                        }
                    } else {
                        TownyMessaging.sendDebugMsg("Nation " + nation.getName() + " could not set capital to " + line + ", selecting a new capital...");
                        if (!nation.findNewCapital()) {
                            System.out.println("The nation " + nation.getName() + " could not load a capital city and is being disbanded.");
                            this.removeNation(nation);
                            boolean e1 = true;
                            return e1;
                        }
                    }
                }
                if ((line = keys.get("nationBoard")) != null) {
                    try {
                        nation.setBoard(line);
                    }
                    catch (Exception e) {
                        nation.setBoard("");
                    }
                }
                if ((line = keys.get("mapColorHexCode")) != null) {
                    try {
                        nation.setMapColorHexCode(line);
                    }
                    catch (Exception e) {
                        nation.setMapColorHexCode(MapUtil.generateRandomNationColourAsHexCode());
                    }
                } else {
                    nation.setMapColorHexCode(MapUtil.generateRandomNationColourAsHexCode());
                }
                line = keys.get("tag");
                if (line != null) {
                    try {
                        nation.setTag(line);
                    }
                    catch (TownyException e) {
                        nation.setTag("");
                    }
                }
                if ((line = keys.get("allies")) != null) {
                    List<Nation> allies = this.getNations(line.split(","));
                    for (Nation ally : allies) {
                        nation.addAlly(ally);
                    }
                }
                if ((line = keys.get("enemies")) != null) {
                    List<Nation> enemies = this.getNations(line.split(","));
                    for (Nation enemy : enemies) {
                        nation.addEnemy(enemy);
                    }
                }
                if ((line = keys.get("taxes")) != null) {
                    try {
                        nation.setTaxes(Double.parseDouble(line));
                    }
                    catch (Exception e) {
                        nation.setTaxes(0.0);
                    }
                }
                if ((line = keys.get("spawnCost")) != null) {
                    try {
                        nation.setSpawnCost(Double.parseDouble(line));
                    }
                    catch (Exception e) {
                        nation.setSpawnCost(TownySettings.getSpawnTravelCost());
                    }
                }
                if ((line = keys.get("neutral")) != null) {
                    nation.setNeutral(Boolean.parseBoolean(line));
                }
                if ((line = keys.get("uuid")) != null) {
                    try {
                        nation.setUUID(UUID.fromString(line));
                    }
                    catch (IllegalArgumentException ee) {
                        nation.setUUID(UUID.randomUUID());
                    }
                    this.universe.registerNationUUID(nation);
                }
                if ((line = keys.get("registered")) != null) {
                    try {
                        nation.setRegistered(Long.valueOf(line));
                    }
                    catch (Exception ee) {
                        nation.setRegistered(0L);
                    }
                }
                if ((line = keys.get("nationSpawn")) != null && (tokens = line.split(",")).length >= 4) {
                    try {
                        World world = this.plugin.getServerWorld(tokens[0]);
                        double x = Double.parseDouble(tokens[1]);
                        double y = Double.parseDouble(tokens[2]);
                        double z = Double.parseDouble(tokens[3]);
                        Location loc = new Location(world, x, y, z);
                        if (tokens.length == 6) {
                            loc.setPitch(Float.parseFloat(tokens[4]));
                            loc.setYaw(Float.parseFloat(tokens[5]));
                        }
                        nation.forceSetNationSpawn(loc);
                    }
                    catch (NotRegisteredException | NullPointerException | NumberFormatException exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("isPublic")) != null) {
                    try {
                        nation.setPublic(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("isOpen")) != null) {
                    try {
                        nation.setOpen(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("metadata")) != null && !line.isEmpty()) {
                    nation.setMetadata(line.trim());
                }
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg("Loading Error: Exception while reading nation file " + nation.getName() + " at line: " + line + ", in towny\\data\\nations\\" + nation.getName() + ".txt");
                e.printStackTrace();
                boolean bl = false;
                return bl;
            }
            finally {
                this.saveNation(nation);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadWorld(TownyWorld world) {
        File fileWorld;
        String line = "";
        String path = this.getWorldFilename(world);
        if (!FileMgmt.checkOrCreateFile(path)) {
            TownyMessaging.sendErrorMsg("Loading Error: Exception while reading file " + path);
        }
        if ((fileWorld = new File(path)).exists() && fileWorld.isFile()) {
            TownyMessaging.sendDebugMsg("Loading World: " + world.getName());
            try {
                ArrayList<String> mats2;
                HashMap<String, String> keys = FileMgmt.loadFileIntoHashMap(fileWorld);
                line = keys.get("claimable");
                if (line != null) {
                    try {
                        world.setClaimable(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("pvp")) != null) {
                    try {
                        world.setPVP(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("forcepvp")) != null) {
                    try {
                        world.setForcePVP(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("friendlyFire")) != null) {
                    try {
                        world.setFriendlyFire(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("forcetownmobs")) != null) {
                    try {
                        world.setForceTownMobs(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("wildernessmobs")) != null) {
                    try {
                        world.setWildernessMobs(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("worldmobs")) != null) {
                    try {
                        world.setWorldMobs(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("firespread")) != null) {
                    try {
                        world.setFire(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("forcefirespread")) != null) {
                    try {
                        world.setForceFire(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("explosions")) != null) {
                    try {
                        world.setExpl(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("forceexplosions")) != null) {
                    try {
                        world.setForceExpl(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("endermanprotect")) != null) {
                    try {
                        world.setEndermanProtect(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("disableplayertrample")) != null) {
                    try {
                        world.setDisablePlayerTrample(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("disablecreaturetrample")) != null) {
                    try {
                        world.setDisableCreatureTrample(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("unclaimedZoneBuild")) != null) {
                    try {
                        world.setUnclaimedZoneBuild(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("unclaimedZoneDestroy")) != null) {
                    try {
                        world.setUnclaimedZoneDestroy(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("unclaimedZoneSwitch")) != null) {
                    try {
                        world.setUnclaimedZoneSwitch(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("unclaimedZoneItemUse")) != null) {
                    try {
                        world.setUnclaimedZoneItemUse(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("unclaimedZoneName")) != null) {
                    try {
                        world.setUnclaimedZoneName(line);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("unclaimedZoneIgnoreIds")) != null) {
                    try {
                        mats2 = new ArrayList<String>();
                        for (String s : line.split(",")) {
                            if (s.isEmpty()) continue;
                            mats2.add(s);
                        }
                        world.setUnclaimedZoneIgnore(mats2);
                    }
                    catch (Exception mats2) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("usingPlotManagementDelete")) != null) {
                    try {
                        world.setUsingPlotManagementDelete(Boolean.parseBoolean(line));
                    }
                    catch (Exception mats2) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("plotManagementDeleteIds")) != null) {
                    try {
                        mats2 = new ArrayList();
                        for (String s : line.split(",")) {
                            if (s.isEmpty()) continue;
                            mats2.add(s);
                        }
                        world.setPlotManagementDeleteIds(mats2);
                    }
                    catch (Exception mats3) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("usingPlotManagementMayorDelete")) != null) {
                    try {
                        world.setUsingPlotManagementMayorDelete(Boolean.parseBoolean(line));
                    }
                    catch (Exception mats3) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("plotManagementMayorDelete")) != null) {
                    try {
                        ArrayList<String> materials = new ArrayList<String>();
                        for (String s : line.split(",")) {
                            if (s.isEmpty()) continue;
                            try {
                                materials.add(s.toUpperCase().trim());
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        world.setPlotManagementMayorDelete(materials);
                    }
                    catch (Exception materials) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("usingPlotManagementRevert")) != null) {
                    try {
                        world.setUsingPlotManagementRevert(Boolean.parseBoolean(line));
                    }
                    catch (Exception materials) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("plotManagementIgnoreIds")) != null) {
                    try {
                        mats2 = new ArrayList();
                        for (String s : line.split(",")) {
                            if (s.isEmpty()) continue;
                            mats2.add(s);
                        }
                        world.setPlotManagementIgnoreIds(mats2);
                    }
                    catch (Exception mats4) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("usingPlotManagementWildRegen")) != null) {
                    try {
                        world.setUsingPlotManagementWildEntityRevert(Boolean.parseBoolean(line));
                    }
                    catch (Exception mats4) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("PlotManagementWildRegenEntities")) != null) {
                    try {
                        ArrayList<String> entities = new ArrayList<String>();
                        for (String s : line.split(",")) {
                            if (s.isEmpty()) continue;
                            try {
                                entities.add(s.trim());
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        world.setPlotManagementWildRevertEntities(entities);
                    }
                    catch (Exception entities) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("usingPlotManagementWildRegenDelay")) != null) {
                    try {
                        world.setPlotManagementWildRevertDelay(Long.parseLong(line));
                    }
                    catch (Exception entities) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("usingPlotManagementWildRegenBlocks")) != null) {
                    try {
                        world.setUsingPlotManagementWildBlockRevert(Boolean.parseBoolean(line));
                    }
                    catch (Exception entities) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("PlotManagementWildRegenBlocks")) != null) {
                    try {
                        mats2 = new ArrayList();
                        for (String s : line.split(",")) {
                            if (s.isEmpty()) continue;
                            try {
                                mats2.add(s.trim());
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        world.setPlotManagementWildRevertMaterials(mats2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("usingTowny")) != null) {
                    try {
                        world.setUsingTowny(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("warAllowed")) != null) {
                    try {
                        world.setWarAllowed(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = keys.get("metadata")) != null && !line.isEmpty()) {
                    world.setMetadata(line.trim());
                }
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg("Loading Error: Exception while reading world file " + path + " at line: " + line + ", in towny\\data\\worlds\\" + world.getName() + ".txt");
                boolean bl = false;
                return bl;
            }
            finally {
                this.saveWorld(world);
            }
            return true;
        }
        TownyMessaging.sendErrorMsg("Loading Error: File error while reading " + world.getName() + " at line: " + line + ", in towny\\data\\worlds\\" + world.getName() + ".txt");
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean loadPlotGroups() {
        line = "";
        for (PlotGroup group : this.getAllPlotGroups()) {
            block7: {
                path = this.getPlotGroupFilename(group);
                groupFile = new File(path);
                if (!groupFile.exists() || !groupFile.isFile()) break block7;
                try {
                    keys = FileMgmt.loadFileIntoHashMap(groupFile);
                    line = keys.get("groupName");
                    if (line != null) {
                        group.setName(line.trim());
                    }
                    if ((line = keys.get("groupID")) != null) {
                        group.setID(UUID.fromString(line.trim()));
                    }
                    if ((line = keys.get("town")) == null || line.isEmpty()) ** GOTO lbl22
                    town = this.universe.getTown(line.trim());
                    if (town != null) {
                        group.setTown(town);
                    } else {
                        TownyMessaging.sendDebugMsg("Group file missing Town, deleting " + path);
                        this.deletePlotGroup(group);
                        TownyMessaging.sendDebugMsg("Missing file: " + path + " deleting entry in group.txt");
                        continue;
lbl22:
                        // 1 sources

                        TownyMessaging.sendErrorMsg("Could not add to town!");
                        this.deletePlotGroup(group);
                    }
                    if ((line = keys.get("groupPrice")) == null || line.isEmpty()) continue;
                    group.setPrice(Double.parseDouble(line.trim()));
                    continue;
                }
                catch (Exception e) {
                    TownyMessaging.sendErrorMsg("Loading Error: Exception while reading Group file " + path + " at line: " + line);
                    return false;
                }
            }
            TownyMessaging.sendDebugMsg("Missing file: " + path + " deleting entry in groups.txt");
        }
        this.savePlotGroupList();
        return true;
    }

    @Override
    public boolean loadTownBlocks() {
        String line = "";
        for (TownBlock townBlock : this.getAllTownBlocks()) {
            String path = this.getTownBlockFilename(townBlock);
            File fileTownBlock = new File(path);
            if (fileTownBlock.exists() && fileTownBlock.isFile()) {
                try {
                    HashMap<String, String> keys = FileMgmt.loadFileIntoHashMap(fileTownBlock);
                    line = keys.get("town");
                    if (line != null) {
                        if (line.isEmpty()) {
                            TownyMessaging.sendErrorMsg("TownBlock file missing Town, deleting " + path);
                            TownyUniverse.getInstance().removeTownBlock(townBlock);
                            this.deleteTownBlock(townBlock);
                            continue;
                        }
                        Town town = this.universe.getTown(line.trim());
                        if (town == null) {
                            TownyMessaging.sendErrorMsg("TownBlock file contains unregistered Town: " + line + ", deleting " + path);
                            TownyUniverse.getInstance().removeTownBlock(townBlock);
                            this.deleteTownBlock(townBlock);
                            continue;
                        }
                        townBlock.setTown(town);
                        try {
                            town.addTownBlock(townBlock);
                            TownyWorld townyWorld = townBlock.getWorld();
                            if (townyWorld != null && !townyWorld.hasTown(town)) {
                                townyWorld.addTown(town);
                            }
                        }
                        catch (AlreadyRegisteredException townyWorld) {}
                    } else {
                        TownyMessaging.sendErrorMsg("TownBlock file missing Town, deleting " + path);
                        TownyUniverse.getInstance().removeTownBlock(townBlock);
                        this.deleteTownBlock(townBlock);
                        continue;
                    }
                    if ((line = keys.get("name")) != null) {
                        try {
                            townBlock.setName(line.trim());
                        }
                        catch (Exception town) {
                            // empty catch block
                        }
                    }
                    if ((line = keys.get("price")) != null) {
                        try {
                            townBlock.setPlotPrice(Double.parseDouble(line.trim()));
                        }
                        catch (Exception town) {
                            // empty catch block
                        }
                    }
                    if ((line = keys.get("resident")) != null && !line.isEmpty()) {
                        Resident res = this.universe.getResident(line.trim());
                        if (res != null) {
                            townBlock.setResident(res);
                        } else {
                            TownyMessaging.sendErrorMsg("Invalid resident for townblock " + townBlock.toString() + ". Skipped setting resident for townblock...");
                        }
                    }
                    if ((line = keys.get("type")) != null) {
                        try {
                            townBlock.setType(Integer.parseInt(line));
                        }
                        catch (Exception res) {
                            // empty catch block
                        }
                    }
                    if ((line = keys.get("outpost")) != null) {
                        try {
                            townBlock.setOutpost(Boolean.parseBoolean(line));
                        }
                        catch (Exception res) {
                            // empty catch block
                        }
                    }
                    if ((line = keys.get("permissions")) != null && !line.isEmpty()) {
                        try {
                            townBlock.setPermissions(line.trim());
                        }
                        catch (Exception res) {
                            // empty catch block
                        }
                    }
                    if ((line = keys.get("changed")) != null) {
                        try {
                            townBlock.setChanged(Boolean.parseBoolean(line.trim()));
                        }
                        catch (Exception res) {
                            // empty catch block
                        }
                    }
                    if ((line = keys.get("locked")) != null) {
                        try {
                            townBlock.setLocked(Boolean.parseBoolean(line.trim()));
                        }
                        catch (Exception res) {
                            // empty catch block
                        }
                    }
                    if ((line = keys.get("metadata")) != null && !line.isEmpty()) {
                        townBlock.setMetadata(line.trim());
                    }
                    line = keys.get("groupID");
                    UUID groupID = null;
                    if (line != null && !line.isEmpty()) {
                        groupID = UUID.fromString(line.trim());
                    }
                    if (groupID == null) continue;
                    PlotGroup group = this.getPlotObjectGroup(townBlock.getTown().toString(), groupID);
                    townBlock.setPlotObjectGroup(group);
                    continue;
                }
                catch (Exception e) {
                    TownyMessaging.sendErrorMsg("Loading Error: Exception while reading TownBlock file " + path + " at line: " + line);
                    return false;
                }
            }
            TownyMessaging.sendErrorMsg("TownBlock file contains unknown error, deleting " + path);
            TownyUniverse.getInstance().removeTownBlock(townBlock);
            this.deleteTownBlock(townBlock);
        }
        return true;
    }

    @Override
    public boolean savePlotGroupList() {
        ArrayList<String> list = new ArrayList<String>();
        for (PlotGroup group : this.getAllPlotGroups()) {
            list.add(group.getTown().getName() + "," + group.getID() + "," + group.getName());
        }
        this.queryQueue.add(new FlatFileSaveTask(list, this.dataFolderPath + File.separator + "plotgroups.txt"));
        return true;
    }

    @Override
    public boolean saveWorldList() {
        ArrayList<String> list = new ArrayList<String>();
        for (TownyWorld world : this.getWorlds()) {
            list.add(world.getName());
        }
        this.queryQueue.add(new FlatFileSaveTask(list, this.dataFolderPath + File.separator + "worlds.txt"));
        return true;
    }

    @Override
    public boolean saveResident(Resident resident) {
        ArrayList<String> list = new ArrayList<String>();
        if (resident.hasUUID()) {
            list.add("uuid=" + resident.getUUID());
        }
        list.add("lastOnline=" + resident.getLastOnline());
        list.add("registered=" + resident.getRegistered());
        list.add("isNPC=" + resident.isNPC());
        list.add("isJailed=" + resident.isJailed());
        list.add("JailSpawn=" + resident.getJailSpawn());
        list.add("JailDays=" + resident.getJailDays());
        list.add("JailTown=" + resident.getJailTown());
        list.add("title=" + resident.getTitle());
        list.add("surname=" + resident.getSurname());
        if (resident.hasTown()) {
            try {
                list.add("town=" + resident.getTown().getName());
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
            list.add("town-ranks=" + StringMgmt.join(resident.getTownRanks(), ","));
            list.add("nation-ranks=" + StringMgmt.join(resident.getNationRanks(), ","));
        }
        list.add("friends=" + StringMgmt.join(resident.getFriends(), ","));
        list.add("");
        list.add("protectionStatus=" + resident.getPermissions().toString());
        list.add("metadata=" + this.serializeMetadata(resident));
        this.queryQueue.add(new FlatFileSaveTask(list, this.getResidentFilename(resident)));
        return true;
    }

    @Override
    public boolean saveTown(Town town) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("name=" + town.getName());
        if (town.hasMayor()) {
            list.add("mayor=" + town.getMayor().getName());
        }
        if (town.hasNation()) {
            try {
                list.add("nation=" + town.getNation().getName());
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        list.add("assistants=" + StringMgmt.join(town.getRank("assistant"), ","));
        list.add(this.newLine);
        list.add("townBoard=" + town.getBoard());
        list.add("tag=" + town.getTag());
        list.add("protectionStatus=" + town.getPermissions().toString());
        list.add("bonusBlocks=" + town.getBonusBlocks());
        list.add("purchasedBlocks=" + town.getPurchasedBlocks());
        list.add("taxpercent=" + town.isTaxPercentage());
        list.add("taxes=" + town.getTaxes());
        list.add("plotPrice=" + town.getPlotPrice());
        list.add("plotTax=" + town.getPlotTax());
        list.add("commercialPlotPrice=" + town.getCommercialPlotPrice());
        list.add("commercialPlotTax=" + town.getCommercialPlotTax());
        list.add("embassyPlotPrice=" + town.getEmbassyPlotPrice());
        list.add("embassyPlotTax=" + town.getEmbassyPlotTax());
        list.add("spawnCost=" + town.getSpawnCost());
        list.add("hasUpkeep=" + town.hasUpkeep());
        list.add("open=" + town.isOpen());
        list.add("adminDisabledPvP=" + town.isAdminDisabledPVP());
        list.add("adminEnabledPvP=" + town.isAdminEnabledPVP());
        list.add("public=" + town.isPublic());
        list.add("conquered=" + town.isConquered());
        list.add("conqueredDays " + town.getConqueredDays());
        if (town.hasValidUUID()) {
            list.add("uuid=" + town.getUUID());
        } else {
            list.add("uuid=" + UUID.randomUUID());
        }
        list.add("registered=" + town.getRegistered());
        if (town.hasHomeBlock()) {
            try {
                list.add("homeBlock=" + town.getHomeBlock().getWorld().getName() + "," + town.getHomeBlock().getX() + "," + town.getHomeBlock().getZ());
            }
            catch (TownyException townyException) {
                // empty catch block
            }
        }
        if (town.hasSpawn()) {
            try {
                list.add("spawn=" + town.getSpawn().getWorld().getName() + "," + town.getSpawn().getX() + "," + town.getSpawn().getY() + "," + town.getSpawn().getZ() + "," + town.getSpawn().getPitch() + "," + town.getSpawn().getYaw());
            }
            catch (TownyException townyException) {
                // empty catch block
            }
        }
        StringBuilder outpostArray = new StringBuilder("outpostspawns=");
        if (town.hasOutpostSpawn()) {
            for (Location spawn : new ArrayList<Location>(town.getAllOutpostSpawns())) {
                outpostArray.append(spawn.getWorld().getName()).append(",").append(spawn.getX()).append(",").append(spawn.getY()).append(",").append(spawn.getZ()).append(",").append(spawn.getPitch()).append(",").append(spawn.getYaw()).append(";");
            }
        }
        list.add(outpostArray.toString());
        StringBuilder jailArray = new StringBuilder("jailspawns=");
        if (town.hasJailSpawn()) {
            for (Location spawn : new ArrayList<Location>(town.getAllJailSpawns())) {
                jailArray.append(spawn.getWorld().getName()).append(",").append(spawn.getX()).append(",").append(spawn.getY()).append(",").append(spawn.getZ()).append(",").append(spawn.getPitch()).append(",").append(spawn.getYaw()).append(";");
            }
        }
        list.add(jailArray.toString());
        list.add("outlaws=" + StringMgmt.join(town.getOutlaws(), ","));
        list.add("metadata=" + this.serializeMetadata(town));
        list.add("ruined=" + town.isRuined());
        list.add("ruinedTime=" + town.getRuinedTime());
        list.add("neutral=" + town.isNeutral());
        list.add("debtBalance=" + town.getDebtBalance());
        this.queryQueue.add(new FlatFileSaveTask(list, this.getTownFilename(town)));
        return true;
    }

    @Override
    public boolean savePlotGroup(PlotGroup group) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("groupID=" + group.getID().toString());
        list.add("groupName=" + group.getName());
        list.add("groupPrice=" + group.getPrice());
        list.add("town=" + group.getTown().toString());
        this.queryQueue.add(new FlatFileSaveTask(list, this.getPlotGroupFilename(group)));
        return true;
    }

    @Override
    public boolean saveNation(Nation nation) {
        ArrayList<String> list = new ArrayList<String>();
        if (nation.hasCapital()) {
            list.add("capital=" + nation.getCapital().getName());
        }
        list.add("nationBoard=" + nation.getBoard());
        list.add("mapColorHexCode=" + nation.getMapColorHexCode());
        if (nation.hasTag()) {
            list.add("tag=" + nation.getTag());
        }
        list.add("allies=" + StringMgmt.join(nation.getAllies(), ","));
        list.add("enemies=" + StringMgmt.join(nation.getEnemies(), ","));
        list.add("taxes=" + nation.getTaxes());
        list.add("spawnCost=" + nation.getSpawnCost());
        list.add("neutral=" + nation.isNeutral());
        if (nation.hasValidUUID()) {
            list.add("uuid=" + nation.getUUID());
        } else {
            list.add("uuid=" + UUID.randomUUID());
        }
        list.add("registered=" + nation.getRegistered());
        if (nation.hasSpawn()) {
            try {
                list.add("nationSpawn=" + nation.getSpawn().getWorld().getName() + "," + nation.getSpawn().getX() + "," + nation.getSpawn().getY() + "," + nation.getSpawn().getZ() + "," + nation.getSpawn().getPitch() + "," + nation.getSpawn().getYaw());
            }
            catch (TownyException townyException) {
                // empty catch block
            }
        }
        list.add("isPublic=" + nation.isPublic());
        list.add("isOpen=" + nation.isOpen());
        list.add("metadata=" + this.serializeMetadata(nation));
        this.queryQueue.add(new FlatFileSaveTask(list, this.getNationFilename(nation)));
        return true;
    }

    @Override
    public boolean saveWorld(TownyWorld world) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("pvp=" + world.isPVP());
        list.add("forcepvp=" + world.isForcePVP());
        list.add("friendlyFire=" + world.isFriendlyFireEnabled());
        list.add("# Can players found towns and claim plots in this world?");
        list.add("claimable=" + world.isClaimable());
        list.add("worldmobs=" + world.hasWorldMobs());
        list.add("wildernessmobs=" + world.hasWildernessMobs());
        list.add("forcetownmobs=" + world.isForceTownMobs());
        list.add("firespread=" + world.isFire());
        list.add("forcefirespread=" + world.isForceFire());
        list.add("explosions=" + world.isExpl());
        list.add("forceexplosions=" + world.isForceExpl());
        list.add("endermanprotect=" + world.isEndermanProtect());
        list.add("disableplayertrample=" + world.isDisablePlayerTrample());
        list.add("disablecreaturetrample=" + world.isDisableCreatureTrample());
        list.add("");
        list.add("# Unclaimed Zone settings.");
        if (world.getUnclaimedZoneBuild() != null) {
            list.add("unclaimedZoneBuild=" + world.getUnclaimedZoneBuild());
        }
        if (world.getUnclaimedZoneDestroy() != null) {
            list.add("unclaimedZoneDestroy=" + world.getUnclaimedZoneDestroy());
        }
        if (world.getUnclaimedZoneSwitch() != null) {
            list.add("unclaimedZoneSwitch=" + world.getUnclaimedZoneSwitch());
        }
        if (world.getUnclaimedZoneItemUse() != null) {
            list.add("unclaimedZoneItemUse=" + world.getUnclaimedZoneItemUse());
        }
        if (world.getUnclaimedZoneName() != null) {
            list.add("unclaimedZoneName=" + world.getUnclaimedZoneName());
        }
        list.add("");
        list.add("# The following are blocks that will bypass the above build, destroy, switch and itemuse settings.");
        if (world.getUnclaimedZoneIgnoreMaterials() != null) {
            list.add("unclaimedZoneIgnoreIds=" + StringMgmt.join(world.getUnclaimedZoneIgnoreMaterials(), ","));
        }
        list.add("");
        list.add("# The following settings control what blocks are deleted upon a townblock being unclaimed");
        list.add("usingPlotManagementDelete=" + world.isUsingPlotManagementDelete());
        if (world.getPlotManagementDeleteIds() != null) {
            list.add("plotManagementDeleteIds=" + StringMgmt.join(world.getPlotManagementDeleteIds(), ","));
        }
        list.add("");
        list.add("# The following settings control what blocks are deleted upon a mayor issuing a '/plot clear' command");
        list.add("usingPlotManagementMayorDelete=" + world.isUsingPlotManagementMayorDelete());
        if (world.getPlotManagementMayorDelete() != null) {
            list.add("plotManagementMayorDelete=" + StringMgmt.join(world.getPlotManagementMayorDelete(), ","));
        }
        list.add("");
        list.add("# If enabled when a town claims a townblock a snapshot will be taken at the time it is claimed.");
        list.add("# When the townblock is unclaimed its blocks will begin to revert to the original snapshot.");
        list.add("usingPlotManagementRevert=" + world.isUsingPlotManagementRevert());
        list.add("# Any block Id's listed here will not be respawned. Instead it will revert to air. This list also world on the WildRegen settings below.");
        if (world.getPlotManagementIgnoreIds() != null) {
            list.add("plotManagementIgnoreIds=" + StringMgmt.join(world.getPlotManagementIgnoreIds(), ","));
        }
        list.add("");
        list.add("# The following settings control which entities/blocks' explosions are reverted in the wilderness.");
        list.add("# If enabled any damage caused by entity explosions will repair itself.");
        list.add("usingPlotManagementWildRegen=" + world.isUsingPlotManagementWildEntityRevert());
        list.add("# The list of entities whose explosions would be reverted.");
        if (world.getPlotManagementWildRevertEntities() != null) {
            list.add("PlotManagementWildRegenEntities=" + StringMgmt.join(world.getPlotManagementWildRevertEntities(), ","));
        }
        list.add("# If enabled any damage caused by block explosions will repair itself.");
        list.add("usingPlotManagementWildRegenBlocks=" + world.isUsingPlotManagementWildBlockRevert());
        list.add("# The list of entities whose explosions would be reverted.");
        if (world.getPlotManagementWildRevertBlocks() != null) {
            list.add("PlotManagementWildRegenBlocks=" + StringMgmt.join(world.getPlotManagementWildRevertBlocks(), ","));
        }
        list.add("# The delay after which the explosion reverts will begin.");
        list.add("usingPlotManagementWildRegenDelay=" + world.getPlotManagementWildRevertDelay());
        list.add("");
        list.add("# This setting is used to enable or disable Towny in this world.");
        list.add("usingTowny=" + world.isUsingTowny());
        list.add("");
        list.add("# This setting is used to enable or disable Event war in this world.");
        list.add("warAllowed=" + world.isWarAllowed());
        list.add("");
        list.add("metadata=" + this.serializeMetadata(world));
        this.queryQueue.add(new FlatFileSaveTask(list, this.getWorldFilename(world)));
        return true;
    }

    @Override
    public boolean saveTownBlock(TownBlock townBlock) {
        FileMgmt.checkOrCreateFolder(this.dataFolderPath + File.separator + "townblocks" + File.separator + townBlock.getWorld().getName());
        ArrayList<String> list = new ArrayList<String>();
        list.add("name=" + townBlock.getName());
        list.add("price=" + townBlock.getPlotPrice());
        try {
            list.add("town=" + townBlock.getTown().getName());
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        if (townBlock.hasResident()) {
            try {
                list.add("resident=" + townBlock.getResident().getName());
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        list.add("type=" + townBlock.getType().getId());
        list.add("outpost=" + townBlock.isOutpost());
        if (townBlock.isChanged()) {
            list.add("permissions=" + townBlock.getPermissions().toString());
        }
        list.add("changed=" + townBlock.isChanged());
        list.add("locked=" + townBlock.isLocked());
        list.add("metadata=" + this.serializeMetadata(townBlock));
        StringBuilder groupID = new StringBuilder();
        StringBuilder groupName = new StringBuilder();
        if (townBlock.hasPlotObjectGroup()) {
            groupID.append(townBlock.getPlotObjectGroup().getID());
            groupName.append(townBlock.getPlotObjectGroup().getName());
        }
        list.add("groupID=" + groupID.toString());
        this.queryQueue.add(new FlatFileSaveTask(list, this.getTownBlockFilename(townBlock)));
        return true;
    }

    private String serializeMetadata(TownyObject obj) {
        if (!obj.hasMeta()) {
            return "";
        }
        StringJoiner serializer = new StringJoiner(";");
        for (CustomDataField<?> cdf : obj.getMetadata()) {
            serializer.add(cdf.toString());
        }
        return serializer.toString();
    }

    @Override
    public void deleteResident(Resident resident) {
        File file = new File(this.getResidentFilename(resident));
        this.queryQueue.add(new DeleteFileTask(file, false));
    }

    @Override
    public void deleteTown(Town town) {
        File file = new File(this.getTownFilename(town));
        this.queryQueue.add(new DeleteFileTask(file, false));
    }

    @Override
    public void deleteNation(Nation nation) {
        File file = new File(this.getNationFilename(nation));
        this.queryQueue.add(new DeleteFileTask(file, false));
    }

    @Override
    public void deleteWorld(TownyWorld world) {
        File file = new File(this.getWorldFilename(world));
        this.queryQueue.add(new DeleteFileTask(file, false));
    }

    @Override
    public void deleteTownBlock(TownBlock townBlock) {
        File file = new File(this.getTownBlockFilename(townBlock));
        this.queryQueue.add(() -> {
            if (file.exists()) {
                String name = null;
                try {
                    name = townBlock.getTown().getName();
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
                if (name != null) {
                    FileMgmt.moveTownBlockFile(file, "deleted", name);
                } else {
                    FileMgmt.moveTownBlockFile(file, "deleted", "");
                }
            }
        });
    }

    @Override
    public void deletePlotGroup(PlotGroup group) {
        File file = new File(this.getPlotGroupFilename(group));
        this.queryQueue.add(new DeleteFileTask(file, false));
    }

    public static enum elements {
        VER,
        novalue;


        public static elements fromString(String Str) {
            try {
                return elements.valueOf(Str);
            }
            catch (Exception ex) {
                return novalue;
            }
        }
    }
}

